$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$computer = $env:COMPUTERNAME
$computer = $computer.toLower()
try
{
    # Get the Current Domain Information
    $domain = [System.DirectoryServices.ActiveDirectory.Domain]::GetCurrentDomain()
}
catch
{
    Write-host "Something went wrong"
    Exit 1
}

try
{
    $DomainControllers = $domain | ForEach-Object -Process { $_.DomainControllers } | Select-Object -Property Name
    foreach ($dc in $DomainControllers)
       {
        $DCName = $($dc.Name).toLower()
        if($dcname.IndexOf($computer) -eq 0)
        {
            $path = "c:/windows/debug/netlogon.log"
            if ((Test-Path -Path $path) -and ((Get-Item -Path $path).Length -ne $null))
            {
                IF ((Get-Content -Path $path | Measure-Object -Line).lines -gt 0)
                {
                     # Convert the TXT file to a CSV format
                     $importString = Import-Csv -Path $path -Delimiter ' ' -Header Date,Time,Domain,Error,Name,IPAddress
                     #  Get Only the entries for the Missing Subnets
                     $MissingSubnets = $importString | Where-Object {$_.Error -like "*NO_CLIENT_SITE*"}
                     #  Get the other errors from the log
                     $OtherErrors = Get-Content $path | Where-Object {$_ -notlike "*NO_CLIENT_SITE*"} | Sort-Object -Unique
                     write-host "List of Active Directory client that can not find their site."
                     write-host "You need to add those subnets into the console Active Directory Sites And Services."
                     IF ($MissingSubnets)
                     {
                        Write-host "Missing Subnet(s) Found: $($MissingSubnets.count)"
                        foreach($line in $MissingSubnets)
                        {
                            write-host($line)
                        }
                        
                     }
                     else
                     {
                        write-host "No Missing Subnet(s) detected."
                     }
                     IF ($OtherErrors)
                     {
                        Write-host "Other Error(s) Found: $($OtherErrors.count)"
                        FOREACH($line in $otherErrors)
                        {
                           write-host ($line)
                        }
                     }
                     else
                     {
                        write-host "No Other Error detected."
                     }
                }
                else
                {
                    write-host "$($path) file is empty"
                }
            }
            else
            {
                write-host "netlogon.log is not reachable"
            }
        }
        else
        {
            write-host "ignoring $DCName"
        }
    }

}
catch
{

} 
