$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

import-module grouppolicy

function IsNotLinked($xmldata){
    If ($xmldata.GPO.LinksTo -eq $null) {
        Return $true
    }
    
    Return $false
}

$unlinkedGPOs = @()

Get-GPO -All | ForEach { $gpo = $_ ; $_ | Get-GPOReport -ReportType xml | ForEach { If(IsNotLinked([xml]$_)){$unlinkedGPOs += $gpo} }}

If ($unlinkedGPOs.Count -eq 0) {
    "0 Unlinked GPO's Found"
}
Else{
    #write-host $unlinkedGPOs.count" GPO's are unlinked:"
    write-host "Display_Name;ID;Creation_Time;Modification_Time;GPO_Status;Description"
    foreach($unlinkedGPO in $unlinkedGPOs)
    {
        Write-Host "$($unlinkedGPO.DisplayName);$($unlinkedGPO.ID);$($unlinkedGPO.CreationTime);$($unlinkedGPO.ModificationTime);$($unlinkedGPO.GpoStatus);$($unlinkedGPO.Description)"
    }
}