$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
add-pssnapin citrix.broker.*
if($args.Count -gt 0)
{
    $delierygroupname = $args[0]
    $badVMs = Get-BrokerMachine -DesktopGroupName $delierygroupname -SessionSupport SingleSession -PowerActionPending $false -PowerState On -SummaryState Available -WillShutdownAfterUse $true -InMaintenanceMode $false -MaxRecordCount 5000
}
else
{    
    $badVMs = Get-BrokerMachine -PowerActionPending $false -SessionSupport SingleSession -PowerState On -SummaryState Available -WillShutdownAfterUse $true  -InMaintenanceMode $false  -MaxRecordCount 5000
}
If ($badVMs) 
{ 
   foreach($vm in $badVMs) 
   {
      Write-Host "The machine $($vm.HostedMachineName) is in dirty state and 'Reset' power action has been invoked" 
      New-BrokerHostingPowerAction -MachineName $vm.HostedMachineName -Action Reset 
   } 
}
else
{
	Write-Host "No VDI desktops found in dirty state"  
} 
Remove-pssnapin citrix.broker.*