[CmdletBinding()]
param
(
    [Parameter(Mandatory = $true)][string] $DeliveryGroupName,
    [Parameter(Mandatory = $true)] [string] $Uids,
    [Parameter (Mandatory = $true)] [string] $Message
)
Add-PSSnapin Citrix.Broker.*
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Title = "Message from EG Portal"
$sessionids = $uids -split ","
if($sessionids[0] -like "*none*")
{
	try {
	
		$sessions = Get-BrokerSession -DesktopGroupName $DeliveryGroupName -erroraction stop
		Send-BrokerSessionMessage $sessions -MessageStyle Information -Title $Title -Text "$Message" -erroraction stop
		Write-Host "Sent the message to the selected user successfully"
	}catch 
	{
	   Write-Host "Unable to send a message to the selected user session"
	}
}
else
{
    foreach($sessionid in $sessionids)
    {
		try {
			$session = Get-BrokerSession -uid $sessionid -erroraction stop
			Send-BrokerSessionMessage $session -MessageStyle Information -Title $Title -Text "$Message" -erroraction stop
			Write-Host "Sent the message to the selected user successfully"
		} catch{
			 Write-Host "Unable to send a message to the selected user session"
		}
    }
}
Remove-PSSnapin Citrix.Broker.*