$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

# Retrieve instance of Win32_Process based on the process name or PID
$ID = $args[0]
$wmi = Get-WmiObject -Class Win32_OperatingSystem
$Procs = Get-WmiObject -Namespace root\cimv2 -Query "select * from Win32_Process where ProcessId = '$ID'"

# If there are no processes returned from the query, then simply exit the function
if (-not $Procs)
{
              Write-Host -Object "No processes were found for the PID $ID";
              return;
}
# If one process is found, get the value of __PATH, which we will use for our next query
elseif (@($Procs).Count -eq 1)
{
              $ProcPath = @($Procs)[0].__PATH;
}

# Get the CIM_ProcessExecutable instances for the process we retrieved
$ProcQuery = "select * from CIM_ProcessExecutable where Dependent = '$ProcPath'".Replace('\','\\');

Write-Verbose $ProcQuery
$ProcExes = Get-WmiObject -Namespace root\cimv2 -Query $ProcQuery;

# If there are instances of CIM_ProcessExecutable for the specified process, go ahead and grab the important properties
if ($ProcExes)
{
	write-host File_Name,File_Path,Manufacturer,Version,File_Size@In_MB%,Install_Date,Last_Accessed,Last_Modified -Separator "^^"

              foreach ($ProcExe in $ProcExes)
              {
                             # Use the [wmi] type accelerator to retrieve an instance of CIM_DataFile from the WMI __PATH in the Antecentdent property
                             $ExeFile = [wmi]"$($ProcExe.Antecedent)"
                             # If the WMI instance we just retrieve "IS A" (think WMI operator) CIM_DataFile, then write properties to console
                             if ($ExeFile.__CLASS -eq 'CIM_DataFile' -and $ExeFile.Extension -eq 'dll')
                             {
                                           write-host $ExeFile.FileName, $ExeFile.EightDotThreeFileName, $ExeFile.Manufacturer, $ExeFile.Version,$ExeFile.FileSize,$wmi.ConvertToDateTime($ExeFile.InstallDate), $wmi.ConvertToDateTime($ExeFile.LastAccessed),$wmi.ConvertToDateTime($ExeFile.LastModified) -Separator "^^"
                             }
              }
}
