<#
    Script to find disconnected sessions and end them if they have been disconnected over specified period.
#>

[CmdletBinding(SupportsShouldProcess=$True,ConfirmImpact='High')]
Param
(
	[Parameter(Mandatory=$false,HelpMessage='Disconnected threshold in -hours:minutes')]
	[string]$threshold = '8:30' ,
    [string]$ddc = 'localhost'
)

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[string[]]$snapins = @('Citrix.Broker.Admin.*')
[int]$hours,[int]$minutes = $threshold -split ':'
if((!$hours -and !$minutes) -or $minutes -lt 0 -or $minutes -gt 59)
{
    Write-Host "Bad durtion of $threshold specified"
    return
} 

$threshold = "-$([math]::Abs( $hours )):$minutes"
ForEach( $snapin in $snapins )
{
    Add-PSSnapin $snapin -ErrorAction Stop
}
$disconnected = @( Get-BrokerSession -AdminAddress $ddc -SessionState 'Disconnected' -Filter { SessionStateChangeTime -lt $threshold } )

if( $disconnected -and $disconnected.Count -gt 0 )
{
    Write-host "$($disconnected.count) disconnected sessions over given duration found in $ddc DDC. We are trying to stop the sessions."
    Write-Host 
    Write-Host "Disconnected session details are "
    Write-Host "------------------------------------"
    Write-Host "UserName","ConnectedVIAIP","LaunchedVIAIP","DeliveryGroup","HostedMachine","StartTime","SessionStateChangeTime" | ft -AutoSize
    Write-Host
    foreach($discsession in $disconnected)
    {
        write-host $discsession.username, $discsession.ConnectedViaIP,$discsession.LaunchedViaIP,$discsession.DesktopGroupName,$discsession.HostedMachineName,$discsession.StartTime,$discsession.SessionStateChangeTime | format-table -Autosize
    }
     
    write-host 
    foreach($discsession in $disconnected)
    {
        
	try
        {
	    Write-Host "Going to stop $($discsession.username) session"
            #Stop-BrokerSession $discsession
        }
        catch
        {

        }
    }
}
else
{
    Write-host "0 disconnected sessions over $threshold period found in $ddc."    
}