﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
Function Get-LocalTime(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$dat, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$hr
    )
    Process
    {
        $ltimArr=@()
        $UTCTime=[DateTime]$dat
        $UTCTime=$UTCTime.AddHours([int]$hr)
        $strCurrentTimeZone = (Get-WmiObject win32_timezone).StandardName
        $TZ = [System.TimeZoneInfo]::FindSystemTimeZoneById($strCurrentTimeZone)
        $LocalTime = [System.TimeZoneInfo]::ConvertTimeFromUtc($UTCTime, $TZ)
        $ltimArr+='{0:yyyy-MM-dd}' -f $LocalTime
        $ltimArr+=(Get-Date $LocalTime).Hour
        Return $ltimArr
    }
}

$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptDateHr=$mperiodAndIsTeam[2].Trim()
$prxyCrds=$TestInputs[3].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[4]).ToString().trim()

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin))
$dat2=$dat1.ToUniversalTime()
$hr=$dat2.Hour
$strtDatStr='{0:yyyy-MM-dd}' -f $dat2
$endDatStr='{0:yyyy-MM-dd}' -f $dat2.AddDays(1)
if($rptDateHr -ne 'none'){
    $arr=$rptDateHr.Split('~')
    $lstRptDat=$arr[0]
    $chkrptDat=$lstRptDat
    $lstrptHr=$arr[1]
    $chkrptHr=$lstrptHr
    $chkPnt=$arr[2] 
}else{
    $lstRptDat=$strtDatStr
    $lstrptHr=$hr
}

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

$measures='Measures.AppSharing Stream Count','Measures.AppSharing Poor Due To SpoiledTilePercentTotal Count','Measures.AppSharing Poor Due To RelativeOneWayAverage Count','Measures.AppSharing Poor Due To RDPTileProcessingLatencyAverage Count','Measures.AppSharing Poor Stream Count','Measures.AppSharing Good Stream Count','Measures.AppSharing Unclassified Stream Count','Measures.AppSharing Poor Percentage','Measures.Avg AppSharing Spoiled Tile Percent Total','Measures.Avg AppSharing Relative OneWay','Measures.Avg AppSharing RDP Tile Processing Latency','Measures.Avg Relative OneWay','Measures.Avg Relative OneWay Max'
$Dimentions ='AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.AppSharing Poor Due To SpoiledTilePercentTotal','AllStreams.AppSharing Poor Due To RelativeOneWayAverage','AllStreams.AppSharing Poor Due To RDPTileProcessingLatencyAverage','AllStreams.ClassifiedPoorCall','AllStreams.Is Teams','AllStreams.Media Type','AllStreams.First UPN','AllStreams.Second UPN'

$AppShrngStrmsOutput=Get-CQDData -Dimensions $Dimentions -StartDate $lstRptDat -EndDate $endDatStr  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3  | Where-Object { $_.'Media Type' -eq 'AppSharing' -and [int]$_.Hour -gt $lstrptHr} | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled}
[System.GC]::GetTotalMemory($true) | out-null
if($strtDatStr -ne $lstRptDat){
    $lstRptDat=$strtDatStr
    $lstrptHr=0
    $AppShrngStrmsOutput+=Get-CQDData -Dimensions $Dimentions -StartDate $lstRptDat -EndDate $endDatStr  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3  | Where-Object { $_.'Media Type' -eq 'AppSharing' -and [int]$_.Hour -ge $lstrptHr} | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled}
}
$AppShrngStrmsOutput | select * | ForEach-Object {if($_.Date -eq $lstRptDat -and $_.Hour -gt $lstrptHr){$lstrptHr=$_.Hour};}

$isWrite=$true
if($lstRptDat -eq $chkrptDat -and $lstrptHr -eq $chkrptHr){
    $chkPnt=[int]$chkPnt+1
    if([int]$chkPnt -gt 1){
        $isWrite=$false
    }
}else{
    $chkPnt=1
}
$rptDatHrstr='LastReporting Date and Hour#'+$lstRptDat+'~'+$lstrptHr+'~'+$chkPnt
Write-Host $rptDatHrstr

if($isWrite){
    $AppSharingStreamCount=0
    $AppSharingPoorDueToSpoiledTilePercentTotalCount=0
    $AppSharingPoorDueToRelativeOneWayAverageCount=0
    $AppSharingPoorDueToRDPTileProcessingLatencyAverageCount=0
    $AppSharingPoorStreamCount=0
    $AppSharingGoodStreamCount=0
    $AppSharingUnclassifiedStreamCount=0
    $AppSharingPoorPercentage=0
    $AvgAppSharingSpoiledTilePercentTotal=0
    $AvgAppSharingRDPTileProcessingLatency=0
    $AvgRelativeOneWay=0
    $AvgRelativeOneWayMax=0

    if($AppShrngStrmsOutput){
        $AppSharingStreamCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Stream Count')  -and $_.'AppSharing Stream Count' -ne 'NaN' } 
        $AppSharingStreamCount = ($AppSharingStreamCountlist| Measure-Object "AppSharing Stream Count" -Sum | select Sum).Sum
        if(-not $AppSharingStreamCount){  
            $AppSharingStreamCount=0
        }
        $AppSharingStreamCountlist=$null

        $AppSharingPoorDueToSpoiledTilePercentTotalCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Poor Due To SpoiledTilePercentTotal Count')  -and  $_.'AppSharing Poor Due To SpoiledTilePercentTotal Count' -ne 'NaN' -and $_.'AppSharing Poor Due To SpoiledTilePercentTotal' -eq 'TRUE' }
        $AppSharingPoorDueToSpoiledTilePercentTotalCount =($AppSharingPoorDueToSpoiledTilePercentTotalCountlist | Measure-Object "AppSharing Poor Due To SpoiledTilePercentTotal Count" -Sum | select Sum).Sum
        if($AppSharingPoorDueToSpoiledTilePercentTotalCount){
            $list=$AppSharingPoorDueToSpoiledTilePercentTotalCountlist | where-object {$_.'AppSharing Poor Due To SpoiledTilePercentTotal Count' -gt 0.0001 } | Sort-Object { $_."AppSharing Poor Due To SpoiledTilePercentTotal Count" -as [int] } -Descending | select -First 10
            foreach($in in $list){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddAppSharingPoorDueToSpoiledTilePercentTotalCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'  ~!~ $in.'AppSharing Poor Due To SpoiledTilePercentTotal Count'
            }
            $list=$null
        }
        else{ 
            $AppSharingPoorDueToSpoiledTilePercentTotalCount=0 
        }
        $AppSharingPoorDueToSpoiledTilePercentTotalCountlist=0

        $AppSharingPoorDueToRelativeOneWayAverageCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Poor Due To RelativeOneWayAverage Count')  -and  $_.'AppSharing Poor Due To RelativeOneWayAverage Count' -ne 'NaN' -and $_.'AppSharing Poor Due To RelativeOneWayAverage' -eq 'TRUE'} 
        $AppSharingPoorDueToRelativeOneWayAverageCount =($AppSharingPoorDueToRelativeOneWayAverageCountlist | Measure-Object "AppSharing Poor Due To RelativeOneWayAverage Count" -Sum | select Sum).Sum
        if($AppSharingPoorDueToRelativeOneWayAverageCount){
            $list=$AppSharingPoorDueToRelativeOneWayAverageCountlist | where-object {$_.'AppSharing Poor Due To RelativeOneWayAverage Count' -gt 0.0001 } | Sort-Object { $_."AppSharing Poor Due To RelativeOneWayAverage Count" -as [int] } -Descending | select -First 10
            foreach($in in $list){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddAppSharingPoorDueToRelativeOneWayAverageCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'AppSharing Poor Due To RelativeOneWayAverage Count'
            }
            $list=$null
        }
        else{ 
            $AppSharingPoorDueToRelativeOneWayAverageCount=0
        }
        $AppSharingPoorDueToRelativeOneWayAverageCountlist=$null

        $AppSharingPoorDueToRDPTileProcessingLatencyAverageCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Poor Due To RDPTileProcessingLatencyAverage Count')  -and  $_.'AppSharing Poor Due To RDPTileProcessingLatencyAverage Count' -ne 'NaN' -and $_.'AppSharing Poor Due To RDPTileProcessingLatencyAverage' -eq 'TRUE' } 
        $AppSharingPoorDueToRDPTileProcessingLatencyAverageCount = ($AppSharingPoorDueToRDPTileProcessingLatencyAverageCountlist| Measure-Object "AppSharing Poor Due To RDPTileProcessingLatencyAverage Count" -Sum | select Sum).Sum
        if($AppSharingPoorDueToRDPTileProcessingLatencyAverageCount){
            $list=$AppSharingPoorDueToRDPTileProcessingLatencyAverageCountlist | where-object {$_.'AppSharing Poor Due To RDPTileProcessingLatencyAverage Count' -gt 0.0001 }  | Sort-Object { $_."AppSharing Poor Due To RDPTileProcessingLatencyAverage Count" -as [int] } -Descending | select -First 10
            foreach($in in $list){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddAppSharingPoorDueToRDPTileProcessingLatencyAverageCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id'  ~!~ $in.'AppSharing Poor Due To RDPTileProcessingLatencyAverage Count'
            }
            $list=$null
        }
        else{ 
            $AppSharingPoorDueToRDPTileProcessingLatencyAverageCount=0 
        }
        $AppSharingPoorDueToRDPTileProcessingLatencyAverageCountlist=$null

        $AppSharingPoorStreamCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Poor Stream Count')  -and  $_.'AppSharing Poor Stream Count' -ne 'NaN' -and $_.'ClassifiedPoorCall' -eq 'TRUE' } 
        $AppSharingPoorStreamCount = ($AppSharingPoorStreamCountlist | Measure-Object "AppSharing Poor Stream Count" -Sum | select Sum).Sum
        if($AppSharingPoorStreamCount){
            $list=$AppSharingPoorStreamCountlist | where-object {$_.'AppSharing Poor Stream Count' -gt 0.0001} | Sort-Object { $_."AppSharing Poor Stream Count" -as [int] } -Descending  | select -First 10
            foreach($in in $list){
                $ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                Write-Host 'ddAppSharingPoorStreamCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'AppSharing Poor Stream Count'
            }
            $list=$null
        }
        else{ 
            $AppSharingPoorStreamCount=0
        }
        $AppSharingPoorStreamCountlist=$null

        $AppSharingGoodStreamCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Good Stream Count')  -and  $_.'AppSharing Good Stream Count' -ne 'NaN' } 
        $AppSharingGoodStreamCount = ($AppSharingGoodStreamCountlist | Measure-Object "AppSharing Good Stream Count" -Sum | select Sum).Sum
        if(-not $AppSharingGoodStreamCount){
            $AppSharingGoodStreamCount =0
        }
        $AppSharingGoodStreamCountlist=$null

        $AppSharingUnclassifiedStreamCountlist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Unclassified Stream Count')  -and  $_.'AppSharing Unclassified Stream Count' -ne 'NaN' } 
        $AppSharingUnclassifiedStreamCount =($AppSharingUnclassifiedStreamCountlist | Measure-Object "AppSharing Unclassified Stream Count" -Sum | select Sum).Sum
        if(-not $AppSharingUnclassifiedStreamCount){
            $AppSharingUnclassifiedStreamCount =0
        } 
        $AppSharingUnclassifiedStreamCountlist=$null

        write-host '*********** AppSharingPoorPercentage measure **************'
        #$AppSharingPoorPercentagelist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'AppSharing Poor Percentage')  -and  $_.'AppSharing Poor Percentage' -ne 'NaN' -and $_.'AppSharing Poor Percentage' -gt 0.0001} 
        #$AppSharingPoorPercentage = ($AppSharingPoorPercentagelist | Measure-Object "AppSharing Poor Percentage" -Average | select Average).Average
        $AppSharingPoorPercentage = ($AppSharingPoorStreamCount/$AppSharingStreamCount)*100
        if(-not $AppSharingPoorPercentage) { $AppSharingPoorPercentage =0 } else { $AppSharingPoorPercentage=$AppSharingPoorPercentage.ToString("#.##") }
        $AppSharingPoorPercentagelist=$null

        $AvgAppSharingSpoiledTilePercentTotallist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg AppSharing Spoiled Tile Percent Total')  -and  $_.'Avg AppSharing Spoiled Tile Percent Total' -ne 'NaN' -and $_.'Avg AppSharing Spoiled Tile Percent Total' -gt 0.0001 } 
        $AvgAppSharingSpoiledTilePercentTotal = ($AvgAppSharingSpoiledTilePercentTotallist | Measure-Object "Avg AppSharing Spoiled Tile Percent Total" -Average | select Average).Average
        if( -not $AvgAppSharingSpoiledTilePercentTotal) { $AvgAppSharingSpoiledTilePercentTotal=0 } else { $AvgAppSharingSpoiledTilePercentTotal=$AvgAppSharingSpoiledTilePercentTotal.ToString("#.##") }
        $AvgAppSharingSpoiledTilePercentTotallist=$null

        $AvgAppSharingRDPTileProcessingLatencylist =$AppShrngStrmsOutput  | where-object { -not [string]::IsNullOrEmpty($_.'Avg AppSharing RDP Tile Processing Latency')  -and  $_.'Avg AppSharing RDP Tile Processing Latency' -ne 'NaN' -and $_.'Avg AppSharing RDP Tile Processing Latency' -gt 0.0001 } 
        $AvgAppSharingRDPTileProcessingLatency = ($AvgAppSharingRDPTileProcessingLatencylist | Measure-Object "Avg AppSharing RDP Tile Processing Latency" -Average | select Average).Average
        if( -not $AvgAppSharingRDPTileProcessingLatency) { $AvgAppSharingRDPTileProcessingLatency=0 }  else { $AvgAppSharingRDPTileProcessingLatency=$AvgAppSharingRDPTileProcessingLatency.ToString("#.##") }
        $AvgAppSharingRDPTileProcessingLatencylist=0

        $AvgRelativeOneWaylist =$AppShrngStrmsOutput | where-object { -not [string]::IsNullOrEmpty($_.'Avg Relative OneWay')  -and  $_.'Avg Relative OneWay' -ne 'NaN' -and $_.'Avg Relative OneWay' -gt 0.0001 }
        $AvgRelativeOneWay = ($AvgRelativeOneWaylist  | Measure-Object "Avg Relative OneWay" -Average | select Average).Average
        if(-not $AvgRelativeOneWay){ $AvgRelativeOneWay =0 }  else { $AvgRelativeOneWay=$AvgRelativeOneWay.ToString("#.##") }
        $AvgRelativeOneWaylist=$null

        $AvgRelativeOneWayMaxlist =$AppShrngStrmsOutput | where-object { -not [string]::IsNullOrEmpty($_.'Avg Relative OneWay Max')  -and  $_.'Avg Relative OneWay Max' -ne 'NaN' -and $_.'Avg Relative OneWay Max' -gt 0.0001 } 
        $AvgRelativeOneWayMax = ($AvgRelativeOneWayMaxlist | Measure-Object "Avg Relative OneWay Max" -Average | select Average).Average
        if( -not $AvgRelativeOneWayMax ){ $AvgRelativeOneWayMax =0 } else { $AvgRelativeOneWayMax=$AvgRelativeOneWayMax.ToString("#.##") }
        $AvgRelativeOneWayMaxlist=$null

        Write-Host 'measures##' $AppSharingStreamCount ~ $AppSharingPoorDueToSpoiledTilePercentTotalCount ~ $AppSharingPoorDueToRelativeOneWayAverageCount ~ $AppSharingPoorDueToRDPTileProcessingLatencyAverageCount ~ $AppSharingPoorStreamCount ~ $AppSharingGoodStreamCount ~ $AppSharingUnclassifiedStreamCount ~ $AppSharingPoorPercentage ~ $AvgAppSharingSpoiledTilePercentTotal ~ $AvgAppSharingRDPTileProcessingLatency ~ $AvgRelativeOneWay ~ $AvgRelativeOneWayMax 
    }
}
[System.GC]::GetTotalMemory($true) | out-null
# SIG # Begin signature block
# MIIldgYJKoZIhvcNAQcCoIIlZzCCJWMCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUlEPxw52JLi4uuKc+MGZFHz6T
# 5oOggh6cMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFsTCC
# BJmgAwIBAgIQASQK+x44C4oW8UtxnfTTwDANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwNjA5MDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBXjCCAVowDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHkGCCsGAQUF
# BwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMG
# CCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
# c3N1cmVkSURSb290Q0EuY3J0MEUGA1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwIAYDVR0g
# BBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0GCSqGSIb3DQEBDAUAA4IBAQCa
# FgKlAe+B+w20WLJ4ragjGdlzN9pgnlHXy/gvQLmjH3xATjM+kDzniQF1hehiex1W
# 4HG63l7GN7x5XGIATfhJelFNBjLzxdIAKicg6okuFTngLD74dXwsgkFhNQ8j0O01
# ldKIlSlDy+CmWBB8U46fRckgNxTA7Rm6fnc50lSWx6YR3zQz9nVSQkscnY2W1ZVs
# RxIUJF8mQfoaRr3esOWRRwOsGAjLy9tmiX8rnGW/vjdOvi3znUrDzMxHXsiVla3R
# y7sqBiD5P3LqNutFcpJ6KXsUAzz7TdZIcXoQEYoIdM1sGwRc0oqVA3ZRUFPWLvdK
# RsOuECxxTLCHtic3RGBEMIIGMzCCBRugAwIBAgIQCJp0nrgtw+wn6mXq2/g1MTAN
# BgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQg
# SW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2Vy
# dCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4XDTIxMDUyNTAwMDAw
# MFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBK
# ZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMs
# IEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMuMIICIjANBgkqhkiG
# 9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7JDxOs7sySHvaQ3wGR
# 2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJIk0AZXDTMvXr/mEvm
# KxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+f9I4EgTo9OcdVeIN
# XhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuKifgxL2i8d5FDzkhZ
# SZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZyyaRURtlx11pYfJ/K
# NYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgRADe3/k0NtiVwJIo0
# ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yKf4kpRFmClYfK5Lst
# GQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3VhN+aV56kR/efo8e
# D81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRvIID/l+yDJogDBpae
# 3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug3F2CVJpNbzb1HmAH
# 6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4KTAg7ROmGkwdLhmXo
# PCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsqCqOl6nEDwGD5LfZl
# dQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAOBgNVHQ8BAf8EBAMC
# B4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1oDOgMYYvaHR0cDov
# L2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5jcmwwNaAzoDGG
# L2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3VyZWQtY3MtZzEuY3Js
# MEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUHAgEWG2h0dHA6Ly93
# d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsGAQUFBwEBBHgwdjAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tME4GCCsGAQUFBzAC
# hkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
# ZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQsF
# AAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuChsgkv1PmQpgfypxC
# 3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5NAxDGuIczAIeXOc5k
# RRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9ndCmGSsqcxjG2ud8O6
# Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKRLAUu6IgD6WJKMVfZ
# XWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwoevxbIWh0SenZOUrA
# q9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQICEAc2N7ckVHzYR6z9
# KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERp
# Z2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMY
# RGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAwMDAwMFoXDTM3MDMy
# MjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRp
# bWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMaG
# NQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2EaFEFUJfpIjzaPp9
# 85yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuAhIoiGN/r2j3EF3+r
# GSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQh0YAe9tEQYncfGpX
# evA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7LeSn3O9TkSZ+8OpWNs
# 5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw54qVI1vCwMROpVymW
# Jy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP29p7mO1vsgd4iFNmC
# KseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjFKfPKqpZzQmiftkaz
# nTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHtQr8FnGZJUlD0UfM2
# SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpYPtMDiP6zj9NeS3YS
# UZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4JduyrXUZ14mCjWAkB
# KAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGjggFdMIIBWTASBgNV
# HRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2mi91jGogj57IbzAf
# BgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNVHQ8BAf8EBAMCAYYw
# EwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBpMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUHMAKGNWh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3J0MEMG
# A1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG
# /WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIBfmbW2CFC4bAYLhBN
# E88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb122H+oQgJTQxZ822
# EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+rT4osequFzUNf7WC2
# qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQsl3p/yhUifDVinF2
# ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsKRcnfxI2g55j7+6ad
# cq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKnN36TU6w7HQhJD5TN
# OXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSereU0cZLXJmvkOHOr
# pgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no8Zhf+yvYfvJGnXUs
# HicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcWoWa63VXAOimGsJig
# K+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInwAM1dwvnQI38AC+R2
# AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7qS9EFUrnEw4d2zc4
# GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhNhpedMA0GCSqGSIb3
# DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7
# MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1l
# U3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQsw
# CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG0Rp
# Z2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx5DxArvurxON4XX5c
# Nur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJx
# bKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFqRUIjQVr4YNNlLD5+
# Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJHGVvimC6P0Mo//8Zn
# zzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHVGBS3BEXz4Di9or16
# cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vICNEyu4P6IzzZ/9KM
# u/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03ShL7BU
# dsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2xwafEDsTvQD4ZOgLU
# MalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiay
# CDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2QT3nr6caKMmtYbCg
# QRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGj
# ggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNVHSUBAf8E
# DDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEw
# HwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYEFI1kt4kh
# /lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRp
# Z2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3Rh
# bXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzABhhhodHRw
# Oi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNlcnRz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1l
# U3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk
# 9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4qOVo5TtiEWaW8G5iq
# 6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJ
# T4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8y/pc9+RTv24KfH7X
# 3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEip
# tucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiLfmSiZZQR+24y8fW7
# OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp43UZ3Lht6wDOK+Eoo
# jBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pIallDrl/q+A8GQp3f
# BmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVrNQ6F1uAszOAMJLh8
# UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBFThIcFClYzG/Tf8u+
# wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdjOEcXW28T2moQbh9J
# t0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmlu
# ZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYBBAGCNwIB
# DDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
# MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFA4K6eFQaIDl+leQUn3oqZp/
# yA6RMA0GCSqGSIb3DQEBAQUABIICAEREhKbU2pppKWf3XQHQfEoPyzLeHLI+EFtZ
# k++mg3lvlZBUjU77YU6GoRBDVsnHy7vtacaiojZu+lpDbnWlZxzHYkhUQuyzHl6P
# C7cnwIog5O+LhohKTvlPEZsyrEB+mLbFpSyZUwG1o6+q9T9z3dMdPdLwQRTu6aG9
# d281sP/npXAURZbSO8YYA+crEfDGRvITltAjkIizU4ft8CibJuVbpdeiA0zAhh+s
# qDPDOUosUh6nExmHiFwn4asttrLvaz2YI/Usx3MJUd7H+b1BjCoNZ2nOPbmdLhiE
# NecGcX3z36pTAkcpjAwy7KJXhkaYjPW5aiC1d3x5xAVROqDUlL88fX7MLi1Yazw9
# YlyBLiTWwMseVcpf8VF2k6fFIwAWea2GON81x/0xtT82qo1BvkFTCApiAg8z1KcY
# 9YKJDlbs6Tc8puEwgjJMeqtEpqGJl7Z0YwTGyEvqpVRq4PqZ8JswsvSuNYxBHKAl
# +GwPOYdtmKku8VPtivtoDiM/J7ILZ1r86p96or1VS7GRJ+W5AtOZ25P9xCL9a9JX
# dr4XfBBtVtAIx3lkYk/YnH84tGNdHIrk5Tg1GjdJX4XBzdcymOyhOBPVZCGzkOqk
# e5H4rQ0or7sVo53RqB5PMkxAtFghwbuDI+p+ApnwbN/xSdXmjUpTkgsILpDQOZdR
# teEEKXVjoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzELMAkGA1UE
# BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2Vy
# dCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQCnpK
# iJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJAzELBgkq
# hkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDcxMTEzMTEwNFowLwYJKoZIhvcN
# AQkEMSIEIFDwQka2Zl58RJSYz7V9B0u/5UXrCXPyrFgo25byYiZ/MA0GCSqGSIb3
# DQEBAQUABIICAKdtkxcnjPc1JqdY7c1caCA4t7re9gdbvzNM2+jaXHUXgBCtnsS0
# j1IvJ3BiZKtTOCIwTUKh9Tay8yluvXxqb5GboqTXFsMqN8I7V0QaUKs0SenfWzza
# kOYD/tk1ch6LVB9eZuJWTyIPo2oIKXgxldKS3JhJu2k3kHy7EXAP/IUQYv3IS4uX
# zCGN07Gi2uoQVWGewIBHgSeAjSNDj7WL7+HNpB0EMPvCcBkijmHpGi9qIsRXNxcc
# B/j++6PTuQiHoRsrg3wR3f33lLfdHB8f+xBwv1gaIIg6u/+o7E8QndfnJd6sEXcP
# Fvopk3HWUC7SIFCucjKD7yhH8e1qE7NjBRtpV3u/SJYC+rVxK13TedZPKGp4Xh2q
# vYM2Wq3JdthIC8a+OLQUQday4c5/tBV7uackcTkVsr76B1CqPQ07nTw0SHnXAAjI
# 3zxCirrn0V3prTPn2UETIokRx4jWIXk5UutGMB/RPCTwy+yZSGAByDSWIN1B+iLH
# 9LRvdJ4uoYGcYeu3wXVU2x8OxVL9D8lanFIst4kuf/jwTw+P+P76vJbVf9MxCFjm
# os4XjxAkXG1uckrc0+qeu3980on5obWnuoHZM7PbRJKvDjuoQ/efyVgKaw+Fih8q
# 0RK27sUB2zjDqDGprbYd3OVKwdVIFFH1xAXDJiic+PZCL3Z50Thbdh5P
# SIG # End signature block
