'---------------------------------------------------------------------------------------------------
'	File Name :	getsiteinfo.vbs 
'	
'	Purpose   :	This file is VBScript code which will get all the infomation 
'	about websites details 	and it's aliasNames details from the localhost IIS Server
'	and write into a text file.  It needs one argument as File name in which it will 
'	write the output. If the specified is already available it will truncate the  
'	existing content and write it.
'	
'	The output in the file as follows ...	
'	
'	[IIS_WEBSITES]
'	Default Web Site=192.168.10.32:80:nttestsite
'	Administration Web Site=null:5099:null
'	testsite=192.168.10.32:8989:newtestsite
'	[SITE_ALIASNAMES]
'	Default Web Site=192.168.10.32:80:nttestsite#null:80:testsite
'	Administration Web Site=null:5099:null
'	testsite=192.168.10.32:8989:newtestsite#192.168.10.32:80:ravee#null:80:localEgurkha
'
'	Created Date 	:	24-5-2001
'	Last Modifed 	:	24-05-2001

'	Author 		:	Raveendran T.
'	LastModified By :	Raveendran T.
'	LastModified By : 	Ch.Narasimha Raju for Win2003-IIS 6.0 	
'	LastModified By :	Rama .R for displaying more than one ip and removing dummy ip (127.0.0.1)
'---------------------------------------------------------------------------------------------------

' Force explicit declaration of all variables.
'Option Explicit

On Error Resume Next

Dim oArgs, ArgNum


Set oArgs = WScript.Arguments
ArgComputers = Array("LocalHost")
'
ArgWebSites = "1"
ArgNum = 0

Dim foundSite
Dim compIndex
Dim aliasInfo2
Dim aBinding, binding
Dim siteNames (100)
Dim siteIndex (100)
set siteNames = Array()	
set siteIndex = Array()
	
Dim gCount
Set ArgObj = WScript.Arguments

Dim fso, dataFile  
Dim fileName 
fileName = ArgObj.Item(0)



Set fso = CreateObject("Scripting.FileSystemObject")
Set dataFile = fso.CreateTextFile(ArgObj.Item(0),true) 

dataFile.WriteLine("[IIS_WEBSITES]")
WScript.Echo "[IIS_WEBSITES]"
 'WScript.Echo ArgComputers(0)
for compIndex = 0 to UBound(ArgComputers)

	Dim indexPath,data
	
	if( fileName = "") then
		WScript.Echo " Usage cscript.exe getsiteinfo.vbs <FileName to write the output> "
		Exit for 
	end if
	
	
	' This will returned all the valid WebSite info and write into the output file
	set foundSite = findWeb(ArgComputers(compIndex), ArgWebSites)
	dataFile.WriteLine("[SITE_ALIASNAMES]")
	WScript.Echo "[SITE_ALIASNAMES]"
	if (IsArray(siteNames)) then
		
		for s = 0 to gCount-1
			'WScript.Echo s&" = "& siteNames(s)
			indexPath ="W3SVC/"&siteIndex(s)&"/ServerBindings"
			
			' Get the alias Names for each siteName and 
			'WScript.Echo "indexPath ="&indexPath
			aliasInfo2 = GetCommand(indexPath)
			'WScript.Echo "Site = "&siteNames(s)&" : "&aliasInfo2
			
			data = siteNames(s)&"="&aliasInfo2
			WScript.Echo data
			dataFile.WriteLine(data)
			
		next
		dataFile.WriteLine("[IIS_SSL_WEBSITES]")
		WScript.Echo "[IIS_SSL_WEBSITES]"
		for s = 0 to gCount-1
			'WScript.Echo s&" = "& siteNames(s)
			indexPath ="W3SVC/"&siteIndex(s)&"/SecureBindings"
			
			' Get the alias Names for each siteName and 
			'WScript.Echo "indexPath ="&indexPath
			aliasInfo2 = GetCommand(indexPath)
			'WScript.Echo "Site = "&siteNames(s)&" : "&aliasInfo2
			if aliasInfo2 = "" then
				aliasInfo2 ="null"
			end if
			if isNull(aliasInfo2) then
				aliasInfo2 ="null"
			end if
			data = siteNames(s)&"="&aliasInfo2
			WScript.Echo data
			dataFile.WriteLine(data)
		next			
		dataFile.WriteLine("[SITE_STATUS]")
		WScript.Echo "[SITE_STATUS]"
		Dim siteObject
		Dim val
		for s = 0 to gCount-1
			set siteObject = GetObject("IIS://LocalHost/W3SVC/" &siteIndex(s))	
			val = siteObject.Status
			select case val
			      case 1 
				  WScript.Echo siteNames(s)&"=starting"
				  dataFile.WriteLine(siteNames(s)&"=starting")
			      case 2
				  WScript.Echo siteNames(s)&"=started"
				  dataFile.WriteLine(siteNames(s)&"=started")
			      case 3
				  WScript.Echo siteNames(s)&"=stopping"
				  dataFile.WriteLine(siteNames(s)&"=stopping")
			      case 4
				  WScript.Echo siteNames(s)&"=stopped"
				  dataFile.WriteLine(siteNames(s)&"=stopped")
			      case 5
				  WScript.Echo siteNames(s)&"=pausing"
				  dataFile.WriteLine(siteNames(s)&"=pausing")
			      case 6
				  WScript.Echo siteNames(s)&"=paused"
				  dataFile.WriteLine(siteNames(s)&"=paused")
			      case 7
				 WScript.Echo siteNames(s)&"=continuing"
				 dataFile.WriteLine(siteNames(s)&"=continuing")
			      case else
				 WScript.Echo siteNames(s)&"=Unknown Status : " & StatusValue
				 dataFile.WriteLine(siteNames(s)&"=Unknown Status ")
			end select
			
		next
		
	else
		WScript.Echo "IIS server Not Found"
	end if 
	dataFile.Close()
next


function getBinding(bindstr)

	Dim one, two, ia, ip, hn
	
	one=Instr(bindstr,":")
	two=Instr((one+1),bindstr,":")
	
	ia=Mid(bindstr,1,(one-1))
	ip=Mid(bindstr,(one+1),((two-one)-1))
	hn=Mid(bindstr,(two+1))
	
	getBinding=Array(ia,ip,hn)
end function

'''''''''''''''''''''''''''''''''''''''''
'
' This will get the information about the  websites,portNo and Hostname  for 
' all websites which are available in Local IIS server 
'
'''''''''''''''''''''''''''''''''''''''''

Function findWeb(computer, webname)
	On Error Resume Next

	Dim websvc, site
	dim webinfo

	Dim aBinding, binding
	Dim ipAddress,portNo,hostName
	Dim s1,s2
	
	'WScript.Echo "Computer   " & computer & " : webname   " & webname
	' Get the webservice object here 
	
	set websvc = GetObject("IIS://"&computer&"/W3SVC")
	
	if (Err <> 0) then
		exit function
	end if
	
	
	' Get the all siteName here in array  
	set site = websvc.GetObject("IIsWebServer", 1)
	if(isNull(site)) then
		WScript.Echo "Cannot getSite Object"
	end if
	err.clear
	gCount = 0
	'MsgBox (TypeName(site))
	' Get all the valid Website count here 
	for each site in websvc
		if site.class = "IIsWebServer" then
			siteIndex(gCount) = site.Name
			gCount=gCount+1		
	  	end if 
	next
	'WScript.Echo gCount
		
	RootNodePath = "IIS://LocalHost/W3SVC"
	Set oFirstNode = GetObject(RootNodePath)
	If Err <> 0 Then
		Display "Couldn't get the first node in the disptree"
		WScript.Quit (1)
	End If
		
	for  s1 = 0 to gCount-1
		' Get the site name here ..
		'WScript.Echo siteIndex(s1)
		set site = websvc.GetObject("IIsWebServer",siteIndex(s1))
		if site.class = "IIsWebServer" then
			siteBinding=site.ServerBindings
		value = Null
		For i=0 To UBound(siteBinding) 
			aBinding = siteBinding(i)
			
			if (IsArray(aBinding)) then
				if aBinding(0) = "" then
					binding = Null
				else
					binding = getBinding(aBinding(0))
				end if
			else 
				if aBinding = "" then
					binding = Null
				else
					binding = getBinding(aBinding)
				end if
			end if
			
			' Get the site Name and assign to global variable as array 
			
			siteNames(s1) = site.ServerComment
			'WScript.Echo site.ServerComment
			
			' If ip address is null then put the key word as null
			if ( binding(0) = "" ) then
				ipAddress="null"
			else
				ipAddress = binding(0)
			end if
			
			' If  portNo is null then put the key word as null
			
			if ( binding(1) = "" ) then
				portNo ="null"
			else
				portNo = binding(1)
			end if
			
			' If hostname is null then put the key word as null
			
			if ( binding(2) = "" ) then
				hostName="null"
			else
				hostName = binding(2)
			end If
			If (StrComp(ipAddress,"127.0.0.1")<> 0) Then 
				If IsNull(value) Then 
					value = ipAddress&":"&portNo&":"&hostname
				Else
					value = value & "#" & ipAddress&":"&portNo&":"&hostname
				End If
			End if

		next
			'WScript.Echo "Ip = "&binding(0)
			'WScript.Echo "port = "&binding(1)
			'WScript.Echo "hostname = "&binding(2)
			webInfo = siteNames(s1)&"="& value
			 
			 ' Now write the formatted result in to the output file
			 dataFile.WriteLine(webInfo)
			 WScript.Echo  webInfo
			 
			 
		end if
	next
End Function

'''''''''''''''''''''''''''''''''''''''''''''''''
'
' 	GetCommand Function (pathName )
'	This will return the all the alias names (or Hostname) of a website  along 
'	with their ipaddress and portNo. The argument pathName should be as 
'	"W3SVC/"&WebSitIndexNo&"/ServerBindings"
' 
'
'''''''''''''''''''''''''''''''''''''''''''''''''
Function GetCommand(indexPath)

        Dim IIsObject
        Dim IIsObjectPath
        Dim IIsSchemaObject
        Dim IIsSchemaPath
        Dim ObjectPath
        Dim ObjectParameter
        Dim MachineName
        Dim ValueIndex
        Dim ValueList
        Dim ValueDisplay
        Dim ValueDisplayLen
        Dim NewObjectparameter

        Dim DataPathList
        Dim DataPath
	Dim parsedSite
	Dim aliasInfo
	
        On Error Resume Next

        GetCommand = "null" ' Assume Success


        ObjectPath = indexPath

        SanitizePath ObjectPath
        MachineName = "LocalHost"  	
        ObjectParameter = SplitParam(ObjectPath)
        
        NewObjectparameter = MapSpecGetParamName(ObjectParameter)
        ObjectParameter = NewObjectparameter
	

        If (IsSpecialGetProperty(ObjectParameter)) Then
                GetCommand = DoSpecialGetProp(ObjectPath, ObjectParameter, MachineName)
                Exit Function
        End If

        If ObjectPath = "" Then
                IIsObjectPath = "IIS://" & MachineName
        Else
                IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
        End If
	'WScript.Echo "Before GetObjectIISObjectPath :"&IIsObjectPath
        
        Set IIsObject = GetObject(IIsObjectPath)

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To GET the Object (GetObject Failed): " & ObjectPath
                'WScript.Quit (Err.Number)
                Exit Function
        End If
	
	'WScript.Echo "Before GetObjectIISObjectPath :"&ObjectPath		
	
        ' Get the Schema of the property and determine if it's multivalued
        IIsSchemaPath = "IIS://" & MachineName & "/Schema/" & ObjectParameter
        Set IIsSchemaObject = GetObject(IIsSchemaPath)


	
        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To GET the Schema of the property: " & IIsSchemaPath
                'WScript.Quit (Err.Number)
                Exit Function
        End If

        ' First, attempt to retrieve the property - this will tell us
        ' if you are even allowed to set the property at this node.
        ' Retrieve the property
        ValueList = IIsObject.Get(ObjectParameter)
        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To GET the property: (Get Method Failed) " & ObjectParameter
                WScript.Echo "  (This property is probably not allowed at this node)"
                'WScript.Quit (Err.Number)
                Exit Function
        End If

        ' Test to see if the property is ACTUALLY set at this node
        DataPathList = IIsObject.GetDataPaths(ObjectParameter, IIS_DATA_INHERIT)
        If Err.Number <> 0 Then DataPathList = IIsObject.GetDataPaths(ObjectParameter, IIS_DATA_NO_INHERIT)
        Err.Clear

        ' If the data is not set anywhere, then stop the madness
        If (UBound(DataPathList) < 0) Then
                WScript.Echo "The parameter """ & ObjectParameter & """ is not set at this node."
                'WScript.Quit (&H80005006) ' end with property not set error
                Exit Function
        End If

        DataPath = DataPathList(0)
        SanitizePath DataPath

	
        ' Test to see if the item is actually set HERE
        If UCase(DataPath) <> UCase(IIsObjectPath) Then
                WScript.Echo "The parameter """ & ObjectParameter & """ is not set at this node."
                'WScript.Quit (&H80005006) ' end with property not set error
                Exit Function
        End If

        ' Set up the initial part of the display - the property name and data type
        ValueDisplay = ObjectParameter
        ValueDisplayLen = Len(ValueDisplay)
	
        If (ValueDisplayLen < SpacerSize) Then
                'ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & TypeName (ValueList) & ") "
                ValueDisplay = ValueDisplay & (Right(Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & UCase(IIsSchemaObject.Syntax) & ") "
        Else
                ValueDisplay = ValueDisplay & ": " & "(" & TypeName(ValueList) & ") "
        End If

        ' Create the rest of the display - The actual data
 	       
        If (IIsSchemaObject.MultiValued) Then
                For ValueIndex = 0 To UBound(ValueList)
                       'WScript.Echo ValueList(ValueIndex)
 			parsedSite = ParseSite(ValueList(ValueIndex))
 			if (ValueIndex = 0) then
 				aliasInfo=parsedSite
 			else
 				aliasInfo=aliasInfo&"#"&parsedSite
 			end if 	
                        'ValueDisplay = ValueDisplay & """" & ValueList(ValueIndex) & """ "
                Next
        End If

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To GET the Property: " & ObjectParameter
                'WScript.Quit (Err.Number)
                Exit Function
        End If

        GetCommand = aliasInfo ' Success

End Function


''''''''''''''''''''''''
'	ParseSite(siteToparse)
'	This will tokennize the aiasSite (Format = ipAddress:portNo:Hostname).
'	If the any of these info is not available make the value as "null".
'
'''''''''''''''''''''''''
Function ParseSite(siteToparse)

	
	
	Dim ar
	Dim ip,host,port,temp 
	Dim res,count

	ar = split(siteToparse,":",-1,vbTextCompare)
	
	count = UBound(ar)
	
	if (ar(0) = "" ) then
		ip = "null"
	else 
		ip = ar(0)
	end if
	if( ar(1) = "") then
		port ="null"
	else
		port = ar(1)
	end if	
	if(ar(2) = "") then
		host = "null"
	else 
		host = ar(2)
	end if	
	If (StrComp(ip,"127.0.0.1")<>0 ) Then
	
		if(count > 2) then 
			temp = ar(3)
			res = ip&":"&port&":"&host&":"&temp
		else
			res = ip&":"&port&":"&host
		end if 
	End If 
	
	ParseSite = res
		
End Function


Sub SanitizePath(ObjectPath)
        On Error Resume Next

        ' Remove WhiteSpace
        Do While (Left(ObjectPath, 1) = " ")
                ObjectPath = Right(ObjectPath, Len(ObjectPath) - 1)
        Loop

        Do While (Right(ObjectPath, 1) = " ")
                ObjectPath = Left(ObjectPath, Len(ObjectPath) - 1)
        Loop

        If Left(ObjectPath, 1) = "/" Then
                ObjectPath = Right(ObjectPath, Len(ObjectPath) - 1)
        End If

        If Right(ObjectPath, 1) = "/" Then
                ObjectPath = Left(ObjectPath, Len(ObjectPath) - 1)
        End If

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error Trying To Sanitize the path: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

End Sub


''''''''''''''''''''''''''
'
' IsSpecialGetProperty
'
' Checks to see if the property requires special processing in order to
' display its contents.
'
''''''''''''''''''''''''''
Function IsSpecialGetProperty(ObjectParameter)

        On Error Resume Next

        Select Case UCase(ObjectParameter)
                Case "MIMEMAP"
                        IsSpecialGetProperty = True
                Case Else
                        IsSpecialGetProperty = False
        End Select

End Function


''''''''''''''''''''''''''
'
' DoSpecialGetProp
'
' Checks to see if the property requires special processing in order to
' display its contents.
'
''''''''''''''''''''''''''
Function DoSpecialGetProp(ObjectPath, ObjectParameter, MachineName)

        On Error Resume Next

        Select Case UCase(ObjectParameter)
                Case "MIMEMAP"
                        DoSpecialGetProp = MimeMapGet(ObjectPath, MachineName)
                Case Else
                        DoSpecialGetProp = False
        End Select

End Function


''''''''''''''''''''''''''''''
'
' Function SeparateMachineName
'
' This function will get the machine name from the Path parameter
' that was passed into the script.  It will also alter the passed in
' path so that it contains only the rest of the path - not the machine
' name.  If there is no machine name in the path, then the script
' will assume LocalHost.
'
''''''''''''''''''''''''''''''
Function SeparateMachineName(Path)
        On Error Resume Next

        ' Temporarily, just return LocalHost
         SeparateMachineName = "LocalHost"
        

        Exit Function
End Function

''''''''''''''''''''''''''''''
'
' Function MapSpecGetParamName
'
' Some parameters in MDUTIL are named differently in ADSI.
' This function maps the improtant parameter names to ADSI
' names.
'
''''''''''''''''''''''''''''''
Function MapSpecGetParamName(ObjectParameter)
        On Error Resume Next

        Select Case UCase(ObjectParameter)
                Case "ACCESSPERM"
                        WScript.Echo "Note: Your parameter """ & ObjectParameter & """ is being mapped to AccessFlags"
                        WScript.Echo "      Check individual perms using ""GET AccessRead"", ""GET AccessWrite"", etc."
                        MapSpecGetParamName = "AccessFlags"
                Case "VRPATH"
                        'WScript.Echo "Note: Your parameter """ & ObjectParameter & """ is being mapped to PATH"
                        MapSpecGetParamName = "Path"
                Case "AUTHORIZATION"
                        WScript.Echo "Note: Your parameter """ & ObjectParameter & """ is being mapped to AuthFlags"
                        WScript.Echo "      Check individual auths using ""GET AuthNTLM"", ""GET AuthBasic"", etc."
                        MapSpecGetParamName = "AuthFlags"
                Case Else
                        ' Do nothing - the parameter doesn't map to anything special
                        MapSpecGetParamName = ObjectParameter
        End Select
End Function

Function SplitParam(ObjectPath)
' Note: Assume the string has been sanitized (no leading or trailing slashes)
        On Error Resume Next

        Dim SlashIndex
        Dim TempParam
        Dim ObjectPathLen

        SplitParam = ""  ' Assume no parameter
        ObjectPathLen = Len(ObjectPath)

        ' Separate the path of the node from the parameter
        SlashIndex = InStrRev(ObjectPath, "/")

        If (SlashIndex = 0) Or (SlashIndex = ObjectPathLen) Then
                TempParam = ObjectPath
                ObjectPath = "" ' ObjectParameter is more important
        Else
                TempParam = ObjectPath
                ObjectPath = Left(ObjectPath, SlashIndex - 1)
                TempParam = Right(TempParam, Len(TempParam) - SlashIndex)
        End If

        SplitParam = TempParam

        If (Err.Number <> 0) Then
                ReportError ()
                WScript.Echo "Error trying to Split the parameter from the object: " & ObjectPath
                WScript.Quit (Err.Number)
        End If

End Function


'---------------------------------------------------------------------------------
Sub Display(Msg)
	WScript.Echo Now & ". Error Code: " & Hex(Err) & " - " & Msg
End Sub

Sub Trace(Msg)
	WScript.Echo Msg	
End Sub
 
'---------------------------------------------------------------------------------

'' SIG '' Begin signature block
'' SIG '' MIIlSgYJKoZIhvcNAQcCoIIlOzCCJTcCAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFGU2cK1ytvKP
'' SIG '' VHixt9oZEVz0GHVioIIecjCCBTAwggQYoAMCAQICEAQJ
'' SIG '' GBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTEL
'' SIG '' MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IElu
'' SIG '' YzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
'' SIG '' A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENB
'' SIG '' MB4XDTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFow
'' SIG '' cjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0
'' SIG '' IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
'' SIG '' MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
'' SIG '' IENvZGUgU2lnbmluZyBDQTCCASIwDQYJKoZIhvcNAQEB
'' SIG '' BQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsxSRnP
'' SIG '' 0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3
'' SIG '' Gde2qvCchqXYJawOeSg6funRZ9PG+yknx9N7I5TkkSOW
'' SIG '' kHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJRdQtoaPp
'' SIG '' iCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/
'' SIG '' 6XzLkqHlOzEcz+ryCuRXu0q16XTmK/5sy350OTYNkO/k
'' SIG '' tU6kqepqCquE86xnTrXE94zRICUj6whkPlKWwfIPEvTF
'' SIG '' jg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+m
'' SIG '' M6n9Gd8lk9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggr
'' SIG '' BgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
'' SIG '' MEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3Js
'' SIG '' NC5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURS
'' SIG '' b290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsME8GA1UdIARIMEYwOAYKYIZIAYb9bAACBDAqMCgG
'' SIG '' CCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5j
'' SIG '' b20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7
'' SIG '' KgqjpepxA8Bg+S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv
'' SIG '' 9JLLgjEtUYunpyGd823IDzANBgkqhkiG9w0BAQsFAAOC
'' SIG '' AQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134L
'' SIG '' YP3DPQ/Er4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFO
'' SIG '' EKTuP3GOYw4TS63XX0R58zYUBor3nEZOXP+QsRsHDpEV
'' SIG '' +7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRH
'' SIG '' oXpoaK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQM
'' SIG '' JQhCMrI2iiQC/i9yfhzXSUWW6Fkd6fp0ZGuy62ZD2rOw
'' SIG '' jNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
'' SIG '' 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBY0w
'' SIG '' ggR1oAMCAQICEA6bGI750C3n79tQ4ghAGFowDQYJKoZI
'' SIG '' hvcNAQEMBQAwZTELMAkGA1UEBhMCVVMxFTATBgNVBAoT
'' SIG '' DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
'' SIG '' ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJl
'' SIG '' ZCBJRCBSb290IENBMB4XDTIyMDgwMTAwMDAwMFoXDTMx
'' SIG '' MTEwOTIzNTk1OVowYjELMAkGA1UEBhMCVVMxFTATBgNV
'' SIG '' BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRp
'' SIG '' Z2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1
'' SIG '' c3RlZCBSb290IEc0MIICIjANBgkqhkiG9w0BAQEFAAOC
'' SIG '' Ag8AMIICCgKCAgEAv+aQc2jeu+RdSjwwIjBpM+zCpyUu
'' SIG '' ySE98orYWcLhKac9WKt2ms2uexuEDcQwH/MbpDgW61bG
'' SIG '' l20dq7J58soR0uRf1gU8Ug9SH8aeFaV+vp+pVxZZVXKv
'' SIG '' aJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0O21x4i0MG+4g
'' SIG '' 1ckgHWMpLc7sXk7Ik/ghYZs06wXGXuxbGrzryc/NrDRA
'' SIG '' X7F6Zu53yEioZldXn1RYjgwrt0+nMNlW7sp7XeOtyU9e
'' SIG '' 5TXnMcvak17cjo+A2raRmECQecN4x7axxLVqGDgDEI3Y
'' SIG '' 1DekLgV9iPWCPhCRcKtVgkEy19sEcypukQF8IUzUvK4b
'' SIG '' A3VdeGbZOjFEmjNAvwjXWkmkwuapoGfdpCe8oU85tRFY
'' SIG '' F/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6SPDgohIbZpp0
'' SIG '' yt5LHucOY67m1O+SkjqePdwA5EUlibaaRBkrfsCUtNJh
'' SIG '' besz2cXfSwQAzH0clcOP9yGyshG3u3/y1YxwLEFgqrFj
'' SIG '' GESVGnZifvaAsPvoZKYz0YkH4b235kOkGLimdwHhD5QM
'' SIG '' IR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxfjT/JvNNBERJb
'' SIG '' 5RBQ6zHFynIWIgnffEx1P2PsIV/EIFFrb7GrhotPwtZF
'' SIG '' X50g/KEexcCPorF+CiaZ9eRpL5gdLfXZqbId5RsCAwEA
'' SIG '' AaOCATowggE2MA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O
'' SIG '' BBYEFOzX44LScV1kTN8uZz/nupiuHA9PMB8GA1UdIwQY
'' SIG '' MBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgPMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjB5BggrBgEFBQcBAQRtMGswJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggr
'' SIG '' BgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDBF
'' SIG '' BgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsMBEGA1UdIAQKMAgwBgYEVR0gADANBgkqhkiG9w0B
'' SIG '' AQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22Ftf3v1cHvZqs
'' SIG '' oYcs7IVeqRq7IviHGmlUIu2kiHdtvRoU9BNKei8ttzjv
'' SIG '' 9P+Aufih9/Jy3iS8UgPITtAq3votVs/59PesMHqai7Je
'' SIG '' 1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cnRNTnf+hZqPC/
'' SIG '' Lwum6fI0POz3A8eHqNJMQBk1RmppVLC4oVaO7KTVPeix
'' SIG '' 3P0c2PR3WlxUjG/voVA9/HYJaISfb8rbII01YBwCA8sg
'' SIG '' sKxYoA5AY8WYIsGyWfVVa88nq2x2zm8jLfR+cWojayL/
'' SIG '' ErhULSd+2DrZ8LaHlv1b0VysGMNNn3O3AamfV6peKOK5
'' SIG '' lDCCBjMwggUboAMCAQICEAiadJ64LcPsJ+pl6tv4NTEw
'' SIG '' DQYJKoZIhvcNAQELBQAwcjELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQg
'' SIG '' U0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBDQTAe
'' SIG '' Fw0yMTA1MjUwMDAwMDBaFw0yNDA1MjkyMzU5NTlaMHEx
'' SIG '' CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpOZXcgSmVyc2V5
'' SIG '' MQ8wDQYDVQQHEwZJc2VsaW4xHTAbBgNVBAoTFGVHIElu
'' SIG '' bm92YXRpb25zLCBJbmMuMR0wGwYDVQQDExRlRyBJbm5v
'' SIG '' dmF0aW9ucywgSW5jLjCCAiIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggIPADCCAgoCggIBAMRlCdKa4238XJoGRo3eyQ8TrO7M
'' SIG '' kh72kN8Bkdimw92mWoHkhPpBtLSpBLEOJ2vG5zVYmP8x
'' SIG '' eD26NGZGLTMySJNAGVw0zL16/5hL5isQm4iRUwqSpJme
'' SIG '' LGuQWXzu4oCL3DUmtMyCNmuY4kCRcvOY/n/SOBIE6PTn
'' SIG '' HVXiDV4YENsWek4xCvqW4aplV76/AwduiXJTmnndC+Vb
'' SIG '' O/gmxs2bion4MS9ovHeRQ85IWUmX3QrRrRLxOaS3rF0l
'' SIG '' n6c1HXbwjUYrCDxge5oPkZZ9l71GcsmkVEbZcddaWHyf
'' SIG '' yjWAJFAi9t654d/P5msbUr3XoqGAY+MS8re6aEARvm9L
'' SIG '' swo4EQA3t/5NDbYlcCSKNGRLFMgwDaeySCIzHj87DjGM
'' SIG '' 3zD8ovHJQMHwWHNl4UrlHF98in+JKURZgpWHyuS7LRkE
'' SIG '' TWzjY6bAgUxIGbsBH5HTlNK5mjMsGRVSxxKZqWGXj8+z
'' SIG '' N1YTfmleepEf3n6PHg/NROVQ0KpiYhliqv7PY4W5GB+4
'' SIG '' NroS9jF2/7kbIVQ0jpBUbyCA/5fsgyaIAwaWnt8dqL+W
'' SIG '' L42PGaPERdLV78ktK37A7wDWcO5qbcx59AZZsOZboNxd
'' SIG '' glSaTW829R5gB+pNMhR5lmAqFADWwQdGEf5OCb4GNm8r
'' SIG '' bRe3EDycpe1CPQruCkwIO0TphpMHS4Zl6DwgXKNBAgMB
'' SIG '' AAGjggHEMIIBwDAfBgNVHSMEGDAWgBRaxLl7Kgqjpepx
'' SIG '' A8Bg+S32ZXUOWDAdBgNVHQ4EFgQU+chEms/YE0kvGgTW
'' SIG '' ta9+DDAONkowDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHcGA1UdHwRwMG4wNaAzoDGGL2h0
'' SIG '' dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
'' SIG '' ZWQtY3MtZzEuY3JsMDWgM6Axhi9odHRwOi8vY3JsNC5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNy
'' SIG '' bDBLBgNVHSAERDBCMDYGCWCGSAGG/WwDATApMCcGCCsG
'' SIG '' AQUFBwIBFhtodHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9D
'' SIG '' UFMwCAYGZ4EMAQQBMIGEBggrBgEFBQcBAQR4MHYwJAYI
'' SIG '' KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNv
'' SIG '' bTBOBggrBgEFBQcwAoZCaHR0cDovL2NhY2VydHMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRENv
'' SIG '' ZGVTaWduaW5nQ0EuY3J0MAwGA1UdEwEB/wQCMAAwDQYJ
'' SIG '' KoZIhvcNAQELBQADggEBAJQI53BT7yyssE/+AxAhu2x2
'' SIG '' 7YlZfrrpn0Y9mKxbgobIJL9T5kKYH8qcQt4PhK1fckVf
'' SIG '' Pl10gsDmiid7+kS536YS4RMGHNvtELPzZYm+TQMQxriH
'' SIG '' MwCHlznOZEUabxbENl0jbTO1y9bSw5uqf1RuwaFAMqkV
'' SIG '' 7DD3Vm05Df/Z3QphkrKnMYxtrnfDulYbXvSeS2hwVZN5
'' SIG '' SGQDLR+gAnaOUE6zOPZ2yFPEBrkWDV2SkSwFLuiIA+li
'' SIG '' SjFX2V1pcnw/HWdq93o+kNbgDvzW7Xd/e0/gVUKw1jDh
'' SIG '' vPhnkYicKHr8WyFodEnp2TlKwKvb0yWkrxTEr3LZCZv6
'' SIG '' MS1HFHRBkt8wggauMIIElqADAgECAhAHNje3JFR82Ees
'' SIG '' /ShmKl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYT
'' SIG '' AlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNV
'' SIG '' BAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERp
'' SIG '' Z2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMw
'' SIG '' MDAwMDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkG
'' SIG '' A1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
'' SIG '' IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqG
'' SIG '' SIb3DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJ
'' SIG '' UVXHJQPE8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVC
'' SIG '' X6SI82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0
'' SIG '' hNoR8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w
'' SIG '' 1lbU5ygt69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ
'' SIG '' 3HxqV3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43
'' SIG '' IbtArF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFk
'' SIG '' dECnwHLFuk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcp
'' SIG '' licu9Yemj052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6
'' SIG '' OBGz9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTy
'' SIG '' UpURK1h0QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506
'' SIG '' o9UD4L/wojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB
'' SIG '' 7UK/BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfc
'' SIG '' Yd6T/jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwM
'' SIG '' O1uKIqjBJgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbs
'' SIG '' q11GdeJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5r
'' SIG '' mQzSM7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgw
'' SIG '' BgEB/wIBADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxq
'' SIG '' II+eyG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6
'' SIG '' mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoG
'' SIG '' CCsGAQUFBwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEF
'' SIG '' BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEG
'' SIG '' CCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2Vy
'' SIG '' dC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBD
'' SIG '' BgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNy
'' SIG '' bDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQi
'' SIG '' AX5m1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaop
'' SIG '' afxpwc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQ
'' SIG '' TGIdDAiCqBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+K
'' SIG '' LHqrhc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQ
'' SIG '' cAp876i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6
'' SIG '' wCeCRK6ZJxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SN
'' SIG '' oOeY+/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3
'' SIG '' ZpHxcpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/
'' SIG '' a6fxZsNBzU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr
'' SIG '' 5Dhzq6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j
'' SIG '' /R0o08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT
'' SIG '' 1ObyF5lZynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCY
'' SIG '' oCvtlUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y
'' SIG '' 3wSJ8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqk
'' SIG '' hQ/8mJb2VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqh
'' SIG '' K/bt1nz8MIIGwDCCBKigAwIBAgIQDE1pckuU+jwqSj0p
'' SIG '' B4A9WjANBgkqhkiG9w0BAQsFADBjMQswCQYDVQQGEwJV
'' SIG '' UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNV
'' SIG '' BAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBT
'' SIG '' SEEyNTYgVGltZVN0YW1waW5nIENBMB4XDTIyMDkyMTAw
'' SIG '' MDAwMFoXDTMzMTEyMTIzNTk1OVowRjELMAkGA1UEBhMC
'' SIG '' VVMxETAPBgNVBAoTCERpZ2lDZXJ0MSQwIgYDVQQDExtE
'' SIG '' aWdpQ2VydCBUaW1lc3RhbXAgMjAyMiAtIDIwggIiMA0G
'' SIG '' CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDP7KUmOsap
'' SIG '' 8mu7jcENmtuh6BSFdDMaJqzQHFUeHjZtvJJVDGH0nQl3
'' SIG '' PRWWCC9rZKT9BoMW15GSOBwxApb7crGXOlWvM+xhiumm
'' SIG '' KNuQY1y9iVPgOi2Mh0KuJqTku3h4uXoW4VbGwLpkU7sq
'' SIG '' FudQSLuIaQyIxvG+4C99O7HKU41Agx7ny3JJKB5MgB6F
'' SIG '' VueF7fJhvKo6B332q27lZt3iXPUv7Y3UTZWEaOOAy2p5
'' SIG '' 0dIQkUYp6z4m8rSMzUy5Zsi7qlA4DeWMlF0ZWr/1e0Bu
'' SIG '' bxaompyVR4aFeT4MXmaMGgokvpyq0py2909ueMQoP6Mc
'' SIG '' D1AGN7oI2TWmtR7aeFgdOej4TJEQln5N4d3CraV++C0b
'' SIG '' H+wrRhijGfY59/XBT3EuiQMRoku7mL/6T+R7Nu8GRORV
'' SIG '' /zbq5Xwx5/PCUsTmFntafqUlc9vAapkhLWPlWfVNL5Af
'' SIG '' J7fSqxTlOGaHUQhr+1NDOdBk+lbP4PQK5hRtZHi7mP2U
'' SIG '' w3Mh8y/CLiDXgazT8QfU4b3ZXUtuMZQpi+ZBpGWUwFjl
'' SIG '' 5S4pkKa3YWT62SBsGFFguqaBDwklU/G/O+mrBw5qBzli
'' SIG '' GcnWhX8T2Y15z2LF7OF7ucxnEweawXjtxojIsG4yeccL
'' SIG '' WYONxu71LHx7jstkifGxxLjnU15fVdJ9GSlZA076XepF
'' SIG '' cxyEftfO4tQ6dwIDAQABo4IBizCCAYcwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAww
'' SIG '' CgYIKwYBBQUHAwgwIAYDVR0gBBkwFzAIBgZngQwBBAIw
'' SIG '' CwYJYIZIAYb9bAcBMB8GA1UdIwQYMBaAFLoW2W1NhS9z
'' SIG '' KXaaL3WMaiCPnshvMB0GA1UdDgQWBBRiit7QYfyPMRTt
'' SIG '' lwvNPSqUFN9SnDBaBgNVHR8EUzBRME+gTaBLhklodHRw
'' SIG '' Oi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRSU0E0MDk2U0hBMjU2VGltZVN0YW1waW5nQ0Eu
'' SIG '' Y3JsMIGQBggrBgEFBQcBAQSBgzCBgDAkBggrBgEFBQcw
'' SIG '' AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMFgGCCsG
'' SIG '' AQUFBzAChkxodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkRzRSU0E0MDk2U0hBMjU2
'' SIG '' VGltZVN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEBCwUA
'' SIG '' A4ICAQBVqioa80bzeFc3MPx140/WhSPx/PmVOZsl5vdy
'' SIG '' ipjDd9Rk/BX7NsJJUSx4iGNVCUY5APxp1MqbKfujP8DJ
'' SIG '' AJsTHbCYidx48s18hc1Tna9i4mFmoxQqRYdKmEIrUPwb
'' SIG '' tZ4IMAn65C3XCYl5+QnmiM59G7hqopvBU2AJ6KO4ndet
'' SIG '' Hxy47JhB8PYOgPvk/9+dEKfrALpfSo8aOlK06r8JSRU1
'' SIG '' NlmaD1TSsht/fl4JrXZUinRtytIFZyt26/+YsiaVOBmI
'' SIG '' RBTlClmia+ciPkQh0j8cwJvtfEiy2JIMkU88ZpSvXQJT
'' SIG '' 657inuTTH4YBZJwAwuladHUNPeF5iL8cAZfJGSOA1zZa
'' SIG '' X5YWsWMMxkZAO85dNdRZPkOaGK7DycvD+5sTX2q1x+Dz
'' SIG '' BcNZ3ydiK95ByVO5/zQQZ/YmMph7/lxClIGUgp2sCovG
'' SIG '' SxVK05iQRWAzgOAj3vgDpPZFR+XOuANCR+hBNnF3rf2i
'' SIG '' 6Jd0Ti7aHh2MWsgemtXC8MYiqE+bvdgcmlHEL5r2X6cn
'' SIG '' l7qWLoVXwGDneFZ/au/ClZpLEQLIgpzJGgV8unG1TnqZ
'' SIG '' bPTontRamMifv427GFxD9dAq6OJi7ngE273R+1sKqHB+
'' SIG '' 8JeEeOMIA11HLGOoJTiXAdI/Otrl5fbmm9x+LMz/F0xN
'' SIG '' AKLY1gEOuIvu5uByVYksJxlh9ncBjDGCBkQwggZAAgEB
'' SIG '' MIGGMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJl
'' SIG '' ZCBJRCBDb2RlIFNpZ25pbmcgQ0ECEAiadJ64LcPsJ+pl
'' SIG '' 6tv4NTEwCQYFKw4DAhoFAKBwMBAGCisGAQQBgjcCAQwx
'' SIG '' AjAAMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwG
'' SIG '' CisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMCMGCSqG
'' SIG '' SIb3DQEJBDEWBBRKmTYCuTJll/S3IBTRyrF/hEFXSjAN
'' SIG '' BgkqhkiG9w0BAQEFAASCAgChj0nAO1xImPlzwXbmmS1H
'' SIG '' 9zs21qW8rZA75gbmD0u9U+WMY99AMvCysY/pQnY97Ei2
'' SIG '' PrQ1ReiFc6zkJDQcIlgUXvkj3cWccdty148SqLnm5dF6
'' SIG '' HneZ6SAvT97uZWarX4BYc7lIFh8B+HRWOvmKjG/3qRLu
'' SIG '' 7YaKeIDiyoa+PDL0t/9DHRMgCF0C5X+12HXX+La2T6OY
'' SIG '' +h+0Lnq6zIDm9g8GPz4lzlS50Z8V1kded1Hz2E9wOmya
'' SIG '' SRvztKqK/jOa+C6FbjnUeKWBi/c5KKHEiKQkA6yRyHdb
'' SIG '' X0PVvm5gGY5bd6Ca7dC2qGVViE5lCo6NN3aQY+btRnL4
'' SIG '' 8ghHhWTlj7FYbN2Jb5w+5PCYNfPlzgenS0CVBFCkUwZN
'' SIG '' BvFEDIwDb4kbwmfr7OHAzhDCghnKmIDHh1V1XeuAJgKE
'' SIG '' QbkbjVzETjO7tYue1QZvKoSO0C9DS9PNrpyu29qkNzkA
'' SIG '' SsMmruFv6bysDm5m4iMb8mSifmfqQ2nqt03jACUWEc/w
'' SIG '' cmVht3YnZ2dw23W8Ufh/77kgQjAJlv70OctsWfDiaHAS
'' SIG '' W1MlFHwh4PIRUNgiP4Yg4ke4W1Y009IQiuC3dhoSt7gQ
'' SIG '' XhaJJBE+HEFhTpDyf/xzsDSS2hpghx6d/iUu6Ec9Du7M
'' SIG '' artG4DPVhcIScglwiJcFVx3tm6x/L+4i3AM3LPVofK4L
'' SIG '' 9KGCAyAwggMcBgkqhkiG9w0BCQYxggMNMIIDCQIBATB3
'' SIG '' MGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2Vy
'' SIG '' dCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
'' SIG '' ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcg
'' SIG '' Q0ECEAxNaXJLlPo8Kko9KQeAPVowDQYJYIZIAWUDBAIB
'' SIG '' BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwG
'' SIG '' CSqGSIb3DQEJBTEPFw0yMjEyMTQwODU3MjVaMC8GCSqG
'' SIG '' SIb3DQEJBDEiBCAdZVPBV/reYMoheyfZLLD35BLReDI5
'' SIG '' bf/qqatxWbrYmzANBgkqhkiG9w0BAQEFAASCAgCkI760
'' SIG '' MbrDMj6aLZcLbep96WQmpAiXPRcILcnfxJ3lGTQx187X
'' SIG '' XdH5c1EWBU30HFtvSTCaefWSbmLh8wQWpOA8iJJw13Bv
'' SIG '' Ab51gqDqJj+wFUnCxBtkYiKGVgKwJwZJqffYdxq/APoW
'' SIG '' p3BMwRXU1moiLVEvS955EtSXobgKdC82BxPkonHn/V5s
'' SIG '' Xd6vcRieybu+UFs9DeB532v2dHlc2LDhkt1tYApGCOJw
'' SIG '' 8inXsjrb6M4iME7C6mNMtzPHaONnZWWPkXO8QsUiz456
'' SIG '' rf19ali50oBYOsGRYnQvr5XHaBIiVoFgzNuQgfeQfkPC
'' SIG '' hz1uZ2I6f+vUUd1DvdxPvURm4CAxe1sNv2eZasNb9c9t
'' SIG '' A7nlp+e+P7C/ILPLrUcTuhVwHFMgzCNltZaQkbUKP6K3
'' SIG '' t8XpLqOuLpEnZP2F6ERAK/Ky3bUUZQOibxzpw6XsWuM0
'' SIG '' Fe+JqSai3MaNiiIoYPItBncfQKPraMPpA3Tt35AEE0Tb
'' SIG '' u4mUbA8F+RiS+Sz9S+RMGZxDvJgUj6NlE/VmrRRHvcv6
'' SIG '' lDJyXfaf/Ch3Td0d2lNLBXBj1P1xf6ieXO2QOoH5FUMP
'' SIG '' dMhOkAbz9P37N2NGev5Pth7DmunQ8ldzAHQhPSo5+kra
'' SIG '' lF/D3uEgt395TUcJ1siOaYHBpNnvSe2vJsf6aKn/q4St
'' SIG '' A2apKtdA9FChOZaoxQ==
'' SIG '' End signature block
