$ErrorActionPreference = 'SilentlyContinue'
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

# Array of files to be cleaned
[array]$arrFilesToBeDeleted = @(
    '%SystemRoot%\memory.dmp',
    '%SystemRoot%\Minidump.dmp'
)
 
# Array of folders to be cleaned
[array]$arrFoldersToBeCleaned = @(
    '%systemroot%\Downloaded Program Files',
    '%systemroot%\Temp',
    '%systemdrive%\Windows.old',
    '%systemdrive%\Temp',
    '%systemdrive%\MSOCache\All Users',
    '%allusersprofile%\Adobe\Setup',
    '%allusersprofile%\Microsoft\Windows Defender\Definition Updates',
    '%allusersprofile%\Microsoft\Windows Defender\Scans',
    '%allusersprofile%\Microsoft\Windows\WER'
)

# Create counter to optionally record how many files could not be deleted. Not output by default
[long]$lngSkippedFileCount = 0
$global:TotalFileSize = 0

Function Log ($strLogString)
{
  # This function provides Log in the console on errors or progress, and aborts if error has occured.
  If ($error.count -eq 0)
  {
    Write-Host -Object $strLogString
  }
  # If an error occured report it, and exit the script with ErrorLevel 1
  Else
  {
    Write-Host -Object $strLogString
    # Display error details
    Write-Host 'Details: ' $error[0].Exception.Message
  }
}

Function Remove-AllFilesInFolder ($strFolder){
    $ExpFolder = [System.Environment]::ExpandEnvironmentVariables("$strFolder")
    # Make sure folder exists, Get-Childitem -recurse can hang on folders that don't exist
    If ((Test-Path -Path "$ExpFolder") -eq $true){
        $Files = Get-ChildItem -Path $ExpFolder -Recurse -File -Force
        # Call the function to remove the files
        Remove-FilesInArray $Files
    }
}

Function Remove-FilesInArray ($arrFiles){
    Foreach ($File in $Files){
        try 
		{
			$crntFileSize = 0
            $crntFileSize = (Get-Item $file.Fullname).length
			$crntFileSize = [System.Math]::Round((($crntFileSize)/1KB),2)
			
            Remove-Item -Path $file.Fullname -Force -ErrorAction Stop
			
			$global:TotalFileSize += $crntFileSize
			$($file.Fullname)
        }
        catch {
			"Unable to delete: $($file.Fullname)"
			$script:lngSkippedFileCount += 1
		}
    }
}
"File deletion starts"
 # Pass the folder array to function that gathers files

Foreach ($folder in $arrFoldersToBeCleaned) {
    Remove-AllFilesInFolder $folder
}

# Delete the specified files
Foreach ($File in $arrFilesToBeDeleted){
    Try{
        # Check if the file exists at all before trying to remove it, because default files may not exist on system
        $File = [System.Environment]::ExpandEnvironmentVariables("$File")
        If (Test-Path -Path $File) 
		{
			$crntFileSize = 0
			$crntFileSize = (Get-Item $File).length
			$crntFileSize = [System.Math]::Round((($crntFileSize)/1KB),2)
            
			Remove-Item -Path $File -Force -ErrorAction Stop
			
			$global:TotalFileSize += $crntFileSize
			$file
        }
    }
    catch{
	"Unable to delete: $($File)"
        # File WAS FOUND but the file object could not be retreived, increase the Skipped File counter
        $lngSkippedFileCount +=1
    }
}
"File deletion end"
$global:TotalFileSize = [math]::Round(($global:TotalFileSize))
Write-host "Number of files skipped from deletion due to locked or used by applications = $lngSkippedFileCount"
Write-Host "Disk Space Freed = $global:TotalFileSize KB"
Write-Host "Disk Space Automation Completed"
