Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$CONFIG_INFO_SEPARATOR = ">"
$Servers = Get-XAServer -full
Write-Host "#====Load Evaluator details - starts====#"

foreach($server in $Servers)
{
	$Evaluators = Get-XALoadEvaluator -servername $server.ServerName

	Write-Host("#==== Version : ",$Server.OSVersion, "====#")
	$a = "Load Evaluator name : " + $Server.IPAddresses + $CONFIG_INFO_SEPARATOR+$Evaluators.LoadEvaluatorName
	Write-Host ($a)
	Write-Host "#====Rule types starts====#"
	if($Evaluators.CpuUtilizationEnabled -eq "True")
	{
		$a = "CPU utilization#" + $Evaluators.CpuUtilization
		Write-Host $a
	}
	if($Evaluators.ContextSwitchesEnabled -eq "True")
	{
		$a = "Context switches#" + $Evaluators.ContextSwitches
		Write-Host $a
	}
	if($Evaluators.MemoryUsageEnabled -eq "True")
	{
		$a = "Memory usage#" + $Evaluators.MemoryUsage
		Write-Host $a
	}

	if($Evaluators.PageFaultsEnabled -eq "True")
	{
		$a = "Page faults#" + $Evaluators.PageFaults
		Write-Host $a
	}
	Write-Host  "Scheduling # - # -"
	if($Evaluators.PageSwapsEnabled -eq "True")
	{
		$a = "Page swaps#" + $Evaluators.PageSwaps
		Write-Host $a
	}
	if($Evaluators.DiskDataIOEnabled -eq "True")
	{
		$a = "Disk data IO#" + $Evaluators.DiskDataIO
		Write-Host $a
	}
	if($Evaluators.DiskOperationsEnabled -eq "True")
	{
		$a = "Disk operations#" + $Evaluators.DiskOperations
		Write-Host $a
	}
	Write-Host "IP range # - # -"
	if($Evaluators.ApplicationUserLoadEnabled -eq "True")
	{
		$a = "Application user load#" + $Evaluators.ApplicationUserLoad
		Write-Host $a
	}
	if($Evaluators.ServerUserLoadEnabled -eq "True")
	{
		$a = "Server user load#" + $Evaluators.ServerUserLoad
		Write-Host $a
	}
	Write-Host "#====Rule types ends====#"
	
}
Write-Host  "#====Load Evaluator details - end====#"
Remove-PSSnapin Citrix.XenApp.Commands



