﻿Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Write-Host "#====Load Evaluator details - starts====#"
$LoadEvaluators = Get-XALoadEvaluator -EA 0 | sort-object LoadEvaluatorName
If( $? )
{
	ForEach($LoadEvaluator in $LoadEvaluators)
	{
		Write-Host "Load Evaluator Name:" $LoadEvaluator.LoadEvaluatorName
		If($LoadEvaluator.IsBuiltIn)
		{
			Write-Host "Built-in Load Evaluator"
		} 
		Else 
		{
			Write-Host "User created load evaluator"
		} 
		
		Write-Host "#====Rule types starts====#"
		If($LoadEvaluator.ApplicationUserLoadEnabled)
		{
			Write-Host "Applicaiton User Load Rule: Enabled"
			Write-Host "Report full load when the number of users for this application equals: " $LoadEvaluator.ApplicationUserLoad
		    Write-Host "Application: " $LoadEvaluator.ApplicationBrowserName
		}
		else
		{
			Write-Host "Applicaiton User Load Rule: Disabled"
			Write-Host "Report full load when the number of users for this application equals: -"
		    Write-Host "Application: -"		
		}
		
			
		If($LoadEvaluator.ContextSwitchesEnabled)
		{
			Write-Host "Context Switches Load Rule: Enabled"
			Write-Host "Report full load when the number of context switches per second is greater than this value: " $LoadEvaluator.ContextSwitches[1]
			Write-Host "Report no load when the number of context switches per second is less than or equal to this value: " $LoadEvaluator.ContextSwitches[0]
		}
		else
		{
			Write-Host "Context Switches Load Rule: Disabled"
			Write-Host "Report full load when the number of context switches per second is greater than this value: -" 
			Write-Host "Report no load when the number of context switches per second is less than or equal to this value: -" 
		}
		
		If($LoadEvaluator.CpuUtilizationEnabled)
		{
			Write-Host "Cpu Utilization Load Rule: Enabled"
			Write-Host "Report full load when the processor utilization percentage is greater than this value: " $LoadEvaluator.CpuUtilization[1]
			Write-Host "Report no load when the processor utilization percentage is less than or equal to this value: " $LoadEvaluator.CpuUtilization[0]
		}
		else
		{
			Write-Host "Cpu Utilization Load Rule: Disabled"
			Write-Host "Report full load when the processor utilization percentage is greater than this value: -" 
			Write-Host "Report no load when the processor utilization percentage is less than or equal to this value: -" 
		
		}
		
		If($LoadEvaluator.DiskDataIOEnabled)
		{
			Write-Host "Disk DataIO Load Rule : Enabled"
			Write-Host "Report full load when the total disk I/O in kilobytes per second is greater than this value: " $LoadEvaluator.DiskDataIO[1]
			Write-Host "Report no load when the total disk I/O in kilobytes per second is less than or equal to this value: " $LoadEvaluator.DiskDataIO[0]
		}
		else
		{
			Write-Host "Disk DataIO Load Rule : Disabled"
			Write-Host "Report full load when the total disk I/O in kilobytes per second is greater than this value: -"
			Write-Host "Report no load when the total disk I/O in kilobytes per second is less than or equal to this value: -"
		}
		
		If($LoadEvaluator.DiskOperationsEnabled)
		{
			Write-Host "Disk Operations Load Rule: Enabled"
			Write-Host "Report full load when the total number of read and write operations per second is greater than this value: " $LoadEvaluator.DiskOperations[1]
			Write-Host "Report no load when the total number of read and write operations per second is less than or equal to this value: " $LoadEvaluator.DiskOperations[0]
		}
		else
		{
			Write-Host "Disk Operations Load Rule: Disabled"
			Write-Host "Report full load when the total number of read and write operations per second is greater than this value: -"
			Write-Host "Report no load when the total number of read and write operations per second is less than or equal to this value: -"
		}
		
		
		If($LoadEvaluator.IPRangesEnabled)
		{
			Write-Host "IP Range Rule : Enabled"
			If($LoadEvaluator.IPRangesAllowed)
			{
				Write-Host "IP Range Settings : Allow"
				Write-Host "client connections fro the listed IP Ranges : " $LoadEvaluator.IPRanges
			}
			else
			{
				Write-Host "IP Range Settings : Deny"
				Write-Host "client connections fro the listed IP Ranges: -"
			}
		}
		else
		{
			Write-Host "IP Range Rule : Disabled"	
			Write-Host "IP Range Settings : Deny"
			Write-Host "client connections fro the listed IP Ranges: -"

		}
		
		
		If($LoadEvaluator.LoadThrottlingEnabled)
		{
			Write-Host "Load Throttling Rule : Enabled"
			Write-Host "Impact of logons on load: " $LoadEvaluator.LoadThrottling
		}
		else
		{
			Write-Host "Load Throttling Rule : Disabled"
			Write-Host "Impact of logons on load: -"
		
		}
		
		
		If($LoadEvaluator.MemoryUsageEnabled)
		{
			Write-Host  "Memory Usage Rule : Enabled"
			Write-Host "Report full load when the memory usage is greater than this value: " $LoadEvaluator.MemoryUsage[1]
			Write-Host "Report no load when the memory usage is less than or equal to this value: " $LoadEvaluator.MemoryUsage[0]
		}
		else
		{
			Write-Host  "Memory Usage Rule : Disabled"
			Write-Host "Report full load when the memory usage is greater than this value: -"
			Write-Host "Report no load when the memory usage is less than or equal to this value: -"
			
		}
		
		If($LoadEvaluator.PageFaultsEnabled)
		{
			Write-Host "Page Faults Rule : Enabled"
			Write-Host "Report full load when the number of page faults per second is greater than this value: " $LoadEvaluator.PageFaults[1]
			Write-Host "Report no load when the number of page faults per second is less than or equal to this value: " $LoadEvaluator.PageFaults[0]
		}
		else
		{
			Write-Host "Page Faults Rule : Disabled"
			Write-Host "Report full load when the number of page faults per second is greater than this value: -"
			Write-Host "Report no load when the number of page faults per second is less than or equal to this value: -"
		}
		
		
		If($LoadEvaluator.PageSwapsEnabled)
		{
			Write-Host "Page Swaps Rule : Enabled"
			Write-Host "Report full load when the number of page swaps per second is greater than this value: " $LoadEvaluator.PageSwaps[1]
			Write-Host "Report no load when the number of page swaps per second is less than or equal to this value: " $LoadEvaluator.PageSwaps[0]
		}
		else
		{
			Write-Host "Page Swaps Rule : Disabled"
			Write-Host "Report full load when the number of page swaps per second is greater than this value: -"
			Write-Host "Report no load when the number of page swaps per second is less than or equal to this value: -"	
		}
		
		
		If($LoadEvaluator.ScheduleEnabled)
		{
			Write-Host "Scheduling Rule: Enabled"
			Write-Host "Sunday Schedule   : " $LoadEvaluator.SundaySchedule
			Write-Host "Monday Schedule   : " $LoadEvaluator.MondaySchedule
			Write-Host "Tuesday Schedule  : " $LoadEvaluator.TuesdaySchedule
			Write-Host "Wednesday Schedule: " $LoadEvaluator.WednesdaySchedule
			Write-Host "Thursday Schedule : " $LoadEvaluator.ThursdaySchedule
			Write-Host "Friday Schedule   : " $LoadEvaluator.FridaySchedule
			Write-Host "Saturday Schedule : " $LoadEvaluator.SaturdaySchedule
		}
		else
		{
			Write-Host "Scheduling Rule: Disabled"
			Write-Host "Sunday Schedule   : -" 
			Write-Host "Monday Schedule   : -" 
			Write-Host "Tuesday Schedule  : -" 
			Write-Host "Wednesday Schedule: -" 
			Write-Host "Thursday Schedule : -" 
			Write-Host "Friday Schedule   : -" 
			Write-Host "Saturday Schedule : -"
		}
		
		If($LoadEvaluator.ServerUserLoadEnabled)
		{
			Write-Host "Server User Rule : Enabled"
			Write-Host "Report full load when the number of server users equals: " $LoadEvaluator.ServerUserLoad
		}
		else
		{
			Write-Host "Server User Rule : Disabled"
			Write-Host "Report full load when the number of server users equals: -"
		}
		Write-Host "#====Rule types ends====#"
	}
}
Write-Host "#====Load Evaluator details - end====#"
Write-Host "#EG_SCRIPT_DONE#"
Remove-PSSnapin Citrix.XenApp.Commands



