﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$testargs=$args
$reportingname='EXO/'+$testargs[0]
$username=$testargs[1]
$rptTopNDD=[int]$testargs[2]
$Syntime=$testargs[3]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

try{
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "devicestats" -keyFileName "kdevicestats" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
        $users= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'devicestats' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kdevicestats' -InputFile $readfiles[4]
        Write-Host 'ReadFile:'$readfiles[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}

    [System.GC]::GetTotalMemory($true) | out-null
	$useragents=@{}
	$devicetypes=@{}
	$deviceOss=@{}
	$clienttypes=@{}
	$devicelanges=@{}
	$totaldevicecount=0
    #$domainname=$username.split('@')[1]
	foreach($user in $users)
	{
		$totaldevicecount++
	    $useragent=$user.DeviceUserAgent
	       if($useragent -ne "" -and $useragent -ne $null)
	       {
		
			 if($useragents.ContainsKey($useragent))
			 {
			      $useragents[$useragent]+=1
			 }
			 else
			 {
			      $useragents.Add($useragent,1) 
			 }
	       }


	    $devicetype=$user.DeviceType
	       if($devicetype -ne "" -and $devicetype -ne $null)
	       {
		     
			 if($devicetypes.ContainsKey($devicetype))
			 {
			      $devicetypes[$devicetype]+=1
			 }
			 else
			 {
			      $devicetypes.Add($devicetype,1) 
			 }
	       }


	    $deviceos=$user.DeviceOS
	       if($deviceos -ne "" -and $deviceos -ne $null -and -not($deviceos -match "^[A-Z]$") -and -not($deviceos -match "^\d+$")  -and -not($deviceos -match "^\d+.+\d+.+\d+$")  -and -not($deviceos -match "^\d+.+\d+$") )
	       {
		     
			 if($deviceOss.ContainsKey($deviceos))
			 {
			      $deviceOss[$deviceos]+=1
			 }
			 else
			 {
			      $deviceOss.Add($deviceos,1) 
			 }
	       }


	    $clienttype=$user.ClientType
	       if($clienttype -ne "" -and $clienttype -ne $null)
	       { 
		
			 if($clienttypes.ContainsKey($clienttype))
			 {
			      $clienttypes[$clienttype]+=1
			 }
			 else
			 {
			      $clienttypes.Add($clienttype,1) 
			 }
	       }


	    $devicelang=$user.DeviceOSLanguage
	       if($devicelang -ne "" -and $devicelang -ne $null)
	       { 
		
			 if($devicelanges.ContainsKey($devicelang))
			 {
			      $devicelanges[$devicelang]+=1
			 }
			 else
			 {
			      $devicelanges.Add($devicelang,1) 
			 }
	       }

	}

	    Write-Host "useragentscount "$useragents.Count
	    Write-Host "devicetypescount "$devicetypes.Count
	    Write-Host "operatingsystemscount "$deviceOss.Count
	    Write-Host "clientscount "$clienttypes.Count
	    Write-Host "deviceOSlangcount "$devicelanges.Count
	    Write-Host "Sychdevicescount "$totaldevicecount

	    foreach($entry in $useragents.GetEnumerator() | sort -Property value  -Descending | select -first $rptTopNDD)
	    {
		Write-Host '#useragents' $entry.Name ~!~ $entry.Value
	    }


	    foreach($entry in $devicetypes.GetEnumerator() | sort -Property value  -Descending | select -first $rptTopNDD)
	    {
		Write-Host '#devicetypes' $entry.Name ~!~ $entry.Value
	    }


	    foreach($entry in $deviceOss.GetEnumerator() | sort -Property value  -Descending | select -first $rptTopNDD)
	    {
		Write-Host '#deviceOss' $entry.Name ~!~ $entry.Value
	    }


	    foreach($entry in $clienttypes.GetEnumerator() | sort -Property value  -Descending | select -first $rptTopNDD)
	    {
		Write-Host '#clienttypes' $entry.Name ~!~ $entry.Value
	    }


	    foreach($entry in $devicelanges.GetEnumerator() | sort -Property value  -Descending | select -first $rptTopNDD)
	    {
		Write-Host '#devicelanges' $entry.Name ~!~ $entry.Value
	    }
[System.GC]::GetTotalMemory($true) | out-null