﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$egurkhaPath+"\lib\EGFileEncryption.psm1"
$egDatnKy=$egurkhaPath+'\lib\GetDatnKeyFiles.psm1'
Import-Module $egEncryPath,$egDatnKy



$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$DateProxyhost=($TestInputs[4]).ToString().Split("#")
$graphDetails=$TestInputs[5]

$readingdate=[datetime]($DateProxyhost[0].Trim())
$proxyserverip=($DateProxyhost[1]).ToString().trim()

if($graphDetails -and $graphDetails -ne 'none'){
    $graphDetailsArr=($graphDetails).ToString() -Split ("~!~")
    $appId=$graphDetailsArr[0]
    $appSecret=$graphDetailsArr[1]
    $authString=$graphDetailsArr[2]
    $resource=$graphDetailsArr[3]
}

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$proxyserver='http://'+$proxyserverip

$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url  
    )

    Process
    {
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()

        $header = @{
            'Authorization'=$authCode
        }
        $queryRes = [System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
        #$queryRes = Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url 
        $queryRes=$queryRes.Replace('ï»¿','')
	    $queryRes=$queryRes.Replace('(Byte)','')
        $queryRes=$queryRes.Replace(' ','')

        $resultarray = ConvertFrom-Csv -InputObject $queryRes
        $reprts=$resultarray | ConvertTo-Json 
        $jsonRpt=@()
        $jsonRpt='{ "Usage" :['+$reprts+']}'
        $obj=ConvertFrom-Json -InputObject $jsonRpt
        return $obj.Usage
    }
}

try{
    $ConLyncVersnTotal=Eg-InvokeUrl -Url "https://graph.microsoft.com/v1.0/reports/getEmailAppUsageUserCounts(period='D7')"
}catch{
    $message= $_.Exception.Message + $_.ScriptStackTrace 
    Write-Error -Message "Error while running Eg-InvokeUrl function $message "
}
[System.GC]::GetTotalMemory($true) | out-null
$enddate=Get-date
$diffence=(NEW-TIMESPAN –Start $readingdate –End (Get-Date) | Select-Object Days).Days
$strt=$enddate.AddDays(-($diffence+1))

$notFirsttime = $false
while($diffence -ge 1)
{
    if($notFirsttime){ $readingdate=$readingdate.AddDays(1) }
    $actualdate=$readingdate
    $notFirsttime = $true
    $ConLyncVersn =$ConLyncVersnTotal | Where-Object { [datetime]$_.ReportDate -eq $actualdate }       
    if($ConLyncVersn)
    {
        Write-Host 'ReadedDate for the Date#'$actualdate.tostring(“yyyy-MM-dd”)
        break
    }
    else
    {
        Write-Host 'thereIs No Data on#'$actualdate.tostring(“yyyy-MM-dd”)
    }
    $diffence=$diffence-1
}

if($ConLyncVersn)
{
    Write-Host 'ConLyncVersn_MailForMac  '  $ConLyncVersn.MailForMac
    Write-Host 'ConLyncVersn_OutlookForMac  '  $ConLyncVersn.OutlookForMac
    Write-Host 'ConLyncVersn_OutlookForWindows  '  $ConLyncVersn.OutlookForWindows
    Write-Host 'ConLyncVersn_OutlookForMobile  '  $ConLyncVersn.OutlookForMobile
    Write-Host 'ConLyncVersn_OtherForMobile  '  $ConLyncVersn.OtherForMobile
    Write-Host 'ConLyncVersn_OutlookForWeb  '  $ConLyncVersn.OutlookForWeb
    Write-Host 'ConLyncVersn_POP3App  '  $ConLyncVersn.POP3App
    Write-Host 'ConLyncVersn_IMAP4App  '  $ConLyncVersn.IMAP4App
    Write-Host 'ConLyncVersn_SMTPApp  '  $ConLyncVersn.SMTPApp
}
[System.GC]::GetTotalMemory($true) | out-null