﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$scriptPath = $egurkhaPath+"\lib"
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

$AppDir=$egurkhaPath+'\agent\O365\AppInfo'
$unProtPath=$AppDir+'\AppDetails.dat'
$keyFileNam='\AppKey.dat'
if(Test-Path -Path $AppDir ){
    $tempLastWriteTime=(Get-Item $unProtPath).LastWriteTime
    $kvalue=Get-Content -Path $AppDir$keyFileNam
    $null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
    $iniFile=$AppDir+"\AppDetails.ini"
    $appDetails=Get-Content -Path $iniFile
    Remove-Item $iniFile
    foreach($line in $appDetails) {
        Write-Host $line
    }
    Write-Host 'LastWriteTime~'$tempLastWriteTime.tostring('MM/dd/yyyy HH:mm:ss')
}
