'Measures Details
'Format=VariableName=>Measure name
'v=>Application Pool Name
'v1=>Recycle worker processes (in minutes)
'v2=>Recycle worker process (number of requests)
'v3=>Recycle worker processes schedule time (hh:mm)
'v4=>Maximum virtual memory (in MB)
'v5=>Maximum used memory (in MB)
'v6=>Idle timeout
'v7=>Request queue limit
'v8=>Action performed when CPU usage exceeds maximum CPU use
'v9=>Maximum CPU use (percentage)
'v10=>Refresh CPU usage numbers (in minutes)
'v11=>Maximum number of worker processes
'v12=>Enable pinging
'v13=>Ping interval (in seconds)
'v14=>Enable rapid-fail protection
'v15=>Number of worker process failures
'v16=>Time period (in minutes)
'v17=>Startup time limit (in seconds)
'v18=>Shutdown time limit (in seconds)
'v19=>Application pool identity type
'v20=>User name
'v21=>NET CLR  Version
'v22=>Enable 32 Bit-Applications
'v23=>Managed Pipe-Line Mode
'v24=>Start Mode
'v25=>Processor Affinity Enabled
'v26=>Processor Affinity Mask
'v27=>Processor Affinity Mask(64-Bit Option)
'v28=>Idle Time-Out Reached
'v29=>Idle Time-Out Action
'v30=>Load User Profile
'v31=>Ping Maximum Response Time(Seconds)
'v32=>Process Orphaning Enabled
'v33=>Process Orphaning Executable
'v34=>Process Orphaning Executable Parameters
'v35=>Service Unavailable Response
'v36=>Shutdown Executable
'v37=>Shutdown Executable Parameter
'v38=>Disable Overlapped Recycle
'v39=>Disable Recycling For Configuration Changes
'v40=>Application Pool Configuration Changed
'v40=>Isapi Reported Unhealthy
'v40=>Manual Recycle
'v40=>Private Memory Limit Exceeded
'v40=>Regular Time Interval
'v40=>Request Limit Exceed
'v40=>Specific Time
'v40=>Virtual Memory Limit Exceeds

'output format
'v^~^v1^~^v2^~^v3^~^v4^~^v5^~^v6^~^v7^~^v8^~^v9^~^v10^~^v11^~^v12^~^v13^~^v14^~^v15^~^v16^~^v17^~^v18^~^v19^~^v20^~^v21
'^~^v22^~^v23^~^v24^~^v25^~^v26^~^v27^~^v28^~^v29^~^v30^~^v31^~^v32^~^v33^~^v34^~^v35^~^v36^~^v37^~^v38^~^v39^~^v40

Err.Clear
CNSTSPRTR = "^~^"
CNSTHYPEN = " - "
CNSTCOMMA = " , "
CNSTSTRTTAG = "<=ScriptStarted=>"
CNSTENDTAG = "<=ScriptEnded=>"

Set oWebAdmin = GetObject("winmgmts:root\WebAdministration")  

WScript.Echo CNSTSTRTTAG

	getIISAppPoolsInfo()
	
If(Err.number = 0) then
	WScript.Echo CNSTENDTAG
End If

Function getIISAppPoolsInfo()
	Set oSvr = oWebAdmin.Get("Server=@")  
	Set appPool = oSvr.ApplicationPoolDefaults

	Dim v,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20
	Dim v21,v22,v23,v24,v25,v26,v27,v28,v29,v30,v31,v32,v33,v34,v35,v36,v37,v38,v39,v40

	v = appPool.Name
	If(Trim(v) = "") Then
		v = "Application Pool Defaults"
	End if 
	v1 = appPool.Recycling.PeriodicRestart.Time
	v2 = appPool.Recycling.PeriodicRestart.Requests

	Set dataList = CreateObject("System.Collections.ArrayList")						
	For Each strSchedule in appPool.Recycling.PeriodicRestart.Schedule
		dataList.Add strSchedule.value
	Next

	v3 = getSortedData(dataList)
	v4 = appPool.Recycling.PeriodicRestart.Memory
	if(v4 > 0) then
		v4 = v4/1024
		v4 = Round(v4,4)
	end if
	v5 = appPool.Recycling.PeriodicRestart.PrivateMemory
	if(v5 > 0) then
		v5 = v5/1024
		v5 = Round(v5,4)
	end if
	V6 = appPool.ProcessModel.IdleTimeout
	v7 = appPool.QueueLength

	Dim cpuAction
	cpuAction = appPool.Cpu.Action
	If(cpuAction = 0) Then 
		cpuAction = "No Action"
	ElseIf(cpuAction = 1) Then
		cpuAction = "Shutdown"
	Else
		cpuAction = CNSTHYPEN
	End if 

	v8 =  cpuAction
	v9 = appPool.Cpu.Limit
	if(v9 > 0) then
		v9 = v9/1000
	end if

	V10 =  appPool.Cpu.ResetInterval
	V11 = appPool.ProcessModel.MaxProcesses
	v12 = appPool.ProcessModel.PingingEnabled
	v13 = appPool.ProcessModel.PingInterval
	v14 = appPool.Failure.RapidFailProtection	
	v15 = appPool.Failure.RapidFailProtectionMaxCrashes
	v16 = appPool.Failure.RapidFailProtectionInterval
	v17 = appPool.ProcessModel.StartupTimeLimit
	v18 = appPool.ProcessModel.ShutdownTimeLimit
	V19 =  getPoolIdentityType(appPool.ProcessModel.IdentityType)
	v20 = CNSTHYPEN 'User name
	v21 = appPool.ManagedRuntimeVersion
	v22 = appPool.Enable32BitAppOnWin64  

	Dim mngdPipeLnMd	
	mngdPipeLnMd = appPool.ManagedPipelineMode
	If(mngdPipeLnMd = 0) Then 
		mngdPipeLnMd = "Integrated"
	ElseIf(mngdPipeLnMd = 1) Then
		mngdPipeLnMd = "Classic"
	Else
		mngdPipeLnMd = CNSTHYPEN
	End If 

	v23 = mngdPipeLnMd

	Dim startMode
	startMode = appPool.startMode
	If(startMode = 0) Then 
		startMode = "OnDemand"
	ElseIf (startMode = 1) Then
		startMode = "AlwaysRunning"
	Else
		startMode = CNSTHYPEN
	End if 

	v24 =  startMode
	v25 =  appPool.Cpu.SmpAffinitized

	Dim afMask
	afMask = appPool.Cpu.SmpProcessorAffinityMask
	If(afMask < 0) Then
		afMask = 4294967296 + afMask
	End if
	v26 = afMask

	Dim afMasktwo
	afMasktwo = appPool.Cpu.SmpProcessorAffinityMask2
	If(afMasktwo < 0 ) Then
		afMasktwo = 4294967296 + afMasktwo
	End if
	v27 =  afMasktwo

	Dim evntL 
	evntL = appPool.ProcessModel.logEventOnProcessModel
	If(evntL = 0) Then
		evntL = "False"
	Else
		evntL = "True"
	End if
	v28 =  evntL

	Dim prcsMdlAction
	prcsMdlAction = appPool.ProcessModel.idleTimeoutAction 
	If(prcsMdlAction = 0) Then 
		prcsMdlAction = "Terminate"
	ElseIf(prcsMdlAction = 1) Then 
		prcsMdlAction = "Suspend"
	Else 
		prcsMdlAction = CNSTHYPEN
	End if 

	v29 = prcsMdlAction
	V30 = appPool.ProcessModel.LoadUserProfile
	V31 = appPool.ProcessModel.PingResponseTime
	v32 = appPool.Failure.OrphanWorkerProcess
	v33 = appPool.Failure.OrphanActionExe
	v34 = appPool.Failure.OrphanActionParams

	Dim srviceResponse
	srviceResponse = appPool.Failure.loadBalancerCapabilities 
	If(srviceResponse = 2) Then 
		srviceResponse = "HttpLevel"
	ElseIf(srviceResponse = 1) Then 
		srviceResponse = "TcpLevel"
	Else 
		srviceResponse = CNSTHYPEN
	End If

	v35 = srviceResponse
	v36 = appPool.Failure.AutoShutdownExe
	v37 = appPool.Failure.AutoShutdownParams
	v38 = appPool.Recycling.DisallowOverlappingRotation
	v39 = appPool.Recycling.DisallowRotationOnConfigChange
	v40 = appPool.Recycling.LogEventOnRecycle

	WScript.Echo validate(v) & CNSTSPRTR & validate(v1) & CNSTSPRTR & validate(v2) & CNSTSPRTR & validate(v3) & CNSTSPRTR & validate(v4) & CNSTSPRTR & validate(v5) & CNSTSPRTR & validate(v6) & CNSTSPRTR & validate(v7) & CNSTSPRTR & validate(v8) & CNSTSPRTR & validate(v9) & CNSTSPRTR & validate(v10) & CNSTSPRTR & validate(v11) & CNSTSPRTR & validate(v12) & CNSTSPRTR & validate(v13) & CNSTSPRTR & validate(v14) & CNSTSPRTR & validate(v15) & CNSTSPRTR & validate(v16) & CNSTSPRTR & validate(v17) & CNSTSPRTR & validate(v18) & CNSTSPRTR & validate(v19) & CNSTSPRTR & validate(v20) & CNSTSPRTR & validate(v21) & CNSTSPRTR & validate(v22) & CNSTSPRTR & validate(v23) & CNSTSPRTR & validate(v24) & CNSTSPRTR & validate(v25) & CNSTSPRTR & validate(v26) & CNSTSPRTR & validate(v27) & CNSTSPRTR & validate(v28) & CNSTSPRTR & validate(v29) & CNSTSPRTR & validate(v30) & CNSTSPRTR & validate(v31) & CNSTSPRTR & validate(v32) & CNSTSPRTR & validate(v33) & CNSTSPRTR & validate(v34) & CNSTSPRTR & validate(v35) & CNSTSPRTR & validate(v36) & CNSTSPRTR & validate(v37) & CNSTSPRTR & validate(v38) & CNSTSPRTR & validate(v39) & CNSTSPRTR & validate(v40)

End Function


Function getPoolIdentityType(value)
	Select Case value
	Case 0: getPoolIdentityType="LOCAL SYSTEM"
	Case 1: getPoolIdentityType="LOCAL SERVICE"
	Case 2: getPoolIdentityType="NETWORK SERVICE"
	Case 3: getPoolIdentityType="SPECIFIC USER"
	Case 4: getPoolIdentityType="ApplicationPoolIdentity"
	End Select
End Function

Function getSortedData(DataList)
	Dim inputVal
	inputVal = ""
	DataList.sort()
	For inc = 0 to DataList.Count - 1
		If(inc = 0) then
			inputVal = DataList.Item(inc)
		Else
			inputVal = inputVal & DataList.Item(inc)
		End if
			
		If(inc < (DataList.Count - 1)) then
		 inputVal = inputVal & CNSTCOMMA
		End if		
	Next
	getSortedData = inputVal
End Function

Function validate(crntValue)
	Dim inptVal
	inptVal = crntValue
	If(IsNull(inptVal) or Trim(inptVal) = "")  then
		Validate = CNSTHYPEN
	Else
		Validate = Trim(inptVal)
	End If
End Function
'' SIG '' Begin signature block
'' SIG '' MIIlSgYJKoZIhvcNAQcCoIIlOzCCJTcCAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFG4/RtfYpfNw
'' SIG '' fWEWsqGrhUkA6BtOoIIecjCCBTAwggQYoAMCAQICEAQJ
'' SIG '' GBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTEL
'' SIG '' MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IElu
'' SIG '' YzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
'' SIG '' A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENB
'' SIG '' MB4XDTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFow
'' SIG '' cjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0
'' SIG '' IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
'' SIG '' MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
'' SIG '' IENvZGUgU2lnbmluZyBDQTCCASIwDQYJKoZIhvcNAQEB
'' SIG '' BQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsxSRnP
'' SIG '' 0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3
'' SIG '' Gde2qvCchqXYJawOeSg6funRZ9PG+yknx9N7I5TkkSOW
'' SIG '' kHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJRdQtoaPp
'' SIG '' iCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/
'' SIG '' 6XzLkqHlOzEcz+ryCuRXu0q16XTmK/5sy350OTYNkO/k
'' SIG '' tU6kqepqCquE86xnTrXE94zRICUj6whkPlKWwfIPEvTF
'' SIG '' jg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+m
'' SIG '' M6n9Gd8lk9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggr
'' SIG '' BgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
'' SIG '' MEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3Js
'' SIG '' NC5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURS
'' SIG '' b290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsME8GA1UdIARIMEYwOAYKYIZIAYb9bAACBDAqMCgG
'' SIG '' CCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5j
'' SIG '' b20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7
'' SIG '' KgqjpepxA8Bg+S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv
'' SIG '' 9JLLgjEtUYunpyGd823IDzANBgkqhkiG9w0BAQsFAAOC
'' SIG '' AQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134L
'' SIG '' YP3DPQ/Er4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFO
'' SIG '' EKTuP3GOYw4TS63XX0R58zYUBor3nEZOXP+QsRsHDpEV
'' SIG '' +7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRH
'' SIG '' oXpoaK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQM
'' SIG '' JQhCMrI2iiQC/i9yfhzXSUWW6Fkd6fp0ZGuy62ZD2rOw
'' SIG '' jNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
'' SIG '' 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBY0w
'' SIG '' ggR1oAMCAQICEA6bGI750C3n79tQ4ghAGFowDQYJKoZI
'' SIG '' hvcNAQEMBQAwZTELMAkGA1UEBhMCVVMxFTATBgNVBAoT
'' SIG '' DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
'' SIG '' ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJl
'' SIG '' ZCBJRCBSb290IENBMB4XDTIyMDgwMTAwMDAwMFoXDTMx
'' SIG '' MTEwOTIzNTk1OVowYjELMAkGA1UEBhMCVVMxFTATBgNV
'' SIG '' BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRp
'' SIG '' Z2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1
'' SIG '' c3RlZCBSb290IEc0MIICIjANBgkqhkiG9w0BAQEFAAOC
'' SIG '' Ag8AMIICCgKCAgEAv+aQc2jeu+RdSjwwIjBpM+zCpyUu
'' SIG '' ySE98orYWcLhKac9WKt2ms2uexuEDcQwH/MbpDgW61bG
'' SIG '' l20dq7J58soR0uRf1gU8Ug9SH8aeFaV+vp+pVxZZVXKv
'' SIG '' aJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0O21x4i0MG+4g
'' SIG '' 1ckgHWMpLc7sXk7Ik/ghYZs06wXGXuxbGrzryc/NrDRA
'' SIG '' X7F6Zu53yEioZldXn1RYjgwrt0+nMNlW7sp7XeOtyU9e
'' SIG '' 5TXnMcvak17cjo+A2raRmECQecN4x7axxLVqGDgDEI3Y
'' SIG '' 1DekLgV9iPWCPhCRcKtVgkEy19sEcypukQF8IUzUvK4b
'' SIG '' A3VdeGbZOjFEmjNAvwjXWkmkwuapoGfdpCe8oU85tRFY
'' SIG '' F/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6SPDgohIbZpp0
'' SIG '' yt5LHucOY67m1O+SkjqePdwA5EUlibaaRBkrfsCUtNJh
'' SIG '' besz2cXfSwQAzH0clcOP9yGyshG3u3/y1YxwLEFgqrFj
'' SIG '' GESVGnZifvaAsPvoZKYz0YkH4b235kOkGLimdwHhD5QM
'' SIG '' IR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxfjT/JvNNBERJb
'' SIG '' 5RBQ6zHFynIWIgnffEx1P2PsIV/EIFFrb7GrhotPwtZF
'' SIG '' X50g/KEexcCPorF+CiaZ9eRpL5gdLfXZqbId5RsCAwEA
'' SIG '' AaOCATowggE2MA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O
'' SIG '' BBYEFOzX44LScV1kTN8uZz/nupiuHA9PMB8GA1UdIwQY
'' SIG '' MBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgPMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjB5BggrBgEFBQcBAQRtMGswJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggr
'' SIG '' BgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDBF
'' SIG '' BgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsMBEGA1UdIAQKMAgwBgYEVR0gADANBgkqhkiG9w0B
'' SIG '' AQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22Ftf3v1cHvZqs
'' SIG '' oYcs7IVeqRq7IviHGmlUIu2kiHdtvRoU9BNKei8ttzjv
'' SIG '' 9P+Aufih9/Jy3iS8UgPITtAq3votVs/59PesMHqai7Je
'' SIG '' 1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cnRNTnf+hZqPC/
'' SIG '' Lwum6fI0POz3A8eHqNJMQBk1RmppVLC4oVaO7KTVPeix
'' SIG '' 3P0c2PR3WlxUjG/voVA9/HYJaISfb8rbII01YBwCA8sg
'' SIG '' sKxYoA5AY8WYIsGyWfVVa88nq2x2zm8jLfR+cWojayL/
'' SIG '' ErhULSd+2DrZ8LaHlv1b0VysGMNNn3O3AamfV6peKOK5
'' SIG '' lDCCBjMwggUboAMCAQICEAiadJ64LcPsJ+pl6tv4NTEw
'' SIG '' DQYJKoZIhvcNAQELBQAwcjELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQg
'' SIG '' U0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBDQTAe
'' SIG '' Fw0yMTA1MjUwMDAwMDBaFw0yNDA1MjkyMzU5NTlaMHEx
'' SIG '' CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpOZXcgSmVyc2V5
'' SIG '' MQ8wDQYDVQQHEwZJc2VsaW4xHTAbBgNVBAoTFGVHIElu
'' SIG '' bm92YXRpb25zLCBJbmMuMR0wGwYDVQQDExRlRyBJbm5v
'' SIG '' dmF0aW9ucywgSW5jLjCCAiIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggIPADCCAgoCggIBAMRlCdKa4238XJoGRo3eyQ8TrO7M
'' SIG '' kh72kN8Bkdimw92mWoHkhPpBtLSpBLEOJ2vG5zVYmP8x
'' SIG '' eD26NGZGLTMySJNAGVw0zL16/5hL5isQm4iRUwqSpJme
'' SIG '' LGuQWXzu4oCL3DUmtMyCNmuY4kCRcvOY/n/SOBIE6PTn
'' SIG '' HVXiDV4YENsWek4xCvqW4aplV76/AwduiXJTmnndC+Vb
'' SIG '' O/gmxs2bion4MS9ovHeRQ85IWUmX3QrRrRLxOaS3rF0l
'' SIG '' n6c1HXbwjUYrCDxge5oPkZZ9l71GcsmkVEbZcddaWHyf
'' SIG '' yjWAJFAi9t654d/P5msbUr3XoqGAY+MS8re6aEARvm9L
'' SIG '' swo4EQA3t/5NDbYlcCSKNGRLFMgwDaeySCIzHj87DjGM
'' SIG '' 3zD8ovHJQMHwWHNl4UrlHF98in+JKURZgpWHyuS7LRkE
'' SIG '' TWzjY6bAgUxIGbsBH5HTlNK5mjMsGRVSxxKZqWGXj8+z
'' SIG '' N1YTfmleepEf3n6PHg/NROVQ0KpiYhliqv7PY4W5GB+4
'' SIG '' NroS9jF2/7kbIVQ0jpBUbyCA/5fsgyaIAwaWnt8dqL+W
'' SIG '' L42PGaPERdLV78ktK37A7wDWcO5qbcx59AZZsOZboNxd
'' SIG '' glSaTW829R5gB+pNMhR5lmAqFADWwQdGEf5OCb4GNm8r
'' SIG '' bRe3EDycpe1CPQruCkwIO0TphpMHS4Zl6DwgXKNBAgMB
'' SIG '' AAGjggHEMIIBwDAfBgNVHSMEGDAWgBRaxLl7Kgqjpepx
'' SIG '' A8Bg+S32ZXUOWDAdBgNVHQ4EFgQU+chEms/YE0kvGgTW
'' SIG '' ta9+DDAONkowDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHcGA1UdHwRwMG4wNaAzoDGGL2h0
'' SIG '' dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
'' SIG '' ZWQtY3MtZzEuY3JsMDWgM6Axhi9odHRwOi8vY3JsNC5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNy
'' SIG '' bDBLBgNVHSAERDBCMDYGCWCGSAGG/WwDATApMCcGCCsG
'' SIG '' AQUFBwIBFhtodHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9D
'' SIG '' UFMwCAYGZ4EMAQQBMIGEBggrBgEFBQcBAQR4MHYwJAYI
'' SIG '' KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNv
'' SIG '' bTBOBggrBgEFBQcwAoZCaHR0cDovL2NhY2VydHMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRENv
'' SIG '' ZGVTaWduaW5nQ0EuY3J0MAwGA1UdEwEB/wQCMAAwDQYJ
'' SIG '' KoZIhvcNAQELBQADggEBAJQI53BT7yyssE/+AxAhu2x2
'' SIG '' 7YlZfrrpn0Y9mKxbgobIJL9T5kKYH8qcQt4PhK1fckVf
'' SIG '' Pl10gsDmiid7+kS536YS4RMGHNvtELPzZYm+TQMQxriH
'' SIG '' MwCHlznOZEUabxbENl0jbTO1y9bSw5uqf1RuwaFAMqkV
'' SIG '' 7DD3Vm05Df/Z3QphkrKnMYxtrnfDulYbXvSeS2hwVZN5
'' SIG '' SGQDLR+gAnaOUE6zOPZ2yFPEBrkWDV2SkSwFLuiIA+li
'' SIG '' SjFX2V1pcnw/HWdq93o+kNbgDvzW7Xd/e0/gVUKw1jDh
'' SIG '' vPhnkYicKHr8WyFodEnp2TlKwKvb0yWkrxTEr3LZCZv6
'' SIG '' MS1HFHRBkt8wggauMIIElqADAgECAhAHNje3JFR82Ees
'' SIG '' /ShmKl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYT
'' SIG '' AlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNV
'' SIG '' BAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERp
'' SIG '' Z2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMw
'' SIG '' MDAwMDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkG
'' SIG '' A1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
'' SIG '' IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqG
'' SIG '' SIb3DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJ
'' SIG '' UVXHJQPE8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVC
'' SIG '' X6SI82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0
'' SIG '' hNoR8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w
'' SIG '' 1lbU5ygt69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ
'' SIG '' 3HxqV3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43
'' SIG '' IbtArF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFk
'' SIG '' dECnwHLFuk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcp
'' SIG '' licu9Yemj052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6
'' SIG '' OBGz9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTy
'' SIG '' UpURK1h0QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506
'' SIG '' o9UD4L/wojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB
'' SIG '' 7UK/BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfc
'' SIG '' Yd6T/jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwM
'' SIG '' O1uKIqjBJgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbs
'' SIG '' q11GdeJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5r
'' SIG '' mQzSM7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgw
'' SIG '' BgEB/wIBADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxq
'' SIG '' II+eyG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6
'' SIG '' mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoG
'' SIG '' CCsGAQUFBwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEF
'' SIG '' BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEG
'' SIG '' CCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2Vy
'' SIG '' dC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBD
'' SIG '' BgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNy
'' SIG '' bDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQi
'' SIG '' AX5m1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaop
'' SIG '' afxpwc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQ
'' SIG '' TGIdDAiCqBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+K
'' SIG '' LHqrhc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQ
'' SIG '' cAp876i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6
'' SIG '' wCeCRK6ZJxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SN
'' SIG '' oOeY+/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3
'' SIG '' ZpHxcpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/
'' SIG '' a6fxZsNBzU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr
'' SIG '' 5Dhzq6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j
'' SIG '' /R0o08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT
'' SIG '' 1ObyF5lZynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCY
'' SIG '' oCvtlUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y
'' SIG '' 3wSJ8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqk
'' SIG '' hQ/8mJb2VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqh
'' SIG '' K/bt1nz8MIIGwDCCBKigAwIBAgIQDE1pckuU+jwqSj0p
'' SIG '' B4A9WjANBgkqhkiG9w0BAQsFADBjMQswCQYDVQQGEwJV
'' SIG '' UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNV
'' SIG '' BAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBT
'' SIG '' SEEyNTYgVGltZVN0YW1waW5nIENBMB4XDTIyMDkyMTAw
'' SIG '' MDAwMFoXDTMzMTEyMTIzNTk1OVowRjELMAkGA1UEBhMC
'' SIG '' VVMxETAPBgNVBAoTCERpZ2lDZXJ0MSQwIgYDVQQDExtE
'' SIG '' aWdpQ2VydCBUaW1lc3RhbXAgMjAyMiAtIDIwggIiMA0G
'' SIG '' CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDP7KUmOsap
'' SIG '' 8mu7jcENmtuh6BSFdDMaJqzQHFUeHjZtvJJVDGH0nQl3
'' SIG '' PRWWCC9rZKT9BoMW15GSOBwxApb7crGXOlWvM+xhiumm
'' SIG '' KNuQY1y9iVPgOi2Mh0KuJqTku3h4uXoW4VbGwLpkU7sq
'' SIG '' FudQSLuIaQyIxvG+4C99O7HKU41Agx7ny3JJKB5MgB6F
'' SIG '' VueF7fJhvKo6B332q27lZt3iXPUv7Y3UTZWEaOOAy2p5
'' SIG '' 0dIQkUYp6z4m8rSMzUy5Zsi7qlA4DeWMlF0ZWr/1e0Bu
'' SIG '' bxaompyVR4aFeT4MXmaMGgokvpyq0py2909ueMQoP6Mc
'' SIG '' D1AGN7oI2TWmtR7aeFgdOej4TJEQln5N4d3CraV++C0b
'' SIG '' H+wrRhijGfY59/XBT3EuiQMRoku7mL/6T+R7Nu8GRORV
'' SIG '' /zbq5Xwx5/PCUsTmFntafqUlc9vAapkhLWPlWfVNL5Af
'' SIG '' J7fSqxTlOGaHUQhr+1NDOdBk+lbP4PQK5hRtZHi7mP2U
'' SIG '' w3Mh8y/CLiDXgazT8QfU4b3ZXUtuMZQpi+ZBpGWUwFjl
'' SIG '' 5S4pkKa3YWT62SBsGFFguqaBDwklU/G/O+mrBw5qBzli
'' SIG '' GcnWhX8T2Y15z2LF7OF7ucxnEweawXjtxojIsG4yeccL
'' SIG '' WYONxu71LHx7jstkifGxxLjnU15fVdJ9GSlZA076XepF
'' SIG '' cxyEftfO4tQ6dwIDAQABo4IBizCCAYcwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAww
'' SIG '' CgYIKwYBBQUHAwgwIAYDVR0gBBkwFzAIBgZngQwBBAIw
'' SIG '' CwYJYIZIAYb9bAcBMB8GA1UdIwQYMBaAFLoW2W1NhS9z
'' SIG '' KXaaL3WMaiCPnshvMB0GA1UdDgQWBBRiit7QYfyPMRTt
'' SIG '' lwvNPSqUFN9SnDBaBgNVHR8EUzBRME+gTaBLhklodHRw
'' SIG '' Oi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRSU0E0MDk2U0hBMjU2VGltZVN0YW1waW5nQ0Eu
'' SIG '' Y3JsMIGQBggrBgEFBQcBAQSBgzCBgDAkBggrBgEFBQcw
'' SIG '' AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMFgGCCsG
'' SIG '' AQUFBzAChkxodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkRzRSU0E0MDk2U0hBMjU2
'' SIG '' VGltZVN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEBCwUA
'' SIG '' A4ICAQBVqioa80bzeFc3MPx140/WhSPx/PmVOZsl5vdy
'' SIG '' ipjDd9Rk/BX7NsJJUSx4iGNVCUY5APxp1MqbKfujP8DJ
'' SIG '' AJsTHbCYidx48s18hc1Tna9i4mFmoxQqRYdKmEIrUPwb
'' SIG '' tZ4IMAn65C3XCYl5+QnmiM59G7hqopvBU2AJ6KO4ndet
'' SIG '' Hxy47JhB8PYOgPvk/9+dEKfrALpfSo8aOlK06r8JSRU1
'' SIG '' NlmaD1TSsht/fl4JrXZUinRtytIFZyt26/+YsiaVOBmI
'' SIG '' RBTlClmia+ciPkQh0j8cwJvtfEiy2JIMkU88ZpSvXQJT
'' SIG '' 657inuTTH4YBZJwAwuladHUNPeF5iL8cAZfJGSOA1zZa
'' SIG '' X5YWsWMMxkZAO85dNdRZPkOaGK7DycvD+5sTX2q1x+Dz
'' SIG '' BcNZ3ydiK95ByVO5/zQQZ/YmMph7/lxClIGUgp2sCovG
'' SIG '' SxVK05iQRWAzgOAj3vgDpPZFR+XOuANCR+hBNnF3rf2i
'' SIG '' 6Jd0Ti7aHh2MWsgemtXC8MYiqE+bvdgcmlHEL5r2X6cn
'' SIG '' l7qWLoVXwGDneFZ/au/ClZpLEQLIgpzJGgV8unG1TnqZ
'' SIG '' bPTontRamMifv427GFxD9dAq6OJi7ngE273R+1sKqHB+
'' SIG '' 8JeEeOMIA11HLGOoJTiXAdI/Otrl5fbmm9x+LMz/F0xN
'' SIG '' AKLY1gEOuIvu5uByVYksJxlh9ncBjDGCBkQwggZAAgEB
'' SIG '' MIGGMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJl
'' SIG '' ZCBJRCBDb2RlIFNpZ25pbmcgQ0ECEAiadJ64LcPsJ+pl
'' SIG '' 6tv4NTEwCQYFKw4DAhoFAKBwMBAGCisGAQQBgjcCAQwx
'' SIG '' AjAAMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwG
'' SIG '' CisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMCMGCSqG
'' SIG '' SIb3DQEJBDEWBBQi6cz+6Rr6yYuN5woD9RuyHL0PXDAN
'' SIG '' BgkqhkiG9w0BAQEFAASCAgBWSlbWjk6LHavzk01w5XZ0
'' SIG '' GRBveTZ+dsdGbuyBor+YzEfcGffbCnnAg1FvNTkJo/Dd
'' SIG '' KUdgrq3G+Z9jA/rb7gorkkHfiKxi9WqPJmEw+nApHSOz
'' SIG '' 45cvmPMo5ExsPK+vOVg3B96U6tDmoCUSL8LwpKL9Uu3s
'' SIG '' nTJG2jfOT89fCmWGFAPw7JB40cprkL1d0x6vW6M4QxQM
'' SIG '' p+N3XGzQtj//RHvL2Q6Fz4icT5KbrOFUcIyhw3A/dXiI
'' SIG '' 78lpIbdfJaemLuFvgEojXBdLsfbmmBQm7JfyrcqzWDFe
'' SIG '' 1+UsA1QXTPJQmoi8tmH4i0ePCa1N+LOwT4zqIbZib7gt
'' SIG '' sP632+/dHMrA/fKJEdR4vySig5ASUFtgAoLrGP4J808a
'' SIG '' 188baR+LKgSDLjkKoS1w9DftSe9ionNHHYTdDtq2DZqY
'' SIG '' 0emL2z6Gwu6UyQn+ZIOamNsqX62jMAjNLDgNRlfpU7gI
'' SIG '' egx5h07jPcGRqALI8qH32hh5JxqkamEUiV74KDcn0bst
'' SIG '' jTTaNadFXWHq1C9gP6qmQ0JOWHH/q8hXvvCXatBhfZuc
'' SIG '' BKRxG1/a37md8j9IhshHpUKwmkhgfTWuJw64n29kzsS1
'' SIG '' Hu1NA3t3WSVuau3PhgwYFiWTgHOCe+LmhqET9wNaIroh
'' SIG '' KxF4fk1CK1+Je8vwvC7RSxAJPcWji0EKfjB5DyxeKmAB
'' SIG '' d6GCAyAwggMcBgkqhkiG9w0BCQYxggMNMIIDCQIBATB3
'' SIG '' MGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2Vy
'' SIG '' dCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
'' SIG '' ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcg
'' SIG '' Q0ECEAxNaXJLlPo8Kko9KQeAPVowDQYJYIZIAWUDBAIB
'' SIG '' BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwG
'' SIG '' CSqGSIb3DQEJBTEPFw0yMjEyMTQwODU4NDlaMC8GCSqG
'' SIG '' SIb3DQEJBDEiBCCWsr/DjeE5UlqKmwjxWFBZJpZx/Bhn
'' SIG '' OWrZRqcaBOQ84DANBgkqhkiG9w0BAQEFAASCAgAEwyDN
'' SIG '' 3wIBgiLKjzlR2/EQy5i2Cf63e3oo/nD/YS80kQzeJmY4
'' SIG '' FAG8bEU090yAtdMmR2kqrSyi1L30Y8bmSbC5bO8Xu493
'' SIG '' iJev4GFEy7A30tE2rr4tXGOvAWA5T80pgEYtr0+30HHn
'' SIG '' e4SNVktBbnvmeclJjQcsKHhxAGlbrqC0FwyicV6ab8yn
'' SIG '' pQG2DTnfZbSWriyDifuOQvHpezEbiUFaFOB4KuzwF+ie
'' SIG '' DNrsEA7gKk41vMGv2vrVEXFb8ZLCT0bv40J7Jr0kpuBn
'' SIG '' cztjVWSUHn5l6cEE2YM8+Asyiqo41W+uipvXxnt3I2Ti
'' SIG '' LsvQUY2LPxG/OL4NopMDpEMd6T7x4e6tm2Ny5+1Knypi
'' SIG '' yZn79fdwtLWsMZ6bTx+SqZ2qQ9FJQkL1SCBy3P+rnfEe
'' SIG '' pXip0kVEW7TniK6j1RFPG3mUCtNn2mOpmKQ+/3cm25ta
'' SIG '' 4ezLA++uVV5xIBzqA94NOwGTHDcLTadU33KO7OqiGqOs
'' SIG '' SORHmfT1S8WRYmiGiOAx0RYw6dGA4OaBUQq+KMJ0U0f/
'' SIG '' XXrwfFypORtDjAg8sLo2PaAxxCq71UQJm2Mq8x/LXCfu
'' SIG '' dFx2TwI9NzcBzqoDc1m18OJ5IGT/OPS2HRx0Y1ldxscj
'' SIG '' MPywSTk7n4thQ2PEp5VnbJmJ0gTFkF/Zb6S7pVYXCxva
'' SIG '' nyMtLK1Aq/LsgdkDew==
'' SIG '' End signature block
