﻿#$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
#$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
$mediaDuration='30'
$nwrkAssessDir=''
$drives =gdr -PSProvider 'FileSystem' | select name
foreach($drv in $drives){
    $path=$drv.Name+':\*\Microsoft Teams Network Assessment Tool'
    Try{
        $nwAsses=Get-Childitem $path -Recurse
        $nwrkAssessDir=$nwAsses.Directory[0].ToString()
        if($nwrkAssessDir -ne '' -and $nwrkAssessDir -ne $null){
            break
        }
    }Catch{}
}

if($nwrkAssessDir -ne '' -and $nwrkAssessDir -ne $null){
try {
    $filePath=$nwrkAssessDir+'\NetworkAssessmentTool.exe.config'
    $writPath=$nwrkAssessDir+'\NetworkAssessmentTool.exe.config1'
    $userNam=$env:UserDomain+'\'+$env:UserName
    [System.GC]::GetTotalMemory($true) | out-null

    #FOLDER PERMISSION
    $acl = Get-Acl $nwrkAssessDir
    $acl.setOwner([System.Security.Principal.NTAccount]$userNam)
    $permission = $userNam,"FullControl","Allow"
    $accessRule = New-Object System.Security.AccessControl.FileSystemAccessRule $permission
    $acl.SetAccessRule($accessRule)
    $acl | Set-Acl $nwrkAssessDir
    #Set-ItemProperty $nwrkAssessDir -name IsReadOnly -value $false

    #FILE PERMISSION
    $acl = Get-Acl $filePath
    $acl.setOwner([System.Security.Principal.NTAccount]$userNam)
    $permission = $userNam,"FullControl","Allow"
    $accessRule = New-Object System.Security.AccessControl.FileSystemAccessRule $permission
    $acl.SetAccessRule($accessRule)
    $acl | Set-Acl $filePath
    Set-ItemProperty $filePath -name IsReadOnly -value $false

    get-content $filePath|ForEach-Object{$val='';if($_.Contains('value') -and $_.Contains('"/>')){$val=$_.Substring($_.IndexOf('value="')+7); $val=$val.Substring(0,$val.IndexOf('"/>'));$val=$val.ToString()}if($_.Contains('MediaDuration') -and $mediaDuration -ne '' -and $val -ne ''){$_ -replace $val,$mediaDuration}else{$_}}|set-content $writPath -Force
    if(Test-Path -Path $filePath -PathType Leaf) {
        Remove-Item $filePath
    }
    if(Test-Path -Path $writPath -PathType Leaf) {
        Rename-Item $writPath $filePath
    }
    write-host '***Permissions provided successfully ********'
} catch {
    Write-Error $_
}
}else{
    write-host '***Operation failed ********'
}
[System.GC]::GetTotalMemory($true) | out-null