﻿<#
    /*****************************************************************************
    Author            :       Prabaharan.T
    Purpose           :       display the activity operations that done by user
    Created           :       31/01/2018
    Modified By       : 

#>
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

clear

$TestInputs=$args
#<#
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$testFreRpt=$TestInputs[2]
$inputUsrKey=$TestInputs[3]   
$arrStrng=$TestInputs[4]
$proxyUsr=$TestInputs[5]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[6]
$appDetails=$TestInputs[7]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

$inputUsrKey=$inputUsrKey.ToString().Replace('^',' ')

#<#
$spoOpertns=$arrStrng.ToString().Trim().Split('#')
$fileOpe=$spoOpertns[0].ToString().Trim().Split('~')
$folderOpe=$spoOpertns[1].ToString().Trim().Split('~')
$syncOpe=$spoOpertns[2].ToString().Trim().Split('~')
$sharngOpe=$spoOpertns[3].ToString().Trim().Split('~')
$siteAdminOpe=$spoOpertns[4].ToString().Trim().Split('~')
#>

$allOperatns=$fileOpe+$folderOpe+$syncOpe+$sharngOpe+$siteAdminOpe

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$tstArr=$testFreRpt.Split('#')
$testFrequency=[int]$tstArr[0]
$reportingNam=$tstArr[1]
$showUsrFileOpe=$tstArr[2]
$proxyserverip=$tstArr[3]
$rptPath='SPO/'+$reportingNam
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }

$logPath=$egurkhaPath+'\agent\'+$rptPath+'\SPOActOperations.log'
$isWriteLog=$false

Function Start-SleepWithProgress {
	Param([int]$sleeptime)

	For ($i=0;$i -le $sleeptime;$i++){
		$timeleft = ($sleeptime - $i);
		Write-Progress -Activity "Sleeping" -CurrentOperation "$Timeleft More Seconds" -PercentComplete (($i/$sleeptime)*100);
		start-sleep 1
	}
	
	Write-Progress -Completed -Activity "Sleeping"
}

Function New-CleanSPOSession {
    $Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    $i = 0
	while (($Credential -eq $Null) -and ($i -lt 5)){
		$script:Credential = Get-Credential -Message "Please provide your Exchange Online Credentials"
		$i++
	}

	if ($Credential -eq $null){
		Write-Error -Message "Failed to get credentials" -ErrorAction Stop
	}

	$getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
	    Disconnect-ExchangeOnline -Confirm:$false
    }
	[System.GC]::Collect()
	Start-SleepWithProgress -SleepTime 15
	$Error.Clear()
	
    $sessionOption = New-PSSessionOption -SkipRevocationCheck
    if(!$proxyserverip.ToString().ToLower().Contains('none')){
        $proxyserver='http://'+$proxyserverip
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
	    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
	        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication Basic -ProxyCredential $proxyCred
	    }
    }
		
	if ($Error.Count -gt 0){
		$ErrorCount++
		if ($ErrorCount -gt 3){
			exit
		}
		Start-SleepWithProgress -sleeptime 60
		New-CleanSPOSession
	}
	else {
		$ErrorCount = 0
	}
	# Connect the ExchangeOnline
    if($appDetails -and $appDetails -ne 'none'){
            Connect-ExchangeOnline -CertificateThumbPrint $thumbPrint -AppID $clientId -Organization $tenantName -PSSessionOption $sessionOption -ShowBanner:$false -WarningAction SilentlyContinue
    }else{
        Connect-ExchangeOnline  -ExchangeEnvironmentName $azureEnvArr[4] -ConnectionUri $azureEnvArr[1] -Credential $Credential -PSSessionOption $sessionOption -WarningAction SilentlyContinue
	}
    Set-Variable -Scope script -Name SessionStartTime -Value (Get-Date)
}

$fileAct=@{}
foreach($act in $fileOpe){  
    $fileAct.Add($act,0)
}

$folderAct=@{}
foreach($act in $folderOpe){ 
    $folderAct.Add($act,0)
}

$syncAct=@{}
foreach($act in $syncOpe){  
    $syncAct.Add($act,0)
}

$sharngAct=@{}
foreach($act in $sharngOpe){  
    $sharngAct.Add($act,0)
}

$siteAdminAct=@{}
foreach($act in $siteAdminOpe){  
    $siteAdminAct.Add($act,0)
}

# hash for summary counts
$uniqOpe=@{}
$uniqusers= @{}
$uniqClientIp=@{}
$uniqsites=@{}
$uniqItem=@{}
$uniqDestnatn=@{}
$uniqUsrAgent=@{}

$uniqFdrOpe=@{}
$uniqFdrusers= @{}
$uniqFdrClientIp=@{}
$uniqFdrsites=@{}
$uniqFdrItem=@{}
$uniqFdrDestnatn=@{}
$uniqFdUsrAgent=@{}

$uniqSyncOpe=@{}
$uniqSyncUsers= @{}
$uniqSyncClientIp=@{}
$uniqSyncSites=@{}
$uniqSyncItem=@{}
$uniqSyncDestnatn=@{}
$uniqSyncUsrAgent=@{}

$uniqShrOpe=@{}
$uniqShrUsers= @{}
$uniqShrClientIp=@{}
$uniqShrSites=@{}
$uniqShrItem=@{}
$uniqShrDestnatn=@{}
$uniqShrUsrAgent=@{}

$uniqAdmnOpe=@{}
$uniqAdmnUsers= @{}
$uniqAdmnClientIp=@{}
$uniqAdmnSites=@{}
$uniqAdmnItem=@{}
$uniqAdmnDestnatn=@{}
$uniqAdmnUsrAgent=@{}

$usrFileOpe=@("FileAccessed","FileCheckedIn","FileCheckedOut","FileDeleted","FileUploaded","FileModified","PageViewed")

$usrKeyArr=$inputUsrKey.Split(',')
$filePath=''
$kfilePath=''
$actPath=''

$sysDat=(Get-Date).ToUniversalTime()
$endDat=$sysDat.AddMinutes(-60)
$startDat=$endDat.AddMinutes(-($testFrequency))
Try{
    Import-Module MsOnline
    Set-StrictMode -Version 2
    $ErrorCount = 0

    New-CleanSPOSession
    Eg-WriteLog -writString ('Entering create session...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    Try{
        $actWritArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "spoActOprBase" -keyFileName "kspoActOprBase" -EgPath $egurkhaPath
        #Search-UnifiedAuditLog -StartDate $startDat -EndDate $endDat | select AuditData,Operations |Export-Csv $actWritArr[1]
        Eg-WriteLog -writString ('actWritArr -->>'+$actWritArr.Keys +' -- '+$actWritArr.Values) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
        $curResCnt=0
        while($true){
            $results=Search-UnifiedAuditLog -StartDate $startDat -EndDate $endDat -Operations $allOperatns -SessionId sa -SessionCommand ReturnLargeSet -ResultSize 5000
            $results | Export-Csv $actWritArr[1] -Encoding $encTyp -Append -Force
            $curResCnt=$curResCnt+($results.count)
            if(($curResCnt -eq 50000) -or ($results.count -lt 5000)){
                break
            }
        }
        Eg-WriteLog -writString ('curResCnt -->>'+$curResCnt) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
        $null=Protect-File  $actWritArr[1] -Algorithm AES -KeyAsPlainText $actWritArr[0] -RemoveSource
    }Catch{
        if([System.IO.File]::Exists($actWritArr[1]) -eq 'True'){
            Remove-Item $actWritArr[1]
        }
        $spoExcepMsg1='[SPOActOperations] Exception Occured in "Search-UnifiedAuditLog" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception+'!>'
        Eg-WriteLog -writString ('spoExcepMsg1 -->>'+$spoExcepMsg1) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
        Write-Host $spoExcepMsg1
    }
    Try{
        $actReadArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "spoActOprBase" -keyFileName "kspoActOprBase" -EgPath $egurkhaPath
        if($actReadArr -ne $null -and [System.IO.File]::Exists($actReadArr[1]) -eq 'True'){
            Eg-WriteLog -writString ('actReadArr -->>'+$actReadArr.Keys +' -- '+$actReadArr.Values) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            $unProtctAct=$actReadArr[1] -replace (".csv",".dat")
            Eg-WriteLog -writString ('unProtctAct -->>'+$unProtctAct) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            $actPath=Unprotect-File $unProtctAct -Algorithm AES -KeyAsPlainText $actReadArr[0]
            Eg-WriteLog -writString ('actPath -->>'+$actPath) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            $serchAuditLog= import-csv $actPath -Encoding $encTyp
            Eg-WriteLog -writString ('serchAuditLog.Count -->>'+$serchAuditLog.Count) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            Remove-Item $actPath
            Eg-WriteLog -writString ('After Remove-Item actPath') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            $filePath=$actReadArr[2]+''+$actReadArr[3]
            $kfilePath=$actReadArr[2]+''+$actReadArr[4]
            Eg-WriteLog -writString ('filePath -->> '+$filePath+' -- '+$kfilePath) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
            if(Test-Path -Path $filePath -PathType Leaf){
                Remove-Item $filePath -Force
            }
            if(Test-Path -Path $kfilePath -PathType Leaf){
                Remove-Item $kfilePath -Force
            }
        }
    }Catch{
        $errmsg=$_.Exception.Message
        Write-Error -Message $errmsg
    }
    Eg-WriteLog -writString ('After Remove-Item filePath') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    $getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
        Eg-WriteLog -writString ('Disconnect-ExchangeOnline') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
	    Disconnect-ExchangeOnline -Confirm:$false
    }
}
Catch{
    if([System.IO.File]::Exists($actPath) -eq 'True'){
        Remove-Item $actPath
    }
    if([System.IO.File]::Exists($filePath) -eq 'True'){
        Remove-Item $filePath -Force
    }
    if([System.IO.File]::Exists($kfilePath) -eq 'True'){
        Remove-Item $kfilePath -Force
    }
    $spoExcepMsg2='[SPOActOperations] Exception Occured while reading the Files -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception+'!>'
    Eg-WriteLog -writString ('spoExcepMsg2 -->> '+$spoExcepMsg2) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    Write-Host $spoExcepMsg2
}

[System.GC]::GetTotalMemory($true) | out-null

Try{

    foreach($log in $serchAuditLog){

         #'if' condition for if userkey is in {NT AUTHORITY\SYSTEM,SHAREPOINT\system} or not
        if($inputUsrKey -ne "" -and $inputUsrKey -ne $null -and $inputUsrKey -ne "No" -and $inputUsrKey -ne "false"){
            $res= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $fileOpe -and $_.UserKey -notin $usrKeyArr}
            $resFldr= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $folderOpe -and $_.UserKey -notin $usrKeyArr}
            $resSync= $log.AuditData | ConvertFrom-Json | Where-Object {($_.Workload -eq "SharePoint" -or $_.Workload -eq "OneDrive") -and $_.Operation -in $syncOpe -and $_.UserKey -notin $usrKeyArr}
            $resShrg= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $sharngOpe -and $_.UserKey -notin $usrKeyArr}
            $resSAdm= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $siteAdminOpe -and $_.UserKey -notin $usrKeyArr}
        }else{
            $res= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $fileOpe}
            $resFldr= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $folderOpe }
            $resSync= $log.AuditData | ConvertFrom-Json | Where-Object {($_.Workload -eq "SharePoint" -or $_.Workload -eq "OneDrive") -and $_.Operation -in $syncOpe }
            $resShrg= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $sharngOpe }
            $resSAdm= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $siteAdminOpe }
        }


        # ******* FILE OPERATIONS ********* 

        if($res -ne "" -and $res -ne $null){ 
	        if($showUsrFileOpe -eq 'no'){
                if(($res.UserId -eq $userName) -and ($res.Operation -in $usrFileOpe )){
                    continue;
                }
            }
        
            $isUserAgent=[bool]($res.PSobject.Properties.name -match "UserAgent")
            $isSiteUrl=[bool]($res.PSobject.Properties.name -match "SiteUrl")
            if(!$isSiteUrl -or ($isUserAgent -eq $false) -or (($res.UserId).IndexOf('#') -ne -1)){
                continue
            }   

            if($uniqOpe.ContainsKey($res.Operation)){
                $uniqOpe[$res.Operation]=[int]$uniqOpe[$res.Operation]+1
            }else{
                $uniqOpe.Add($res.Operation,1) 
            }

            $uniqUsrLine=$res.UserId+'#'+$res.ClientIP
            if($uniqusers.ContainsKey($uniqUsrLine)){          
                $output=[String]$uniqusers[$uniqUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($res.Operation)){
                    $uniqusers[$uniqUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqusers[$uniqUsrLine]= $arr[0]+','+$res.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqusers.Add($uniqUsrLine,$res.Operation+'#'+1) 
            }

            if($uniqClientIp.ContainsKey($res.ClientIP)){
                $ipOutput=[String]$uniqClientIp[$res.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($res.Operation)){
                    $uniqClientIp[$res.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqClientIp[$res.ClientIP]= $ipArr[0]+','+$res.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqClientIp.Add($res.ClientIP,$res.Operation+'#'+1)
            }        

            if($isSiteUrl){
                $uniqsiteLine=$res.SiteUrl+'#'+$res.Site
            }#else{
            #    $uniqsiteLine='-#'+$res.Site
            #}
            if($uniqsites.ContainsKey($uniqsiteLine)){
                $siteOutput=[String]$uniqsites[$uniqsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($res.Operation)){
                    $uniqsites[$uniqsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqsites[$uniqsiteLine]= $siteArr[0]+','+$res.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqsites.Add($uniqsiteLine,$res.Operation+'#'+1)
            }

            if($uniqItem.ContainsKey($res.ItemType)){
                $itemOutput=[String]$uniqItem[$res.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($res.Operation)){
                    $uniqItem[$res.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqItem[$res.ItemType]= $itemArr[0]+','+$res.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqItem.Add($res.ItemType,$res.Operation+'#'+1)
            }

            if($isSiteUrl){
                if($uniqDestnatn.ContainsKey($res.SiteUrl)){
                    $destOutput=[String]$uniqDestnatn[$res.SiteUrl]
                    $destArr=$destOutput.Split('#')
                    if($destOutput.Contains($res.Operation)){
                        $uniqDestnatn[$res.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                    }else{
                        $uniqDestnatn[$res.SiteUrl]= $destArr[0]+','+$res.Operation+'#'+[String]([int]$destArr[1]+1)
                    }
                }else{
                    $uniqDestnatn.Add($res.SiteUrl,$res.Operation+'#'+1)
                }
            }

            if($isUserAgent){
                if($uniqUsrAgent.ContainsKey($res.UserAgent)){
                    $uniqUsrAgent[$res.UserAgent]=[int]$uniqUsrAgent[$res.UserAgent]+1
                }else{
                    $uniqUsrAgent.Add($res.UserAgent,1)
                }
            }

            if($fileAct.ContainsKey($res.Operation)){      
                $fileAct[$res.Operation]=[int]$fileAct[$res.Operation]+1
            }
        }

        #    ********** FOLDER OPERATIONS *******

        if($resFldr -ne "" -and $resFldr -ne $null){
            
            $isSiteUrlFldr=[bool]($resFldr.PSobject.Properties.name -match "SiteUrl")
            $isUsrAgntFldr=[bool]($resFldr.PSobject.Properties.name -match "UserAgent")
            if(!$isSiteUrlFldr -or ($isUsrAgntFldr -eq $false) -or (($resFldr.UserId).IndexOf('#') -ne -1)){
                continue
            }   
            if($uniqFdrOpe.ContainsKey($resFldr.Operation)){
                $uniqFdrOpe[$resFldr.Operation]=[int]$uniqFdrOpe[$resFldr.Operation]+1
            }else{
                $uniqFdrOpe.Add($resFldr.Operation,1) 
            }

            $fldrUsrLine=$resFldr.UserId+'#'+$resFldr.ClientIP
            if($uniqFdrusers.ContainsKey($fldrUsrLine)){          
                $output=[String]$uniqFdrusers[$fldrUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resFldr.Operation)){
                    $uniqFdrusers[$fldrUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqFdrusers[$fldrUsrLine]= $arr[0]+','+$resFldr.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqFdrusers.Add($fldrUsrLine,$resFldr.Operation+'#'+1) 
            }

            if($uniqFdrClientIp.ContainsKey($resFldr.ClientIP)){
                $ipOutput=[String]$uniqFdrClientIp[$resFldr.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resFldr.Operation)){
                    $uniqFdrClientIp[$resFldr.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqFdrClientIp[$resFldr.ClientIP]= $ipArr[0]+','+$resFldr.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqFdrClientIp.Add($resFldr.ClientIP,$resFldr.Operation+'#'+1)
            }

            $fldrsiteLine=$resFldr.SiteUrl+'#'+$resFldr.Site
            if($uniqFdrsites.ContainsKey($fldrsiteLine)){
                $siteOutput=[String]$uniqFdrsites[$fldrsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resFldr.Operation)){
                    $uniqFdrsites[$fldrsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqFdrsites[$fldrsiteLine]= $siteArr[0]+','+$resFldr.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqFdrsites.Add($fldrsiteLine,$resFldr.Operation+'#'+1)
            }

            if($uniqFdrItem.ContainsKey($resFldr.ItemType)){
                $itemOutput=[String]$uniqFdrItem[$resFldr.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resFldr.Operation)){
                    $uniqFdrItem[$resFldr.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqFdrItem[$resFldr.ItemType]= $itemArr[0]+','+$resFldr.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqFdrItem.Add($resFldr.ItemType,$resFldr.Operation+'#'+1)
            }

            if($uniqFdrDestnatn.ContainsKey($resFldr.SiteUrl)){
                $destOutput=[String]$uniqFdrDestnatn[$resFldr.SiteUrl]
                $destArr=$destOutput.Split('#')
                if($destOutput.Contains($resFldr.Operation)){
                    $uniqFdrDestnatn[$resFldr.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                }else{
                    $uniqFdrDestnatn[$resFldr.SiteUrl]= $destArr[0]+','+$resFldr.Operation+'#'+[String]([int]$destArr[1]+1)
                }
            }else{
                $uniqFdrDestnatn.Add($resFldr.SiteUrl,$resFldr.Operation+'#'+1)
            }

            if($uniqFdUsrAgent.ContainsKey($resFldr.UserAgent)){
                $uniqFdUsrAgent[$resFldr.UserAgent]=[int]$uniqFdUsrAgent[$resFldr.UserAgent]+1
            }else{
                $uniqFdUsrAgent.Add($resFldr.UserAgent,1)
            }
     
            if($folderAct.ContainsKey($resFldr.Operation)){      
                $folderAct[$resFldr.Operation]=[int]$folderAct[$resFldr.Operation]+1
            }       
        }

        #    ********** SYNC OPERATIONS ********

        if($resSync -ne "" -and $resSync -ne $null){
            $isSiteUrlSync=[bool]($resSync.PSobject.Properties.name -match "SiteUrl")
            $isUsrAgntSync=[bool]($resSync.PSobject.Properties.name -match "UserAgent")
            if(!$isSiteUrlSync -or ($isUsrAgntSync -eq $false) -or (($resSync.UserId).IndexOf('#') -ne -1)){
                continue
            }
            if($uniqSyncOpe.ContainsKey($resSync.Operation)){
                $uniqSyncOpe[$resSync.Operation]=[int]$uniqSyncOpe[$resSync.Operation]+1
            }else{
                $uniqSyncOpe.Add($resSync.Operation,1) 
            }

            $syncUsrLine=$resSync.UserId+'#'+$resSync.ClientIP
            if($uniqSyncUsers.ContainsKey($syncUsrLine)){          
                $output=[String]$uniqSyncUsers[$syncUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resSync.Operation)){
                    $uniqSyncUsers[$syncUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqSyncUsers[$syncUsrLine]= $arr[0]+','+$resSync.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqSyncUsers.Add($syncUsrLine,$resSync.Operation+'#'+1) 
            }

            if($uniqSyncClientIp.ContainsKey($resSync.ClientIP)){
                $ipOutput=[String]$uniqSyncClientIp[$resSync.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resSync.Operation)){
                    $uniqSyncClientIp[$resSync.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqSyncClientIp[$resSync.ClientIP]= $ipArr[0]+','+$resSync.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqSyncClientIp.Add($resSync.ClientIP,$resSync.Operation+'#'+1)
            }

            $syncsiteLine=$resSync.SiteUrl+'#'+$resSync.Site
            if($uniqSyncSites.ContainsKey($syncsiteLine)){
                $siteOutput=[String]$uniqSyncSites[$syncsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resSync.Operation)){
                    $uniqSyncSites[$syncsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqSyncSites[$syncsiteLine]= $siteArr[0]+','+$resSync.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqSyncSites.Add($syncsiteLine,$resSync.Operation+'#'+1)
            }

            if($uniqSyncItem.ContainsKey($resSync.ItemType)){
                $itemOutput=[String]$uniqSyncItem[$resSync.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resSync.Operation)){
                    $uniqSyncItem[$resSync.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqSyncItem[$resSync.ItemType]= $itemArr[0]+','+$resSync.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqSyncItem.Add($resSync.ItemType,$resSync.Operation+'#'+1)
            }

            if($uniqSyncDestnatn.ContainsKey($resSync.SiteUrl)){
                $destOutput=[String]$uniqSyncDestnatn[$resSync.SiteUrl]
                $destArr=$destOutput.Split('#')
                if($destOutput.Contains($resSync.Operation)){
                    $uniqSyncDestnatn[$resSync.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                }else{
                    $uniqSyncDestnatn[$resSync.SiteUrl]= $destArr[0]+','+$resSync.Operation+'#'+[String]([int]$destArr[1]+1)
                }
            }else{
                $uniqSyncDestnatn.Add($resSync.SiteUrl,$resSync.Operation+'#'+1)
            }

            if($uniqSyncUsrAgent.ContainsKey($resSync.UserAgent)){
                $uniqSyncUsrAgent[$resSync.UserAgent]=[int]$uniqSyncUsrAgent[$resSync.UserAgent]+1
            }else{
                $uniqSyncUsrAgent.Add($resSync.UserAgent,1)
            }

            if($syncAct.ContainsKey($resSync.Operation)){          
                $syncAct[$resSync.Operation]=[int]$syncAct[$resSync.Operation]+1
            }  
        }

        #    ********** SHARING OPERATIONS ********

        if($resShrg -ne "" -and $resShrg -ne $null){
            $isSiteUrlShrg=[bool]($resShrg.PSobject.Properties.name -match "SiteUrl")
            $isUsrAgntShrg=[bool]($resShrg.PSobject.Properties.name -match "UserAgent")
            if(!$isSiteUrlShrg -or ($isUsrAgntShrg -eq $false) -or (($resShrg.UserId).IndexOf('#') -ne -1)){
                continue
            }
            if($uniqShrOpe.ContainsKey($resShrg.Operation)){
                $uniqShrOpe[$resShrg.Operation]=[int]$uniqShrOpe[$resShrg.Operation]+1
            }else{
                $uniqShrOpe.Add($resShrg.Operation,1) 
            }

            $shrgUsrLine=$resShrg.UserId+'#'+$resShrg.ClientIP
            if($uniqShrUsers.ContainsKey($shrgUsrLine)){          
                $output=[String]$uniqShrUsers[$shrgUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resShrg.Operation)){
                    $uniqShrUsers[$shrgUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqShrUsers[$shrgUsrLine]= $arr[0]+','+$resShrg.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqShrUsers.Add($shrgUsrLine,$resShrg.Operation+'#'+1) 
            }

            if($uniqShrClientIp.ContainsKey($resShrg.ClientIP)){
                $ipOutput=[String]$uniqShrClientIp[$resShrg.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resShrg.Operation)){
                    $uniqShrClientIp[$resShrg.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqShrClientIp[$resShrg.ClientIP]= $ipArr[0]+','+$resShrg.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqShrClientIp.Add($resShrg.ClientIP,$resShrg.Operation+'#'+1)
            }

            $shrgsiteLine=$resShrg.SiteUrl+'#'+$resShrg.Site
            if($uniqShrSites.ContainsKey($shrgsiteLine)){
                $siteOutput=[String]$uniqShrSites[$shrgsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resShrg.Operation)){
                    $uniqShrSites[$shrgsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqShrSites[$shrgsiteLine]= $siteArr[0]+','+$resShrg.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqShrSites.Add($shrgsiteLine,$resShrg.Operation+'#'+1)
            }

            if($uniqShrItem.ContainsKey($resShrg.ItemType)){
                $itemOutput=[String]$uniqShrItem[$resShrg.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resShrg.Operation)){
                    $uniqShrItem[$resShrg.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqShrItem[$resShrg.ItemType]= $itemArr[0]+','+$resShrg.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqShrItem.Add($resShrg.ItemType,$resShrg.Operation+'#'+1)
            }

            if($uniqShrDestnatn.ContainsKey($resShrg.SiteUrl)){
                $destOutput=[String]$uniqShrDestnatn[$resShrg.SiteUrl]
                $destArr=$destOutput.Split('#')
                if($destOutput.Contains($resShrg.Operation)){
                    $uniqShrDestnatn[$resShrg.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                }else{
                    $uniqShrDestnatn[$resShrg.SiteUrl]= $destArr[0]+','+$resShrg.Operation+'#'+[String]([int]$destArr[1]+1)
                }
            }else{
                $uniqShrDestnatn.Add($resShrg.SiteUrl,$resShrg.Operation+'#'+1)
            }   

            if($uniqShrUsrAgent.ContainsKey($resShrg.UserAgent)){
                $uniqShrUsrAgent[$resShrg.UserAgent]=[int]$uniqShrUsrAgent[$resShrg.UserAgent]+1
            }else{
                $uniqShrUsrAgent.Add($resShrg.UserAgent,1)
            }
     
            if($sharngAct.ContainsKey($resShrg.Operation)){               
                $sharngAct[$resShrg.Operation]=[int]$sharngAct[$resShrg.Operation]+1
            }
   
        }

        # ************** SITE ADMIN OPERATIONS ****************

        if($resSAdm -ne "" -and $resSAdm -ne $null){
            $isAdmUserAgent=[bool]($resSAdm.PSobject.Properties.name -match "UserAgent")
            $isAdmSiteUrl=[bool]($resSAdm.PSobject.Properties.name -match "SiteUrl")
            if(!$isAdmSiteUrl -or ($isAdmUserAgent -eq $false) -or (($resSAdm.UserId).IndexOf('#') -ne -1)){
                continue
            }
            if($uniqAdmnOpe.ContainsKey($resSAdm.Operation)){
                $uniqAdmnOpe[$resSAdm.Operation]=[int]$uniqAdmnOpe[$resSAdm.Operation]+1
            }else{
                $uniqAdmnOpe.Add($resSAdm.Operation,1) 
            }

            $admnUsrLine=$resSAdm.UserId+'#'+$resSAdm.ClientIP
            if($uniqAdmnUsers.ContainsKey($admnUsrLine)){          
                $output=[String]$uniqAdmnUsers[$admnUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resSAdm.Operation)){
                    $uniqAdmnUsers[$admnUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqAdmnUsers[$admnUsrLine]= $arr[0]+','+$resSAdm.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqAdmnUsers.Add($admnUsrLine,$resSAdm.Operation+'#'+1) 
            }

            if($uniqAdmnClientIp.ContainsKey($resSAdm.ClientIP)){
                $ipOutput=[String]$uniqAdmnClientIp[$resSAdm.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resSAdm.Operation)){
                    $uniqAdmnClientIp[$resSAdm.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqAdmnClientIp[$resSAdm.ClientIP]= $ipArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqAdmnClientIp.Add($resSAdm.ClientIP,$resSAdm.Operation+'#'+1)
            }

            if($isAdmSiteUrl){
                $admnsiteLine=$resSAdm.SiteUrl+'#'+$resSAdm.Site
            }#else{
             #   $admnsiteLine='-#'+$resSAdm.Site
            #}
            if($uniqAdmnSites.ContainsKey($admnsiteLine)){
                $siteOutput=[String]$uniqAdmnSites[$admnsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resSAdm.Operation)){
                    $uniqAdmnSites[$admnsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqAdmnSites[$admnsiteLine]= $siteArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqAdmnSites.Add($admnsiteLine,$resSAdm.Operation+'#'+1)
            }

            if($uniqAdmnItem.ContainsKey($resSAdm.ItemType)){
                $itemOutput=[String]$uniqAdmnItem[$resSAdm.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resSAdm.Operation)){
                    $uniqAdmnItem[$resSAdm.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqAdmnItem[$resSAdm.ItemType]= $itemArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqAdmnItem.Add($resSAdm.ItemType,$resSAdm.Operation+'#'+1)
            }

            if($isAdmSiteUrl){
                if($uniqAdmnDestnatn.ContainsKey($resSAdm.SiteUrl)){
                    $destOutput=[String]$uniqAdmnDestnatn[$resSAdm.SiteUrl]
                        $destArr=$destOutput.Split('#')
                    if($destOutput.Contains($resSAdm.Operation)){
                        $uniqAdmnDestnatn[$resSAdm.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                    }else{
                        $uniqAdmnDestnatn[$resSAdm.SiteUrl]= $destArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$destArr[1]+1)
                    }
                }else{
                    $uniqAdmnDestnatn.Add($resSAdm.SiteUrl,$resSAdm.Operation+'#'+1)
                }
            }

            if($isAdmUserAgent){
                if($uniqAdmnUsrAgent.ContainsKey($resSAdm.UserAgent)){
                    $uniqAdmnUsrAgent[$resSAdm.UserAgent]=[int]$uniqAdmnUsrAgent[$resSAdm.UserAgent]+1
                }else{
                    $uniqAdmnUsrAgent.Add($resSAdm.UserAgent,1)
                }
            }
      
            if($siteAdminAct.ContainsKey($resSAdm.Operation)){    
                $siteAdminAct[$resSAdm.Operation]=[int]$siteAdminAct[$resSAdm.Operation]+1
            }
        }
    }
    Eg-WriteLog -writString ('serchAuditLog iteartion finished ...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog

    # ******* FILE OPERATIONS *********

    $fileOperCnt=""
    for($i=0;$i -lt $fileOpe.Length;$i++ ){
        $fileOperCnt+="~!~"+$fileAct[$fileOpe[$i]]
    }
    Write-Host "FilePage Operations Count"$fileOperCnt !>

    #Summary measure count values
    foreach($key in $uniqOpe.keys){
        Write-Host "FilePageOpeartion"~!~ $key ~!~ $uniqOpe[$key] !>
    }

    foreach($key in $uniqusers.keys){
        $fileStrArr=([String]$uniqusers[$key]).Split('#')
        if($fileStrArr[0].Trim().Length -gt 1999){
            $updtdStr=$fileStrArr[0].Substring(0,1995)+'...'
            $updtdStr=$updtdStr+'#'+$fileStrArr[1]
            Write-Host "FilePageUsers"~!~ $key '#' $updtdStr !>
        }else{
            Write-Host "FilePageUsers"~!~ $key '#' $uniqusers[$key] !>
        }
    }

    foreach($key in $uniqClientIp.keys){
        $fileStrArr=([String]$uniqClientIp[$key]).Split('#')
        if($fileStrArr[0].Trim().Length -gt 1999){
            $updtdStr=$fileStrArr[0].Substring(0,1995)+'...'
            $updtdStr=$updtdStr+'#'+$fileStrArr[1]
            Write-Host "FilePageClientIP #"$key '#' $updtdStr !>
        }else{
            Write-Host "FilePageClientIP #"$key '#' $uniqClientIp[$key] !>
        }
    }

    foreach($key in $uniqsites.keys){
        $fileStrArr=([String]$uniqsites[$key]).Split('#')
        if($fileStrArr[0].Trim().Length -gt 1999){
            $updtdStr=$fileStrArr[0].Substring(0,1995)+'...'
            $updtdStr=$updtdStr+'#'+$fileStrArr[1]
            Write-Host "FilePageSites #"$key '#' $updtdStr !>
        }else{
            Write-Host "FilePageSites #"$key '#' $uniqsites[$key] !>
        }
    }

    foreach($key in $uniqItem.keys){
        $fileStrArr=([String]$uniqItem[$key]).Split('#')
        if($fileStrArr[0].Trim().Length -gt 1999){
            $updtdStr=$fileStrArr[0].Substring(0,1995)+'...'
            $updtdStr=$updtdStr+'#'+$fileStrArr[1]
            Write-Host "FilePageitems #"$key '#' $updtdStr !>
        }else{
            Write-Host "FilePageitems #"$key '#' $uniqItem[$key] !>
        }
    }
    
    foreach($key in $uniqDestnatn.keys){
        $fileStrArr=([String]$uniqDestnatn[$key]).Split('#')
        if($fileStrArr[0].Trim().Length -gt 1999){
            $updtdStr=$fileStrArr[0].Substring(0,1995)+'...'
            $updtdStr=$updtdStr+'#'+$fileStrArr[1]
            Write-Host "FilePageDestination #"$key '#' $updtdStr !>
        }else{
            Write-Host "FilePageDestination #"$key '#' $uniqDestnatn[$key] !>
        }   
    }

    foreach($key in $uniqUsrAgent.keys){
        Write-Host "FilePageUserAgent"~!~ $key~!~ $uniqUsrAgent[$key] !>
    }
    Eg-WriteLog -writString ('File operations done...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    #    ********** FOLDER OPERATIONS *******

    $fldrOperCnt=""
    for($i=0;$i -lt $folderOpe.Length;$i++ ){   
        $fldrOperCnt+="~!~"+$folderAct[$folderOpe[$i]]
    }
    Write-Host "Folder Operations Count"$fldrOperCnt !>

    foreach($key in $uniqFdrOpe.keys){
        Write-Host "FolderOpeartion"~!~ $key ~!~ $uniqFdrOpe[$key] !>
    }

    foreach($key in $uniqFdrusers.keys){
        $fldrStrArr=([String]$uniqFdrusers[$key]).Split('#')
        if($fldrStrArr[0].Trim().Length -gt 1999){
            $updtdFldrStr=$fldrStrArr[0].Substring(0,1995)+'...'
            $updtdFldrStr=$updtdFldrStr+'#'+$fldrStrArr[1]
            Write-Host "FolderUsers"~!~ $key '#' $updtdFldrStr !>
        }else{
            Write-Host "FolderUsers"~!~ $key '#' $uniqFdrusers[$key] !>
        }   
    }

    foreach($key in $uniqFdrClientIp.keys){
        $fldrStrArr=([String]$uniqFdrClientIp[$key]).Split('#')
        if($fldrStrArr[0].Trim().Length -gt 1999){
            $updtdFldrStr=$fldrStrArr[0].Substring(0,1995)+'...'
            $updtdFldrStr=$updtdFldrStr+'#'+$fldrStrArr[1]
            Write-Host "FolderClientIP #" $key '#' $updtdFldrStr !>
        }else{
            Write-Host "FolderClientIP #" $key '#' $uniqFdrClientIp[$key] !>
        }
        
    }

    foreach($key in $uniqFdrsites.keys){
        $fldrStrArr=([String]$uniqFdrsites[$key]).Split('#')
        if($fldrStrArr[0].Trim().Length -gt 1999){
            $updtdFldrStr=$fldrStrArr[0].Substring(0,1995)+'...'
            $updtdFldrStr=$updtdFldrStr+'#'+$fldrStrArr[1]
            Write-Host "FolderSites #" $key '#' $updtdFldrStr !>
        }else{
            Write-Host "FolderSites #" $key '#' $uniqFdrsites[$key] !>
        } 
    }

    foreach($key in $uniqFdrItem.keys){
        $fldrStrArr=([String]$uniqFdrItem[$key]).Split('#')
        if($fldrStrArr[0].Trim().Length -gt 1999){
            $updtdFldrStr=$fldrStrArr[0].Substring(0,1995)+'...'
            $updtdFldrStr=$updtdFldrStr+'#'+$fldrStrArr[1]
            Write-Host "Folderitems #" $key '#' $updtdFldrStr !>
        }else{
            Write-Host "Folderitems #" $key '#' $uniqFdrItem[$key] !>
        } 
    }

    foreach($key in $uniqFdrDestnatn.keys){
        $fldrStrArr=([String]$uniqFdrDestnatn[$key]).Split('#')
        if($fldrStrArr[0].Trim().Length -gt 1999){
            $updtdFldrStr=$fldrStrArr[0].Substring(0,1995)+'...'
            $updtdFldrStr=$updtdFldrStr+'#'+$fldrStrArr[1]
            Write-Host "FolderDestination #" $key '#' $updtdFldrStr !>
        }else{
            Write-Host "FolderDestination #" $key '#' $uniqFdrDestnatn[$key] !>
        }
    }

    foreach($key in $uniqFdUsrAgent.keys){
        Write-Host "FolderUserAgent"~!~ $key~!~ $uniqFdUsrAgent[$key] !>
    }
    Eg-WriteLog -writString ('Folder operations done...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog

    #    ********** SYNC OPERATIONS ********


    $syncOperCnt=""
    for($i=0;$i -lt $syncOpe.Length;$i++ ){
        $syncOperCnt+="~!~"+$syncAct[$syncOpe[$i]]
    }
    Write-Host "Synchronization Operations Count"$syncOperCnt !>

    foreach($key in $uniqSyncOpe.keys){
        Write-Host "SyncOpeartion"~!~ $key ~!~ $uniqSyncOpe[$key] !>
    }

    foreach($key in $uniqSyncUsers.keys){
        $syncStrArr=([String]$uniqSyncUsers[$key]).Split('#')
        if($syncStrArr[0].Trim().Length -gt 1999){
            $updtdSyncStr=$syncStrArr[0].Substring(0,1995)+'...'
            $updtdSyncStr=$updtdSyncStr+'#'+$syncStrArr[1]
            Write-Host "SyncUsers"~!~ $key '#' $updtdSyncStr !>
        }else{
            Write-Host "SyncUsers"~!~ $key '#' $uniqSyncUsers[$key] !>
        }  
    }

    foreach($key in $uniqSyncClientIp.keys){
        $syncStrArr=([String]$uniqSyncClientIp[$key]).Split('#')
        if($syncStrArr[0].Trim().Length -gt 1999){
            $updtdSyncStr=$syncStrArr[0].Substring(0,1995)+'...'
            $updtdSyncStr=$updtdSyncStr+'#'+$syncStrArr[1]
            Write-Host "SyncClientIP #" $key '#' $updtdSyncStr !>
        }else{
            Write-Host "SyncClientIP #" $key '#' $uniqSyncClientIp[$key] !>
        }  
    }

    foreach($key in $uniqSyncSites.keys){
        $syncStrArr=([String]$uniqSyncSites[$key]).Split('#')
        if($syncStrArr[0].Trim().Length -gt 1999){
            $updtdSyncStr=$syncStrArr[0].Substring(0,1995)+'...'
            $updtdSyncStr=$updtdSyncStr+'#'+$syncStrArr[1]
            Write-Host "SyncSites #"$key '#' $updtdSyncStr !>
        }else{
            Write-Host "SyncSites #"$key '#' $uniqSyncSites[$key] !>
        }
    }

    foreach($key in $uniqSyncItem.keys){
        $syncStrArr=([String]$uniqSyncItem[$key]).Split('#')
        if($syncStrArr[0].Trim().Length -gt 1999){
            $updtdSyncStr=$syncStrArr[0].Substring(0,1995)+'...'
            $updtdSyncStr=$updtdSyncStr+'#'+$syncStrArr[1]
            Write-Host "Syncitems #"$key '#' $updtdSyncStr !>
        }else{
            Write-Host "Syncitems #"$key '#' $uniqSyncItem[$key] !>
        }
    }

    foreach($key in $uniqSyncDestnatn.keys){
        $syncStrArr=([String]$uniqSyncDestnatn[$key]).Split('#')
        if($syncStrArr[0].Trim().Length -gt 1999){
            $updtdSyncStr=$syncStrArr[0].Substring(0,1995)+'...'
            $updtdSyncStr=$updtdSyncStr+'#'+$syncStrArr[1]
            Write-Host "SyncDestination #"$key '#' $updtdSyncStr !>
        }else{
            Write-Host "SyncDestination #"$key '#' $uniqSyncDestnatn[$key] !>
        }   
    }

    foreach($key in $uniqSyncUsrAgent.keys){
        Write-Host "SyncUserAgent"~!~ $key~!~ $uniqSyncUsrAgent[$key] !>
    }
    Eg-WriteLog -writString ('Sync operations done...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog

    #    ********** SHARING OPERATIONS ******** 

    $shrOperCnt=""
     for($i=0;$i -lt $sharngOpe.Length;$i++ ){  
         $shrOperCnt+="~!~"+$sharngAct[$sharngOpe[$i]]
     }
     Write-Host "Sharng Operations Count"$shrOperCnt !>
 
    foreach($key in $uniqShrOpe.keys){
        Write-Host "SharngOpeartion"~!~ $key ~!~ $uniqShrOpe[$key] !>
    }

    foreach($key in $uniqShrUsers.keys){
        $shrStrArr=([String]$uniqShrUsers[$key]).Split('#')
        if($shrStrArr[0].Trim().Length -gt 1999){
            $updtdShrStr=$shrStrArr[0].Substring(0,1995)+'...'
            $updtdShrStr=$updtdShrStr+'#'+$shrStrArr[1]
            Write-Host "SharngUsers"~!~ $key '#' $updtdShrStr !>
        }else{
            Write-Host "SharngUsers"~!~ $key '#' $uniqShrUsers[$key] !>
        }  
    }

    foreach($key in $uniqShrClientIp.keys){
        $shrStrArr=([String]$uniqShrClientIp[$key]).Split('#')
        if($shrStrArr[0].Trim().Length -gt 1999){
            $updtdShrStr=$shrStrArr[0].Substring(0,1995)+'...'
            $updtdShrStr=$updtdShrStr+'#'+$shrStrArr[1]
            Write-Host "SharngClientIP #"$key '#' $updtdShrStr !>
        }else{
            Write-Host "SharngClientIP #"$key '#' $uniqShrClientIp[$key] !>
        }  
    }

    foreach($key in $uniqShrSites.keys){
        $shrStrArr=([String]$uniqShrSites[$key]).Split('#')
        if($shrStrArr[0].Trim().Length -gt 1999){
            $updtdShrStr=$shrStrArr[0].Substring(0,1995)+'...'
            $updtdShrStr=$updtdShrStr+'#'+$shrStrArr[1]
            Write-Host "SharngSites #"$key '#' $updtdShrStr !>
        }else{
            Write-Host "SharngSites #"$key '#' $uniqShrSites[$key] !>
        }  
    }

    foreach($key in $uniqShrItem.keys){
        $shrStrArr=([String]$uniqShrItem[$key]).Split('#')
        if($shrStrArr[0].Trim().Length -gt 1999){
            $updtdShrStr=$shrStrArr[0].Substring(0,1995)+'...'
            $updtdShrStr=$updtdShrStr+'#'+$shrStrArr[1]
            Write-Host "Sharngitems #"$key '#' $updtdShrStr !>
        }else{
            Write-Host "Sharngitems #"$key '#' $uniqShrItem[$key] !>
        }    
    }

    foreach($key in $uniqShrDestnatn.keys){
        $shrStrArr=([String]$uniqShrDestnatn[$key]).Split('#')
        if($shrStrArr[0].Trim().Length -gt 1999){
            $updtdShrStr=$shrStrArr[0].Substring(0,1995)+'...'
            $updtdShrStr=$updtdShrStr+'#'+$shrStrArr[1]
            Write-Host "SharngDestination #"$key '#' $updtdShrStr !>
        }else{
            Write-Host "SharngDestination #"$key '#' $uniqShrDestnatn[$key] !>
        }
    }

    foreach($key in $uniqShrUsrAgent.keys){
        Write-Host "SharngUserAgent"~!~ $key~!~ $uniqShrUsrAgent[$key] !>
    }
    Eg-WriteLog -writString ('Sharing operations done...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    # ************** SITE ADMIN OPERATIONS ****************

    $siteAdminOperCnt=""
    for($i=0;$i -lt $siteAdminOpe.Length;$i++ ){  
        $siteAdminOperCnt+="~!~"+$siteAdminAct[$siteAdminOpe[$i]]
    }
    Write-Host "SAdmin Operations Count"$siteAdminOperCnt !>
 
    foreach($key in $uniqAdmnOpe.keys){
        Write-Host "SAdminOpeartion"~!~ $key ~!~ $uniqAdmnOpe[$key] !>
    }

    foreach($key in $uniqAdmnUsers.keys){
        $admnStrArr=([String]$uniqAdmnUsers[$key]).Split('#')
        if($admnStrArr[0].Trim().Length -gt 1999){
            $updtdAdmnStr=$admnStrArr[0].Substring(0,1995)+'...'
            $updtdAdmnStr=$updtdAdmnStr+'#'+$admnStrArr[1]
            Write-Host "SAdminUsers"~!~ $key '#' $updtdAdmnStr !>
        }else{
            Write-Host "SAdminUsers"~!~ $key '#' $uniqAdmnUsers[$key] !>
        }  
    }

    foreach($key in $uniqAdmnClientIp.keys){
        $admnStrArr=([String]$uniqAdmnClientIp[$key]).Split('#')
        if($admnStrArr[0].Trim().Length -gt 1999){
            $updtdAdmnStr=$admnStrArr[0].Substring(0,1995)+'...'
            $updtdAdmnStr=$updtdAdmnStr+'#'+$admnStrArr[1]
            Write-Host "SAdminClientIP #"$key '#' $updtdAdmnStr !>
        }else{
            Write-Host "SAdminClientIP #"$key '#' $uniqAdmnClientIp[$key] !>
        }  
    }

    foreach($key in $uniqAdmnSites.keys){
        $admnStrArr=([String]$uniqAdmnSites[$key]).Split('#')
        if($admnStrArr[0].Trim().Length -gt 1999){
            $updtdAdmnStr=$admnStrArr[0].Substring(0,1995)+'...'
            $updtdAdmnStr=$updtdAdmnStr+'#'+$admnStrArr[1]
            Write-Host "SAdminSites #"$key '#' $updtdAdmnStr !>
        }else{
            Write-Host "SAdminSites #"$key '#' $uniqAdmnSites[$key] !>
        } 
    }

    foreach($key in $uniqAdmnItem.keys){
        $admnStrArr=([String]$uniqAdmnItem[$key]).Split('#')
        if($admnStrArr[0].Trim().Length -gt 1999){
            $updtdAdmnStr=$admnStrArr[0].Substring(0,1995)+'...'
            $updtdAdmnStr=$updtdAdmnStr+'#'+$admnStrArr[1]
            Write-Host "SAdminitems #"$key '#' $updtdAdmnStr !>
        }else{
            Write-Host "SAdminitems #"$key '#' $uniqAdmnItem[$key] !>
        }
    }

    foreach($key in $uniqAdmnDestnatn.keys){
        $admnStrArr=([String]$uniqAdmnDestnatn[$key]).Split('#')
        if($admnStrArr[0].Trim().Length -gt 1999){
            $updtdAdmnStr=$admnStrArr[0].Substring(0,1995)+'...'
            $updtdAdmnStr=$updtdAdmnStr+'#'+$admnStrArr[1]
            Write-Host "SAdminDestination #"$key '#' $updtdAdmnStr !>
        }else{
            Write-Host "SAdminDestination #"$key '#' $uniqAdmnDestnatn[$key] !>
        }
    }

    foreach($key in $uniqAdmnUsrAgent.keys){
        Write-Host "SAdminUserAgent"~!~ $key~!~ $uniqAdmnUsrAgent[$key] !>
    }
    Eg-WriteLog -writString ('Site admin operations done...') -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
}
Catch{
    $spoExcepMsg3='[SPOActOperations] Exception Occured while processing the objects -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception+'!>'
    Eg-WriteLog -writString ('spoExcepMsg3 -->> '+$spoExcepMsg3) -LogPath $logPath -ReportingName $reportingNam -TestFreq $testFrequency -isWriteLog $isWriteLog
    Write-Host $spoExcepMsg3
}

[System.GC]::GetTotalMemory($true) | out-null

#         *************************** END *************************

