$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply Server name and folder scope"
	break
}

$ServerName = $args[0]
$folderscope = $args[1]
$stats = 'Inbox','Outbox','DeletedItems','SentItems','Calendar'

$Global:ErrorActionPreference="SilentlyContinue"
$allmbs = Get-Mailbox -Server $ServerName -ResultSize unlimited
foreach ($amb in $allmbs)
{
	$mb = Get-Mailbox -Identity $amb.Name
	if($folderscope -ieq "all")
	{
		$mbfolders = Get-MailboxFolderStatistics $amb.Name
		foreach ($folder in $mbfolders)
		{	
			Write-Host ($mb.Database,$amb.Name,$folder.Name,$folder.ItemsInFolder,$folder.FolderSize.ToKB(),$folder.ItemsInFolderAndSubfolders,$folder.FolderAndSubfolderSize.ToKB() ) -Separator  ";"
		 
		}
	}
	else
	{
		foreach($stat in $stats)
		{
			$mbfolders = Get-MailboxFolderStatistics $amb.Name -FolderScope $stat
			foreach ($folder in $mbfolders)
			{
				Write-Host ($mb.Database,$amb.Name,$folder.Name,$folder.ItemsInFolder,$folder.FolderSize.ToKB(),$folder.ItemsInFolderAndSubfolders,$folder.FolderAndSubfolderSize.ToKB() ) -Separator  ";"
		 	}
		}
	}
}