$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
$results = Test-ReplicationHealth -identity $env:computername
if($results -ne $null)
{
	foreach($result in $results)
	{
		$check = $result.check
		$status = $result.Result
		$errorStr = $result.error
		Write-Host($check,$status,$errorStr) -separator ";"
	}

}
Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
