$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply the identity parameter and IndexTimeout parameters"
	break
}

$Identity = $args[0]
$Timeout = $args[1]
Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
$stats = Test-ExchangeSearch -identity $Identity -IndexingTimeoutInSeconds $Timeout 
foreach($stat in $stats)
{
	$Error = "-"
	if ($stat.Error -ne $null)
	{
		$Error = $stat.Error
	}
	Write-Host ($stat.Database,$stat.Server,$stat.Mailbox, $stat.ResultFound,$stat.SearchTimeInSeconds,$Error) -Separator ";"
}
Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn