$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.Broker*
$xdhost ="localhost"
$actions = @()
$pendingactions = get-brokerhostingpoweraction -AdminAddress $xdhost -State 'Pending' -EA 0
$startedactions = get-brokerhostingpoweraction -AdminAddress $xdhost -State 'Started' -EA 0
$actions += $pendingactions
$actions += $startedactions 
$time = get-date
if(($actions) -ne $null)
{
	foreach($action in $actions)
	{
		$desktop = get-brokerdesktop -MachineName $action.MachineName -EA 0
		switch ($action.ActualPriority)
		{
			10 { $actionsource = "'User-driven restart' " }
			20 { $actionsource = "Session Launch " }
			30 { $actionsource = "Admin " }
			33 { $actionsource = "PVD " }
			40 { $actionsource = "'Un-taint' worker " }
			50 { $actionsource = "Power Policy " }
			60 { $actionsource = "Idle Pool " }
		}
		$diff = ($time - $action.RequestTime)
		$elapsedTimeInMSecs = $diff.TotalMilliSeconds
		Write-Host ($action.UID,$action.RequestTime,$actionsource,$action.Action,$action.State,$action.MachineName,
			    $desktop.CatalogName,$desktop.DNSName,$desktop.DesktopGroupName,$desktop.HypervisorConnectionName,$desktop.ProvisioningType,$elapsedTimeInMSecs) -Separator "#~#"
	}
}
else
{
	Write-Host "No pending or running power actions available"    
}

Remove-PSSnapin Citrix.Broker*


