$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$name = $args[0]
cls
$search = New-Object DirectoryServices.DirectorySearcher([ADSI])
$search.filter = "(&(servicePrincipalName=*)(name=$name))"
$results = $search.Findall()

#list results
foreach($result in $results)
{
       $userEntry = $result.GetDirectoryEntry()
       Write-host "Object Name : " $userEntry.name 
       Write-host "DN : "  $userEntry.distinguishedName
       Write-host "Category : "  $userEntry.objectCategory
       Write-host "ServicePrincipalNames are "
       $i=1
       foreach($SPN in $userEntry.servicePrincipalName)
       {
           Write-host "SPN(" $i ") = " $SPN
                 $i+=1
       }
       Write-host ""

}
