$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference = "Stop"
If ($args[1] -ne $args[2])
{
    Write-host "The new password does not match the confirmation. Please re-enter the password and try again."
    Exit 1
}
Try
{
    Import-Module ActiveDirectory
}
Catch
{
    Write-Host "Unable to load the module" -ErrorAction Continue
    Exit 1
}

Try
{
  Set-ADAccountPassword -Identity $args[0].split("\")[1] -NewPassword (ConvertTo-SecureString -AsPlainText $args[1] -Force) -Reset
}
Catch
{
    Write-Error $Error[0] -ErrorAction Continue
    Exit 1
}

Write-Host "The user password is changed successfully." 
