[CmdletBinding()]
Param (
    
    [string] $deliveryController = "localhost",
    [Parameter(Mandatory=$True)]
    [string] $deliveryGroupName = "None"
)

Add-PSSnapin Citrix.Broker.*
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$MaxRecordCount = 250

$allVMs = @()
do 
{
    if($deliveryGroupName -like "*None*")
    {
        $VMs = @(Get-BrokerMachine -AdminAddress $deliveryController -RegistrationState Registered -MaxRecordCount $MaxRecordCount | select-object DnsName, machinename,desktopgroupname, PowerState, IsPhysical)
    }
    else {
        $VMs = @(Get-BrokerMachine -AdminAddress $deliveryController -DesktopGroupName $deliveryGroupName -RegistrationState Registered  -MaxRecordCount $MaxRecordCount | select-object DnsName, machinename,desktopgroupname, PowerState, IsPhysical)
    }
    if($VMs.count -gt 0)
    {
        $allVMs += $VMs
    }
} while ($VMs.count -ge $MaxRecordCount)

if($allVMs)
{
    foreach($VM in $allVMs)
    {
        # Checking for managed VMs with PowerState 
        if($VM.PowerState -eq 'On' -and $VM.IsPhysical -eq $false)
        {
            $computer = $VM.machinename.split('\').item(1)
            try {
                New-BrokerHostingPowerAction -MachineName $computer -Action Restart -ErrorAction stop
                Write-host "Restarting the VDA $($VM.DnsName) in the deliver group $($VM.DesktopGroupName) is initiated successfully using the hosting power action."
            }
            catch {
                Write-host "Restarting the VDA $($VM.DnsName) in the deliver group $($VM.DesktopGroupName) has failed. Please check the permissions"  
            }
            
        }
	else
	{
		Write-host "The VM $($computer) in the delivery group '$($VM.DesktopGroupName)' is in '$($VM.PowerState)' powerstate . So the restart acton is skipped." 
	}
    }

}
else
{
	Write-Host "No managed registered VMs found in the selected delivery group"
}

Remove-pssnapin Citrix.Broker.*
