$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Filter = "(&(objectCategory=User))"
$Domain = New-Object System.DirectoryServices.DirectoryEntry
$Searcher = New-Object System.DirectoryServices.DirectorySearcher
$Searcher.SearchRoot = "LDAP://$($Domain.DistinguishedName)"
$Searcher.PageSize = 1000
$Searcher.SearchScope = "Subtree"
$Searcher.Filter = $Filter
$Searcher.PropertiesToLoad.Add("Name") | Out-Null
$Searcher.PropertiesToLoad.Add("LastLogonTimeStamp") | Out-Null
$Results = $Searcher.FindAll()
write-host "Name;Last Logon Time" 
Foreach($Result in $Results) {
    $Name = $Result.Properties.Item("Name")
    $LastLogonTimeStamp = $Result.Properties.Item("LastLogonTimeStamp")          
    If ($LastLogonTimeStamp.Count -eq 0)
    {
        $LastLogonTimeStamp = "Never Logon"
    }
    Else
    {
        $Time = [DateTime]$LastLogonTimeStamp.Item(0)
        $LastLogonTimeStamp = $Time.AddYears(1600).ToString("yyyy/MM/dd")
    }
    $str = $Name + ";" +  $LastLogonTimeStamp.trim()  
    write-host $str                                              
}
