$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$CONFIG_INFO_SEPARATOR = ">"
$applications = Get-XAApplication

foreach($application in $applications)
{
	Write-Host "#Applications - start"
	Write-Host "#Application Name Settings - start"
	$report = get-XAApplicationReport -BrowserName $application.BrowserName
	Write-Host "Display name : "  $report.DisplayName
	Write-Host "Application name : " $report.BrowserName
	Write-Host "Description : " $report.Description
	if($report.Enabled -eq "True")
	{
		Write-Host "Enable : true"
	}
	else
	{
		Write-Host "Enable : false"
	}
	Write-host "#Application Name Settings - end"
	Write-Host

	Write-Host "#Application Location Settings - start"
	if($report.ApplicationType -eq "ServerInstalled")
	{
		Write-Host  "Application type : Published Application"
	}
	if($report.ApplicationType -eq "ServerDesktop")
	{
		Write-Host "Applicaiton type : Published Desktop"
	}
	Write-Host "Command line : " $report.CommandLineExecutable
	Write-Host "Working Directory  : " $report.WorkingDirectory
	Write-host "#Application Location Settings - end"
	Write-Host

	Write-Host "#Application appearence Settings - start"
	Write-Host "Session Window Size: " $report.WindowType
	Write-Host "Colors : " $report.ColorDepth

	if($report.MaximizedOnStartup -eq "False")
	{
		Write-Host "Max startup : Not Selected"
	}
	else
	{
		Write-Host "Max startup : Selected"
	}

	if($report.TitleBarHidden -eq "False")
	{
		Write-Host "Hide titlebar : Not Selected"
	}
	else
	{
		Write-Host "Hide titlebar : Selected"
	}

	Write-Host "#Application appearence Settings - end"
	Write-Host

	Write-Host #Application limits Settings - start"

	if($report.InstanceLimit -eq -1)
	{
		Write-Host "Limit instances : Not Selected"
		Write-Host "Maximum Instances : Not Selected"
	}
	else
	{
		Write-Host "Limit instances : Selected"
		Write-Host "Maximum Instances : " $report.InstanceLimit
	}

	if($report.MultipleInstancesPerUserAllowed -eq "True")
	{
		Write-Host "AllowMultiInstancePerUser : Selected"
	}
	else
	{
		Write-Host "AllowMultiInstancePerUser : Not Selected"
	}

	Write-Host "CpuPriority : " $report.CpuPriorityLevel
	Write-Host  "#Application limits Settings - end"
	Write-Host

	Write-Host "#ICA client options - start"

	if($report.AudioRequired -eq "False")
	{
		Write-Host  "Audio : Not Selected"
	}
	else
	{
		Write-Host "Audio : Selected"
	}

	Write-Host "Encryption : " $report.EncryptionLevel
	Write-Host  "#ICA client options - end"
	Write-Host

	Write-Host "#PN settings - start"
	Write-Host "Program Neighborhood folder : " $report.ClientFolder

	if($report.AddToClientStartMenu -eq "False")
	{
		Write-Host "Add Client Start menu : Not Selected"
	}
	else
	{
		Write-Host "Add Client Start menu : Selected"
	}

	if($report.StartMenuFolder -eq "" -or $report.StartMenuFolder -eq "False")
	{
		Write-Host "Start menu folder : Not Selected"
	}
	else
	{
		Write-Host "Start menu folder : Selected"
	}
	Write-Host "Place under program folder : Not Selected"

	if($report.AddToClientDesktop -eq "False")
	{
		Write-Host "Desktop shortcut : Not Selected"
	}
	else
	{
		Write-Host "Desktop shortcut : Selected"
	}
	Write-Host "#PN settings - end"
	Write-Host

	Write-Host "#Servers - start"
	Write-Host $report.ServerNames
	Write-Host "#Servers - end"
	Write-Host

	Write-Host  "#Users - start"
	Write-Host "List of users for " $report.DisplayName
	$UserNames = "-"
	$Accounts = $report.Accounts
	if ($Accounts -ne $null -and $Accounts.length -gt 0)
	{
		$users = ""
		foreach ($Account in $Accounts)
		{
			$users = $users + "," + $Account
		}
		if ($users.startsWith(","))
		{
			$UserNames = $users.substring(1)
		}
		else
		{
			$UserNames = $users
		}
	}
	Write-Host $UserNames
	Write-Host "#Users - end"
	Write-Host 

	Write-Host "#Groups - start"
	Wriite-Host "List of groups for " $report.DisplayName
	Write-Host $report.WorkerGroupNames
	Write-Host "#Groups - end"
	Write-Host 

}
Remove-PSSnapin Citrix.XenApp.Commands

