﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear

function Get-INIContent(){
    [CmdletBinding()]
    Param (
    [Parameter(Mandatory=$true, Position=1)]
    [String]$subject, 
    [Parameter(Mandatory=$true, Position=2)]
    [String]$appNam
    )
    Process
    {
        $appVal=''
        $hashAppVal=@{}
        $ischk=$false
		$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
		$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
        $tstIniPath=$egurkhaPath+'\agent\config\O365_Prerequisites.ini'
        $iniContent=get-content -Path $tstIniPath
        $isFound=$false
        for($i=0;$i -lt $iniContent.Length;$i++ ){
            if($appNam -eq 'none'){
                if($iniContent[$i].StartsWith('['+$subject) -and (!$iniContent[$i].StartsWith(';'))){ 
                    $ischk=$true
                    #Write-Host '88888 ' $iniContent[$i]
                    $subNam=($iniContent[$i] -split '-')[1]
                    $val=$subNam.Substring(0,($subNam.length-1)).Trim()
                    $i++
                    $key=($iniContent[$i] -split '=')[1]
                    $hashAppVal.Add($key,$val)
                }
            }else{
                if($iniContent[$i].StartsWith('['+$subject) -and (!$iniContent[$i].StartsWith(';'))){ 
                    $i++
                    while($true){
                        try{
                            $iniArr=$iniContent[$i].Split('=')
                            if($appNam -eq $iniArr[0]){
                                $appVal=$iniArr[1]
                                $isFound=$true
                                break;    
                            }
                        }catch{$isFound=$true;break;}
                            $i++  
                    }
                }
            if($isFound){break;}
            }
        }
        if($ischk){
            return $hashAppVal
        }
        else{
            return $appVal
        }
    }
}

$dwnld=Get-INIContent -subject 'Location' -appNam 'Download'
if($dwnld -ne 'none' -and (Test-Path $dwnld)){
    $DownloadLocation=$dwnld   
}else{
    $DownloadLocation = $env:USERPROFILE+'\downloads\O365\'
}
if(!(Test-Path -Path $DownloadLocation)){
    $null=New-Item -ItemType directory -Path $DownloadLocation
}
$os=[String](Get-WMIObject win32_operatingsystem).Name
$osNam=$os.Substring(0,$os.IndexOf('|')).Trim() #(Microsoft Windows 7 Professional |C:\Windows|\Device\Harddisk0\Partition2)
$csdVersion=(Get-WMIObject win32_operatingsystem).CSDVersion #(Service Pack 1)
$sysType=(Get-WMIObject win32_operatingsystem).OSArchitecture #(64-bit)

Write-Host 'SYSTEM INFO - ' $osNam ' -- ' $csdVersion '--' $sysType
Write-Host 'Download Location - ' $DownloadLocation

#LOG
$lgf=Get-INIContent -subject 'Location' -appNam 'Log'
if($lgf -ne 'none' -and (Test-Path $lgf)){
    $logDir=$lgf   
}else{
	$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
	$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
    $logDir=$egurkhaPath+'\agent\O365'
}
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$logFile=$logDir+'\Installation.log'
#Remove-Item -Path $logFile
Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

function Unzip{
    param([string]$zipfile, [string]$outpath)
    #[System.IO.Compression.ZipFile]::ExtractToDirectory($zipfile, $outpath)
    $shell_app=new-object -com shell.application
    $zip_file = $shell_app.namespace($zipfile)
    $destination = $shell_app.namespace($outpath)
    $destination.Copyhere($zip_file.items())
}
O365-WriteLog -writString '*****************************************************************' -LogPath $logFile -ReportingName 'START-1'
O365-WriteLog -writString $osNam ' -- ' $csdVersion '--' $sysType -LogPath $logFile -ReportingName 'SYSTEM INFO'
O365-WriteLog -writString $DownloadLocation -LogPath $logFile -ReportingName 'Download Location'
$isR2=$false
function Chk-OSTypes(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$OSStr       
    )
    Process
    {
        if($OSStr -eq 'AllOS'){
            return $true
        }else{
            $chkOS=$false
            $osArr=$OSStr -split '!'
            foreach($osTyp in $osArr){           
                if($osTyp -match '#' -and $osTyp -notmatch '-'){
                    $osVerArr=$osTyp -split '#'
                    if($osNam -match $osVerArr[0] -and $osNam -match $osVerArr[1]){$chkOS=$true}
                    $isR2=$true
                }elseif($osTyp -match '#' -and $osTyp -match '-'){
                    $osVerArr=$osTyp -split '#'
                    $osHyArr=$osVerArr[1] -split '-'
                    if($osNam -match $osVerArr[0] -and $osNam -match $osHyArr[0] -and $csdVersion -match $osHyArr[1]){$chkOS=$true}
                }elseif($osTyp -notmatch '#' -and $osTyp -match '-'){
                    $osVerArr=$osTyp -split '-'
                    if($osNam -match $osVerArr[0] -and $csdVersion -match $osVerArr[1]){$chkOS=$true}
                }else{
                    if($osNam -match $osTyp){$chkOS=$true}
                }
                if($chkOS){
                    return $true
                }
            }
            return $false   
        }
    }
}

function Chk-Registry(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$RegStr       
    )
    Process
    {
        if($RegStr -eq 'NIL'){
            return $true
        }else{
        $regArr=$RegStr -split '#'
        $regValuesArr=$regArr[1] -split '!'
        $regValues=Get-ItemProperty -Path $regArr[0]
        foreach($regValue in $regValuesArr){
            $valArr=$regValue -split '-'
            $regStr=$valArr[0]
            $curval=[int]$regValues."$regStr"
            $val=[int]$valArr[1]
            if(!($curval -ge $val)){
                return $true
                break;
            }
        }
        return $false
        }
    }
}

function Get-DotNetVer(){
    $releases=Get-ChildItem 'HKLM:\SOFTWARE\Microsoft\NET Framework Setup\NDP' -recurse |Get-ItemProperty -name Version,Release -EA 0 |Where { $_.PSChildName -match '^(?!S)\p{L}'} |Select Release
    $version=0
    foreach($re in $releases){
        $release=$re.Release
        if($release -eq ""){$release=0}else{$release=[int]$release}
        if($release -gt $version){
            $version=$release
        }   
    }
    return $version
}

$preDwnldHash=New-Object System.Collections.Specialized.OrderedDictionary #[ordered]@{}
$installHash=New-Object System.Collections.Specialized.OrderedDictionary #[ordered]@{}

function Proceed-Download(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$APPName, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$APPFile
    )
    Process
    {
        Try{
            if($APPFile -match '#'){
                $arr=$APPFile -split '#'
                $appDst=$arr[0].Substring($arr[0].LastIndexOf('/')+1)
                $dest=$DownloadLocation+$appDst
                if((Get-Host).Version.Major -le 3){
                    $wc=New-Object System.Net.WebClient
                    $wc.DownloadFile($arr[0],$dest)
                }else{
                    $isPresent=Test-Path $dest -PathType Leaf
                    if(!$isPresent){
                        Try{
                            Write-Host $APPName '- Downloading started' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading started' -LogPath $logFile -ReportingName $APPName
                            Start-BitsTransfer -Source $arr[0] -Destination $dest -TransferType Download -Description "Transfering $APPName" -ErrorAction Stop
                            Write-Host $APPName '- Downloading completed' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading completed' -LogPath $logFile -ReportingName $APPName
                        }Catch{
                            Write-Host $APPName '- Downloading not completed or failed' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading not completed or failed' -LogPath $logFile -ReportingName $APPName
                        }
                    }
                }
                Unzip -zipfile $dest -outpath $DownloadLocation
                #$dest=$dest.Replace(".zip",$arr[1])
                #$installHash.Add($dest,$APPName)
            }else{
                $appDst=$APPFile.Substring($APPFile.LastIndexOf('/')+1)
                $dest=$DownloadLocation+$appDst
                if((Get-Host).Version.Major -le 3){
                    $wc=New-Object System.Net.WebClient
                    $wc.DownloadFile($APPFile,$dest)
                }else{
                    $isPresent=Test-Path $dest -PathType Leaf
                    if(!$isPresent){
                        Try{
                            Write-Host $APPName '- Downloading started' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading started' -LogPath $logFile -ReportingName $APPName
                            Start-BitsTransfer -Source $APPFile -Destination $dest -TransferType Download -Description "Transfering $APPName" -ErrorAction Stop
                            Write-Host $APPName '- Downloading completed' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading completed' -LogPath $logFile -ReportingName $APPName
                        }Catch{
                            Write-Host $APPName '- Downloading not completed or failed' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading not completed or failed' -LogPath $logFile -ReportingName $APPName
                        }
                    }
                }       
            }
        }Catch{
                Write-Host "Download Failed" $Exception.Message -ForegroundColor Red
        }
    }      
}

function EG-Download(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$APPName, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$APPFile
    )
    Process
    {
        if($APPFile -match '#'){
            $arr=$APPFile -split '#'
            $appDst=$arr[0].Substring($arr[0].LastIndexOf('/')+1)
            $dest=$DownloadLocation+$appDst
            $isPresent=Test-Path $dest -PathType Leaf
            if(!$isPresent){
                $preDwnldHash.add($APPName,$APPFile)
            }
            $dest=$dest.Replace(".zip",$arr[1])
        }else{
            $appDst=$APPFile.Substring($APPFile.LastIndexOf('/')+1)
            $dest=$DownloadLocation+$appDst
            $isPresent=Test-Path $dest -PathType Leaf
            if(!$isPresent){
                $preDwnldHash.add($APPName,$APPFile)
            }  
        } 
        $installHash.Add($dest,$APPName)    
    }
}

$dotNetInsVer=0
$currVer=0
function DotNet-Download{
    if ($sysType -match '64-bit'){
        $dotNetVerArr =Get-INIContent -subject 'DotNet' -appNam 'Dotnet_64' 
    }
    if($sysType -match '32-bit'){
        $dotNetVerArr =Get-INIContent -subject 'DotNet' -appNam 'Dotnet_32' 
    }
    $dotNetArr=$dotNetVerArr -split '~'
    foreach($element in $dotNetArr){
        if($isR2){$isR2=$false; continue;}
        $valArr=$element -split '@'
        $currVer=Get-DotNetVer #379393
        $dotNetInsVer=[int]$valArr[2]
        $isOk=Chk-OSTypes -OSStr $valArr[1] 
        if($currVer -lt $dotNetInsVer -and $isOk){
            EG-Download -APPName $valArr[0] -APPFile $valArr[3]  
        }
        
    }
}

$updatOptions=@{}
$updatOptions=Get-INIContent -subject 'Updates' -appNam 'none'
$onames =$updatOptions.Keys
$chkBxStr=''

######***GUI****#######
 $form = New-Object System.Windows.Forms.Form
    $flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
    $buttonOK = New-Object System.Windows.Forms.Button
    $textbox1=New-Object System.Windows.Forms.TextBox
    $label1=New-Object System.Windows.Forms.Label
    $textbox2=New-Object System.Windows.Forms.TextBox
    $label2=New-Object System.Windows.Forms.Label

    $textbox3=New-Object System.Windows.Forms.TextBox
    $label3=New-Object System.Windows.Forms.Label
    $textbox4=New-Object System.Windows.Forms.TextBox
    $label4=New-Object System.Windows.Forms.Label
    $label5=New-Object System.Windows.Forms.Label
    
    $totalvalues = ($onames.count)

    $formsize = 225 + (30 * $totalvalues)
    $flowlayoutsize = 10 + (30 * $totalvalues)
    $buttonplacement = 160 + (30 * $totalvalues)

    $script:CheckBoxArray = @()

    $form_Load = {

       foreach($user in $onames){

            $DynamicCheckBox = New-object System.Windows.Forms.CheckBox

            $DynamicCheckBox.Margin = '10, 8, 0, 0'
            $DynamicCheckBox.Name = $user
            $DynamicCheckBox.Size = '200, 22'
            $DynamicCheckBox.Text = "" + $user
            $DynamicCheckBox.TextAlign = 'MiddleLeft'
            $flowlayoutpanel.Controls.Add($DynamicCheckBox)
            $script:CheckBoxArray += $DynamicCheckBox
        }       
    }
    $form.Controls.Add($label5)
    $form.Controls.Add($label1)
    $form.Controls.Add($textbox1)
    $form.Controls.Add($label2)
    $form.Controls.Add($textbox2)
    $form.Controls.Add($label3)
    $form.Controls.Add($textbox3)
    $form.Controls.Add($label4)
    $form.Controls.Add($textbox4)
    $form.Controls.Add($flowlayoutpanel)
    $form.Controls.Add($buttonOK)
    $form.AcceptButton = $buttonOK
    $form.AutoScaleDimensions = '8, 17'
    $form.AutoScaleMode = 'Font'
    $form.ClientSize = "380 , $formsize"
    $form.FormBorderStyle = 'FixedDialog'
    $form.Margin = '5, 5, 5, 5'
    $form.MaximizeBox = $False
    $form.MinimizeBox = $False
    $form.Name = 'form1'
    $form.StartPosition = 'CenterScreen'
    $form.Text = 'O365 Prerequisites'
    $form.add_Load($($form_Load))

    
    $flowlayoutpanel.BorderStyle = 'FixedSingle'
    $flowlayoutpanel.Location = '38, 135'
    $flowlayoutpanel.Margin = '4, 4, 4, 4'
    $flowlayoutpanel.Name = 'flowlayoutpanel1'
    $flowlayoutpanel.AccessibleName = 'flowlayoutpanel1'
    $flowlayoutpanel.Size = "300, $flowlayoutsize"
    $flowlayoutpanel.TabIndex = 1

    $label5.Location="38,15"
    $label5.Anchor="Bottom, Left"
    $label5.Text="&Proxy Details :"
    $label5.Size="100,20"

    $label1.Location="38,40"
    $label1.Anchor="Bottom, Left"
    $label1.Text="&Host IP"
    $label1.Size="60,20"

    $textbox1.Location="105,40"
    $textbox1.Name="ProxyHost"
    $textbox1.Size="120,20"
    $textbox1.Text="none"

    $label2.Location="228,40"
    $label2.Anchor="Bottom, Left"
    $label2.Text="&Port"
    $label2.Size="25,20"

    $textbox2.Location="255,40"
    $textbox2.Name="Port"
    $textbox2.Size="50,20"
    $textbox2.Text="none"

    $label3.Location="38,70"
    $label3.Anchor="Bottom, Left"
    $label3.Text="&Username"
    $label3.Size="60,20"

    $textbox3.Location="105,70"
    $textbox3.Name="ProxyUser"
    $textbox3.Size="200,20"
    $textbox3.Text="none"

    $label4.Location="38,100"
    $label4.Anchor="Bottom, Left"
    $label4.Text="&Password"
    $label4.Size="60,20"

    $textbox4.Location="105,100"
    $textbox4.Name="ProxyPass"
    $textbox4.Size="200,20"
    $textbox4.Text="none"
    $textbox4.PasswordChar='*'

    $buttonOK.Anchor = 'Bottom, Right'
    $buttonOK.DialogResult = 'OK'
    $buttonOK.Location = "150, $buttonplacement"
    $buttonOK.Margin = '4, 4, 4, 4'
    $buttonOK.Name = 'buttonOK'
    $buttonOK.Size = '100, 30'
    $buttonOK.TabIndex = 0
    $buttonOK.Text = '&OK'

    $frmDialog=$form.ShowDialog()
    $isChkdOption=$false
    foreach($cbox in $CheckBoxArray){
        if($cbox.CheckState -eq 'Checked'){
            $isChkdOption=$true
            $chkBxStr=$chkBxStr+'~'+$updatOptions[$cbox.Name]
        }   
    }  
    Remove-Variable checkbox*

if($frmDialog -eq 'OK'){
    $proxyHost=$textbox1.Text
    $proxyPort=$textbox2.Text
    $proxyUsr=$textbox3.Text
    $proxyPass=$textbox4.Text

    if($proxyHost -ne '' -and $proxyHost -ne $null -and $proxyHost -ne 'none' -and $proxyPort -ne '' -and $proxyPort -ne $null -and $proxyPort -ne 'none'){
        $proxyserver='http://'+$proxyHost+':'+$proxyPort
        O365-WriteLog -writString 'Proxy Available in this System '$proxyserver -LogPath $logFile -ReportingName 'SYSTEM'
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
        if($proxyUsr -ne '' -and $proxyUsr -ne $null -and $proxyUsr -ne 'none' -and $proxyPass -ne '' -and $proxyPass -ne $null -and $proxyPass -ne 'none'){
            O365-WriteLog -writString 'Proxy credentials are Available in this System ' -LogPath $logFile -ReportingName 'SYSTEM'
            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        }
    }
    
    O365-WriteLog -writString 'Installations Block Started' -LogPath $logFile -ReportingName 'SYSTEM'

    if((Get-Host).Version.Major -ge 5 -and (Get-Host).Version.Minor -ge 1){
        Write-Host "powershell version -- " (Get-Host).Version
        O365-WriteLog -writString (Get-Host).Version 'version' -LogPath $logFile -ReportingName 'Windows FrameWork'    
    }
    else{
        DotNet-Download
        O365-WriteLog -writString (Get-Host).Version 'version' -LogPath $logFile -ReportingName 'Windows FrameWork'
        if ($sysType -match '64-bit'){
            $winFWArr=Get-INIContent -subject 'WinFW' -appNam 'WinFW_64' 
        }
        if($sysType -match '32-bit'){
            $winFWArr=Get-INIContent -subject 'WinFW' -appNam 'WinFW_64'
        }
        $sss=
        $wmfArr=$winFWArr -split '~'
        foreach($wmf in $wmfArr){
            $wmfValArr=$wmf -split '@'
            $chkOk=Chk-OSTypes -OSStr $wmfValArr[1]
            if($chkOk){
                EG-Download -APPName $wmfValArr[0] -APPFile $wmfValArr[2]
                break;
            }
        }
    }
}

if($isChkdOption){
    foreach($upOpt in $updatOptions.Values){
        if($chkBxStr -match $upOpt){
            if ($sysType -match '64-bit'){
                $cntNam='Update_'+$upOpt+'_64'
                $updatOptArr =Get-INIContent -subject 'Updates' -appNam $cntNam
            }
            if($sysType -match '32-bit'){
                $cntNam='Update_'+$upOpt+'_32'
                $updatOptArr =Get-INIContent -subject 'Updates' -appNam $cntNam 
            }
            $updatOpts=$updatOptArr -split '~'
            foreach($updatOpt in $updatOpts){
                $updatFilesArr=$updatOpt -split '@'
                if($updatFilesArr[0] -match '.Net FrameWork'){
                    DotNet-Download
                }else{
                    $chkOSTyps=Chk-OSTypes -OSStr $updatFilesArr[1]
                    $chkRegs=Chk-Registry -RegStr $updatFilesArr[2]
                    if($chkOSTyps -and $chkRegs){
                        EG-Download -APPName $updatFilesArr[0] -APPFile $updatFilesArr[3]
                    }
                }
            }
        }
    }
}

$proceedInstal=$False
if($preDwnldHash.Count -ne 0){
    $message = @("Download the below?")
    $message+=" "
    foreach($key in $preDwnldHash.Keys){
    $message+=' -> '+$key
    }
    $res=[system.windows.forms.messagebox]::show(($message -join "`n"),"Download",'YesNo')
    if($res -eq 'Yes'){
        foreach($key in $preDwnldHash.Keys){
            Proceed-Download -APPName $key -APPFile $preDwnldHash[$key]
        } 
        $proceedInstal=$true    
    }else{
        Write-Host 'u have cancelled the download ....'
    }
}else{
    $msg = @("Downloads available in")
    $msg+=$DownloadLocation
    $msg+=" "
    $msg+="Proceed with installation?"
    $procdIns=[system.windows.forms.messagebox]::show(($msg -join "`n"),"Download",'YesNo')
    if($procdIns -eq 'Yes'){
        $proceedInstal=$true
    }else{
        Write-Host 'u have cancelled to proceed installation ....'
    }
}

if($proceedInstal){
    if($installHash.Count -ne 0){
        $insMsg=@("Install the below?")
        $insMsg+=" "
        foreach($key in $installHash.Keys){
            $insMsg+=' -> '+$installHash[$key]
        }
        $insRes=[system.windows.forms.messagebox]::show(($insMsg -join "`n"),"Installation",'YesNo')
        if($insRes -eq 'Yes'){
            foreach($key in $installHash.Keys){
            Try{
                Write-Host $installHash[$key]' Installation Started' -ForegroundColor Yellow
                O365-WriteLog -writString 'Installation started' -LogPath $logFile -ReportingName $installHash[$key]
                Start-Process $key -Wait -ErrorAction Stop
                Write-Host $installHash[$key]' Installation process completed' -ForegroundColor Yellow
                O365-WriteLog -writString 'Installation process completed' -LogPath $logFile -ReportingName $installHash[$key]
            }Catch{
                Write-Host 'Installation failed' -ForegroundColor Red
                O365-WriteLog -writString 'Installation process not completed or failed' -LogPath $logFile -ReportingName $installHash[$key]
            }  
        }     
        }else{
            Write-Host 'u have cancelled the installation ....'
        }
    }else{
       [system.windows.forms.messagebox]::show("All Prerequisites are in place","Installation",'Ok')
    }
}


#TESTING
#-------
Write-Host 'Testing ............'
O365-WriteLog -writString 'Testing started ' -LogPath $logFile -ReportingName 'Testing'
#DOTNET
if ($sysType -match '64-bit'){
        $dotNetVerArr =Get-INIContent -subject 'DotNet' -appNam 'Dotnet_64' 
}
if($sysType -match '32-bit'){
    $dotNetVerArr =Get-INIContent -subject 'DotNet' -appNam 'Dotnet_32' 
}
$dotNetArr=$dotNetVerArr -split '~'
foreach($element in $dotNetArr){
    $valArr=$element -split '@'
    $currVer=Get-DotNetVer
    $dotNetInsVer=[int]$valArr[2]
    if($currVer -ge $dotNetInsVer){
        Write-Host $valArr[0] '- installed sucessfully'
        O365-WriteLog -writString '- installed sucessfully' -LogPath $logFile -ReportingName $valArr[0]
    }else{
        Write-Host $valArr[0] '- not installed properly'
        O365-WriteLog -writString '- not installed properly' -LogPath $logFile -ReportingName $valArr[0]
    }
}
#WMF
if((Get-Host).Version.Major -ge 5 -and (Get-Host).Version.Minor -ge 1){
    Write-Host 'WMF 5.1 - installed sucessfully'
    O365-WriteLog -writString '- installed sucessfully' -LogPath $logFile -ReportingName 'WMF 5.1'
}else{
    Write-Host 'WMF 5.1 - not installed properly'
    O365-WriteLog -writString '- not installed properly' -LogPath $logFile -ReportingName 'WMF 5.1'
}
#UPDATES
foreach($upOpt in $updatOptions.Values){
    if($chkBxStr -match $upOpt){
        if($sysType -match '64-bit'){
            $cntNam='Update_'+$upOpt+'_64'
            $updatOptArr =Get-INIContent -subject 'Updates' -appNam $cntNam 
        }
        if($sysType -match '32-bit'){
            $cntNam='Update_'+$upOpt+'_32'
            $updatOptArr =Get-INIContent -subject 'Updates' -appNam $cntNam 
        }
        $updatOpts=$updatOptArr -split '~'
        foreach($updatOpt in $updatOpts){
            $updatFilesArr=$updatOpt -split '@'
            if($updatFilesArr[0] -match '.Net FrameWork'){
                $currVer=Get-DotNetVer
                $dotNetInsVer=[int]$updatFilesArr[2]
                if($currVer -ge $dotNetInsVer){
                    Write-Host $valArr[0] '- installed sucessfully'
                    O365-WriteLog -writString '- installed sucessfully' -LogPath $logFile -ReportingName $valArr[0]
                }else{
                    Write-Host $valArr[0] '- not installed properly'
                    O365-WriteLog -writString '- not installed properly' -LogPath $logFile -ReportingName $valArr[0]
                }
            }else{  
                $chkRegs=Chk-Registry -RegStr $updatFilesArr[2]
                if(!$chkRegs){
                    Write-Host $updatFilesArr[0] '- installed sucessfully'
                    O365-WriteLog -writString '- installed sucessfully' -LogPath $logFile -ReportingName $updatFilesArr[0]
                }else{
                    Write-Host $updatFilesArr[0] '- not installed properly'
                    O365-WriteLog -writString '- not installed properly' -LogPath $logFile -ReportingName $updatFilesArr[0]
                }
            }
        }
    }
}
O365-WriteLog -writString '**************************************************************************' -LogPath $logFile -ReportingName 'END'
#END
# SIG # Begin signature block
# MIIldgYJKoZIhvcNAQcCoIIlZzCCJWMCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUbCUd/qZUW4U+fPrOzOyLYhiP
# OzSggh6cMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFsTCC
# BJmgAwIBAgIQASQK+x44C4oW8UtxnfTTwDANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwNjA5MDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBXjCCAVowDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHkGCCsGAQUF
# BwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMG
# CCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
# c3N1cmVkSURSb290Q0EuY3J0MEUGA1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwIAYDVR0g
# BBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0GCSqGSIb3DQEBDAUAA4IBAQCa
# FgKlAe+B+w20WLJ4ragjGdlzN9pgnlHXy/gvQLmjH3xATjM+kDzniQF1hehiex1W
# 4HG63l7GN7x5XGIATfhJelFNBjLzxdIAKicg6okuFTngLD74dXwsgkFhNQ8j0O01
# ldKIlSlDy+CmWBB8U46fRckgNxTA7Rm6fnc50lSWx6YR3zQz9nVSQkscnY2W1ZVs
# RxIUJF8mQfoaRr3esOWRRwOsGAjLy9tmiX8rnGW/vjdOvi3znUrDzMxHXsiVla3R
# y7sqBiD5P3LqNutFcpJ6KXsUAzz7TdZIcXoQEYoIdM1sGwRc0oqVA3ZRUFPWLvdK
# RsOuECxxTLCHtic3RGBEMIIGMzCCBRugAwIBAgIQCJp0nrgtw+wn6mXq2/g1MTAN
# BgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQg
# SW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2Vy
# dCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4XDTIxMDUyNTAwMDAw
# MFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBK
# ZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMs
# IEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMuMIICIjANBgkqhkiG
# 9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7JDxOs7sySHvaQ3wGR
# 2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJIk0AZXDTMvXr/mEvm
# KxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+f9I4EgTo9OcdVeIN
# XhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuKifgxL2i8d5FDzkhZ
# SZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZyyaRURtlx11pYfJ/K
# NYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgRADe3/k0NtiVwJIo0
# ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yKf4kpRFmClYfK5Lst
# GQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3VhN+aV56kR/efo8e
# D81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRvIID/l+yDJogDBpae
# 3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug3F2CVJpNbzb1HmAH
# 6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4KTAg7ROmGkwdLhmXo
# PCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsqCqOl6nEDwGD5LfZl
# dQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAOBgNVHQ8BAf8EBAMC
# B4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1oDOgMYYvaHR0cDov
# L2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5jcmwwNaAzoDGG
# L2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3VyZWQtY3MtZzEuY3Js
# MEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUHAgEWG2h0dHA6Ly93
# d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsGAQUFBwEBBHgwdjAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tME4GCCsGAQUFBzAC
# hkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
# ZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQsF
# AAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuChsgkv1PmQpgfypxC
# 3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5NAxDGuIczAIeXOc5k
# RRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9ndCmGSsqcxjG2ud8O6
# Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKRLAUu6IgD6WJKMVfZ
# XWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwoevxbIWh0SenZOUrA
# q9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQICEAc2N7ckVHzYR6z9
# KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERp
# Z2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMY
# RGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAwMDAwMFoXDTM3MDMy
# MjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRp
# bWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMaG
# NQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2EaFEFUJfpIjzaPp9
# 85yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuAhIoiGN/r2j3EF3+r
# GSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQh0YAe9tEQYncfGpX
# evA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7LeSn3O9TkSZ+8OpWNs
# 5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw54qVI1vCwMROpVymW
# Jy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP29p7mO1vsgd4iFNmC
# KseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjFKfPKqpZzQmiftkaz
# nTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHtQr8FnGZJUlD0UfM2
# SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpYPtMDiP6zj9NeS3YS
# UZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4JduyrXUZ14mCjWAkB
# KAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGjggFdMIIBWTASBgNV
# HRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2mi91jGogj57IbzAf
# BgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNVHQ8BAf8EBAMCAYYw
# EwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBpMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUHMAKGNWh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3J0MEMG
# A1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG
# /WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIBfmbW2CFC4bAYLhBN
# E88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb122H+oQgJTQxZ822
# EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+rT4osequFzUNf7WC2
# qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQsl3p/yhUifDVinF2
# ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsKRcnfxI2g55j7+6ad
# cq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKnN36TU6w7HQhJD5TN
# OXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSereU0cZLXJmvkOHOr
# pgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no8Zhf+yvYfvJGnXUs
# HicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcWoWa63VXAOimGsJig
# K+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInwAM1dwvnQI38AC+R2
# AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7qS9EFUrnEw4d2zc4
# GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhNhpedMA0GCSqGSIb3
# DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7
# MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1l
# U3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQsw
# CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG0Rp
# Z2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx5DxArvurxON4XX5c
# Nur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJx
# bKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFqRUIjQVr4YNNlLD5+
# Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJHGVvimC6P0Mo//8Zn
# zzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHVGBS3BEXz4Di9or16
# cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vICNEyu4P6IzzZ/9KM
# u/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03ShL7BU
# dsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2xwafEDsTvQD4ZOgLU
# MalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiay
# CDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2QT3nr6caKMmtYbCg
# QRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGj
# ggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNVHSUBAf8E
# DDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEw
# HwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYEFI1kt4kh
# /lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRp
# Z2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3Rh
# bXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzABhhhodHRw
# Oi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNlcnRz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1l
# U3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk
# 9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4qOVo5TtiEWaW8G5iq
# 6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJ
# T4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8y/pc9+RTv24KfH7X
# 3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEip
# tucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiLfmSiZZQR+24y8fW7
# OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp43UZ3Lht6wDOK+Eoo
# jBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pIallDrl/q+A8GQp3f
# BmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVrNQ6F1uAszOAMJLh8
# UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBFThIcFClYzG/Tf8u+
# wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdjOEcXW28T2moQbh9J
# t0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmlu
# ZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYBBAGCNwIB
# DDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
# MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFI9hdrKXzjzrIp3AI65Dk1uo
# M/a/MA0GCSqGSIb3DQEBAQUABIICAKG2A3cVqble87JLKBWyIdNOlk9PLNiShCIU
# f3D2zGBLucZ5cQiHHH9tgSISK94HK/MAibie+FQDqK8PLbRRGjIoXKHFTTFCYz+8
# KdCyEGJoJLrz8fVX61WvgtOvQ5/rlH5ejTLuwUlRWnTbBssjOdWJgrFTzc/LX85w
# 0Kwz8xrP59ecjiYlUGWfsgrf4gHIUA2TMuFAUDP3bziFlImjRlPkHY7EH3a7bDp7
# RH/xg3AXWCaaZcBLefK9hq3TBkSkPnvR+Wlg22Ac7ujKsW3y3hueWMONNKoYRkXN
# 1q9Thtcem8WVQqEHvaT5xZqXdmQLnMCuRyQwI92ZbNUQ1OEPpwWXa/FStc6rJ3UJ
# RlNkLPs5JOSWFI32CP4fiY8+KNHTM6X6t2psj8MaG/WeKFXiOzks67paotDLpEQa
# zw9plun+weXZhTHS3K52QosBdPLrxvn2EWlX/ZU6Rg7axmTN9QfwjBGibR8Tg0io
# CqZ0dxcPc8Ja1476pdIg2OuRvD78FzOxsX9VWdKHvE7xUOXKyK05iSkSsmt3WlQA
# Krc+Yw2HeIm6Bnq2s8knSARetPCDcmgn0GFPdNu7kxu5u67CwH+91gQn9wT9Mnu1
# hEAocbjCO7b6c24+3UMxYgsO7X6s8vpw/FlSRzGrajTv9SADv0gpZ9PAMlCuqomu
# GcjG30f+oYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzELMAkGA1UE
# BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2Vy
# dCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQCnpK
# iJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJAzELBgkq
# hkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDcxMTEzMTEyNVowLwYJKoZIhvcN
# AQkEMSIEINK7Kcgh3byJ04JzQpyZgOq8rM5Csh3xbSY06SKFtI92MA0GCSqGSIb3
# DQEBAQUABIICACKT6dfr8aJ1VbwT3GOM09u8Epo4G92lioT1o8fd2CFrn18OWlGk
# OWkw+ANd1EoE+Rua9G7EUGF5GKcHuzy2nztylt23OiS5ZCS0REVLtFB0RwKR6mAO
# RHkRRu22GyD3nu2h8TaE3XXJrg3woJ5NwLjXtuFs28kmSAJzvEucPPXo/s4sSV3h
# 6v6n7ZwUyqA+J/yP64HKubndfA7NYKQWSuGE9KtFS4sLQN25LlxJCCuFpYCH6AeX
# v84iOqdfnCr5Y8CiFWmaBLVAhozdn26QS8Ginh24t4G7t34ufZxr+rIWjSuFqBaM
# PQu//dmlyu8KyPWLULGMGHC/3R3wui0iab6IqnP74gVmcdqqdGOUVUICW3ABmsLP
# ZWvoMZCeIYUnCx7RxOH6WA+YWfNQH0ccsd4Q8WplLZ1+PMCF2VOQ9lNt37kMw+wm
# nsQE90MG4ACT/eEGsoVFduQPFbIiAs3mc+UVjE5lgdXtB2+3d+lonGMcQXTSwfui
# SBJ+gqEC/Vr4QRAoub2nNeSwI7jp0+KIRsuGDj8r+2pqJx9OoigHno53czrXm43x
# x0AvJFxa3vQ7gBOnUGriSKkoY4zToj7B+eJMA1cD/VSMNLXDN5za+4kyMAHFQjLm
# yzC+NV45P3dZ3ZAjIEFq+sGWywtDAYVUenDWLxAOoLkdzpsex11njCYW
# SIG # End signature block
