﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

$OpenWebPartDD = @{}
$OpenWebPartTypeCount = @{}
$OpenWebPartsCount = @{}
$CloseWebPartsCount = @{}
$SPWebApps = Get-SPWebApplication

foreach ($SPWebApp in $SPWebApps)
{
    foreach ($SPSite in $SPWebApp.Sites)
    {

    #Get all Webs
    $webs = Get-SPSite $SPSite.URL| Get-SPWeb -Limit All 
     
    #Iterate through webs
            foreach ($web in $webs) 
            {
            #Get All Pages from site's Root into $AllPages Array
            $AllPages = @($web.Files | Where-Object {$_.Name -match ".aspx"})
 
            #Search All Folders for Pages
            foreach ($folder in $web.Folders)
                {
                   #Add the pages to $AllPages Array
                   $AllPages += @($folder.Files | Where-Object {$_.Name -match ".aspx"})
                }
  
             #Iterate through all pages
             foreach($Page in $AllPages)
              {
                 $webPartManager = $web.GetLimitedWebPartManager($Page.ServerRelativeUrl, [System.Web.UI.WebControls.WebParts.PersonalizationScope]::Shared)
  
    
                 # Array to Hold all Web Parts 
               
                            foreach ($webPart in $webPartManager.WebParts)
                            {

                             $WEBAPPNAME=$SPWebApp.name
                             $SITEURL=$($web.site.Url)
                             $RELATIVEURL=$($Page.ServerRelativeUrl)
                             $TITLE=$webpart.Title
                             $ISCLOSED=$($webpart.IsClosed).ToString()
                             $TYPE=$($webpart.GetType().ToString())
                              
                             if( ($WEBAPPNAME.Length -eq 0) -or ($WEBAPPNAME -eq $null) )
                             {
                                $WEBAPPNAME="-"
                             }

                             if( ($SITEURL.Length -eq 0) -or ($SITEURL -eq $null) )
                             {
                                $SITEURL="-"
                             }

                             if( ($RELATIVEURL.Length -eq 0) -or ($RELATIVEURL -eq $null) )
                             {
                                $RELATIVEURL="-"
                             }
                              
                             if( ($TITLE.Length -eq 0) -or ($TITLE -eq $null) )
                             {
                                $TITLE="-"
                             }

                             if( ($ISCLOSED.Length -eq 0) -or ($ISCLOSED -eq $null) )
                             {
                                $ISCLOSED="-"
                             }

                             if( ($TYPE.Length -eq 0) -or ($TYPE -eq $null) )
                             {
                                $TYPE="-"
                             }

                             
                             #The below "IF" condition is to validate the OPEN WEB PARTS.

                                    if($ISCLOSED -eq "False")
                                    { 
                                       
                                       # To count the open web parts per web app
                                       # Web Application as Key and Count of open webparts as Value in HashMap, so we take the measure from "$OpenWebPartsCount" HashMap for Measure count.
                                       if($OpenWebPartsCount.ContainsKey($WEBAPPNAME))
                                       {
                                            $integer=$OpenWebPartsCount.Get_Item($WEBAPPNAME)
                                            $a = $integer -as [int]
                                            $a=$a+1
                                            $OpenWebPartsCount.Set_Item($WEBAPPNAME, $a)

                                       }
                                       else
                                       {
                                            $newOpenCount=1
                                            $OpenWebPartsCount.Add($WEBAPPNAME, $newOpenCount)

                                       }

                                       # To sort the top 10 open web parts DD based on higher number of webparts per page
                                       <#

                                       # Here the below logic to sort open web parts based upon highest number of Open webparts per page.
                                       # HashMap "$OpenWebPartDD" takes the Web Application as key and HashMap as value.
                                       # Inner HashMap takes PAGE URL as key and count of web parts per PAGE as value
                                       
                                       #>
                                        $URL=$SITEURL+$RELATIVEURL
                                       
                                            if($OpenWebPartDD.ContainsKey($WEBAPPNAME))
                                            {
                                                
                                                $hasURL=$OpenWebPartDD.Get_Item($WEBAPPNAME)

                                                if($hasURL.ContainsKey($URL))
                                                {
                                                    $integer=$hasURL.Get_Item($URL)
                                                    $b = $integer -as [int]
                                                    $b=$b+1
                                                    $hasURL.Set_Item($URL, $b)
                                                }
                                                else
                                                {
                                                    $new=1
                                                    $hasURL.Add($URL, $new)
                                                }

                                                
                                              
                                            }
                                            else
                                            {
                                                $new=1
                                                $OpenWebPartURL = @{}
                                                $OpenWebPartURL.Add($URL, $new)
                                                $OpenWebPartDD.Add($WEBAPPNAME, $OpenWebPartURL)
                                            }
                                                  
                                                  
                                           # To count the total number of web parts type per page   
                                           <#

                                           # Here the below logic to get TYPES of Open webparts per page.
                                           # HashMap "$OpenWebPartTypeCount" takes the Web Application as key and HashMap as value.
                                           # Inner HashMap takes PAGE URL as key and ArrayList as value.
                                           # ArrayList take the types of webParts as the element.
                                                # If the page that has similar webpart type we are not adding it to ArrayList.
                                                # If the page that has different webpart type we are adding it to ArrayList, so later we get the size of the Arraylist as the TYPE of WebPart TYPE.
                                            #>                                    
                                           if($OpenWebPartTypeCount.ContainsKey($WEBAPPNAME))         
                                           {
                                               
                                                $UniqueWebPartsURL=$OpenWebPartTypeCount.Get_Item($WEBAPPNAME)

                                                if($UniqueWebPartsURL.Contains($URL))
                                                {
                                                    $UniqueWebParts=$UniqueWebPartsURL.Get_Item($URL)
                                                    if(!$UniqueWebParts.Contains($TYPE))
                                                    {
                                                        $UniqueWebParts.add($TYPE)
                                                    }

                                                }
                                                else
                                                {
                                                    $newArrayList = New-Object System.Collections.ArrayList
                                                    $newArrayList.Add($TYPE)
                                                    $UniqueWebPartsURL.Add($URL, $newArrayList)
                                                }
                                                                                 
                                           }
                                           else
                                           {

                                                    
                                                $newArrayList = New-Object System.Collections.ArrayList
                                                $newArrayList.Add($TYPE)
                                                $newOpenWebPartURL = @{}
                                                $newOpenWebPartURL.Add($URL, $newArrayList)
                                                $OpenWebPartTypeCount.Add($WEBAPPNAME, $newOpenWebPartURL) 
                                           }  

                                    }
                                    else
                                    {

                                        # To count the Closed web parts per web app
                                       if($CloseWebPartsCount.ContainsKey($WEBAPPNAME))
                                       {
                                            $integer=$CloseWebPartsCount.Get_Item($WEBAPPNAME)
                                            $c = $integer -as [int]
                                            $c=$c+1
                                            $CloseWebPartsCount.Set_Item($WEBAPPNAME, $c)

                                       }
                                       else
                                       {
                                            $newCloseCount=1
                                            $CloseWebPartsCount.Add($WEBAPPNAME, $newCloseCount)

                                       }

                                         Write-Host "CLOSE WEB PART DD="$WEBAPPNAME!$SITEURL$RELATIVEURL!$TITLE!$TYPE

                                    }
                           
                             
                            }

                }
                   $web.Dispose();
             }

            $SPSite.Dispose();
        }
    }

     

    foreach ($h in $OpenWebPartsCount.GetEnumerator()) 
    {
        $keys=($h.Name).ToString()
        $values=($h.Value).ToString()
        Write-Host "OPEN WEB PART MCount="$keys!$values
    }

    foreach ($h in $CloseWebPartsCount.GetEnumerator()) 
    {
        $keys=($h.Name).ToString()
        $values=($h.Value).ToString()
        Write-Host "CLOSE WEB PART MCount="$keys!$values
    }

    foreach ($h in $OpenWebPartDD.GetEnumerator()) 
    {
        $WebAPP=($h.Name).ToString()
        $WebAPPasKEY=($h.Value)
        $TYPEcountHeader=$OpenWebPartTypeCount.Get_Item($WebAPP)
        foreach( $i in $WebAPPasKEY.GetEnumerator() | Sort-Object Value -descending| select -First 10)
        {
            $URLs=$i.Name
            $counts=$i.Value
            $webPartType=$TYPEcountHeader.Get_Item($URLs)
            Write-Host "OPEN WEB PART DD="$WebAPP!$URLs!$($webPartType.Count)!$counts
        }
        
    }



# SIG # Begin signature block
# MIIbjAYJKoZIhvcNAQcCoIIbfTCCG3kCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQURYFUHD8OiM0XzdSVSQGUltfM
# 9ZCgghWiMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUx
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAw
# MDAwWhcNMjQwNTI5MjM1OTU5WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDf
# AZHYpsPdplqB5IT6QbS0qQSxDidrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+Y
# S+YrEJuIkVMKkqSZnixrkFl87uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V
# 4g1eGBDbFnpOMQr6luGqZVe+vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPO
# SFlJl90K0a0S8Tmkt6xdJZ+nNR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8
# n8o1gCRQIvbeueHfz+ZrG1K916KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAk
# ijRkSxTIMA2nskgiMx4/Ow4xjN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rk
# uy0ZBE1s42OmwIFMSBm7AR+R05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+
# jx4PzUTlUNCqYmIZYqr+z2OFuRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMG
# lp7fHai/li+NjxmjxEXS1e/JLSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUe
# YAfqTTIUeZZgKhQA1sEHRhH+Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uG
# Zeg8IFyjQQIDAQABo4IBxDCCAcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt
# 9mV1DlgwHQYDVR0OBBYEFPnIRJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQE
# AwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOg
# MYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5j
# cmwwSwYDVR0gBEQwQjA2BglghkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUH
# MAKGQmh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1
# cmVkSURDb2RlU2lnbmluZ0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEB
# CwUAA4IBAQCUCOdwU+8srLBP/gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/K
# nELeD4StX3JFXz5ddILA5oone/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5
# zmRFGm8WxDZdI20ztcvW0sObqn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53
# w7pWG170nktocFWTeUhkAy0foAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkox
# V9ldaXJ8Px1navd6PpDW4A781u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5
# SsCr29MlpK8UxK9y2Qmb+jEtRxR0QZLfMYIFVDCCBVACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFG5iSNPYn57aTNli
# RggJzjfUSn0qMA0GCSqGSIb3DQEBAQUABIICAGehkgqlUjzW966fqhyB+E3LL64D
# yx6o+3HNQggPxXUhwOdoSMHOVshmP52G/2Zk5QbsWUc2XcBVaNdhZ4wWJWpdFc+J
# QwQhkp72E49AuzzlzRFlJ6/d19tPJ/lAPtC1R1qyy9rLcpaQIARd3Zr+gIzownS1
# jAxmbbV//7iIfqVHhvDbJreWZnxCBDmLOFPtQcDM8Nnj/xWJcDTyo+VpmXW6MeqY
# p9XMVK1sle3p4/H7sR+OYgZYZb3msJCEeaK76BFAG2mEOleFhMtHBhrntaUTWLQA
# WyfCAn5tW9Iio0B5FOuyIqQHCC+GCOXbSSveZs2hIEYeUR4APyXHLn7DZhQG6xT8
# /aSmF3n9OCF1PWGj7ZUtAjcNDYorUbcEMY4+lJOGl5qI4F2HNJHQeZDWfht94lFL
# rRL/6WcY375feQBawK3zyv3eiHoetCuXwq4Ray03qUfQzE+QpPC4tadwiSYF0NaN
# Yll94d9AYBGLg8n4xzv+MJLdHWgYmKtr9zT+4rl/hEe0SPe48XRPC3spTwT/l86z
# 0E0BTzf7JtLmp3TwhuVx5gOFJEmkN+c3pQfMjkt9Ht2B7CkibYUuJ30/WooOr6dR
# oIZYaSzFN0BVLMXgJcZgd/MGPhaOgjyno9QmypxVBcq7qkfB+bLJ0sPpx6JpvaWq
# zhISUgNVvCNfVdF2oYICMDCCAiwGCSqGSIb3DQEJBjGCAh0wggIZAgEBMIGGMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBUaW1lc3RhbXBpbmcgQ0ECEA1CSuC+Ooj/YEAhzhQA8N0wDQYJYIZIAWUDBAIB
# BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0y
# MTA5MDExMjM2NTFaMC8GCSqGSIb3DQEJBDEiBCBlcWONRfezW69c3JZR5LTK98Zf
# ZUx+W925zaV/ZvGNGzANBgkqhkiG9w0BAQEFAASCAQAkMbtIGDhVutEKlQFBD3Hd
# zKbZN3czf0uMv3Hrg5yCHRANxzT5XGjlmAR41YTEt0msv2Pc5Xw4fCPV4s4BHe2i
# WXwrmsbTl3I4L9YXVUHoMuevETOyvxl0adIcjtSaq/MIyNUOofV6CX/xLJnT0VZK
# JPY0eV5Y0R5t1vVYvjM2t9UIuAk+rkgcodINbvc33gwGVk+/PkVqvQ3Y2i3J5GDH
# rgjPlNQ8RUoxTn51hEKXeGIEzBz99v6zfyLEekjapC4pGn36aND26Ok2CjwZw9Rt
# JEKMjp+vy626ZdEx/ii5C1N8Lq/3ErBp2Jm17oEeTrwIjRoDg/xHGiDHKJ1p8Op1
# SIG # End signature block
