
#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
			
			To get the Sites Information of Active Directory
.DESCRIPTION

			This Script is used to collect the Sites Information of Active Directory
			Measure are:
			1.Site name,
			2.Organizational unit,
			3.IPv4 address,
			4.IPv6 address,
			5.OS type,
			6.Service pack,
			7.SYSVOL replication,
			8.SYSVOL location,
			9.SYSVOL quota
.INPUTS
			CONST_TEST_HDR and delimiter
.OUTPUTS
			Collect the Sites Information measures of Active Directory in following format 
            <siteName><Delimiter><serverName><Delimiter><dcDNName>
            <Delimiter><ipV4><Delimiter><ipv6><Delimiter><OSType>
            <Delimiter><ServicePack><Delimiter><SysVolRep><Delimiter>
            <SysVolLoc><Delimiter><SysVolQuota>
#>

$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False

$global:CONST_TEST_HDR = $args[0]
$global:CONST_TEST_END = $args[1]
$global:delimiter = $args[2]


import-module ActiveDirectory

Clear-Host

#To get Site information Details of Active Directory

Function getADConfigSiteInfo
{
			
    $Forest = Get-ADForest -Current LocalComputer
    $rootDomain = $Forest.RootDomain
	$ConfigurationPart = ($Forest.PartitionsContainer -Replace "CN=Partitions,","")
	$AllSites = Get-ADObject -Server $rootDomain -Filter { objectClass -eq "site" } -SearchBase $ConfigurationPart -Properties *
	foreach ( $Site in $AllSites )
	{
		$siteName = $Site.Name
		$ServersInSite = Get-ADObject -Server $rootDomain -Filter { objectClass -eq "server" } -SearchBase $Site.distinguishedName -SearchScope Subtree -Properties Name | Select Name | Sort-Object Name
		foreach ($Server in $ServersInSite)
		{
            $dcDetails = $null
			if ( $Server -ne $null )
			{
                try
                {
			        $dcDetails = Get-ADDomainController $Server.Name                
                }
                catch
                {
                    $dcDetails = $null
                }


				if ( $dcDetails -ne $null )
				{
					$dcDN = $dcDetails.ComputerObjectDN -Replace $dcDetails.Name,""
					$dcDN = $dcDN -Replace "CN=,",""
					$dcFRS = "CN=Domain System Volume (SYSVOL share),CN=NTFRS Subscriptions,$($dcdetails.computerobjectdn)"
					$dcDFSR = "CN=SYSVOL Subscription,CN=Domain System Volume,CN=DFSR-LocalSettings,$($dcdetails.computerobjectdn)"
					$dcFRSinfo = Get-ADObject -Filter { distinguishedName -eq $dcFRS } -Properties fRSRootPath
					$dcDFSRinfo = Get-ADObject -Filter { distinguishedName -eq $dcDFSR } -Properties msDFSR-RootPath, msDFSR-RootSizeInMb
					$serverName = $Server.Name
					$dcDNName = $dcDN
					$ipV4 = $dcDetails.ipv4address
					if ($ipV4 -eq $null)
					{
						$ipV4 = "None"
					}
					$ipv6 = $dcDetails.ipv6address
					if ($ipv6 -eq $null)
					{
						$ipv6 = "None"
					}
					$OSType = $dcDetails.operatingSystem
					if ($OSType -eq $null)
					{
						$OSType = "-"
					}
					$ServicePack = $dcDetails.operatingSystemServicePack
					if ($ServicePack -eq $null)
					{
						$ServicePack = "-"
					}
					$SysVolRep = "-"
					$SysVolLoc = "-"
					if ($dcFRSinfo -ne $null)
					{
						$SysVolRep = "FRS"
						$SysVolLoc = $dcFRSinfo.fRSRootPath.toUpper()
					}
					if ($dcDFSRinfo -ne $null)
					{
						$SysVolRep = "DFS-R"
						$SysVolLoc = $dcDFSRinfo."msDFSR-RootPath".toUpper()
					}
					if ($dcDFSRinfo."msDFSR-RootSizeInMb" -ne $null)
					{
						Write-Host($siteName,$dcName,$ipV4,$ipv6,$OSType,$ServicePack,$SysVolRep,$SysVolLoc,$dcDFSRinfo."msDFSR-RootSizeInMb") -Separator $global:delimiter
					}
					else
					{
						$SysVolQuota = "4GB (default setting)"
						Write-Host($siteName,$serverName,$dcDNName,$ipV4,$ipv6,$OSType,$ServicePack,$SysVolRep,$SysVolLoc,$SysVolQuota) -Separator $global:delimiter
					}
				}
			}
		}
	}
}

#Main Region Starts
try
{

   	Write-Host $global:CONST_TEST_HDR
	Write-Host "-------------------------"
   
    getADConfigSiteInfo
}
catch [Exception]
{
	$global:isErrorOccured = $True
	Write-Verbose "Catch block executed and following Exception is occured : " $_.Exception.GetType().FullName, $_.Exception.Message
}

If($global:isErrorOccured -eq $False)
{
	Write-Host $global:CONST_TEST_END
}
#Main Region Ends

	