﻿# Script starts
Add-PSSnapin Citrix.XenApp.Commands
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ConfigurationLogging = Get-XAConfigurationLog -EA 0
Write-Host "#====Configuration logging starts====#"
if($?)
{
	If ($ConfigurationLogging.LoggingEnabled )
	{
		Write-Host "Configuration logging enabled: Yes"
		Write-Host "Allow changes while disconnected: " $ConfigurationLogging.ChangesWhileDisconnectedAllowed
		Write-Host "Require credentials to clear log: " $ConfigurationLogging.CredentialsOnClearLogRequired
		Write-Host "Database type: " $ConfigurationLogging.DatabaseType
		Write-Host "Authentication mode: " $ConfigurationLogging.AuthenticationMode
		Write-Host "Connection String: " $ConfigurationLogging.ConnectionString
		Write-Host "User name: " $ConfigurationLogging.UserName
	}
	Else
	{
		Write-Host "Configuration logging enabled: No"
	}
}
Else 
{
	Write-Host "Configuration logging enabled: No"
}
Write-Host "#====Configuration logging ends====#"
Write-Host "#EG_SCRIPT_DONE#"
Remove-PSSnapin Citrix.XenApp.Commands