﻿Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$hostname = $env:COMPUTERNAME
$server = Get-XAServer -ServerName $hostname
Write-Host "#Server - start"
if ($?)
{
	Write-Host "#Server details - start"
	Write-Host "Name  : " $server.ServerName
	Write-Host "Server FQDN: " $server.ServerFqdn
	Write-Host "IP Address : " $server.IPAddresses
	Write-Host "Product Name : " $server.CitrixProductName ", " $server.CitrixEdition " Edition"
	Write-Host "Service Pack : " $server.CitrixServicePack
	Write-Host "Version : " $server.CitrixVersion
	Write-Host "Product Installed Date : " $server.CitrixInstallDate
	Write-Host "Product Installation Path: " $server.CitrixInstallPath
	If($server.Is64Bit)
	{
		Write-Host "Operating System Type: 64 bit"
	}
	else
	{
		Write-Host "Operating System Type: 32 bit"
	}
	If($server.LogOnsEnabled)
	{
		Write-Host "Logons : Enabled"
	}
	else
	{
		Write-Host "Logons : Disabled"
	}
	Write-Host "Logon Control Mode: " $Server.LogOnMode
	Write-Host "Operating System Version: " $server.OSVersion " " $server.OSServicePack
	Write-Host "Zone: " $server.ZoneName
	Write-Host "Election Preference: " $server.ElectionPreference
	Write-Host "Folder: " $server.FolderPath
	If($server.LicenseServerName)
	{
		Write-Host "License Server Name: " $server.LicenseServerName
		Write-Host "License Server Port: " $server.LicenseServerPortNumber
	}
	else
	{
		Write-Host "License Server Name: -"
		Write-Host "License Server Port: -"	
	}
	If($server.ICAPortNumber -gt 0)
	{
		Write-Host "ICA Port Number: " $server.ICAPortNumber
	}
	If($server.RDPPortNumber -gt 0)
	{
		Write-Host "RDP Port Number: " $server.RDPPortNumber
	}
	if($server.IsSpoolerHealthy)
	{
		Write-Host "Is the Print Spooler on this server healthy: Yes"
	}
	else
	{
		Write-Host "Is the Print Spooler on this server healthy: -"
	}
	Write-Host "Power Management Control Mode: " $server.PcmMode
	Write-Host "#Server details - end"
	Write-Host  "#Hot fixes - start"
	$hotfixes = Get-XAServerHotfix -ServerName $hostname -EA 0 | Sort-Object HotfixName 
	if($hotfixes)
	{
		foreach($hotfix in $hotfixes)
		{
			Write-Host "Hotfix Name : " $hotfix.HotfixName
			Write-Host "Installed By : " $hotfix.InstalledBy
			Write-Host "Hotfix Installed on : " $hotfix.InstalledOn
			Write-Host "Hotfix type : " $hotfix.HotfixType
			Write-Host "Valid : " $hotfix.Valid
			Write-Host "Hotfix replaced : " $hotfix.HotfixesReplaced
		}
	}	
	Write-Host "#Hot fixes - end"
}
Write-Host
Write-Host "#Server - end"
Remove-PSSnapin Citrix.XenApp.Commands

