﻿$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Dns = Get-DnsClientGlobalSetting
if ($Dns -ne $null)
{
	$SearchList = $Dns.SuffixSearchList
	if ($SearchList -ne $null -and $SearchList.Count -gt 0)
	{
		$Count = 0
		$AllSuffix = ""
		foreach ($Search in $SearchList)
		{
			if ($Count -eq 0)
			{
				$AllSuffix = $Search
			}
			else
			{
				$AllSuffix = $AllSuffix + "#" + $Search
			}
			$Count = $Count + 1
		}
		Write-Host "DNSSuffixSearchList="$AllSuffix
	}
}


