﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides Exchange Users Mail App Usage
    Created           :       18/07/2020    
    /*****************************************************************************
#>
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$readingdate=[datetime]$TestInputs[5]
$rptNam=$TestInputs[6]
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($proxyUser.toString().toLower().Trim() -eq 'none') { $proxyUser=$proxyUser.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserver.toString().toLower().Trim().Contains('none')) { $proxyserver=$proxyserver.toString().toLower().Trim() }
if(!$proxyserver.Contains('none')){
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUser -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUser, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$toReadDat=$readingdate.tostring(“yyyy-MM-dd”)
$rptPath=$egurkhaPath+'\agent\EXO\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$o365Domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

$appId=''
$appSecret=''
$tenantID=''
$authString=''
$resource=''
$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

#------Get App Reg Details ------------
$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
$kvalue=Get-Content -Path $GraphDir$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
$spoGraphDtls=$GraphDir+"\GraphDetails.ini"
$getInputs=Get-Content -Path $spoGraphDtls
Remove-Item $spoGraphDtls
$flag=$false
foreach($input in $getInputs){
    if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
        $flag=$true
    }
    if($flag){
        if($input.Contains("client_id")){
            $appId=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("client_secret")){
            $appSecret=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("TenantName")){
            $tenantID=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("Authority")){
            $authString=$input.ToString().Substring($input.IndexOf('~')+1)
            $authString=$authString+$o365Domain
        }
        if($input.Contains("Resource")){
            $resource=$input.ToString().Substring($input.IndexOf('~')+1)
            $flag=$false
        }
    }         
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$MailAppUsageCSV=$rptPath+'\MailAppUsage'+$timenow+'.csv'


Eg-InvokeGraphUrl -Url "https://graph.microsoft.com/v1.0/reports/getEmailAppUsageUserDetail(period='D7')" -filePath $MailAppUsageCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource

$TotalMailAppUsage=Import-Csv $MailAppUsageCSV -Encoding $encTyp

$diffence=(NEW-TIMESPAN –Start $readingdate –End (Get-Date) | Select-Object Days).Days

$notFirsttime = $false
while($diffence -ge 1)
{
    if($notFirsttime){ $readingdate=$readingdate.AddDays(1) }
    $actualdate=$readingdate
    $notFirsttime = $true
    $TotalMailAppUsg =$TotalMailAppUsage | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
    if($TotalMailAppUsg)
    {
        Write-Host 'ReadDate for the Date#'$actualdate.tostring(“yyyy-MM-dd”)
        break
    }
    else
    {
        Write-Host 'thereIs No Data on#'$actualdate.tostring(“yyyy-MM-dd”)
    }
    $diffence=$diffence-1
}

foreach($Apps in $TotalMailAppUsg){
#----------------MailForMac ---------------------
if($Apps.MailForMac -eq ""){
    $MailForMac = "0"
}elseif($Apps.MailForMac -eq "Undetermined"){
    $MailForMac = "1"
}else{
    $MailForMac="2"
}
#---------------OutlookForMac---------------------
if($Apps.OutlookForMac -eq ""){
    $OutlookForMac = "0"
}elseif($Apps.OutlookForMac -eq "Undetermined"){
    $OutlookForMac = "1"
}else{
    $OutlookForMac="2"
}
#---------------OutlookForWindows---------------------
if($Apps.OutlookForWindows -eq ""){
    $OutlookForWindows = "0"
}elseif($Apps.OutlookForWindows -eq "Undetermined"){
    $OutlookForWindows = "1"
}else{
    $OutlookForWindows="2"
}
#---------------OutlookForMobile---------------------
if($Apps.OutlookForMobile -eq ""){
    $OutlookForMobile = "0"
}elseif($Apps.OutlookForMobile -eq "Undetermined"){
    $OutlookForMobile = "1"
}else{
    $OutlookForMobile="2"
}
#---------------OtherForMobile---------------------
if($Apps.OtherForMobile -eq ""){
    $OtherForMobile = "0"
}elseif($Apps.OtherForMobile -eq "Undetermined"){
    $OtherForMobile = "1"
}else{
    $OtherForMobile="2"
}
#---------------OutlookForWeb---------------------
if($Apps.OutlookForWeb -eq ""){
    $OutlookForWeb = "0"
}elseif($Apps.OutlookForWeb -eq "Undetermined"){
    $OutlookForWeb = "1"
}else{
    $OutlookForWeb="2"
}
#---------------POP3App---------------------
if($Apps.POP3App -eq ""){
    $POP3App = "0"
}elseif($Apps.POP3App -eq "Undetermined"){
    $POP3App = "1"
}else{
    $POP3App="2"
}
#---------------IMAP4App---------------------
if($Apps.IMAP4App -eq ""){
    $IMAP4App = "0"
}elseif($Apps.IMAP4App -eq "Undetermined"){
    $IMAP4App = "1"
}else{
    $IMAP4App="2"
}
#---------------SMTPApp---------------------
if($Apps.SMTPApp -eq ""){
    $SMTPApp = "0"
}elseif($Apps.SMTPApp -eq "Undetermined"){
    $SMTPApp = "1"
}else{
    $SMTPApp="2"
}

$MailAppUsage=$Apps.UserPrincipalName+'~'+$MailForMac+'~'+$OutlookForMac+'~'+$OutlookForWindows+'~'+$OutlookForMobile+'~'+$OtherForMobile+'~'+$OutlookForWeb+'~'+$POP3App+'~'+$IMAP4App+'~'+$SMTPApp
Write-Host 'MailAppUsage='$MailAppUsage
}
if([System.IO.File]::Exists($MailAppUsageCSV) -eq 'True'){
    Remove-Item $MailAppUsageCSV
}
