$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Import-Module FailoverClusters -EA SilentlyContinue
$Global:ErrorActionPreference="SilentlyContinue"

$ClusterName = (Get-Cluster).Name
if ($ClusetName)
{
	$VMs=Get-ClusterGroup-Cluster$ClusterName| where grouptype-eq'virtualmachine'|Get-VM
}
else
{
$VMs=Get-VM
}

$VolumesHash = @{}
$Volumes = Get-Volume
if ($Volumes -ne $null)
{
	foreach($Volume in $Volumes)
	{
		$DriveLetter = $Volume.DriveLetter
		if ($DriveLetter -ne $null)
		{
			$SizeRemaining = [math]::Round($Volume.SizeRemaining/1MB,4)
			$VolumesHash.Add($DriveLetter,$SizeRemaining)
		}
	}
}

if ($VMs -ne $null)
{
	foreach($VM in $VMs)
	{
		$path = $VM.harddrives.path
		if ($path -ne $null)
		{
			foreach ($p in $path)
			{
				$VHDs = Get-VHD$p-ComputerName$VM.computername
				$VMName = $VM.Name
				#$VHDs = Get-VM -VMName $VMName | Select-Object VMID | Get-VHD
				if ($VHDs -ne $null)
				{
					foreach($VHD in $VHDs)
					{
						if ($VHD.vhdType -eq "Dynamic")
						{
							$UsedSize = [math]::Round($VHD.FileSize/1MB,4)
							$TotalSize = [math]::Round($VHD.Size/1MB,4)
							$DiskFreeSize = 0
							foreach($Vol in $VolumesHash.GetEnumerator())
							{
								$DriverLetter = ($($Vol).Name)
								$SizeRemaining = ($($Vol).Value)
								if($p.StartsWith($DriverLetter + ":\"))
								{
									$DiskFreeSize = $SizeRemaining
									Break
								}
							}
							$TotalSize = $TotalSize + $DiskFreeSize
							$TotalSize = [math]::Round($TotalSize,4);
							$Free = $TotalSize - $UsedSize
							$Free = [math]::Round($Free,4);
							$Utilization = ($UsedSize/$TotalSize) * 100.0
							$Utilization = [math]::Round($Utilization,4);
							Write-Host($VMName,$p,$TotalSize,$UsedSize,$Free,$Utilization) -Separator ";"
						}
					}
				}
			}
		}
	}
}


