$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Import-Module -Name WebAdministration

Get-ChildItem -Path IIS:\SSLBindings | ForEach-Object -Process `
{
	if ($_.Sites)
	{
		$SiteName = $_.Sites.Value
		$personalCert = Get-ChildItem -Path CERT:LocalMachine/My | Where-Object -Property Thumbprint -EQ -Value $_.Thumbprint
		if ($personalCert -ne $null)
		{
			if($personalCert.NotAfter -gt (Get-Date))
			{
				$ExpiryDays = ($personalCert.NotAfter).subtract([DateTime]::Now).Days
				Write-Host($SiteName, $personalCert.FriendlyName, $personalCert.DnsNameList,
					   $personalCert.NotAfter, $ExpiryDays, $personalCert.Issuer) -Separator "#~#"
			}
		}
		else
		{
			$webHostingCert = Get-ChildItem -Path CERT:LocalMachine/WebHosting | Where-Object -Property Thumbprint -EQ -Value $_.Thumbprint
			if ($webHostingCert -ne $null)
			{
				if($webHostingCert.NotAfter -gt (Get-Date))
				{
					$ExpiryDays = ($webHostingCert.NotAfter).subtract([DateTime]::Now).Days
					Write-Host($SiteName, $webHostingCert.FriendlyName, $webHostingCert.DnsNameList,
						   $webHostingCert.NotAfter, $ExpiryDays, $webHostingCert.Issuer) -Separator "#~#"
				}
			}
		}
	}
}



