'Measures Details 
'Format = Variable name => Measure Name
'v1=>IIS Version
'v2=>Connection timeout
'v3=>Enable HTTP Keep-Alives
'v4=>Enable logging
'v5=>Active log format
'v6=>Use local time for file naming and rollover
'v7=>Log file directory
'v8=>Log schedule
'v9=>Limit the total network bandwidth
'v10=>Maximum bandwidth
'v11=>Maximum connections
'v12=>Enable default content page
'v13=>Default document(s)
'v14=>Cache ISAPI extensions
'v15=>Enable session state
'v16=>Session timeout
'v17=>Enable buffering
'v18=>Enable parent paths
'v19=>Default ASP language
'v20=>ASP script timeout
'v21=>Anonymous access
'v22=>Anonymous user
'v23=>Script source access
'v24=>Read permission
'v25=>Write permission
'v26=>Directory browsing
'v27=>Log visits
'v28=>Index resource
'v29=>Execute permissions
'v30=>Batch compilations
'v31=>Maximum file size
'v32=>Maximum size of batch
'v33=>Time-out(hh:mm:ss)
'v34=>Debug
'v35=>Enable prefetch
'v36=>Enable profiling optimizations
'v37=>Number of recompiles
'v38=>Optimize compilations
'v39=>Url line pragmas
'v40=>Explicit compile option
'v41=>Strict compile option
'v42=>Assemblies
'v43=>Default language
'v44=>Temporary directory
'v45=>Culture
'v46=>Enable client-based culture
'v47=>UI culture
'v48=>File
'v49=>Requests
'v50=>Response headers
'v51=>Responses
'v52=>Name : value
'v53=>Code page
'v54=>Enable chunked encoding
'v55=>Enable html fallback
'v56=>Client connection test interval
'v57=>Maximum  requesting entity body limit
'v58=>Queue length
'v59=>Request queue time-out
'v60=>Response buffering limit
'v61=>Threads per processor limit
'v62=>Local id
'v63=>Restart on config change
'v64=>Calculate line numbers
'v65=>Catch com component exceptions
'v66=>Enable client-side debugging
'v67=>Enable log errors request
'v68=>Enable server-side debugging
'v69=>Log errors to nt log
'v70=>Run on end functions anonymously
'v71=>Script error message
'v72=>Send errors to browser
'v73=>Cache directory path
'v74=>Enable type library caching
'v75=>Maximum  disk cached files
'v76=>Maximum  memory cached files
'v77=>Maximum  script engines cached
'v78=>Enable side by side component
'v79=>Enable tracker
'v80=>Execute in mta
'v81=>Honor component threading model
'v82=>Partition id
'v83=>Side by side component
'v84=>Use partition
'v85=>Maximum  sessions
'v86=>New id on secure connection
'v87=>CGI - Time-out(hh:mm:ss)
'v88=>Use new console for each invocation
'v89=>Impersonate user
'v90=>Name:connectionstring
'v91=>E-mail address
'v92=>Delivery method
'v93=>Smtp server
'v94=>Port
'v95=>Authentication settings
'v96=>Specified credentials - username
'v97=>Pickup directory location
'v98=>Ftp - allowed authorization rule(users : roles : permissions)
'v99=>Ftp - denied authorization rule(users : roles : permissions)
'v100=>Ftp - Data channel port range
'v101=>Ftp - Allowed restriction rules(ip address : range of ip addresses : domain)
'v102=>Ftp - Denied restriction rules(ip address : range of ip addresses : domain)
'v103=>Ftp - Access for unspecified clients
'v104=>Ftp - Enable domain name restrictions
'v105=>Ftp - log enabled
'v106=>Ftp - One log file per
'v107=>Ftp - Directory
'v108=>Ftp - Encoding
'v109=>Ftp - Use local time for file naming and rollover
'v110=>Ftp - Allow unlisted file name extensions
'v111=>Ftp - Allow high bit characters
'v112=>Ftp - Maximum  content length(bytes)
'v113=>Ftp - Maximum  url length(bytes)
'v114=>Ftp - Allowed file name extensions
'v115=>Ftp - Denied file name extensions
'v116=>Ftp - Hidden segments
'v117=>Ftp - Denied url sequence
'v118=>List of net error pages (status code: absolute url)
'v119=>Mode
'v120=>Redirect mode
'v121=>Absolute url
'v122=>Allow nested errors
'v123=>Features-Time
'v123=>Features-Size
'v123=>Features-Extension
'v123=>Features-Date
'v123=>Features-Long date
'v128=>When server encounter an error , return
'v129=>Default page path
'v130=>Path type
'v131=>Http redirect
'v132=>Redirect request to this destination
'v133=>Redirect all requests to exact  destination(instead of relative to destination)
'v134=>Only redirect requests to content in this directory(not subdirectories)
'v135=>Status code
'v136=>List of response headers (name : value)
'v137=>List of mime types(file name extension: mime type)
'v138=>Allow unlisted file name extensions
'v139=>Allow unlisted verbs
'v140=>Allow high bit characters
'v141=>Allow double escaping
'v142=>Maximum  allowed content length(bytes)
'v143=>Maximum  url length(bytes)
'v144=>Maximum  query string (bytes)
'v145=>Allowed file name extensions
'v146=>Denied file name extensions
'v147=>Hidden segments
'v148=>Allow urls
'v149=>Deny urls
'v150=>Allow verbs
'v151=>Deny verbs
'v152=>Header : header size limit
'v153=>Allow query strings
'v154=>Deny query strings
'v155=>List of WebDAV authoring rules (content path : users :roles :permissions)
'v156=>Allow unknown mime types
'v157=>Default mime type
'v158=>Allow locks
'v159=>Lock store
'v160=>Require lock for writing
'v161=>Allow anonymous property queries
'v162=>Allow custom queries
'v163=>Allow property queries with infinite depth
'v164=>Allow hidden files to be listed
'v165=>Allow multiple property sections
'v165=>Return compact xml
'v165=>Return is collection property
'v165=>Return in hidden property
'v165=>Return ms author via header
'v170=>Require ssl access
'v171=>Enable dynamic content compression
'v172=>Enable static content compression
'v173=>Only Compress Files larger than
'v174=>Only Compress Files larger than(in Bytes)
'v175=>Cache Directory
'v176=>Per application pool diskspace limit
'v177=>Per application pool diskspace limit(in MB)
'v178=>Enable cache
'v179=>Enable kernel cache
'v180=>Maximum cache response size(in bytes)
'v181=>Cache size limit(in mb)
'v182=>Trust level
'v183=>Allow authorization rules(Users : Roles : Verbs)
'v184=>Deny authorization rules(Users : Roles : Verbs)
'v185=>Basic authentication
'v186=>Basic authentication domain
'v187=>Basic authentication realm
'v188=>Digest authentication
'v189=>Digest authentication realm
'v190=>Windows authentication
'v191=>Allowed restriction rules(ip address : ip address range :domain)
'v192=>Denied restriction rules(ip address : ip address range :domain)
'v193=>Access for un specified clients
'v194=>Enable domain name restrictions
'v195=>Enable proxy mode
'v196=>Deny action type
'v197=>Deny ip address based on number of requests
'v198=>Maximum number of concurrent requests
'v199=>Deny ip address based on number of requests over a period of time
'v200=>Maximum number of requests
'v201=>Time period(in milli seconds)
'v202=>Enable logging only mode
'v203=>Allow unspecified CGI modules
'v204=>Allow unspecified ISAPI modules
'v205=>List of allowed isapi or cgi restrictions(Description : Path)
'v206=>List of restricted isapi or cgi restrictions(Description : Path)

'Output format

'v1^~^v2^~^v3^~^v4^~^v5^~^v6^~^v7^~^v8^~^v9^~^v10^~^v11^~^v12^~^v13^~^v14^~^v15^~^v16^~^v17^~^v18^~^v19^~^v20^~^v21^~^v22^~^v23^~^v24^~^v25
'^~^v26^~^v27^~^v28^~^v29^~^v30^~^v31^~^v32^~^v33^~^v34^~^v35^~^v36^~^v37^~^v38^~^v39^~^v40^~^v41^~^v42^~^v43^~^v44^~^v45^~^v46^~^v47^~^v48
'^~^v49^~^v50^~^v51^~^v52^~^v53^~^v54^~^v55^~^v56^~^v57^~^v58^~^v59^~^v60^~^v61^~^v62^~^v63^~^v64^~^v65^~^v66^~^v67^~^v68^~^v69^~^v70^~^v71
'^~^v72^~^v73^~^v74^~^v75^~^v76^~^v77^~^v78^~^v79^~^v80^~^v81^~^v82^~^v83^~^v84^~^v85^~^v86^~^v87^~^v88^~^v89^~^v90^~^v91^~^v92^~^v93^~^v94
'^~^v95^~^v96^~^v97^~^v98^~^v99^~^v100^~^v101^~^v102^~^v103^~^v104^~^v105^~^v106^~^v107^~^v108^~^v109^~^v110^~^v111^~^v112^~^v113^~^v114^~^
'v115^~^v116^~^v117^~^v118^~^v119^~^v120^~^v121^~^v122^~^v123^~^v128^~^v129^~^v130^~^v131^~^v132^~^v133^~^v134^~^v135^~^v136^~^v137^~^v138
'^~^v139^~^v140^~^v141^~^v142^~^v143^~^v144^~^v145^~^v146^~^v147^~^v148^~^v149^~^v150^~^v151^~^v152^~^v153^~^v154^~^v155^~^v156^~^v157^~^
'v158^~^v159^~^v160^~^v161^~^v162^~^v163^~^v164^~^v165^~^v170^~^v171^~^v172^~^v173^~^v174^~^v175^~^v176^~^v177^~^v178^~^v179^~^v180^~^v181
'^~^v182^~^v183^~^v184^~^v185^~^v186^~^v187^~^v188^~^v189^~^v190^~^v191^~^v192^~^v193^~^v194^~^v195^~^v196^~^v197^~^v198^~^v199^~^v200^~^v201
'^~^v202^~^v203^~^v204^~^v205^~^v206

CNSTSPRTR =  "^~^"
CNSTHYPEN = "-" 
CNSTCOLON = " : " 
CNSTCOMMA = " , " 
CNSTSTRTTAG = "<=ScriptStarted=>"
CNSTENDTAG = "<=ScriptEnded=>"

Err.Clear

Set webAdmin = GetObject("winmgmts:root\WebAdministration")

WScript.Echo CNSTSTRTTAG

	getIISServerInfo()
	
If(Err.number = 0) then
	WScript.Echo CNSTENDTAG
End If

'===================================================================
'Get IIS Server Details
Function getIISServerInfo()
	
	Dim v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,v16,v17,v18,v19,v20,v21,v22,v23,v24,v25,v26,v27,v28,v29,v30
	Dim v31,v32,v33,v34,v35,v36,v37,v38,v39,v40,v41,v42,v43,v44,v45,v46,v47,v48,v49,v50,v51,v52,v53,v54,v55,v56,v57,v58,v59,v60
	Dim v61,v62,v63,v64,v65,v66,v67,v68,v69,v70,v71,v72,v73,v74,v75,v76,v77,v78,v79,v80,v81,v82,v83,v84,v85,v86,v87,v88,v89,v90
	Dim v91,v92,v93,v94,v95,v96,v97,v98,v99,v100,v101,v102,v103,v104,v105,v106,v107,v108,v109,v110,v111,v112,v113,v114,v115,v116,v117,v118,v119,v120
	Dim v121,v122,v123,v128,v129,v130,v131,v132,v133,v134,v135,v136,v137,v138,v139,v140,v141,v142,v143,v144,v145,v146,v147,v148,v149,v150
	Dim v151,v152,v153,v154,v155,v156,v157,v158,v159,v160,v161,v162,v163,v164,v165,v170,v171,v172,v173,v174,v175,v176,v177,v178,v179,v180,v181
	Dim v182,v183,v184,v185,v186,v187,v188,v189,v190,v191,v192,v193,v194,v195,v196,v197,v198,v199,v200,v201,v202,v203,v204,v205,v206,v207,v208,v209,v210

	Set srvr = webAdmin.Get("Server=@")
	Set crntSite = srvr.SiteDefaults

	v1 = CNSTHYPEN
	v2 = crntSite.Limits.ConnectionTimeout
	
	Set oSection = webAdmin.Get("httpProtocolSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	v3 = oSection.AllowKeepAlive
	v4 = crntSite.LogFile.Enabled
	if(v4 = True) then
		v4 = "Enabled"
	else
		v4 = "Disabled"
	end if
	
	v5 = crntSite.LogFile.LogFormat
	if(v5 = 0) then
		v5 = "IIS"
	Elseif(v5 = 1) then
		v5 = "NCSA"
	Elseif(v5 = 2) then
		v5 = "W3C"
	Elseif(v5 = 3) then
		v5 = "Custom"
	Else
		v5 = "-"
	End if
	
	v6 = crntSite.LogFile.LocalTimeRollover
	v7 = crntSite.LogFile.Directory
	if(v4 = False) then
		v5 = CNSTHYPEN
		v6 = CNSTHYPEN
		v7 = CNSTHYPEN
	end if
	v8 = CNSTHYPEN
	
	v9 = crntSite.Limits.MaxBandwidth
	If(v9 = -1) Then
		v9 = "False" 
		v10 = CNSTHYPEN
	Else
		if(v9 < -1) then
			v10 = 4294967296+v9 & " Bytes"
		else
			v10 = v9 & " Bytes"
		end if
		v9 = "True" 
	End If
	
	v11 = crntSite.Limits.MaxConnections
	If(v11 = -1) Then
		v11 = CNSTHYPEN 
	Else
		if(v11 < -1) then
			v11 = 4294967296+v11
		else
			v11 = v11
		end if
	End If	

	Set oSection = webAdmin.Get("DefaultDocumentSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
	
	v12 = getState(oSection.Enabled)	
	
	Set dataList = CreateObject("System.Collections.ArrayList")	
	For Each objItem in oSection.Files.Files
		dataList.Add objItem.Value
	Next
	v13 = getSortedData(dataList)
	
	v14 = CNSTHYPEN	

	Set oSection = webAdmin.Get("AspSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	v15 = oSection.Session.AllowSessionState
	v16 = oSection.Session.Timeout
	v17 = oSection.BufferingOn
	v18 = oSection.EnableParentPaths
	v19 = oSection.ScriptLanguage
	V20 = oSection.Limits.ScriptTimeout

	Set oSection = webAdmin.Get("anonymousAuthenticationSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
 
	v21 = oSection.Enabled	
	v22 = oSection.userName
	If(v22 = "") then
	   v22 = "Application pool identity"
	End if
	v23 = CNSTHYPEN
	v25 = CNSTHYPEN

	Set oSection = webAdmin.Get("DirectoryBrowseSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
	
	v26 = getState(oSection.Enabled)
	if(v26 = True) then
		v26 = "Enabled"
	else
		v26 = "Disabled"
	end if
	
	v27 = CNSTHYPEN
	v28 = CNSTHYPEN
	
	Set oSection = webAdmin.Get("HandlersSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	Dim tmVal
	tmVal=	oSection.AccessPolicy
	if(tmVal = 513 Or tmVal = 517 Or tmVal = 512 Or tmVal = 516) then
		v29 = "Scripts"
	End If
	if(tmVal = 4 Or tmVal = 5 Or tmVal = 516 Or tmVal = 517) then
		v29 = "Execute"
	End If
	if(tmVal = 1 Or tmVal = 513 Or tmVal = 517 Or tmVal = 5) then
		v24 = "Enabled"
	Else
		v24 = "Disabled"
	End If
	if(tmVal = 0) then
		v24 = "Disabled"
		v29 = "None"
	End if
	
	if(tmVal = 517) Then
		v24 = "Enabled"
		v29 = "Scripts and Executables"
	End If
	
	Set oSection = webAdmin.Get("CompilationSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	Set dataList = CreateObject("System.Collections.ArrayList")		
	For Each objItem In oSection.Assemblies.Assemblies
		dataList.Add  objItem.Assembly
	Next 
	
	v30 = getState(oSection.Batch)
	v31 = oSection.MaxBatchGeneratedFileSize
	v32 = oSection.MaxBatchSize
	v33 = oSection.BatchTimeout		
	v34 = getState(oSection.Debug)
	v35 = oSection.enablePrefetchOptimization
	v36 = oSection.profileGuidedOptimizations
	v37 = oSection.NumRecompilesBeforeAppRestart
	v38 = oSection.optimizeCompilations
	v39 = getState(oSection.UrlLinePragmas)
	v40 = getState(oSection.Explicit)
	v41 = getState(oSection.Strict)
	v42 = getSortedData(dataList)
	v43 = oSection.DefaultLanguage
	v44 = oSection.TempDirectory
	
	Set oSection = webAdmin.Get("GlobalizationSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
	
	v45 = Trim(oSection.Culture)
	If(v45 = "") Then
		v45 = "Invariant Country"
	End If
	v46 = getState(oSection.EnableClientBasedCulture)
	v47 = Trim(oSection.UICulture)
	If(v47 = "") Then
		v47 = "Invariant Country"
	End if
	v48 = Trim(oSection.FileEncoding)
	If(v48 = "") Then
		v48 = "windows-1253"
	End If
	v49 = oSection.RequestEncoding
	v50 = oSection.ResponseHeaderEncoding
	v51 = oSection.ResponseEncoding

	Set oSection = webAdmin.Get("AppSettingsSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
	
	Set dataList = CreateObject("System.Collections.ArrayList")		
	For Each objItem In oSection.AppSettings
		dataList.Add validate(objItem.key) & CNSTCOLON &  validate(objItem.value)
	Next 		
	v52 = getSortedData(dataList)

	Set oSection = webAdmin.Get("AspSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
    	
	v53 = oSection.CodePage
	V54 = oSection.EnableChunkedEncoding
	V55 = oSection.EnableAspHtmlFallback			
	V56 = oSection.Limits.QueueConnectionTestTime
	V57 = oSection.Limits.MaxRequestEntityAllowed
	V58 = oSection.Limits.RequestQueueMax
	V59 = oSection.Limits.QueueTimeout
	V60 = oSection.Limits.BufferingLimit
	V61 = oSection.Limits.ProcessorThreadMax	
	V62 = oSection.Lcid
	V63 = oSection.EnableApplicationRestart	
	V64 = oSection.CalcLineNumber
	V65 = oSection.ExceptionCatchEnable
	V66 = oSection.AppAllowClientDebug
	V67 = oSection.LogErrorRequests	
	V68 = oSection.AppAllowDebugging
	V69 = oSection.ErrorsToNTLog
	V70 = oSection.RunOnEndAnonymously
	V71 = oSection.ScriptErrorMessage
	V72 = oSection.ScriptErrorSentToBrowser	
	V73 = oSection.Cache.DiskTemplateCacheDirectory
	V74 = oSection.Cache.EnableTypelibCache
	V75 = oSection.Cache.MaxDiskTemplateCacheFiles
	V76 = oSection.Cache.ScriptFileCacheSize
	V77 = oSection.Cache.ScriptEngineCacheMax
	
	Dim srvicFlgs
	srvicFlgs = oSection.ComPlus.appServiceFlags
	v78 = False
	v79 = False
	v84 = False	
	If(srvicFlgs = 7) Then
		v78 = True
		v79 = True
		v84 = True
	Elseif (srvicFlgs = 1 Or srvicFlgs = 3 Or srvicFlgs = 7 Or srvicFlgs = 5) Then
		v79 = True
	Elseif (srvicFlgs = 2 Or srvicFlgs = 3 Or srvicFlgs = 7 Or srvicFlgs = 6) Then
		v78 = True
	Elseif (srvicFlgs = 4 Or srvicFlgs = 6 Or srvicFlgs = 5 Or srvicFlgs = 7) Then
		v84 = True
	End If
	
	V80 = oSection.ComPlus.ExecuteInMta
	V81 = oSection.ComPlus.TrackThreadingModel
	V82 = oSection.ComPlus.PartitionId
	V83 = oSection.ComPlus.SxsName
	
	v85 = oSection.Session.Max
	If(v85 < 0) Then
		v85 = 4294967296+v85
	End If 
	
	v86 = oSection.Session.KeepSessionIdSecure

	Set oSection = webAdmin.Get("CgiSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
    
    v87 = oSection.Timeout
	v88 = getState(oSection.CreateCGIWithNewConsole)
	v89 = getState(oSection.CreateProcessAsUser)

	Set oSection = webAdmin.Get("ConnectionStringsSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	Set dataList = CreateObject("System.Collections.ArrayList")		
	For Each objItem In oSection.ConnectionStrings
		dataList.Add validate(objItem.Name) & " : " &  validate(objItem.ConnectionString)
	Next 		
	v90 = getSortedConStrs(dataList)
	
	Set oSection = webAdmin.Get("SmtpMailSettingsSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	v91 = oSection.From
	
	v92 = oSection.DeliveryMethod
	If(v92 = 0) Then
		v92 = "Deliver e-mail to SMTP Server"
	ElseIf(v92 = 1) then
		v92 = "Store e-mail In pickup directory"
	ElseIf(v92 = 2) then
		v92 = "E-mail is copied to the directory specified by the Specified Pickup Directory property for delivery by an external application"
	End If
	
	v93 = oSection.Network.Host
	v94 = oSection.Network.Port

	Dim spcfcCrdn
	spcfcCrdn = oSection.Network.DefaultCredentials
	If(spcfcCrdn = False) Then
		v95 = "Not required"
	Else 
		v95 = "Windows"
	End If
	
	v96 = oSection.Network.userName
	If(Not (Trim(v96) = "")) Then
		v95 = "Specify Credentials"
	End if 
	v97 = oSection.SpecifiedPickupDirectory.PickupDirectoryLocation
	
	if(v92 = "Store e-mail In pickup directory") then
		v93 = CNSTHYPEN
		v94 = CNSTHYPEN
		v95 = CNSTHYPEN
		v96 = CNSTHYPEN
	else
		v97 = CNSTHYPEN
	end if
		
	
	Set oSection = webAdmin.Get("FtpAuthorizationSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
	
	Set allwRules = CreateObject("System.Collections.ArrayList")
	Set denyRules = CreateObject("System.Collections.ArrayList")
	For each objItem in oSection.Authorization
		Dim mode,users,rls,prmsn
		mode =  objItem.AccessType
			
		users = objItem.Users
		rls = objItem.Roles
		prmsn = objItem.Permissions
		
		If(users = "*") Then
			users = "All Users"
		ElseIf(users = "?") Then
			users = "All Anonymous Users"
		ElseIf(validate(users) = "") Then
			users = CNSTHYPEN
		End If
		
		If(rls = "") Then
			rls = CNSTHYPEN
		End If
		
		If(prmsn = 1) Then
			prmsn = "Read"
		ElseIf(prmsn = 2) Then
			prmsn = "Write"
		ElseIf(prmsn = 3) Then
			prmsn = "Read,Write"
		else
			prmsn = CNSTHYPEN
		End If
		
		
		If(mode = 0) Then
			allwRules.add users & CNSTCOLON & rls & CNSTCOLON & prmsn	
		ElseIf(mode = 1) then
			denyRules.add users & CNSTCOLON & rls & CNSTCOLON & prmsn
		end If
	Next

	v98 = getSortedData(allwRules)
	v99 = getSortedData(denyRules)
	
	Set oSection = webAdmin.Get("FtpFirewallSupportSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	v100 = oSection.LowDataChannelPort & CNSTHYPEN & oSection.HighDataChannelPort  

	Set oSection = webAdmin.Get("FtpIpSecuritySection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
	
	Set ftpAllowIps = CreateObject("System.Collections.ArrayList")
	Set ftpDenyIps = CreateObject("System.Collections.ArrayList")			
	For Each objItem In oSection.IpSecurity
		Dim v
		v =  objItem.Allowed
		If(v = -1) Then
			ftpAllowIps.Add validate(objItem.IpAddress) & CNSTCOLON & validate(objItem.SubnetMask) & CNSTCOLON & validate(objItem.DomainName)
		ElseIf(v = 0) Then
			ftpDenyIps.Add validate(objItem.IpAddress) & CNSTCOLON & validate(objItem.SubnetMask) & CNSTCOLON & validate(objItem.DomainName)
		End If
	Next 		
	v101 = getSortedData(ftpAllowIps)
	v102 = getSortedData(ftpDenyIps)
	
	v103 = oSection.AllowUnlisted
	If(v103 = "True") Then
		v103 = "Allow"
	Else
		v103 = "Deny"
	End If
	v104 = oSection.EnableReverseDns

	Set oSection = webAdmin.Get("FtpLogSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	v105 = oSection.CentralLogFile.Enabled
	v106 = oSection.CentralLogFileMode
	If(v106 = 0) Then
		v106 = "Site"
	ElseIf(v106= 1) then
		v106 = "Server"
	End If
	
	v107 = oSection.CentralLogFile.Directory	
	v108 = oSection.LogInUTF8
	if(v108 = True) then
		v108 = "UTF8"
	else
		v108 = "ANSI"
	End if
	
	v109 = oSection.CentralLogFile.LocalTimeRollover
	if(v105 = False) then
		v106 = CNSTHYPEN
		v107 = CNSTHYPEN
		v108 = CNSTHYPEN
		v109 = CNSTHYPEN	
	end if

	Set oSection = webAdmin.Get("FtpRequestFilteringSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
	
	v110 = oSection.FileExtensions.AllowUnlisted
	v111 = oSection.AllowHighBitCharacters		
	v112 = oSection.RequestLimits.MaxAllowedContentLength
	v113 = oSection.RequestLimits.MaxUrl
	
	Set ftpAllwExts = CreateObject("System.Collections.ArrayList")
	Set ftpDenyExts = CreateObject("System.Collections.ArrayList")
		
	For each objItem in oSection.FileExtensions.FileExtensions
		Dim extMode
		extMode = objItem.Allowed	
		If(extMode = True) Then
			ftpAllwExts.add objItem.FileExtension
		ElseIf(extMode = False) then
			ftpDenyExts.add objItem.FileExtension
		end if
	Next
	
	v114 = getSortedData(ftpAllwExts)
	v115 = getSortedData(ftpDenyExts)
	
	Set dataList = CreateObject("System.Collections.ArrayList")
	For each objItem in oSection.HiddenSegments.HiddenSegments
		dataList.add objItem.Segment
	Next	
	v116 = getSortedData(dataList)
	
	Set dataList = CreateObject("System.Collections.ArrayList")
	For each objItem in oSection.DenyUrlSequences.DenyUrlSequences
		dataList.add objItem.Sequence
	Next
	v117 = getSortedData(dataList)

	Set oSection = webAdmin.Get("CustomErrorsSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
	
	Set dataList = CreateObject("System.Collections.ArrayList")
	For Each objItem in oSection.CustomErrors
		dataList.Add objItem.StatusCode & CNSTCOLON &  objItem.Redirect
	Next
	v118 = getSortedData(dataList)	
	
	v119 = oSection.Mode
	if v119 = 0 then
		v119 = "RemoteOnly"
	elseif v119 = 1 then
		v119 = "On"
	elseif v119 = 2 Then
		v119 = "Off"	
	End If
	
	v120 = oSection.redirectMode
	v121 = oSection.defaultRedirect
	v122 = oSection.allowNestedErrors

	Set oSection = webAdmin.Get("DirectoryBrowseSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	v123 = oSection.showFlags
	
	Set oSection = webAdmin.Get("HttpErrorsSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	v128 = oSection.ErrorMode
	if (v128 = 2 )then
		v128 = "Detailed errors"
	elseif (v128 = 1) then
		v128 = "Custom error pages"
	elseif (v128 = 0) then
		v128 = "Detailed errors for local requests and custom error pages for remote requests"	
	End If
	
	v129 = oSection.DefaultPath
	v130 = oSection.DefaultResponseMode
	if (v130 = 0 )then
		v130 = "File"
	elseif (v130 = 1) Then
		v130 = "ExecuteURL"
	elseif (v130 = 2 )Then
		v130 = "Redirect"	
	End If
	
	Set oSection = webAdmin.Get("HttpRedirectSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
    
	v131 = getState(oSection.Enabled)
	v132 = oSection.Destination
	v133 = getState(oSection.ExactDestination)
	v134 = getState(oSection.ChildOnly)
	v135 = oSection.HttpResponseStatus
	If(v135 = "301") Then
		v135 = "Permanent(301)"
	ElseIf(v135 = "302") Then
		v135 = "Found(302)"
	ElseIf(v135 = "307") Then
		v135 = "Temporary(307)"
	End if
	
	if(v131 = false) then
		v132 = CNSTHYPEN
		v133 = CNSTHYPEN
		v134 = CNSTHYPEN
		v135 = CNSTHYPEN
	end if
	
	Set oSection = webAdmin.Get("httpProtocolSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''")    

    Set dataList = CreateObject("System.Collections.ArrayList") 
	For Each objItem in oSection.CustomHeaders.CustomHeaders
		dataList.add objItem.Name & CNSTCOLON & objItem.Value
	Next
	v136 = getSortedData(dataList)
	
	Set oSection = webAdmin.Get("StaticContentSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	Set dataList = CreateObject("System.Collections.ArrayList")	
	For Each oMimeMapElement in  oSection.StaticContent 
		dataList.Add oMimeMapElement.FileExtension & CNSTCOLON & oMimeMapElement.MimeType
	Next
	v137 = getSortedData(dataList)

	Set oSection = webAdmin.Get("RequestFilteringSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
		
	V138 = oSection.FileExtensions.AllowUnlisted	
	V139 = oSection.Verbs.AllowUnlisted
	V140 = oSection.AllowHighBitCharacters
	V141 = oSection.AllowDoubleEscaping	
	V142 = oSection.RequestLimits.MaxAllowedContentLength
	V143 = oSection.RequestLimits.MaxUrl		
	V144 = oSection.RequestLimits.MaxQueryString	
	
	Set allwdExts = CreateObject("System.Collections.ArrayList")
	Set deniedExts = CreateObject("System.Collections.ArrayList")		
	For each objItem in oSection.FileExtensions.FileExtensions
		Dim extFlMode
		extFlMode = objItem.Allowed	
		If(extFlMode = True) Then
			allwdExts.add objItem.FileExtension
		ElseIf(extFlMode = False) then
			deniedExts.add objItem.FileExtension
		end if
	Next	
	v145 = getSortedData(allwdExts)
	v146 = getSortedData(deniedExts)
		
	Set dataList = CreateObject("System.Collections.ArrayList")
	For each objItem in oSection.HiddenSegments.HiddenSegments
		dataList.add objItem.Segment
	Next	
	V147 = getSortedData(dataList)

	Set dataList = CreateObject("System.Collections.ArrayList")
	For each objItem in oSection.alwaysAllowedUrls.alwaysAllowedUrls
		dataList.add objItem.url
	Next	
	v148 = getSortedData(dataList)
	
	Set dataList = CreateObject("System.Collections.ArrayList")
	For each objItem in oSection.DenyUrlSequences.DenyUrlSequences
		dataList.add objItem.Sequence
	Next	
	v149 = getSortedData(dataList)	
	
	Set allwedVerbs = CreateObject("System.Collections.ArrayList")
	Set deniedVerbs = CreateObject("System.Collections.ArrayList")	
	For Each Vrb In oSection.Verbs.Verbs
		If(Vrb.Allowed = True) Then
			allwedVerbs.add Vrb.Verb 
		ElseIf(Vrb.Allowed = False) then
			deniedVerbs.add Vrb.Verb 
		End If
	Next	
	v150 = getSortedData(allwedVerbs)
	v151 = getSortedData(deniedVerbs)
	
	Set dataList = CreateObject("System.Collections.ArrayList")	
	For Each Vrb In oSection.RequestLimits.HeaderLimits.HeaderLimits
		dataList.add Vrb.Header & CNSTCOLON & validate(Vrb.SizeLimit)
	Next	
	v152 = getSortedData(dataList)
	
	Set dataList = CreateObject("System.Collections.ArrayList")
	For each objItem in oSection.alwaysAllowedQueryStrings.alwaysAllowedQueryStrings
		dataList.add objItem.queryString
	Next	
	v153 = getSortedData(dataList)
	
	Set dataList = CreateObject("System.Collections.ArrayList")
	For each objItem in oSection.denyQueryStringSequences.denyQueryStringSequences
		dataList.add objItem.sequence
	Next	
	v154 = getSortedData(dataList)

	Set oSection = webAdmin.Get("WebDavAuthoringSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 	
		
	Set oSection = webAdmin.Get("WebDavAuthoringRulesSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 	

	Set dataList = CreateObject("System.Collections.ArrayList")
	For each objItem in oSection.AuthoringRules
		Dim acss,path,usrs,roles	
		acss = objItem.Access		
		If(acss = 0) Then
				acss = "None"
		ElseIf(acss = 1) Then
			acss = "Read"
		ElseIf(acss = 2) Then
			acss = "Write"
		ElseIf(acss = 16) Then
			acss = "Source"			
		ElseIf(acss = 19) Then
			acss = "Read,Write,Source"
		ElseIf(acss = 3) Then
			acss = "Read,Write"
		ElseIf(acss = 17) Then
			acss = "Read,Source"
		ElseIf(acss = 18) Then
			acss = "Write,Source"
		Else
			acss = "None"
		End if
				
		path = objItem.Path	
		If(path = "*") Then
			path = "All Content"
		ElseIf(path = "") Then
			path = CNSTHYPEN
		End If
		
		usrs = objItem.Users
		If(usrs = "*") Then
			usrs = "All Users"
		ElseIf(usrs = "?") Then
			usrs = "All Anonymous Users"
		ElseIf(usrs = "") Then
			usrs = CNSTHYPEN
		End If
		
		roles = objItem.Roles
		If(roles = "") Then
		 	roles = CNSTHYPEN
		End if
	
		dataList.add  validate(path) & CNSTCOLON & validate(usrs) & CNSTCOLON & validate(roles) & CNSTCOLON & validate(acss) 
	Next	
	v155 = getSortedData(dataList)	
	V156 = oSection.allowNonMimeMapFiles	
	V157 = oSection.DefaultMimeType
	
	Set oSection = webAdmin.Get("WebDavAuthoringSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 	
		
	V158 = oSection.Locks.enabled
	V159 = oSection.Locks.lockStore
	V160 = oSection.Locks.requireLockForWriting		
	V161 = oSection.Properties.allowAnonymousPropfind	
	V162 = oSection.Properties.allowCustomProperties
	V163 = oSection.Properties.allowInfinitePropfindDepth
	V164 = oSection.fileSystem.allowHiddenFiles	
	v165 = oSection.compatFlags
	v170 = oSection.RequireSsl
    
	Set oSection = webAdmin.Get("UrlCompressionSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	v171 = oSection.DoDynamicCompression
	v172 = oSection.DoStaticCompression
    
    Set oSection = webAdmin.Get("HttpCompressionSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
    
	v173 = oSection.MinFileSizeForComp	
	If(v173 > 0) Then
		v174 = v173
		v173 = "True" 
	Else
		v173 = "False" 
		v174 = CNSTHYPEN
	End If
	
	v175 = oSection.Directory
	v176 = oSection.DoDiskSpaceLimiting
	v177 = oSection.MaxDiskSpaceUsage
	if(v176 = false) then
		v177 = CNSTHYPEN
	End if
	
	Set oSection = webAdmin.Get("CachingSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 

	v178 = oSection.Enabled  
	v179 = oSection.EnableKernelCache  
	v180 = oSection.MaxResponseSize 
	v181 = oSection.MaxCacheSize  
	
		
	Set oSection = webAdmin.Get("TrustSection.Path='MACHINE/WEBROOT/APPHOST/',Location=''") 
   
	v182 = oSection.Level
	
	Set oSection = webAdmin.Get( _  
    "AuthorizationSection.Path=" & _  
    "'MACHINE/WEBROOT/APPHOST/',Location=''") 

    Set allwAuthRule = CreateObject("System.Collections.ArrayList")
	Set denyAuthRule = CreateObject("System.Collections.ArrayList")	
	For each objItem in oSection.Authorization	
		Dim accssType,usrName
		accssType = objItem.AccessType
		usrName = objItem.Users
	
		If(usrName = "*") Then
			usrName = "All Users"
		ElseIf(usrName = "?") Then
			usrName = "All Anonymous Users"
		ElseIf(usrName = "") Then
			usrName = CNSTHYPEN
		End If
		
		If(accssType = 0) Then
			allwAuthRule.add validate(usrName) & CNSTCOLON & validate(objItem.Roles) & CNSTCOLON & validate(objItem.Verbs)
		ElseIf(accssType = 1) then
			denyAuthRule.add validate(usrName) & CNSTCOLON & validate(objItem.Roles) & CNSTCOLON & validate(objItem.Verbs)
		end if
	Next
	
	v183 = getSortedData(allwAuthRule)
	v184 = getSortedData(denyAuthRule)
	
	Set oSection = webAdmin.Get( _  
    "BasicAuthenticationSection.Path=" & _  
    "'MACHINE/WEBROOT/APPHOST/',Location=''") 
	V185 = oSection.Enabled
	V186 = oSection.DefaultLogonDomain			
	V187 = oSection.Realm

	Set oSection = webAdmin.Get( _  
    "DigestAuthenticationSection.Path=" & _  
    "'MACHINE/WEBROOT/APPHOST/',Location=''") 
	v188 = oSection.Enabled
	v189 = oSection.Realm	
	
	Set oSection = webAdmin.Get( _  
    "WindowsAuthenticationSection.Path=" & _  
    "'MACHINE/WEBROOT/APPHOST/',Location=''") 
	V190 = oSection.Enabled

	Set oSection = webAdmin.Get( _  
    "IPSecuritySection.Path=" & _  
    "'MACHINE/WEBROOT/APPHOST/',Location=''")

	Set allwdIps = CreateObject("System.Collections.ArrayList")
	Set denyIps = CreateObject("System.Collections.ArrayList")			
	For Each objItem In oSection.IpSecurity
		Dim ipMode
		ipMode =  objItem.Allowed
		If(ipMode = -1) Then
			allwdIps.Add validate(objItem.IpAddress) & CNSTCOLON & validate(objItem.SubnetMask) & CNSTCOLON & validate(objItem.DomainName)
		ElseIf(ipMode = 0) Then
			denyIps.Add validate(objItem.IpAddress) & CNSTCOLON & validate(objItem.SubnetMask) & CNSTCOLON & validate(objItem.DomainName)
		End If
	Next 		
	v191 = getSortedData(allwdIps)
	v192 = getSortedData(denyIps)	
	
	v193 = oSection.allowUnlisted 
	if(v193 = True) then 
		v193 = "Allow"
	else 
		v193 = "Deny"
	end if	
	v194 = oSection.enableReverseDns  
	v195 = oSection.enableProxyMode  
	v196 = oSection.denyAction  
	If(v196 = "403") Then
		v196 = "Forbidden"
	ElseIf(v196 = "401") Then
		v196 = "Unauthorized"
	ElseIf(v196 = "404") Then
		v196 = "Not Found"
	ElseIf(v196 = "0") Then
		v196 = "Abort"
	End If
	
	Set oSection = webAdmin.Get( _  
    "dynamicIpSecuritySection.Path=" & _  
    "'MACHINE/WEBROOT/APPHOST/',Location=''")
	
	v197 = oSection.denyByConcurrentRequests.enabled 
	v198 = oSection.denyByConcurrentRequests.maxConcurrentRequests 
	v199 = oSection.denyByRequestRate.enabled
	v200 = oSection.denyByRequestRate.maxRequests 
	v201 = oSection.denyByRequestRate.requestIntervalInMilliseconds
	v202 = oSection.enableLoggingOnlyMode

	if(v197 = False) then
		v198 = CNSTHYPEN
	end if
	
	if(v199 = False) then
		v200 = CNSTHYPEN
		v201 = CNSTHYPEN
	end if	

	 Set oSection = webAdmin.Get( _  
    "IsapiCgiRestrictionSection.Path=" & _  
    "'MACHINE/WEBROOT/APPHOST/',Location=''")
  
	v203 = oSection.NotListedCgisAllowed  
	v204 = oSection.NotListedIsapisAllowed
	
	Set allwCgi = CreateObject("System.Collections.ArrayList")
	Set denyCgi = CreateObject("System.Collections.ArrayList")			
	For Each objItem In oSection.IsapiCgiRestriction
		Dim cgiMode
		cgiMode =  objItem.Allowed
		If(cgiMode = True) Then
			allwCgi.Add objItem.Description & CNSTCOLON & validate(objItem.Path)
		ElseIf(cgiMode = False) Then
			denyCgi.Add objItem.Description & CNSTCOLON & validate(objItem.Path) 
		End If
	Next 	
	v205 = getSortedData(allwCgi)
	v206 = getSortedData(denyCgi)
	
	Wscript.Echo validate(v1) & CNSTSPRTR _
	& validate(v2) & CNSTSPRTR _
	& validate(v3) & CNSTSPRTR _
	& validate(v4) & CNSTSPRTR _
	& validate(v5) & CNSTSPRTR _
	& validate(v6) & CNSTSPRTR _
	& validate(v7) & CNSTSPRTR _
	& validate(v8) & CNSTSPRTR _
	& validate(v9) & CNSTSPRTR _
	& validate(v10) & CNSTSPRTR _
	& validate(v11) & CNSTSPRTR _
	& validate(v12) & CNSTSPRTR _
	& validate(v13) & CNSTSPRTR _
	& validate(v14) & CNSTSPRTR _
	& validate(v15) & CNSTSPRTR _
	& validate(v16) & CNSTSPRTR _
	& validate(v17) & CNSTSPRTR _
	& validate(v18) & CNSTSPRTR _
	& validate(v19) & CNSTSPRTR _
	& validate(v20) & CNSTSPRTR _
	& validate(v21) & CNSTSPRTR _
	& validate(v22) & CNSTSPRTR _
	& validate(v23) & CNSTSPRTR _
	& validate(v24) & CNSTSPRTR _
	& validate(v25) & CNSTSPRTR _
	& validate(v26) & CNSTSPRTR _
	& validate(v27) & CNSTSPRTR _
	& validate(v28) & CNSTSPRTR _
	& validate(v29) & CNSTSPRTR _
	& validate(v30) & CNSTSPRTR _
	& validate(v31) & CNSTSPRTR _
	& validate(v32) & CNSTSPRTR _
	& validate(v33) & CNSTSPRTR _
	& validate(v34) & CNSTSPRTR _
	& validate(v35) & CNSTSPRTR _
	& validate(v36) & CNSTSPRTR _
	& validate(v37) & CNSTSPRTR _
	& validate(v38) & CNSTSPRTR _
	& validate(v39) & CNSTSPRTR _
	& validate(v40) & CNSTSPRTR _
	& validate(v41) & CNSTSPRTR _
	& validate(v42) & CNSTSPRTR _
	& validate(v43) & CNSTSPRTR _
	& validate(v44) & CNSTSPRTR _
	& validate(v45) & CNSTSPRTR _
	& validate(v46) & CNSTSPRTR _
	& validate(v47) & CNSTSPRTR _
	& validate(v48) & CNSTSPRTR _
	& validate(v49) & CNSTSPRTR _
	& validate(v50) & CNSTSPRTR _
	& validate(v51) & CNSTSPRTR _
	& validate(v52) & CNSTSPRTR _
	& validate(v53) & CNSTSPRTR _
	& validate(v54) & CNSTSPRTR _
	& validate(v55) & CNSTSPRTR _
	& validate(v56) & CNSTSPRTR _
	& validate(v57) & CNSTSPRTR _
	& validate(v58) & CNSTSPRTR _
	& validate(v59) & CNSTSPRTR _
	& validate(v60) & CNSTSPRTR _
	& validate(v61) & CNSTSPRTR _
	& validate(v62) & CNSTSPRTR _
	& validate(v63) & CNSTSPRTR _
	& validate(v64) & CNSTSPRTR _
	& validate(v65) & CNSTSPRTR _
	& validate(v66) & CNSTSPRTR _
	& validate(v67) & CNSTSPRTR _
	& validate(v68) & CNSTSPRTR _
	& validate(v69) & CNSTSPRTR _
	& validate(v70) & CNSTSPRTR _
	& validate(v71) & CNSTSPRTR _
	& validate(v72) & CNSTSPRTR _
	& validate(v73) & CNSTSPRTR _
	& validate(v74) & CNSTSPRTR _
	& validate(v75) & CNSTSPRTR _
	& validate(v76) & CNSTSPRTR _
	& validate(v77) & CNSTSPRTR _
	& validate(v78) & CNSTSPRTR _
	& validate(v79) & CNSTSPRTR _
	& validate(v80) & CNSTSPRTR _
	& validate(v81) & CNSTSPRTR _
	& validate(v82) & CNSTSPRTR _
	& validate(v83) & CNSTSPRTR _
	& validate(v84) & CNSTSPRTR _
	& validate(v85) & CNSTSPRTR _
	& validate(v86) & CNSTSPRTR _
	& validate(v87) & CNSTSPRTR _
	& validate(v88) & CNSTSPRTR _
	& validate(v89) & CNSTSPRTR _
	& validate(v90) & CNSTSPRTR _
	& validate(v91) & CNSTSPRTR _
	& validate(v92) & CNSTSPRTR _
	& validate(v93) & CNSTSPRTR _
	& validate(v94) & CNSTSPRTR _
	& validate(v95) & CNSTSPRTR _
	& validate(v96) & CNSTSPRTR _
	& validate(v97) & CNSTSPRTR _
	& validate(v98) & CNSTSPRTR _
	& validate(v99) & CNSTSPRTR _
	& validate(v100) & CNSTSPRTR _
	& validate(v101) & CNSTSPRTR _
	& validate(v102) & CNSTSPRTR _
	& validate(v103) & CNSTSPRTR _
	& validate(v104) & CNSTSPRTR _
	& validate(v105) & CNSTSPRTR _
	& validate(v106) & CNSTSPRTR _
	& validate(v107) & CNSTSPRTR _
	& validate(v108) & CNSTSPRTR _
	& validate(v109) & CNSTSPRTR _
	& validate(v110) & CNSTSPRTR _
	& validate(v111) & CNSTSPRTR _
	& validate(v112) & CNSTSPRTR _
	& validate(v113) & CNSTSPRTR _
	& validate(v114) & CNSTSPRTR _
	& validate(v115) & CNSTSPRTR _
	& validate(v116) & CNSTSPRTR _
	& validate(v117) & CNSTSPRTR _
	& validate(v118) & CNSTSPRTR _
	& validate(v119) & CNSTSPRTR _
	& validate(v120) & CNSTSPRTR _
	& validate(v121) & CNSTSPRTR _
	& validate(v122) & CNSTSPRTR _
	& validate(v123) & CNSTSPRTR _
	& validate(v128) & CNSTSPRTR _
	& validate(v129) & CNSTSPRTR _
	& validate(v130) & CNSTSPRTR _
	& validate(v131) & CNSTSPRTR _
	& validate(v132) & CNSTSPRTR _
	& validate(v133) & CNSTSPRTR _
	& validate(v134) & CNSTSPRTR _
	& validate(v135) & CNSTSPRTR _
	& validate(v136) & CNSTSPRTR _
	& validate(v137) & CNSTSPRTR _
	& validate(v138) & CNSTSPRTR _
	& validate(v139) & CNSTSPRTR _
	& validate(v140) & CNSTSPRTR _
	& validate(v141) & CNSTSPRTR _
	& validate(v142) & CNSTSPRTR _
	& validate(v143) & CNSTSPRTR _
	& validate(v144) & CNSTSPRTR _
	& validate(v145) & CNSTSPRTR _
	& validate(v146) & CNSTSPRTR _
	& validate(v147) & CNSTSPRTR _
	& validate(v148) & CNSTSPRTR _
	& validate(v149) & CNSTSPRTR _
	& validate(v150) & CNSTSPRTR _
	& validate(v151) & CNSTSPRTR _
	& validate(v152) & CNSTSPRTR _
	& validate(v153) & CNSTSPRTR _
	& validate(v154) & CNSTSPRTR _
	& validate(v155) & CNSTSPRTR _
	& validate(v156) & CNSTSPRTR _
	& validate(v157) & CNSTSPRTR _
	& validate(v158) & CNSTSPRTR _
	& validate(v159) & CNSTSPRTR _
	& validate(v160) & CNSTSPRTR _
	& validate(v161) & CNSTSPRTR _
	& validate(v162) & CNSTSPRTR _
	& validate(v163) & CNSTSPRTR _
	& validate(v164) & CNSTSPRTR _
	& validate(v165) & CNSTSPRTR _
	& validate(v170) & CNSTSPRTR _
	& validate(v171) & CNSTSPRTR _
	& validate(v172) & CNSTSPRTR _
	& validate(v173) & CNSTSPRTR _
	& validate(v174) & CNSTSPRTR _
	& validate(v175) & CNSTSPRTR _
	& validate(v176) & CNSTSPRTR _
	& validate(v177) & CNSTSPRTR _
	& validate(v178) & CNSTSPRTR _
	& validate(v179) & CNSTSPRTR _
	& validate(v180) & CNSTSPRTR _
	& validate(v181) & CNSTSPRTR _
	& validate(v182) & CNSTSPRTR _
	& validate(v183) & CNSTSPRTR _
	& validate(v184) & CNSTSPRTR _
	& validate(v185) & CNSTSPRTR _
	& validate(v186) & CNSTSPRTR _
	& validate(v187) & CNSTSPRTR _
	& validate(v188) & CNSTSPRTR _
	& validate(v189) & CNSTSPRTR _
	& validate(v190) & CNSTSPRTR _
	& validate(v191) & CNSTSPRTR _
	& validate(v192) & CNSTSPRTR _
	& validate(v193) & CNSTSPRTR _
	& validate(v194) & CNSTSPRTR _
	& validate(v195) & CNSTSPRTR _
	& validate(v196) & CNSTSPRTR _
	& validate(v197) & CNSTSPRTR _
	& validate(v198) & CNSTSPRTR _
	& validate(v199) & CNSTSPRTR _
	& validate(v200) & CNSTSPRTR _
	& validate(v201) & CNSTSPRTR _
	& validate(v202) & CNSTSPRTR _
	& validate(v203) & CNSTSPRTR _
	& validate(v204) & CNSTSPRTR _
	& validate(v205) & CNSTSPRTR _
	& validate(v206) 
		
End function

Function getState(state)
	Dim status
	Select Case state
	Case 0: status= False
	Case -1: status= True
	End Select
	getState = status
End Function

Function getSortedConStrs(dataList)
	Dim inputVal
	inputVal = ""
	dataList.sort()
	For inc = 0 to dataList.Count - 1
		If(inc = 0) then
			inputVal = dataList.Item(inc)
		Else
			inputVal = inputVal & dataList.Item(inc)
		End if
			
		If(inc < (dataList.Count - 1)) then
		 inputVal = inputVal & "~*~"
		End if		
	Next
	getSortedConStrs = inputVal
End Function

Function getSortedData(dataList)
	Dim inputVal
	inputVal = ""
	dataList.sort()
	For inc = 0 to dataList.Count - 1
		If(inc = 0) then
			inputVal = dataList.Item(inc)
		Else
			inputVal = inputVal & dataList.Item(inc)
		End if
			
		If(inc < (dataList.Count - 1)) then
		 inputVal = inputVal & CNSTCOMMA
		End if		
	Next
	getSortedData = inputVal
End Function

Function validate(crntValue)
	Dim inptVal
	inptVal = crntValue
	If(IsNull(inptVal) or Trim(inptVal) = "")  then
		validate = CNSTHYPEN
	Else
		validate = Trim(inptVal)
	End If
End Function
'' SIG '' Begin signature block
'' SIG '' MIIlSgYJKoZIhvcNAQcCoIIlOzCCJTcCAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFIGVtKRF3t3O
'' SIG '' cwJY61BjYzkVHe/ooIIecjCCBTAwggQYoAMCAQICEAQJ
'' SIG '' GBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTEL
'' SIG '' MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IElu
'' SIG '' YzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
'' SIG '' A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENB
'' SIG '' MB4XDTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFow
'' SIG '' cjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0
'' SIG '' IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
'' SIG '' MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
'' SIG '' IENvZGUgU2lnbmluZyBDQTCCASIwDQYJKoZIhvcNAQEB
'' SIG '' BQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsxSRnP
'' SIG '' 0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3
'' SIG '' Gde2qvCchqXYJawOeSg6funRZ9PG+yknx9N7I5TkkSOW
'' SIG '' kHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJRdQtoaPp
'' SIG '' iCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/
'' SIG '' 6XzLkqHlOzEcz+ryCuRXu0q16XTmK/5sy350OTYNkO/k
'' SIG '' tU6kqepqCquE86xnTrXE94zRICUj6whkPlKWwfIPEvTF
'' SIG '' jg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+m
'' SIG '' M6n9Gd8lk9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggr
'' SIG '' BgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
'' SIG '' MEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3Js
'' SIG '' NC5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURS
'' SIG '' b290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsME8GA1UdIARIMEYwOAYKYIZIAYb9bAACBDAqMCgG
'' SIG '' CCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5j
'' SIG '' b20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7
'' SIG '' KgqjpepxA8Bg+S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv
'' SIG '' 9JLLgjEtUYunpyGd823IDzANBgkqhkiG9w0BAQsFAAOC
'' SIG '' AQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134L
'' SIG '' YP3DPQ/Er4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFO
'' SIG '' EKTuP3GOYw4TS63XX0R58zYUBor3nEZOXP+QsRsHDpEV
'' SIG '' +7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRH
'' SIG '' oXpoaK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQM
'' SIG '' JQhCMrI2iiQC/i9yfhzXSUWW6Fkd6fp0ZGuy62ZD2rOw
'' SIG '' jNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
'' SIG '' 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBY0w
'' SIG '' ggR1oAMCAQICEA6bGI750C3n79tQ4ghAGFowDQYJKoZI
'' SIG '' hvcNAQEMBQAwZTELMAkGA1UEBhMCVVMxFTATBgNVBAoT
'' SIG '' DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
'' SIG '' ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJl
'' SIG '' ZCBJRCBSb290IENBMB4XDTIyMDgwMTAwMDAwMFoXDTMx
'' SIG '' MTEwOTIzNTk1OVowYjELMAkGA1UEBhMCVVMxFTATBgNV
'' SIG '' BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRp
'' SIG '' Z2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1
'' SIG '' c3RlZCBSb290IEc0MIICIjANBgkqhkiG9w0BAQEFAAOC
'' SIG '' Ag8AMIICCgKCAgEAv+aQc2jeu+RdSjwwIjBpM+zCpyUu
'' SIG '' ySE98orYWcLhKac9WKt2ms2uexuEDcQwH/MbpDgW61bG
'' SIG '' l20dq7J58soR0uRf1gU8Ug9SH8aeFaV+vp+pVxZZVXKv
'' SIG '' aJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0O21x4i0MG+4g
'' SIG '' 1ckgHWMpLc7sXk7Ik/ghYZs06wXGXuxbGrzryc/NrDRA
'' SIG '' X7F6Zu53yEioZldXn1RYjgwrt0+nMNlW7sp7XeOtyU9e
'' SIG '' 5TXnMcvak17cjo+A2raRmECQecN4x7axxLVqGDgDEI3Y
'' SIG '' 1DekLgV9iPWCPhCRcKtVgkEy19sEcypukQF8IUzUvK4b
'' SIG '' A3VdeGbZOjFEmjNAvwjXWkmkwuapoGfdpCe8oU85tRFY
'' SIG '' F/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6SPDgohIbZpp0
'' SIG '' yt5LHucOY67m1O+SkjqePdwA5EUlibaaRBkrfsCUtNJh
'' SIG '' besz2cXfSwQAzH0clcOP9yGyshG3u3/y1YxwLEFgqrFj
'' SIG '' GESVGnZifvaAsPvoZKYz0YkH4b235kOkGLimdwHhD5QM
'' SIG '' IR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxfjT/JvNNBERJb
'' SIG '' 5RBQ6zHFynIWIgnffEx1P2PsIV/EIFFrb7GrhotPwtZF
'' SIG '' X50g/KEexcCPorF+CiaZ9eRpL5gdLfXZqbId5RsCAwEA
'' SIG '' AaOCATowggE2MA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O
'' SIG '' BBYEFOzX44LScV1kTN8uZz/nupiuHA9PMB8GA1UdIwQY
'' SIG '' MBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgPMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjB5BggrBgEFBQcBAQRtMGswJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggr
'' SIG '' BgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDBF
'' SIG '' BgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsMBEGA1UdIAQKMAgwBgYEVR0gADANBgkqhkiG9w0B
'' SIG '' AQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22Ftf3v1cHvZqs
'' SIG '' oYcs7IVeqRq7IviHGmlUIu2kiHdtvRoU9BNKei8ttzjv
'' SIG '' 9P+Aufih9/Jy3iS8UgPITtAq3votVs/59PesMHqai7Je
'' SIG '' 1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cnRNTnf+hZqPC/
'' SIG '' Lwum6fI0POz3A8eHqNJMQBk1RmppVLC4oVaO7KTVPeix
'' SIG '' 3P0c2PR3WlxUjG/voVA9/HYJaISfb8rbII01YBwCA8sg
'' SIG '' sKxYoA5AY8WYIsGyWfVVa88nq2x2zm8jLfR+cWojayL/
'' SIG '' ErhULSd+2DrZ8LaHlv1b0VysGMNNn3O3AamfV6peKOK5
'' SIG '' lDCCBjMwggUboAMCAQICEAiadJ64LcPsJ+pl6tv4NTEw
'' SIG '' DQYJKoZIhvcNAQELBQAwcjELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQg
'' SIG '' U0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBDQTAe
'' SIG '' Fw0yMTA1MjUwMDAwMDBaFw0yNDA1MjkyMzU5NTlaMHEx
'' SIG '' CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpOZXcgSmVyc2V5
'' SIG '' MQ8wDQYDVQQHEwZJc2VsaW4xHTAbBgNVBAoTFGVHIElu
'' SIG '' bm92YXRpb25zLCBJbmMuMR0wGwYDVQQDExRlRyBJbm5v
'' SIG '' dmF0aW9ucywgSW5jLjCCAiIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggIPADCCAgoCggIBAMRlCdKa4238XJoGRo3eyQ8TrO7M
'' SIG '' kh72kN8Bkdimw92mWoHkhPpBtLSpBLEOJ2vG5zVYmP8x
'' SIG '' eD26NGZGLTMySJNAGVw0zL16/5hL5isQm4iRUwqSpJme
'' SIG '' LGuQWXzu4oCL3DUmtMyCNmuY4kCRcvOY/n/SOBIE6PTn
'' SIG '' HVXiDV4YENsWek4xCvqW4aplV76/AwduiXJTmnndC+Vb
'' SIG '' O/gmxs2bion4MS9ovHeRQ85IWUmX3QrRrRLxOaS3rF0l
'' SIG '' n6c1HXbwjUYrCDxge5oPkZZ9l71GcsmkVEbZcddaWHyf
'' SIG '' yjWAJFAi9t654d/P5msbUr3XoqGAY+MS8re6aEARvm9L
'' SIG '' swo4EQA3t/5NDbYlcCSKNGRLFMgwDaeySCIzHj87DjGM
'' SIG '' 3zD8ovHJQMHwWHNl4UrlHF98in+JKURZgpWHyuS7LRkE
'' SIG '' TWzjY6bAgUxIGbsBH5HTlNK5mjMsGRVSxxKZqWGXj8+z
'' SIG '' N1YTfmleepEf3n6PHg/NROVQ0KpiYhliqv7PY4W5GB+4
'' SIG '' NroS9jF2/7kbIVQ0jpBUbyCA/5fsgyaIAwaWnt8dqL+W
'' SIG '' L42PGaPERdLV78ktK37A7wDWcO5qbcx59AZZsOZboNxd
'' SIG '' glSaTW829R5gB+pNMhR5lmAqFADWwQdGEf5OCb4GNm8r
'' SIG '' bRe3EDycpe1CPQruCkwIO0TphpMHS4Zl6DwgXKNBAgMB
'' SIG '' AAGjggHEMIIBwDAfBgNVHSMEGDAWgBRaxLl7Kgqjpepx
'' SIG '' A8Bg+S32ZXUOWDAdBgNVHQ4EFgQU+chEms/YE0kvGgTW
'' SIG '' ta9+DDAONkowDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHcGA1UdHwRwMG4wNaAzoDGGL2h0
'' SIG '' dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
'' SIG '' ZWQtY3MtZzEuY3JsMDWgM6Axhi9odHRwOi8vY3JsNC5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNy
'' SIG '' bDBLBgNVHSAERDBCMDYGCWCGSAGG/WwDATApMCcGCCsG
'' SIG '' AQUFBwIBFhtodHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9D
'' SIG '' UFMwCAYGZ4EMAQQBMIGEBggrBgEFBQcBAQR4MHYwJAYI
'' SIG '' KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNv
'' SIG '' bTBOBggrBgEFBQcwAoZCaHR0cDovL2NhY2VydHMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRENv
'' SIG '' ZGVTaWduaW5nQ0EuY3J0MAwGA1UdEwEB/wQCMAAwDQYJ
'' SIG '' KoZIhvcNAQELBQADggEBAJQI53BT7yyssE/+AxAhu2x2
'' SIG '' 7YlZfrrpn0Y9mKxbgobIJL9T5kKYH8qcQt4PhK1fckVf
'' SIG '' Pl10gsDmiid7+kS536YS4RMGHNvtELPzZYm+TQMQxriH
'' SIG '' MwCHlznOZEUabxbENl0jbTO1y9bSw5uqf1RuwaFAMqkV
'' SIG '' 7DD3Vm05Df/Z3QphkrKnMYxtrnfDulYbXvSeS2hwVZN5
'' SIG '' SGQDLR+gAnaOUE6zOPZ2yFPEBrkWDV2SkSwFLuiIA+li
'' SIG '' SjFX2V1pcnw/HWdq93o+kNbgDvzW7Xd/e0/gVUKw1jDh
'' SIG '' vPhnkYicKHr8WyFodEnp2TlKwKvb0yWkrxTEr3LZCZv6
'' SIG '' MS1HFHRBkt8wggauMIIElqADAgECAhAHNje3JFR82Ees
'' SIG '' /ShmKl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYT
'' SIG '' AlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNV
'' SIG '' BAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERp
'' SIG '' Z2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMw
'' SIG '' MDAwMDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkG
'' SIG '' A1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
'' SIG '' IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqG
'' SIG '' SIb3DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJ
'' SIG '' UVXHJQPE8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVC
'' SIG '' X6SI82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0
'' SIG '' hNoR8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w
'' SIG '' 1lbU5ygt69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ
'' SIG '' 3HxqV3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43
'' SIG '' IbtArF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFk
'' SIG '' dECnwHLFuk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcp
'' SIG '' licu9Yemj052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6
'' SIG '' OBGz9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTy
'' SIG '' UpURK1h0QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506
'' SIG '' o9UD4L/wojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB
'' SIG '' 7UK/BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfc
'' SIG '' Yd6T/jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwM
'' SIG '' O1uKIqjBJgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbs
'' SIG '' q11GdeJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5r
'' SIG '' mQzSM7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgw
'' SIG '' BgEB/wIBADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxq
'' SIG '' II+eyG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6
'' SIG '' mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoG
'' SIG '' CCsGAQUFBwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEF
'' SIG '' BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEG
'' SIG '' CCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2Vy
'' SIG '' dC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBD
'' SIG '' BgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNy
'' SIG '' bDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQi
'' SIG '' AX5m1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaop
'' SIG '' afxpwc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQ
'' SIG '' TGIdDAiCqBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+K
'' SIG '' LHqrhc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQ
'' SIG '' cAp876i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6
'' SIG '' wCeCRK6ZJxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SN
'' SIG '' oOeY+/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3
'' SIG '' ZpHxcpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/
'' SIG '' a6fxZsNBzU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr
'' SIG '' 5Dhzq6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j
'' SIG '' /R0o08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT
'' SIG '' 1ObyF5lZynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCY
'' SIG '' oCvtlUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y
'' SIG '' 3wSJ8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqk
'' SIG '' hQ/8mJb2VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqh
'' SIG '' K/bt1nz8MIIGwDCCBKigAwIBAgIQDE1pckuU+jwqSj0p
'' SIG '' B4A9WjANBgkqhkiG9w0BAQsFADBjMQswCQYDVQQGEwJV
'' SIG '' UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNV
'' SIG '' BAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBT
'' SIG '' SEEyNTYgVGltZVN0YW1waW5nIENBMB4XDTIyMDkyMTAw
'' SIG '' MDAwMFoXDTMzMTEyMTIzNTk1OVowRjELMAkGA1UEBhMC
'' SIG '' VVMxETAPBgNVBAoTCERpZ2lDZXJ0MSQwIgYDVQQDExtE
'' SIG '' aWdpQ2VydCBUaW1lc3RhbXAgMjAyMiAtIDIwggIiMA0G
'' SIG '' CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDP7KUmOsap
'' SIG '' 8mu7jcENmtuh6BSFdDMaJqzQHFUeHjZtvJJVDGH0nQl3
'' SIG '' PRWWCC9rZKT9BoMW15GSOBwxApb7crGXOlWvM+xhiumm
'' SIG '' KNuQY1y9iVPgOi2Mh0KuJqTku3h4uXoW4VbGwLpkU7sq
'' SIG '' FudQSLuIaQyIxvG+4C99O7HKU41Agx7ny3JJKB5MgB6F
'' SIG '' VueF7fJhvKo6B332q27lZt3iXPUv7Y3UTZWEaOOAy2p5
'' SIG '' 0dIQkUYp6z4m8rSMzUy5Zsi7qlA4DeWMlF0ZWr/1e0Bu
'' SIG '' bxaompyVR4aFeT4MXmaMGgokvpyq0py2909ueMQoP6Mc
'' SIG '' D1AGN7oI2TWmtR7aeFgdOej4TJEQln5N4d3CraV++C0b
'' SIG '' H+wrRhijGfY59/XBT3EuiQMRoku7mL/6T+R7Nu8GRORV
'' SIG '' /zbq5Xwx5/PCUsTmFntafqUlc9vAapkhLWPlWfVNL5Af
'' SIG '' J7fSqxTlOGaHUQhr+1NDOdBk+lbP4PQK5hRtZHi7mP2U
'' SIG '' w3Mh8y/CLiDXgazT8QfU4b3ZXUtuMZQpi+ZBpGWUwFjl
'' SIG '' 5S4pkKa3YWT62SBsGFFguqaBDwklU/G/O+mrBw5qBzli
'' SIG '' GcnWhX8T2Y15z2LF7OF7ucxnEweawXjtxojIsG4yeccL
'' SIG '' WYONxu71LHx7jstkifGxxLjnU15fVdJ9GSlZA076XepF
'' SIG '' cxyEftfO4tQ6dwIDAQABo4IBizCCAYcwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAww
'' SIG '' CgYIKwYBBQUHAwgwIAYDVR0gBBkwFzAIBgZngQwBBAIw
'' SIG '' CwYJYIZIAYb9bAcBMB8GA1UdIwQYMBaAFLoW2W1NhS9z
'' SIG '' KXaaL3WMaiCPnshvMB0GA1UdDgQWBBRiit7QYfyPMRTt
'' SIG '' lwvNPSqUFN9SnDBaBgNVHR8EUzBRME+gTaBLhklodHRw
'' SIG '' Oi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRSU0E0MDk2U0hBMjU2VGltZVN0YW1waW5nQ0Eu
'' SIG '' Y3JsMIGQBggrBgEFBQcBAQSBgzCBgDAkBggrBgEFBQcw
'' SIG '' AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMFgGCCsG
'' SIG '' AQUFBzAChkxodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkRzRSU0E0MDk2U0hBMjU2
'' SIG '' VGltZVN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEBCwUA
'' SIG '' A4ICAQBVqioa80bzeFc3MPx140/WhSPx/PmVOZsl5vdy
'' SIG '' ipjDd9Rk/BX7NsJJUSx4iGNVCUY5APxp1MqbKfujP8DJ
'' SIG '' AJsTHbCYidx48s18hc1Tna9i4mFmoxQqRYdKmEIrUPwb
'' SIG '' tZ4IMAn65C3XCYl5+QnmiM59G7hqopvBU2AJ6KO4ndet
'' SIG '' Hxy47JhB8PYOgPvk/9+dEKfrALpfSo8aOlK06r8JSRU1
'' SIG '' NlmaD1TSsht/fl4JrXZUinRtytIFZyt26/+YsiaVOBmI
'' SIG '' RBTlClmia+ciPkQh0j8cwJvtfEiy2JIMkU88ZpSvXQJT
'' SIG '' 657inuTTH4YBZJwAwuladHUNPeF5iL8cAZfJGSOA1zZa
'' SIG '' X5YWsWMMxkZAO85dNdRZPkOaGK7DycvD+5sTX2q1x+Dz
'' SIG '' BcNZ3ydiK95ByVO5/zQQZ/YmMph7/lxClIGUgp2sCovG
'' SIG '' SxVK05iQRWAzgOAj3vgDpPZFR+XOuANCR+hBNnF3rf2i
'' SIG '' 6Jd0Ti7aHh2MWsgemtXC8MYiqE+bvdgcmlHEL5r2X6cn
'' SIG '' l7qWLoVXwGDneFZ/au/ClZpLEQLIgpzJGgV8unG1TnqZ
'' SIG '' bPTontRamMifv427GFxD9dAq6OJi7ngE273R+1sKqHB+
'' SIG '' 8JeEeOMIA11HLGOoJTiXAdI/Otrl5fbmm9x+LMz/F0xN
'' SIG '' AKLY1gEOuIvu5uByVYksJxlh9ncBjDGCBkQwggZAAgEB
'' SIG '' MIGGMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJl
'' SIG '' ZCBJRCBDb2RlIFNpZ25pbmcgQ0ECEAiadJ64LcPsJ+pl
'' SIG '' 6tv4NTEwCQYFKw4DAhoFAKBwMBAGCisGAQQBgjcCAQwx
'' SIG '' AjAAMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwG
'' SIG '' CisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMCMGCSqG
'' SIG '' SIb3DQEJBDEWBBT7m2HPIRg9HcsXe6OjrXiyynuHrzAN
'' SIG '' BgkqhkiG9w0BAQEFAASCAgCc0d2CCiUrHDtVsBq61Z/R
'' SIG '' 03GKuMTnW+WbcHo4HR82HbYidjs1YmaNWjm7uw/NazRB
'' SIG '' B0PDlvHZYQFceZysYMw0Up+ub3lNczZ5SssMx4YVgOxd
'' SIG '' 4IdBOA4v0ZT0X6+aeBFLJC2q4359zOul5RD5DHdZ/j3o
'' SIG '' ekDqTmkiMT0AVNKdx+aGxjbjUH8UE0ppXHvRSM6LtbrV
'' SIG '' E9q+lx5OsK78POXOtmColYHQuz2OdhsBJu0OlSI2AU0m
'' SIG '' WoKowjCwfa1pUSyz4YL/wZfvJYQY7iEj0q2DE2xjTDlD
'' SIG '' lBCAJFu6VS6djWVnnPdeBj1+CEGYYcaCzjxQ69yNath+
'' SIG '' stmzdo4wWlc7I4a0DsO26j3C75L8PAPgBEdY6KNK70gx
'' SIG '' IIHQtxvegDI7ID6/ADXg6prHc59VNnsipRzsRmRrxxl/
'' SIG '' ifCHeAWzvTQas3UVt4BYBd5VanatAsTw98iTOJvXT4d6
'' SIG '' m3JBFcAtvKgoc3yKzz/ssPpB84Vr+N0G2AONOtAmgUl2
'' SIG '' qcX/+Fgsx5PI9rtzhEQRKzaF/PG7/4kLYGdNnVU5qPk4
'' SIG '' tEa8sNHaiob/1ct8ydpd1zKFi+uM4K6yQTP/OJT5sWHT
'' SIG '' MLB68md4rpbpf0TN+ABBdUKeRfD91Zhz8OU43bE329+t
'' SIG '' Y6njbVa5djohsl0JcAFmTq3B7BITaaNzP+YvTl8DjuBV
'' SIG '' SaGCAyAwggMcBgkqhkiG9w0BCQYxggMNMIIDCQIBATB3
'' SIG '' MGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2Vy
'' SIG '' dCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
'' SIG '' ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcg
'' SIG '' Q0ECEAxNaXJLlPo8Kko9KQeAPVowDQYJYIZIAWUDBAIB
'' SIG '' BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwG
'' SIG '' CSqGSIb3DQEJBTEPFw0yMjEyMTQwODU4NTFaMC8GCSqG
'' SIG '' SIb3DQEJBDEiBCB4XFjQEJPV3m6vSo78ZiNHBcR8xRz+
'' SIG '' /QfpjZEpDlKf5TANBgkqhkiG9w0BAQEFAASCAgBV455O
'' SIG '' +2qQ7k7EdS48zI4vWPGBIYNOLBSw/Cd98g4A4I6r37BQ
'' SIG '' KO5e7xM87cKtPCcBWGrkqxSEcb/idjWcrUKB3qs097Z5
'' SIG '' S/I6J6fj5pG5xJ7zEnE+zaiN3GidMU5gaLUR0olEfPII
'' SIG '' gm2eQWLJeUnZqfCI4TBYWTCSaAAYztApO3JfsEZtrHy0
'' SIG '' LnKIL/AxJypXZUKzwCpie/uRfIgnQo5pBL+B3kVwx9pj
'' SIG '' BvQyvRriUfoobW2Dt6j/u3DnoZCGEvVH/EbpJmkIl1n7
'' SIG '' W7sI//NMvbO3vC5apZ//ST3psEGrRRCla9k7QJcr4jjx
'' SIG '' /G2ngWFShSzwj7+v33TJoMI9o2u3PAXL/IAaNBKZIgBt
'' SIG '' y9ZFpiiAwWY4z4fGkQ0Qq9JWGk4WFGH2SZp/VwaJyU3+
'' SIG '' sOgy85hEuzTcIkL2mRSBxAUUiE/k6oqUUQ1FxxXyF+jp
'' SIG '' DznUqI0eWzOHLuEba4YHosH0npEd9yo//DwlanyuEC3j
'' SIG '' /rRoQVplalb+D/AXPKSz+bA3SCeKMFViIsYKiW/qjxXu
'' SIG '' GAmp60dOwsogT1yJ7RAHt4/UP0u443u1U6zfSPJ1K2Lr
'' SIG '' 2fNGQFfG30e8vuy9KS/nHlQp02Te1jXkP4B4X7VMNL87
'' SIG '' 7riH8gKd0NnpzMGTkcaiVWOp1Ga75Bi1t633diCnKNqd
'' SIG '' GUXV5DvZNhNc2laIEw==
'' SIG '' End signature block
