$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"

$iisfeatures = @(get-windowsoptionalfeature -Online | where FeatureName -like 'IIS-*')
if($iisfeatures.count -eq 0)
{
	Write-Host 'IIS Features not available.'
	break
}

$WebServerRoleEnabled = $False
foreach($feature in $iisfeatures)
{
	$name = $feature.FeatureName
	$state = $feature.State

	if($name -eq 'IIS-WebServerRole' -and $state -eq 'Enabled')
	{
		$WebServerRoleEnabled = $True
		break
	}
}


if ($WebServerRoleEnabled -eq $True)
{
	Write-Host "IIS Web Server Role is Enabled."
	foreach($feature in $iisfeatures)
	{
		$name = $feature.FeatureName
		$state = $feature.State
		if ($name -eq 'IIS-ManagementScriptingTools' -or $name -eq 'IIS-RequestMonitor')
		{
			if($state -eq 'Disabled')
			{
				Write-host "Enabling the IIS Web Server feature $($name)."
				Enable-WindowsOptionalFeature -Online -FeatureName $name
			}
			else
			{
				Write-host "IIS Web Server feature $($name) already enabled."
			}
		}
	}
}
else
{
	Write-Host "IIS Web Server Role is Disabled. So other child features are can not be enabled."
}



