﻿##/*********************************************************************************************
##Author                :  Guravareddy.T
##Purpose               :  Display the different unique domains in skype sessions
##Created               :  11/08/2018
##Modified By		    :
##reference link        :(https://gallery.technet.microsoft.com/Get-CSUserSessionDomains-c8b0257c)

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

$testargs=$args
$reportingname='SBO\'+$testargs[0]
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "Syalldomains" -keyFileName "kSyalldomains" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
    $domains= import-csv $csvfile -Encoding $encTyp
                         			 			 					
    Remove-Item $csvfile
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'Syalldomains' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kSyalldomains' -InputFile $readfiles[4]
    Write-Host "ReadFile:"$readfiles[3]


$totalcnt=0

[System.GC]::GetTotalMemory($true) | out-null

foreach($domain in $domains)
{
    $totalcnt++
    Write-host '#domainsdd' $domain.domain
}

Write-Host '#domainscount'$totalcnt


[System.GC]::GetTotalMemory($true) | out-null

