﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear-Host

if ((Get-PSSnapin "Microsoft.SharePoint.PowerShell" -ErrorAction SilentlyContinue) -eq $null) {  
    Add-PSSnapin "Microsoft.SharePoint.PowerShell"  
}


$centralAdminURL = Get-SPWebApplication -includecentraladministration | where {$_.IsAdministrationWebApplication} | Select-Object -ExpandProperty Url

$listName = "Review Problems and Solutions"
$spSourceWeb = Get-SPWeb $centralAdminURL
$spSourceList = $spSourceWeb.Lists[$listName]
$spSourceItems = $spSourceList.GetItems() | where {($_['Severity'] -ne "4 - Success")}

$spSourceItems | ForEach-Object {
   Write-Host $_['Category'],"|",$_['Severity'],"|",$_['HealthReportServices'],"|",$_['Modified'],"|",$_['Title'],"|",$_['HealthReportServers']
   } 

Remove-PSSnapin Microsoft.SharePoint.PowerShell