﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue 

#$WarningPreference = "SilentlyContinue"
$InputDays=$args 
$MostActiveSiteCollCount=0
$LeastActiveSitesCount=0
$MostActiveSitesCount=0
$LeastActiveSiteCollCount=0
$currentDate = (get-date).ToUniversalTime()
$LeastActiveSCDate = $currentDate.AddDays(- $InputDays[0]).ToUniversalTime()   # compute the least active site collection date 
$LeastActiveSiteDate = $currentDate.AddDays(- $InputDays[1]).ToUniversalTime()   # compute the least active site date  
$yesterdayDate=$currentDate.AddDays(-1).ToUniversalTime()    

Write-Output "[Most Active Sites]"
$MostActiveSites = (Get-SPWebApplication | Get-SPSite -Limit All| Get-SPWeb -Limit All | Select URL, Title, SiteAdministrators, LastItemModifiedDate | Where-Object {$_.LastItemModifiedDate -gt ($yesterdayDate)}  | sort LastItemModifiedDate -descending)
$A = $MostActiveSites | measure
$MostActiveSitesCount=$A.count

write-output "Count :  $MostActiveSitesCount"

$Top10MostActiveSites = $MostActiveSites| Select URL, Title, SiteAdministrators, LastItemModifiedDate -First 10 
foreach ($objcoll in $Top10MostActiveSites)
{
   
        $mostActiveUrlTitle = $objcoll.URL+"~!~ "+$objcoll.Title +"~!~ "
        $mostActiveAdmin = $objcoll.SiteAdministrators
        $mostActiveDate = "~!~ "+$objcoll.LastItemModifiedDate
        $mostActiveResult =$mostActiveUrlTitle + $mostActiveAdmin +$mostActiveDate + "}"
        Write-Output "$mostActiveResult"
  
} 

Write-Output "[Least Active Sites]"
$LeastActiveSites = (Get-SPWebApplication | Get-SPSite -Limit All| Get-SPWeb -Limit All | Select URL, Title, SiteAdministrators, LastItemModifiedDate, IsRootWeb | Where-Object {$_.LastItemModifiedDate -lt $LeastActiveSiteDate -and $_.IsRootWeb -eq $false } | sort LastItemModifiedDate -descending)                                                                                                                                                 

$B = $LeastActiveSites | measure
$LeastActiveSitesCount=$B.count
Write-Output "Count :$LeastActiveSitesCount"

$Top10LeastActiveSites = $LeastActiveSites | Select URL, Title, SiteAdministrators, LastItemModifiedDate -First 10 
foreach ($objcoll in $Top10LeastActiveSites)
{
  
        $leastActiveUrlTitle = $objcoll.URL+"~!~ "+$objcoll.Title +"~!~ "
        $leastActiveAdmin = $objcoll.SiteAdministrators
        $leastActiveDate = "~!~ "+$objcoll.LastItemModifiedDate
        $leastActiveResult =$leastActiveUrlTitle + $leastActiveAdmin +$leastActiveDate + "}"
        Write-Output "$leastActiveResult"
 } 

Write-Output "[Least Active Site Collections]"

$LeastActiveSiteColl = Get-SPSite -Limit All| Select-object URL, LastContentModifiedDate, owner | Where-Object {$_.LastContentModifiedDate -lt ($LeastActiveSCDate)} | sort LastContentModifiedDate -descending 

$C = $LeastActiveSiteColl | measure
$LeastActiveSiteCollCount = $C.count

Write-Output "Count :$LeastActiveSiteCollCount"

$Top10LeastActSiteColl = $LeastActiveSiteColl | Select URL, LastContentModifiedDate, owner  -First 10 

foreach ($objcoll in $Top10LeastActSiteColl)
{
  
        $leastActiveSiteUrl = $objcoll.URL+"~!~ "
        $leastActiveSiteDate = $objcoll.LastContentModifiedDate
        $leastActiveSiteOwner = "~!~ "+$objcoll.Owner
        $leastActiveSiteResult =$leastActiveSiteUrl + $leastActiveSiteDate +$leastActiveSiteOwner + "}"
        Write-Output "$leastActiveSiteResult"
} 

Write-Output "[Most Active Site collections]"
$MostActiveSiteColl = Get-SPSite -Limit All| Select URL, LastContentModifiedDate, owner | Where-Object {$_.LastContentModifiedDate -gt ($yesterdayDate)} | sort LastContentModifiedDate -descending 

$D = $MostActiveSiteColl | measure

$MostActiveSiteCollCount=$D.count
  
 
write-output "Count :  $MostActiveSiteCollCount" 

$Top10MostActSiteColl=$MostActiveSiteColl | Select URL, LastContentModifiedDate, owner  -First 10 

forEach ($objcoll in $Top10MostActSiteColl)
{
  
        $mostActiveSiteUrl = $objcoll.URL+"~!~ "
        $mostActiveSiteDate = $objcoll.LastContentModifiedDate
        $mostActiveSiteAdmin = "~!~ "+$objcoll.owner
        $mostActiveSiteResult =$mostActiveSiteUrl + $mostActiveSiteDate +$mostActiveSiteAdmin + "}"
        Write-Output "$mostActiveSiteResult"
 } 


write-output "[Quota Limit]"

$ResQuotaExceeded = Get-SPSite -Limit All| Select URL, @{Name=”Storage”; Expression={“{0:N2} MB” -f
($_.Usage.Storage/1000000)}}, @{Name=”Quota”; Expression={“{0:N2} MB” -f
($_.Quota.StorageMaximumLevel/1000000)}}, ResourceQuotaExceeded | Where-Object {$_.ResourceQuotaExceeded -eq "True"}

$E = $ResQuotaExceeded | measure
$ResQuotaExceededCount=$E.count

write-output "Count :  $ResQuotaExceededCount"

$ResQuotaExceeded = $ResQuotaExceeded | Select URL, Storage, Quota -first 10
#$ResQuotaExceeded | FL
forEach ($objcoll in $ResQuotaExceeded)
{
    write-output $objcoll.URL "~!~ " $objcoll.Storage "~!~ " $objcoll.Quota "}"
} 

Exit-PSSession