$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$hvModuleHelper="VMware.HV.Helper.psm1"
[string]$eGInstallDir = $args[0]
$hvModule=$eGInstallDir+"\"+$hvModuleHelper

Import-Module -Name VMware.VimAutomation.HorizonView -EA SilentlyContinue
Import-Module -Name $hvModule -Force -EA SilentlyContinue

function Get-ViewAPIService {
  param(
    [Parameter(Mandatory = $false)]
    $HvServer
  )
  if ($null -ne $hvServer) {
    if ($hvServer.GetType().name -ne 'ViewServerImpl') {
      $type = $hvServer.GetType().name
      Write-Error "Expected hvServer type is ViewServerImpl, but received: [$type]"
      return $null
    }
    elseif ($hvServer.IsConnected) {
      return $hvServer.ExtensionData
    }
  } elseif ($global:DefaultHVServers.Length -gt 0) {
     $hvServer = $global:DefaultHVServers[0]
     return $hvServer.ExtensionData
  }
  return $null
}

$hzUser = $args[1]
$hzPass = $args[2]
$DirPath = $eGInstallDir + "\OE.exe"
& $DirPath $hzPass | Tee-Object -Variable pwd | Out-Null
$hzDomain = $args[3]
[string]$hzConnStr = $args[4]
$totalConnectionServers = New-Object -TypeName System.Collections.Generic.List[string]
$hzConnSvrList = $hzConnStr.Split(",")
$foundServer = ""
$Global:ErrorActionPreference="SilentlyContinue"
Set-PowerCLIConfiguration -Scope User -ParticipateInCEIP $false -confirm:$false |out-null
Set-PowerCLIConfiguration -InvalidCertificateAction Ignore -confirm:$false |out-null

if($hzConnSvrList.count -eq 1)
{
	try
	{
		# Establish connection to Connection Server
		$hvServer = Connect-HVServer -Server $hzConnStr -User $hzUser -Password $pwd -Domain $hzDomain
		$foundServer = $hzConnStr
	}
	catch
	{
		write-host $Error[0]
		write-host "Not able to connect to the server $hzConnStr"
		break
	}
}
else
{
	foreach($Server in $hzConnSvrList)
	{
		$totalConnectionServers.Add($Server)
	}
}

foreach($Server in $totalConnectionServers)
{
	try
	{
		$hvServer = Connect-HVServer -Server $Server -User $hzUser -Password $pwd -Domain $hzDomain
		$foundServer = $Server
		if($hvServer -ne $null)
		{
			break
		}
	}
	catch
	{
		write-host $Error[0]
		write-host "Not able to connect to the server $hzConnStr"
	}
}

if($foundServer -eq "" -or $foundServer.Length -eq 0)
{
	write-host "Not able to connect any of the given connection servers"
	break
}

$Global:hvServices = $hvServer.ExtensionData
$services = Get-ViewAPIService -hvServer $hvServer
$vc_service_helper = New-Object VMware.Hv.VirtualCenterService
$vcList = $vc_service_helper.VirtualCenter_List($services)

cls

write-host "POD"
write-host "------"
$Sites = $services.Site.Site_List()
if($Sites -ne $null)
{
	foreach($Site in $Sites)
	{
	    $SiteBase = $Site.Base
	    $SiteDisplayName = $SiteBase.DisplayName
	    $PodIDs = $Site.Pods
	    foreach($PodID in $PodIDs)
	    {
		    $PodInfo = $services.pod.pod_get($PodID)
		    $PodDisplayName = $PodInfo.DisplayName
		    if($PodInfo.LocalPod -eq $True)
		    {
			    $PodEndpointIDs = $PodInfo.Endpoints
			    foreach($PodEndpointID in $PodEndpointIDs)
			    {
				    $PodEndpoint = $services.PodEndpoint.PodEndpoint_Get($PodEndpointID)
				    Write-Host($SiteDisplayName,$PodDisplayName,$PodEndpoint.name,$PodEndpoint.serverAddress,$PodEndpoint.enabled) -Separator "#" 
			    }
		    }
	    }
	}
}
else
{
	$connection_service_helper = New-Object VMware.Hv.ConnectionServerService
	$connList = $connection_service_helper.ConnectionServer_List($services)
	$SiteDisplayName = "-"
	$PodDisplayName = "-"
    foreach($connsrv in $connList)
	{
        $SiteDisplayName = $connsrv.General.ClusterName
        $PodDisplayName = $connsrv.General.ClusterName
		Write-Host($SiteDisplayName,$PodDisplayName,$connsrv.General.name,$connsrv.General.serverAddress,$connsrv.General.enabled) -Separator "#"
	}
}

write-host

Write-Host "Pools"
Write-Host "--------"

$pools = get-hvpool
if($pools -ne $null)
{
	foreach($pool in $pools)
	{
		$headroomcount = -5
		$maximumcount = -5
		$minimumcount = -5
		$vcServerName = -5

		$DesktopBase = $pool.Base
		$id = $DesktopBase.Name
		$displayName = $DesktopBase.DisplayName

		$DesktopSettings = $pool.DesktopSettings
		$enabled = $DesktopSettings.Enabled
		$deliveryModel = $pool.Type
		$desktopSource = $pool.Source
		$EnableProvisioning = $False
		if($deliveryModel -eq "AUTOMATED")
		{
			$DesktopData = $pool.AutomatedDesktopData
			$EnableProvisioning = $DesktopData.VirtualCenterProvisioningSettings.EnableProvisioning
			$VmNamingSettings = $DesktopData.VmNamingSettings
			$PatternNamingSettings = $VmNamingSettings.PatternNamingSettings
			$maximumcount = $PatternNamingSettings.MaxNumberOfMachines
			$minimumcount = $PatternNamingSettings.MinNumberOfMachines
			$headroomcount = $PatternNamingSettings.NumberOfSpareMachines
			if($minimumcount -eq $null -or $minimumcount.length -eq 0) {$minimumcount = -5}
			if($maximumcount -eq $null -or $maximumcount.length -eq 0) {$maximumcount = -5}
			if($headroomcount -eq $null -or $headroomcount.length -eq 0) {$headroomcount = -5}
		}
		elseif($deliveryModel -eq "MANUAL")
		{
			$DesktopData = $pool.ManualDesktopData
		}

		if($DesktopData.VirtualCenter -ne $null)
		{
			$vcid = $DesktopData.VirtualCenter.Id
			foreach($vCenter in $vcList)
			{
				if($vCenter.Id.Id -eq $vcid)
				{
					$vcServerSpec = $vCenter.ServerSpec
					$vcServerName = $vcServerSpec.ServerName +":" +  $vcServerSpec.Port
					if($vcServerName -eq $null -or $vcServerName.length -eq 0)
					{
						$vcServerName = "-"
					}
					break
				}
			}
		}
		$poolType = $deliveryModel
		write-host ($id, $displayName,$enabled, $deliveryModel, $desktopSource,$vcServerName, $poolType, $headroomcount, $maximumcount, $minimumcount,$EnableProvisioning) -Separator "#"
	}
}

write-host
Write-Host "poolentitlement starts"
Write-host "-----------------------"
if($pools -ne $null)
{
	foreach($pool in $pools)
	{
        $outLines = @()
		$DesktopBase = $pool.Base
		$id = $DesktopBase.Name
		$GlobalEntitlementData = $pool.GlobalEntitlementData
		$geID = $GlobalEntitlementData.GlobalEntitlement
		if($geID -ne $null)
		{
			$AndFilter = Get-HVQueryFilter 'globalData.globalEntitlements' -Contains ([VMware.Hv.GlobalEntitlementId[]]$geID)
			$AndFilter = Get-HVQueryFilter -And -Filters $AndFilter
			$results1 = (Get-HVQueryResult -EntityType EntitledUserOrGroupGlobalSummaryView -Filter $AndFilter -HvServer $HvServer) 
			$results1 = $results1 | where {$_.globalData.globalEntitlements -ne $null}
			$outLines += $results1
		}
		$AndFilter = Get-HVQueryFilter 'localData.desktops' -Contains ([VMware.Hv.DesktopId[]]$pool.Id)
		$AndFilter = Get-HVQueryFilter -And -Filters $AndFilter
		$results2 = (Get-HVQueryResult -EntityType EntitledUserOrGroupLocalSummaryView -Filter $AndFilter -HvServer $HvServer)
		$results2 = $results2 | where {$_.localData.desktops -ne $null}
		$outLines += $results2

		if($outLines -ne $null)
		{
            foreach($results in $outLines)
            {
			    $users = $results.base
			    foreach($user in $users)
			    {
				    Write-Host ($id,$user.DisplayName) -Separator "#"
			    }
            }
		}
	}
}

write-host
Write-Host "Desktops starts"
write-host "-----------------"
if($pools -ne $null)
{
	foreach($pool in $pools)
	{
		$DesktopBase = $pool.Base
		$id = $DesktopBase.Name
		$desktopSource = $pool.Source
		if($desktopSource -eq "VIRTUAL_CENTER" -or $desktopSource -eq "VIEW_COMPOSER" -or $desktopSource -eq "INSTANT_CLONE_ENGINE")
		{
			$machines = Get-HVMachine -poolname $id
			if($machines -ne $null)
			{
				foreach($machine in $machines)
				{
					$machineBase = $machine.Base
					$Name = $machineBase.Name
					if($Name -eq $null -or $Name.length -eq 0)
					{
						$Name = "-"
					}
					$GuestFullName = $machineBase.OperatingSystem
					if($GuestFullName -eq $null -or $GuestFullName.length -eq 0)
					{
						$GuestFullName = "-"
					}
					$HostName = $machineBase.DnsName
					if($HostName -eq $null -or $HostName.length -eq 0)
					{
						$HostName = "-"
					}
					$IPAddress = $HostName
					$isInPool = $true
					$machine_id = $Name
					$ManagedMachineData = $machine.ManagedMachineData
					$VirtualCenterData = $ManagedMachineData.VirtualCenterData
					$Path = $VirtualCenterData.Path
					$ServerGroup = $id
					$BasicState = $machineBase.BasicState
					Write-Host ($id,$Name,$Path, $GuestFullName, $HostName, $IPAddress, $isInPool,$machine_id,$ServerGroup,$BasicState) -Separator "#"
				}
			}
		}
		elseif($desktopSource -eq "RDS")
		{
			$RdsDesktopData = $pool.RdsDesktopData
			if($RdsDesktopData -ne $null)
			{
				$FarmID = $RdsDesktopData.Farm
				$FarmInfo = $services.Farm.Farm_GetSummaryView($FarmID)
				if($FarmInfo -ne $null)
				{
					$farmData = $FarmInfo.Data
					$Path = "-"
					$GuestFullName = "-"
					$isInPool = $true
					$Enabled = $farmData.Enabled
					if($Enabled -eq $null -or $Enabled.length -eq 0)
					{
						$Enabled = 0	#0 means Enabled   1 means Disabled		
					}
					$MaxConns = $farmData.MaximumNumberOfSessions
					if($MaxConns -eq $null -or $MaxConns.length -eq 0)
					{
						$MaxConns = 150
					}
					$farmHealth = $services.FarmHealth.FarmHealth_Get($FarmID)
					if($farmHealth -ne $null)
					{
						$name = $farmHealth.Name
						$RDSServersHealth = $farmHealth.RDSServerHealth
						foreach($RDSServer in $RDSServersHealth)
						{
							$HostName = "-"
							$IPAddress = "-"
							$machine_id = "-"
							$ServerGroup = "-"
							$BasicState = "-"

							$IPAddress = $RDSServer.Name
							$machine_id = $RDSServer.Name
							$HostName = $RDSServer.Name  
							$BasicState = $RDSServer.Status

							Write-Host ($id,$name,$Path, $GuestFullName, $HostName, $IPAddress, $isInPool,$machine_id,$ServerGroup,$BasicState,$Enabled,$MaxConns) -Separator "#"
						}
					}
				}
			}
		}
	}
}


write-host
Write-Host "PoolsUsage"
Write-Host "----------"
$PodSessions = get-hvlocalsession
if($podSessions -ne $null)
{
	foreach($session in $podSessions)
	{
		$NamesData = $session.NamesData
		$mac_id = $NamesData.MachineOrRDSServerName
		$SessionData = $session.SessionData
		$userName = $NamesData.userName
		$SessUniqID = $session.id.id
		if($userName -eq $null -or $userName.length -eq 0)
		{
			$userName = "-"
		}
		$DNSName = $NamesData.MachineOrRDSServerDNS
		if($DNSName -eq $null -or $DNSName.length -eq 0)
		{
			$DNSName = "-"
		}
		$startTime = $SessionData.startTime
		if($startTime -eq $null -or $startTime.length -eq 0)
		{
			$startTime = "-"
		}
		$duration = $SessionData.LastSessionDurationMS
		if($duration -eq $null -or $duration.length -eq 0)
		{
			$duration = "-"
		}
		$state = $SessionData.SessionState
		if($state -eq $null -or $state.length -eq 0)
		{
			$state = "-"
		}
		$protocol = $SessionData.SessionProtocol
		if($protocol -eq $null -or $protocol.length -eq 0)
		{
			$protocol = "-"
		}
		$session_id = $SessionData.SessionType
		if($session_id -eq $null -or $session_id.length -eq 0)
		{
			$session_id = "-"
		}
		$pool_id = $NamesData.DesktopName
		if($pool_id -eq $null)
		{
			$pool_id = $NamesData.FarmName
		}
		Write-Host ($pool_id,$userName,$startTime, $DNSName, $duration, $mac_id, $state, $protocol, $session_id, $SessUniqID) -Separator "#"
	}
}

Write-Host

Write-Host "RDS Applications"
Write-Host "------------------"
$AppForRDSServers = New-Object -TypeName System.Collections.Generic.List[string]
$MissingAppForRDSServers = New-Object -TypeName System.Collections.Generic.List[string]
$query_service_helper = New-Object VMware.Hv.QueryServiceService
$defn = New-Object VMware.Hv.QueryDefinition
$defn.queryEntityType = 'ApplicationInfo'
$queryResults = $query_service_helper.QueryService_Query($services,$defn)
$AppsInfo = $queryResults.results

if($AppsInfo -ne $null)
{
	foreach($AppInfo in $AppsInfo)
	{
		$MissingAppExists = $false
		$AppForRDSServers.Clear()
		$MissingAppForRDSServers.Clear()
		$AppData = $AppInfo.data
		$AppDisplayName = $AppData.Name
		$AppEnabled = $AppData.enabled
		$farmID = $AppInfo.executionData.farm
		$farmHealth = $services.FarmHealth.FarmHealth_Get($farmID)
		if($farmHealth -ne $null)
		{
			$fname = $farmhealth.name
			$RDSServersHealth = $farmHealth.RDSServerHealth
			foreach($RDSServer in $RDSServersHealth)
			{
				$IPAddress = $RDSServer.Name
				$AppForRDSServers.Add($IPAddress)
				$MissingApplications = $RDSServer.MissingApplications
				if($MissingApplications -ne $null)
				{
					foreach($missingApps in $MissingApplications)
					{
						
						if($missingApps.Name -eq $AppDisplayName)
						{
							$MissingAppExists = $true
							$MissingAppForRDSServers.add($IPAddress)
						}
					}
				} 
			}
			write-host ($AppDisplayName,$fname, $AppForRDSServers,$AppEnabled,$MissingAppExists,$MissingAppForRDSServers) -Separator "#"  
		}
	}
}

write-host
write-host "RDS Farms"
Write-host "-----------"
$farms = get-hvfarm -SuppressInfo $true
if($farms -ne $null)
{
	foreach($farm in $farms)
	{
		$farmId = $farm.ID
		$farmtype = $farm.Type
		$FarmInfo = $services.Farm.Farm_GetSummaryView($FarmID)
		if($FarmInfo -ne $null)
		{
			$farmData = $FarmInfo.Data
			$Path = "-"
			$GuestFullName = "-"
			$isInPool = $true
			$Enabled = $farmData.Enabled
			if($Enabled -eq $null -or $Enabled.length -eq 0)
			{
				$Enabled = 0	#0 means Enabled   1 means Disabled		
			}
			$MaxConns = $farmData.MaximumNumberOfSessions
			if($MaxConns -eq $null -or $MaxConns.length -eq 0)
			{
				$MaxConns = 150
			}
			$farmHealth = $services.FarmHealth.FarmHealth_Get($FarmID)
			if($farmHealth -ne $null)
			{
				$name = $farmHealth.Name
				$RDSServersHealth = $farmHealth.RDSServerHealth
				foreach($RDSServer in $RDSServersHealth)
				{
					$HostName = "-"
					$IPAddress = "-"
					$machine_id = "-"
					$ServerGroup = "-"
					$BasicState = "-"

					$IPAddress = $RDSServer.Name
					$machine_id = $RDSServer.Name
					$HostName = $RDSServer.Name  
					$BasicState = $RDSServer.Status
					Write-Host ($name,$Path, $GuestFullName, $HostName, $IPAddress, $isInPool,$machine_id,$ServerGroup,$BasicState,$Enabled,$MaxConns) -Separator "#"
				}
			}
		}
	}
}
write-host
write-host "Date Format"
Write-host "-----------"
$f = (get-culture).datetimeformat.ShortDatePattern
$h = (get-culture).datetimeformat.LongTimePattern
Write-host "$f $h"


Disconnect-HVServer -confirm:$false
