$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply Server name"
	break
}

$ServerName = $args[0]
$Global:ErrorActionPreference="SilentlyContinue"
$svr = Get-ExchangeServer $ServerName 
$version = $svr.AdminDisplayVersion

if($version.Major -lt 14)
{
	break
}

$mbdbs = Get-MailboxDatabase -Server $ServerName -Status
foreach ($mbdb in $mbdbs) 
{
	Write-Host ($mbdb.Name,$mbdb.Mounted,$mbdb.DatabaseSize) -Separator ";"
}
