$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn

$tests = get-healthreport -server $env:computername  | where {$_.alertvalue -ne "healthy"} 

foreach($line in $tests)
{
	$results = $line.entries | where {$_.alertvalue -ne healthy} 
	foreach($result in $results)
        {
		$healthset = $line.HealthSet
		$name = $result.Name
		$targetresource = $result.TargetResource
		if ($targetresource -eq "")
		{
			$targetresource = "-"
		}
		$alertvalue = $result.AlertValue
		$lastexeresult = $result.LastExecutionresult
		$lastexetime = $result.LastExecutionTime
		write-host($healthset,$name,$targetresource,$alertvalue,$lastexeresult,$lastexetime) -separator ";"
      }
}
remove-pssnapin Microsoft.Exchange.Management.PowerShell.SnapIn