[CmdletBinding()]
param
(
    [Switch] $ShowPrivilegedAccountsOnly,
    [Switch] $ShowSystemAccounts
)

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}


$Show
$hpa=0
$npa=0
$lpa=0
$sa=0
$outfile = @()
$domain = [system.directoryservices.activedirectory.domain]::GetCurrentDomain()
$ADSearcher = New-Object System.DirectoryServices.DirectorySearcher
$ADSearcher.PageSize = 100000
$ADSearcher.Filter = "(&(objectCategory=person)(objectClass=user))"
$UserProperties = @("samaccountname","whenChanged","LastLogontimestamp","CanonicalName","DistinguishedName","MemberOf","Description","mail","whenCreated","isdisabled","lastlogondate","pwdLastSet","GivenName","userAccountControl","accountExpires","ispasswordnotrequired","isPasswordNeverExpires","accountExpirationdate","isCriticalSystemObject","isPreAuthNotRequired")
$ADSearcher.PropertiesToLoad.AddRange(@($UserProperties))

$ObjDeDomain = [ADSI] "LDAP://$($domain)"
$ADSearcher.SearchRoot = $ObjDeDomain
$getalluser = @()
$getalluser = $ADSearcher.FindAll()
Write-Host
Write-Host "Number of Users in AD: " $getalluser.count
Write-Host

foreach ($getuser in $getalluser)
{
    $user = $getuser.GetDirectoryEntry()
    [string]$accountExpires = $user.accountExpires
	[string]$accountExpirationdate = $user.accountExpirationdate
	[string]$userAccountControl = $user.userAccountControl
	[string]$GivenName=$user.GivenName
	[string]$samaccountname= $user.samaccountname
	[string]$whenChanged= $user.whenChanged
	[string]$CanonicalName= $user.CanonicalName
	[string]$DistinguishedName= $user.DistinguishedName
	[string]$MemberOf= $user.MemberOf
	[string]$Description= $user.Description
	[string]$mail= $user.mail
    [string]$whenCreated= $user.whenCreated
    
    if($userAccountControl -band 2 )
    {
        write-host "$samaccountname account is disabled"
        [string]$isdisabled="Yes"
    }
    else
    {
    [string]$isdisabled="no"
    }
	if($userAccountControl -band 8388608 )
    {
    [string]$ispasswordexpired="Yes"
    }
    else    
    {
    [string]$ispasswordexpired="no"
    }
	if($userAccountControl -band 16 )
    {
    [string]$islocked="Yes"
    }
    else
    {
    [string]$islocked="no"
    }
    If($isdisabled -like "*Yes*" -or $islocked -like "*Yes*" -or $ispasswordexpired -like "*Yes*")
	{
	    [string]$IsInactive="Yes"
	}
	else
	{
	    [string]$IsInactive="No"
	}
 
 	If($MemberOf -like "*Domain Admin*" -or $MemberOf -like "*Administrators*" -or $MemberOf -like "*Enterprise Admin*" -or $MemberOf -like "*Schema Admin*")
	{
	    $accountType = "High Privilege Account"
        $hpa+=1
	}
	elseIf($MemberOf -like "*server operator*" -or $MemberOf -like "*backup operator*" )
	{
	    $accountType = "Limited Privilege Account"
        $lpa+=1
	}
	elseIf($Description -like "Built-in*")
	{
	    $accountType = "System Account" 
        $sa+=1
	}
	else
	{
	    $accountType = "Non privileged account"
        $npa+=1
	}

    $object = new-object psobject

    $object | add-member -membertype noteproperty -Name "SamAccountName" -Value $samaccountname
    $object | add-member -membertype noteproperty -Name "GivenName" -Value $GivenName
    $object | add-member -membertype noteproperty -Name "DistinguishedName" -Value $DistinguishedName
    $object | add-member -membertype noteproperty -Name "UserAccountControl" -Value $userAccountControl
    $object | add-member -membertype noteproperty -Name "Mail" -Value $mail
    $object | add-member -membertype noteproperty -Name "WhenCreated" -Value $whenCreated
    $object | add-member -membertype noteproperty -Name "MemberOf" -Value $memberof
    $object | add-member -membertype noteproperty -Name "Domain" -Value "$domain"
    $object | add-member -membertype noteproperty -Name "Description" -Value $Description
    $object | add-member -membertype noteproperty -Name "WhenChanged" -Value $whenChanged
    $object | add-member -membertype noteproperty -Name "isdisabled" -Value $isdisabled
    $object | add-member -membertype noteproperty -Name "ObjectType" -Value $accountType
    $object | add-member -membertype noteproperty -Name "IsInactive" -Value $IsInactive
    $object | add-member -membertype noteproperty -Name "IsLocked" -Value $islocked
    $object | add-member -membertype noteproperty -Name "IsPasswordExpired" -Value $ispasswordexpired
    
    if($accountType -eq "High Privilege Account" -and $ShowPrivilegedAccountsOnly -eq $true)
    {
        $outfile+=$object
        $outfile+="-------------" 
    }

    if($accountType -eq "System Account" -and $ShowSystemAccounts -eq $True)
    {
        $outfile+=$object
        $outfile+="-------------" 
    }
       
    $user = ""
    $accountExpires = ""
	$accountExpirationdate = ""
	$userAccountControl = ""
	$GivenName=""
	$samaccountname= ""
	$whenChanged= ""
	$CanonicalName= ""
	$DistinguishedName= ""
	$MemberOf= ""
	$Description= ""
	$mail= ""
    $whenCreated= ""
    $IsInactive=""
    $accountType=""
    $islocked=""
    $ispasswordexpired = ""
    $isdisabled=""
}
Write-host "High Privileged Account = $hpa"
Write-host "Limited Privileged Account = $lpa"
Write-host "System Accounts = $SA"
Write-host "Non privileged account = $npa"

if($ShowPrivilegedAccountsOnly -eq $true -or $ShowSystemAccounts -eq $true)
{
    $outfile
}
