$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$DebugPreference = "Stop"
$name = $args[0]
$Sid = (New-Object System.Security.Principal.NTAccount($name)).Translate([System.Security.Principal.SecurityIdentifier]).value
$Path = "HKEY_USERS\"+$Sid+"\SOFTWARE\Microsoft\Windows\CurrentVersion\Group Policy"
reg delete $Path /f
$ExplorerProcess = @(tasklist /FI "IMAGENAME eq explorer.exe" /FI "USERNAME eq $name" /FO LIST)
if($ExplorerProcess -ne $null -and $ExplorerProcess.Count -eq 6) {
    $ExplorerPid = $ExplorerProcess[2]
    $SessionId = $ExplorerProcess[4]
    $tPid = -1
    $tSessionId = -1
    
    if($ExplorerPid -ne $null)
    {
        $tPid = $ExplorerPid.split(":")[1].trim()
        Write-Host "The Explorer pid is $tPid"
    }
    if($SessionId -ne $null)
    {
        $tSessionId = $SessionId.split(":")[1].trim()
        Write-Host "The Session id is $tSessionId"
    }
    taskkill /PID $tPid /f
    
}
