$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Function Get-RegistryKeyPropertiesAndValues
{
    Param(
            [Parameter(Mandatory=$true)]
            [string]$Path
         )
              Push-Location
    Set-Location -Path $Path
    Get-Item . |
                             Select-Object -ExpandProperty property |
                                           ForEach-Object {
                                                          New-Object -TypeName psobject -Property @{"Folder"=$_;
                                                                        "RedirectedLocation" = (Get-ItemProperty -Path . -Name $_).$_}}
    Pop-Location
}
 
$Profilepath = [regex]::Escape($env:USERPROFILE)
# List all folders
$PATH = 
$RedirectedFolders = Get-RegistryKeyPropertiesAndValues -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders" | Where-Object {$_.RedirectedLocation -notmatch "$Profilepath"}
if ($RedirectedFolders -eq $null)
{
    Write-Output "No folders are redirected for this user"
}
else
{
    $RedirectedFolders | Format-Table -Autosize
}
