const {
  Worker,
} = require('worker_threads');

const logger = require('../logger');
const appendMsg = 'Comm-thread:';

function Communicator(collector) {
  this.collector = collector;
  this.worker = new Worker(__dirname + '/socket-worker.js');

  this.worker.on('message', (message) => {
    if (!message) return;

    if (message.action === 'stopTracing') {
      this.collector.agent.stopTracing();
    } else if (message.action === 'startTracing') {
      this.collector.agent.startTracing();
    } else if (message.action === 'configChanged') {
      this.collector.onConfigChange(message.config);
    } else if (message.action === 'newComponentDetails') {
      this.collector.onNewComponent(message.data);
    }
  });
}
module.exports = Communicator;

Communicator.prototype.start = function (config, runTimeInfo) {
  this.config = config;
  this.ip = config && config.agent_host;
  this.port = config && config.agent_port;

  if (!this.ip || !this.port) {
    logger.error(appendMsg, 'not a valid socket ip or port');
    return;
  }

  this.worker.postMessage({
    action: 'startSocket',
    runTimeInfo,
    config
  });
}

Communicator.prototype.stop = function () {
  this.worker.postMessage('stopSocket');
}

Communicator.prototype.resetConnection = function () {
  this.worker.postMessage('resetConnection');
}

Communicator.prototype.add = async function (metrics) {
  this.worker.postMessage({
    action: 'add',
    metrics
  });
}

Communicator.prototype.sendFile = function (type, payload) {
  this.worker.postMessage({
    action: 'sendFile',
    type,
    payload
  });
}

Communicator.prototype.setConfig = function (config) {
  this.worker.postMessage({
    action: 'setConfig',
    config
  });
}

Communicator.prototype.setTimeout = function () {
  this.worker.postMessage('setTimeout');
}