﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Function Get-LocalTime(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$dat, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$hr
    )
    Process
    {
        $ltimArr=@()
        $UTCTime=[DateTime]$dat
        $UTCTime=$UTCTime.AddHours([int]$hr)
        $strCurrentTimeZone = (Get-WmiObject win32_timezone).StandardName
        $TZ = [System.TimeZoneInfo]::FindSystemTimeZoneById($strCurrentTimeZone)
        $LocalTime = [System.TimeZoneInfo]::ConvertTimeFromUtc($UTCTime, $TZ)
        $ltimArr+='{0:yyyy-MM-dd}' -f $LocalTime
        $ltimArr+=(Get-Date $LocalTime).Hour
        Return $ltimArr
    }
}
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$prxyCrds=$TestInputs[3].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[4]).ToString().trim()
$shwTopNDD=[int]$TestInputs[5]
$fetchDomains=$TestInputs[6].ToString().Trim()
$rptNam=$TestInputs[7]
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

#####################################################
$componentnam='Microsoft_Teams_domain'
$ps1FileName=$MyInvocation.MyCommand.Name
$isRunMainset=$false
$sprsetNam=Domains-GetSuperset -UserName $userName -Password $password -ProxyServerIP $proxyserverip -ProxyUser $proxyUsr -ProxyPassword $proxyPass

$ticks_dtlsArr= Domains-ReadFrmINI -ps1FileName $ps1FileName -RptName $rptNam -ComponentName $componentnam -EncType $encTyp
if($ticks_dtlsArr -eq $null -or $ticks_dtlsArr.Count -eq 0){
    $curTicks=(get-Date).Ticks
    Domains-WriteToINI -ps1FileName $ps1FileName -RptNam $rptNam -SfolderNam $sprsetNam -ticks $curTicks -componentNam $componentnam -encTyp $encTyp
    $isRunMainset=$true
}else{
    $curTicks=(get-Date).Ticks
    $stTicks=[long]$ticks_dtlsArr[2]
    $TimeFromTicks = [datetime]$stTicks
    $diff=((get-Date)-$TimeFromTicks)
    if($mPeriodInMin -le $diff.Minutes){
        Domains-WriteToINI -ps1FileName $ps1FileName -RptNam $rptNam -SfolderNam $sprsetNam -ticks $curTicks -componentNam $componentnam -encTyp $encTyp
        $isRunMainset=$true
    }  
}

$superSetPath='MTM/'+$sprsetNam
$superSetDir=$egurkhaPath+'/agent/MTM/'+$sprsetNam
if(!(Test-Path -Path $superSetDir )){
    New-Item -ItemType directory -Path $superSetDir
}
##################################################
if($isRunMainset){
    $scallsumStrms = Eg-WriteFile -ComntRptPath $superSetPath -FileName "MTDCallSummary" -keyFileName "kMTDCallSummary" -EgPath $egurkhaPath
    Try{
        $measures='Measures.Total Stream Count','Measures.Total CDR Available Stream Count','Measures.Total Media Failed Stream Count','Measures.Total Call Setup Failed Stream Count','Measures.Total Call Dropped Stream Count','Measures.Total Media Succeeded Stream Count','Measures.Total Call Setup Succeeded Stream Count','Measures.Total Call Setup Failure Percentage','Measures.Total Call Dropped Failure Percentage','Measures.Total Answer Seizure Ratio','Measures.Total Short Call Percentage','Measures.Total Media Failure Percentage','Measures.Avg Call Duration','Measures.Media Failed Due To Firewall DPI Stream Count','Measures.Firewall DPI Media Failure Percentage','Measures.Media Failed Due To Firewall IP Blocked Stream Count','Measures.Firewall IP Blocked Media Failure Percentage','Measures.Media Failed Due To Other Stream Count','Measures.Other Media Failure Percentage'
        $Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Is Teams','AllStreams.First UPN','AllStreams.Second UPN'
        Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled} | Sort-Object -Property 'End Time' -Descending | Export-Csv $scallsumStrms[1] -Encoding $encTyp #-Descending
    }
    Catch{
        $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
        Write-Host $ExcepMsg
    }
    $null=Protect-File  $scallsumStrms[1] -Algorithm AES -KeyAsPlainText $scallsumStrms[0] -RemoveSource
    [System.GC]::GetTotalMemory($true) | out-null
}

$readfiles=Eg-ReadFile -ComntRptPath $superSetPath -FileName "MTDCallSummary" -keyFileName "kMTDCallSummary" -EgPath $egurkhaPath
if([System.IO.File]::Exists($readfiles[1]) -eq 'True'){
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $callSummryCSV=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $mtdcallSummry= import-csv $callSummryCSV -Encoding $encTyp
    Remove-Item $callSummryCSV
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'MTDCallSummary' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kMTDCallSummary' -InputFile $readfiles[4]


    $CalSummryStrms=@()
    $rptPath='MTM/'+$rptNam
    $MyDir=$egurkhaPath+'/agent/MTM/'+$rptNam
    if(!(Test-Path -Path $MyDir )){
        New-Item -ItemType directory -Path $MyDir
    }
    Try{
        $mtdCallSmmryStm = Eg-WriteFile -ComntRptPath $rptPath -FileName "MTDCallSummary" -keyFileName "kMTDCallSummary" -EgPath $egurkhaPath
        foreach($resStrms in $mtdcallSummry){  
            $frstUPNDomain=([String]$resStrms.'First UPN').Trim()
            $secUPNDomain=([String]$resStrms.'Second UPN').Trim()
            if($frstUPNDomain -ne $null -and $frstUPNDomain -ne ''){$frstUPNDomain=$frstUPNDomain.Split('@')[1]}
            if($secUPNDomain -ne $null -and $secUPNDomain -ne ''){$secUPNDomain = $secUPNDomain.Split('@')[1]}
            if(($frstUPNDomain -ne $null -and $frstUPNDomain -ne '' -and $fetchDomains -match $frstUPNDomain) -or ($secUPNDomain -ne $null -and $secUPNDomain -ne '' -and $fetchDomains -match $secUPNDomain)){
                $CalSummryStrms+=$resStrms
                $resStrms| Export-Csv $mtdCallSmmryStm[1] -Encoding $encTyp -Append
            }
        }
        $null=Protect-File  $mtdCallSmmryStm[1] -Algorithm AES -KeyAsPlainText $mtdCallSmmryStm[0] -RemoveSource
    }
    Catch{
        $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "fetchdomain Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
        Write-Host $ExcepMsg
    }

    #############################################

    $latestCalSummry=@()
    if($rptTimNUPN -ne 'none'){
        foreach($strms in $CalSummryStrms){
	    if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
            if($iswrite){
                $latestCalSummry+=$strms
            }
            $chktimNam=$strms.'End Time'+'#'+$strms.'First UPN'+'#'+$strms.'Second UPN'
            if($rptTimNUPN -eq $chktimNam){
                $iswrite=$true
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $CalSummryStrms){
	    if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $latestCalSummry+=$strms 
                }
            }
        }
    }
    $lastObj=$CalSummryStrms |Select-Object -First 1
    $rptEdTimNUPN='LastReporting EndTime and UPN#'+$lastObj.'End Time'+'~'+$lastObj.'First UPN'+'~'+$lastObj.'Second UPN'
    Write-Host $rptEdTimNUPN

    if($latestCalSummry){
        $toalStreamsCnt=0
        $TotalCDRAvailableStreamCount=0
        $TotalMediaFailedStreamCount=0
        $TotalCallSetupFailedStreamCount=0
        $TotalCallDroppedStreamCount=0
        $TotalMediaSucceededStreamCount=0
        $TotalCallSetupSucceededStreamCount=0
        $TotalCallSetupFailurePercentage=0
        $TotalCallDroppedFailurePercentage=0
        $TotalAnswerSeizureRatio=0
        $TotalShortCallPercentage=0
        $TotalMediaFailurePercentage=0
        $AvgCallDuration=0
        $MediaFailedDueToFirewallDPIStreamCount=0
        $FirewallDPIMediaFailurePercentage=0
        $MediaFailedDueToFirewallIPBlockedStreamCount=0
        $FirewallIPBlockedMediaFailurePercentage=0
        $MediaFailedDueToOtherStreamCount=0
        $OtherMediaFailurePercentage=0


        $toalStreamsCnt=($latestCalSummry | where-object { $_.'Total Stream Count' -ne 'NaN' } | Measure-Object "Total Stream Count" -Sum | select Sum).Sum
        if($toalStreamsCnt){
            $TotalCDRAvailableStreamCount=($latestCalSummry | where-object { $_.'Total CDR Available Stream Count' -ne 'NaN' } | Measure-Object "Total CDR Available Stream Count" -Sum | select Sum).Sum

            Write-Host '***************DD for TotalMediaFailedStreamCount Measure****************************'
            $TotalMediaFailedStreamCount=($latestCalSummry | where-object { $_.'Total Media Failed Stream Count' -ne 'NaN' } | Measure-Object "Total Media Failed Stream Count" -Sum | select Sum).Sum
            if($TotalMediaFailedStreamCount){
                $ddforFailedstreams = $latestCalSummry | Where-Object { $_."Total Media Failed Stream Count" -gt 0.001 } | Sort-Object { $_."Total Media Failed Stream Count" -as [int] } -Descending | select -First $shwTopNDD
                foreach($in in $ddforFailedstreams){
                    #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                    #Write-Host 'ddTotalMediaFailedStreamCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'Total Media Failed Stream Count'
                    $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                    $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                    Write-Host 'ddTotalMediaFailedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'Total Media Failed Stream Count'
                }
                $ddforFailedstreams=$null
            }

            Write-Host '***************DD for TotalCallSetupFailedStreamCount Measure****************************'
            $TotalCallSetupFailedStreamCount=($latestCalSummry  | where-object { $_.'Total Call Setup Failed Stream Count' -ne 'NaN' } | Measure-Object "Total Call Setup Failed Stream Count" -Sum | select Sum).Sum
            if($TotalCallSetupFailedStreamCount){
                $ddforTotalCalFiledstreams = $latestCalSummry | Where-Object { $_."Total Call Setup Failed Stream Count" -gt 0.001 } | Sort-Object { $_."Total Call Setup Failed Stream Count" -as [int] } -Descending | select -First $shwTopNDD
                foreach($in in $ddforTotalCalFiledstreams){
                    #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                    $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                    $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                    Write-Host 'ddTotalCallSetupFailedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Total Call Setup Failed Stream Count'
                }
                $ddforTotalCalFiledstreams=$null
            }

            Write-Host '***************DD for TotalCallDroppedStreamCount Measure****************************'
            $TotalCallDroppedStreamCount=($latestCalSummry  | where-object { $_.'Total Call Dropped Stream Count' -ne 'NaN' } | Measure-Object "Total Call Dropped Stream Count" -Sum | select Sum).Sum
            if($TotalCallDroppedStreamCount){
                $ddforTotalCallDroppedStreamCount = $latestCalSummry | Where-Object { $_."Total Call Dropped Stream Count" -gt 0.001 } | Sort-Object { $_."Total Call Dropped Stream Count" -as [int] } -Descending | select -First $shwTopNDD
                foreach($in in $ddforTotalCallDroppedStreamCount){
                    #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                    $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                    $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                    Write-Host 'ddTotalCallDroppedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Total Call Dropped Stream Count'
                }
                $ddforTotalCallDroppedStreamCount=$null
            }

            $TotalMediaSucceededStreamCount=($latestCalSummry | where-object { $_.'Total Media Succeeded Stream Count' -ne 'NaN' } | Measure-Object "Total Media Succeeded Stream Count" -Sum | select Sum).Sum
            $TotalCallSetupSucceededStreamCount=($latestCalSummry | where-object { $_.'Total Call Setup Succeeded Stream Count' -ne 'NaN' } | Measure-Object "Total Call Setup Succeeded Stream Count" -Sum | select Sum).Sum

            Write-Host '***************TotalCallSetupFailurePercentage Measure****************************'
            #$TotalCallSetupFailurePercentage=($latestCalSummry | where-object { $_.'Total Call Setup Failure Percentage' -ne 'NaN' -and $_."Total Call Setup Failure Percentage" -gt 0.001 } | Measure-Object "Total Call Setup Failure Percentage" -Average | select Average).Average
            $TotalCallSetupFailurePercentage=($TotalCallSetupFailedStreamCount/$toalStreamsCnt)*100
            if(-not $TotalCallSetupFailurePercentage){  $TotalCallSetupFailurePercentage=0 }  else { $TotalCallSetupFailurePercentage=$TotalCallSetupFailurePercentage.ToString("#.##") }

            Write-Host '***************TotalCallDroppedFailurePercentage Measure****************************'
            #$TotalCallDroppedFailurePercentage=($latestCalSummry | where-object { $_.'Total Call Dropped Failure Percentage' -ne 'NaN' -and $_."Total Call Dropped Failure Percentage" -gt 0.001 } | Measure-Object "Total Call Dropped Failure Percentage" -Average | select Average).Average
            $TotalCallDroppedFailurePercentage=($TotalCallDroppedStreamCount/$toalStreamsCnt)*100
            if(-not $TotalCallDroppedFailurePercentage){  $TotalCallDroppedFailurePercentage=0 }  else { $TotalCallDroppedFailurePercentage=$TotalCallDroppedFailurePercentage.ToString("#.##") }

            $TotalAnswerSeizureRatio=($latestCalSummry  | where-object { $_.'Total Answer Seizure Ratio' -ne 'NaN' } | Measure-Object "Total Answer Seizure Ratio" -Sum | select Sum).Sum

            Write-Host '***************TotalShortCallPercentage Measure************************************************'
            $totalshortcallcount=0
            $TotalShortCallPercentagelist=($latestCalSummry | where-object { $_.'Total Short Call Percentage' -ne 'NaN' -and $_."Total Short Call Percentage" -gt 0.001 } ) | Select-Object 'Total Stream Count','Total Short Call Percentage' #| Measure-Object "Total Short Call Percentage" -Average | select Average).Average
            foreach($input in $TotalShortCallPercentagelist){
                $totalshortcallcount=$totalshortcallcount+(([float]$input.'Total Short Call Percentage')*([float]$input.'Total Stream Count'))/100
            }
            $TotalShortCallPercentage=($totalshortcallcount/$toalStreamsCnt)*100
            if(-not $TotalShortCallPercentage){  $TotalShortCallPercentage=0 }  else { $TotalShortCallPercentage=$TotalShortCallPercentage.ToString("#.##") }

            Write-Host '***************TotalMediaFailurePercentage Measure****************************'
            <#
            $TotalMediaFailurePercentage=($latestCalSummry | where-object { $_.'Total Media Failure Percentage' -ne 'NaN' -and $_."Total Media Failure Percentage" -gt 0.001 } | Measure-Object "Total Media Failure Percentage" -Average | select Average).Average
            #>
            $TotalMediaFailurePercentage=($TotalMediaFailedStreamCount/$toalStreamsCnt)*100
            if(-not $TotalMediaFailurePercentage){  $TotalMediaFailurePercentage=0 }  else { $TotalMediaFailurePercentage=$TotalMediaFailurePercentage.ToString("#.##") }

            $AvgCallDuration=($latestCalSummry | where-object { $_.'Avg Call Duration' -ne 'NaN' -and $_."Avg Call Duration" -gt 0.001 } | Measure-Object "Avg Call Duration" -Average | select Average).Average
            if(-not $AvgCallDuration){  $AvgCallDuration=0 }  else { $AvgCallDuration=$AvgCallDuration.ToString("#.##") }

            Write-Host '***************DD for MediaFailedDueToFirewallDPIStreamCount Measure****************************'
            $MediaFailedDueToFirewallDPIStreamCount=($latestCalSummry | where-object { $_.'Media failed due to firewall DPI stream count' -ne 'NaN' } | Measure-Object "Media failed due to firewall DPI stream count" -Sum | select Sum).Sum
            if($MediaFailedDueToFirewallDPIStreamCount){
                $ddforMediaFailedDueToFirewallDPIStreamCount = $latestCalSummry | Where-Object { $_."Media failed due to firewall DPI stream count" -gt 0.001 } | Sort-Object { $_."Media failed due to firewall DPI stream count" -as [int] } -Descending | select -First $shwTopNDD
                foreach($in in $ddforMediaFailedDueToFirewallDPIStreamCount){
                    #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                    $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                    $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                    Write-Host 'ddMediaFailedDueToFirewallDPIStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Media failed due to firewall DPI stream count'
                }
                $ddforMediaFailedDueToFirewallDPIStreamCount=$null
            }

            Write-Host '*************** FirewallDPIMediaFailurePercentage Measure****************************'
            #$FirewallDPIMediaFailurePercentage=($latestCalSummry  | where-object { $_.'Firewall DPI Media Failure Percentage' -ne 'NaN' -and $_."Firewall DPI Media Failure Percentage" -gt 0.001 } | Measure-Object "Firewall DPI Media Failure Percentage" -Average | select Average).Average
            $FirewallDPIMediaFailurePercentage=($MediaFailedDueToFirewallDPIStreamCount/$toalStreamsCnt)*100
            if(-not $FirewallDPIMediaFailurePercentage){  $FirewallDPIMediaFailurePercentage=0 }  else { $FirewallDPIMediaFailurePercentage=$FirewallDPIMediaFailurePercentage.ToString("#.##") }

            Write-Host '***************DD for MediaFailedDueToFirewallIPBlockedStreamCount Measure****************************'
            $MediaFailedDueToFirewallIPBlockedStreamCount=($latestCalSummry | where-object { $_.'Media Failed Due To Firewall IP Blocked Stream Count' -ne 'NaN' } | Measure-Object "Media Failed Due To Firewall IP Blocked Stream Count" -Sum | select Sum).Sum
            if($MediaFailedDueToFirewallIPBlockedStreamCount){
                $ddforMediaFailedDueToFirewallIPBlockedStreamCount = $latestCalSummry | Where-Object { $_."Media Failed Due To Firewall IP Blocked Stream Count" -gt 0.001 } | Sort-Object { $_."Media Failed Due To Firewall IP Blocked Stream Count" -as [int] } -Descending | select -First $shwTopNDD
                foreach($in in $ddforMediaFailedDueToFirewallDPIStreamCount){
                    #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                    $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                    $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                    Write-Host 'ddMediaFailedDueToFirewallIPBlockedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Media Failed Due To Firewall IP Blocked Stream Count'
                }
                $ddforMediaFailedDueToFirewallIPBlockedStreamCount=$null
            }

            Write-Host '*************** FirewallIPBlockedMediaFailurePercentage Measure****************************'
            #$FirewallIPBlockedMediaFailurePercentage=($latestCalSummry  | where-object { $_.'Firewall IP Blocked Media Failure Percentage' -ne 'NaN' -and $_."Firewall IP Blocked Media Failure Percentage" -gt 0.001 } | Measure-Object "Firewall IP Blocked Media Failure Percentage" -Average | select Average).Average
            $FirewallIPBlockedMediaFailurePercentage=($MediaFailedDueToFirewallIPBlockedStreamCount/$toalStreamsCnt)*100
            if(-not $FirewallIPBlockedMediaFailurePercentage){  $FirewallIPBlockedMediaFailurePercentage=0 }  else { $FirewallIPBlockedMediaFailurePercentage=$FirewallIPBlockedMediaFailurePercentage.ToString("#.##") }

            Write-Host '***************DD for MediaFailedDueToOtherStreamCount Measure****************************'
            $MediaFailedDueToOtherStreamCount=($latestCalSummry | where-object { $_.'Media Failed Due To Other Stream Count' -ne 'NaN' } | Measure-Object "Media Failed Due To Other Stream Count" -Sum | select Sum).Sum
            if($MediaFailedDueToOtherStreamCount){
                $ddforMediaFailedDueToOtherStreamCount = $latestCalSummry | Where-Object { $_."Media Failed Due To Other Stream Count" -gt 0.001 } | Sort-Object { $_."Media Failed Due To Other Stream Count" -as [int] } -Descending | select -First $shwTopNDD
                foreach($in in $ddforMediaFailedDueToOtherStreamCount){
                    #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                    $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                    $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                    Write-Host 'ddMediaFailedDueToOtherStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Media Failed Due To Other Stream Count'
                }
                $ddforMediaFailedDueToOtherStreamCount=$null
            }

            Write-Host '*************** OtherMediaFailurePercentage Measure****************************'
            #$OtherMediaFailurePercentage=($latestCalSummry | where-object { $_.'Other Media Failure Percentage' -ne 'NaN' -and $_."Other Media Failure Percentage" -gt 0.001 } | Measure-Object "Other Media Failure Percentage" -Average | select Average).Average
            $OtherMediaFailurePercentage=($MediaFailedDueToOtherStreamCount/$toalStreamsCnt)*100
            if(-not $OtherMediaFailurePercentage){  $OtherMediaFailurePercentage=0 }  else { $OtherMediaFailurePercentage=$OtherMediaFailurePercentage.ToString("#.##") }
        }
        Write-Host 'measures##' $toalStreamsCnt ~$TotalCDRAvailableStreamCount ~ $TotalMediaFailedStreamCount ~ $TotalCallSetupFailedStreamCount ~ $TotalCallDroppedStreamCount ~ $TotalMediaSucceededStreamCount ~ $TotalCallSetupSucceededStreamCount ~ $TotalCallSetupFailurePercentage ~ $TotalCallDroppedFailurePercentage ~ $TotalAnswerSeizureRatio ~ $TotalShortCallPercentage ~ $TotalMediaFailurePercentage ~ $AvgCallDuration ~ $MediaFailedDueToFirewallDPIStreamCount ~ $FirewallDPIMediaFailurePercentage ~ $MediaFailedDueToFirewallIPBlockedStreamCount ~ $FirewallIPBlockedMediaFailurePercentage ~ $MediaFailedDueToOtherStreamCount ~ $OtherMediaFailurePercentage
    }
}
[System.GC]::GetTotalMemory($true) | out-null








# SIG # Begin signature block
# MIIldgYJKoZIhvcNAQcCoIIlZzCCJWMCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUKrDrnkRD0DyCsyT2UD5mHw84
# 3Heggh6cMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFsTCC
# BJmgAwIBAgIQASQK+x44C4oW8UtxnfTTwDANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwNjA5MDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBXjCCAVowDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHkGCCsGAQUF
# BwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMG
# CCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
# c3N1cmVkSURSb290Q0EuY3J0MEUGA1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwIAYDVR0g
# BBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0GCSqGSIb3DQEBDAUAA4IBAQCa
# FgKlAe+B+w20WLJ4ragjGdlzN9pgnlHXy/gvQLmjH3xATjM+kDzniQF1hehiex1W
# 4HG63l7GN7x5XGIATfhJelFNBjLzxdIAKicg6okuFTngLD74dXwsgkFhNQ8j0O01
# ldKIlSlDy+CmWBB8U46fRckgNxTA7Rm6fnc50lSWx6YR3zQz9nVSQkscnY2W1ZVs
# RxIUJF8mQfoaRr3esOWRRwOsGAjLy9tmiX8rnGW/vjdOvi3znUrDzMxHXsiVla3R
# y7sqBiD5P3LqNutFcpJ6KXsUAzz7TdZIcXoQEYoIdM1sGwRc0oqVA3ZRUFPWLvdK
# RsOuECxxTLCHtic3RGBEMIIGMzCCBRugAwIBAgIQCJp0nrgtw+wn6mXq2/g1MTAN
# BgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQg
# SW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2Vy
# dCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4XDTIxMDUyNTAwMDAw
# MFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBK
# ZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMs
# IEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMuMIICIjANBgkqhkiG
# 9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7JDxOs7sySHvaQ3wGR
# 2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJIk0AZXDTMvXr/mEvm
# KxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+f9I4EgTo9OcdVeIN
# XhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuKifgxL2i8d5FDzkhZ
# SZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZyyaRURtlx11pYfJ/K
# NYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgRADe3/k0NtiVwJIo0
# ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yKf4kpRFmClYfK5Lst
# GQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3VhN+aV56kR/efo8e
# D81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRvIID/l+yDJogDBpae
# 3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug3F2CVJpNbzb1HmAH
# 6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4KTAg7ROmGkwdLhmXo
# PCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsqCqOl6nEDwGD5LfZl
# dQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAOBgNVHQ8BAf8EBAMC
# B4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1oDOgMYYvaHR0cDov
# L2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5jcmwwNaAzoDGG
# L2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3VyZWQtY3MtZzEuY3Js
# MEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUHAgEWG2h0dHA6Ly93
# d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsGAQUFBwEBBHgwdjAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tME4GCCsGAQUFBzAC
# hkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
# ZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQsF
# AAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuChsgkv1PmQpgfypxC
# 3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5NAxDGuIczAIeXOc5k
# RRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9ndCmGSsqcxjG2ud8O6
# Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKRLAUu6IgD6WJKMVfZ
# XWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwoevxbIWh0SenZOUrA
# q9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQICEAc2N7ckVHzYR6z9
# KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERp
# Z2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMY
# RGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAwMDAwMFoXDTM3MDMy
# MjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRp
# bWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMaG
# NQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2EaFEFUJfpIjzaPp9
# 85yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuAhIoiGN/r2j3EF3+r
# GSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQh0YAe9tEQYncfGpX
# evA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7LeSn3O9TkSZ+8OpWNs
# 5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw54qVI1vCwMROpVymW
# Jy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP29p7mO1vsgd4iFNmC
# KseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjFKfPKqpZzQmiftkaz
# nTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHtQr8FnGZJUlD0UfM2
# SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpYPtMDiP6zj9NeS3YS
# UZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4JduyrXUZ14mCjWAkB
# KAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGjggFdMIIBWTASBgNV
# HRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2mi91jGogj57IbzAf
# BgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNVHQ8BAf8EBAMCAYYw
# EwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBpMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUHMAKGNWh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3J0MEMG
# A1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG
# /WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIBfmbW2CFC4bAYLhBN
# E88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb122H+oQgJTQxZ822
# EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+rT4osequFzUNf7WC2
# qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQsl3p/yhUifDVinF2
# ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsKRcnfxI2g55j7+6ad
# cq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKnN36TU6w7HQhJD5TN
# OXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSereU0cZLXJmvkOHOr
# pgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no8Zhf+yvYfvJGnXUs
# HicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcWoWa63VXAOimGsJig
# K+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInwAM1dwvnQI38AC+R2
# AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7qS9EFUrnEw4d2zc4
# GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhNhpedMA0GCSqGSIb3
# DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7
# MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1l
# U3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQsw
# CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG0Rp
# Z2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx5DxArvurxON4XX5c
# Nur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJx
# bKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFqRUIjQVr4YNNlLD5+
# Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJHGVvimC6P0Mo//8Zn
# zzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHVGBS3BEXz4Di9or16
# cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vICNEyu4P6IzzZ/9KM
# u/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03ShL7BU
# dsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2xwafEDsTvQD4ZOgLU
# MalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiay
# CDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2QT3nr6caKMmtYbCg
# QRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGj
# ggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNVHSUBAf8E
# DDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEw
# HwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYEFI1kt4kh
# /lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRp
# Z2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3Rh
# bXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzABhhhodHRw
# Oi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNlcnRz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1l
# U3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk
# 9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4qOVo5TtiEWaW8G5iq
# 6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJ
# T4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8y/pc9+RTv24KfH7X
# 3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEip
# tucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiLfmSiZZQR+24y8fW7
# OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp43UZ3Lht6wDOK+Eoo
# jBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pIallDrl/q+A8GQp3f
# BmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVrNQ6F1uAszOAMJLh8
# UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBFThIcFClYzG/Tf8u+
# wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdjOEcXW28T2moQbh9J
# t0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmlu
# ZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYBBAGCNwIB
# DDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
# MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFFnkPTNS8D3Pp6eCaFl6eoNW
# NXk5MA0GCSqGSIb3DQEBAQUABIICAAxvNMVWL4jmAoXuI053DJAi+nZ4l+fD2zfk
# cM50gD/49dHsBDFRMTiC7Y++juLZkrNf0gDzWYOx/ofICOlYBloH0E+pzrPQPBCJ
# fu7nozMnI4QBbKOjY1aeE3u5dfn6PuEM7T5HYikdtI/qmGHKOl7ZDWjYV6EMCly2
# USrwx38iNYON1L+iTYf8gKXYbqKbqhG+Yg/ooWd1CgbTdteMpMrp/ecG+4L7RgHA
# HZX+/I0rM1roe1sgJqhikXMISSQzC7ldD2lLRW5jqqdnBIg2w/uNPMgUn1G3/MaW
# GQTL+QB0H3kLXX82o8O1ATJvBnPlpqamCrDQentyvt/DGSRaPwcYYSFhx4NBc+4a
# 4Quj9zFgzCFRNJ4E90fkghvZV2Dn4jmlY1+yW+YVBo0t5vVgitUVWhmMirm+uba5
# vg69jLDD7JAwh1mK+8Hp0CMcQ4Gqwsd5TaUjhR3cK4UxEJXYItaB12X3gft0IK1D
# o5wMaE/Pfuj2nZxRuS4qjnKOWvl+goxuIy3VmaSxVvO17/YccCBMWZFne6mtBc+U
# PsHimi4Ezfs5HXn/204m9xFOzETloxwSkdXbY9jZ8KE3C8N6XLy2rUjK/YI0Cv/V
# rf6PedxC3amKKIVjT0/YrqyPDbICRGohgJjKq1qBZusYNS0A6Y/zehThXuL2xE7W
# KryzSqL0oYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzELMAkGA1UE
# BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2Vy
# dCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQCnpK
# iJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJAzELBgkq
# hkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDcxMTEzMTEwMFowLwYJKoZIhvcN
# AQkEMSIEIGP+PvbAe+6vOtEFcNIcL5Dxn6f8L8BQySQjWA4NcIiRMA0GCSqGSIb3
# DQEBAQUABIICAHNhOvDsIkPQvusXcEduJ6igqsKz7jajzC/eslpB4E1UQ00HnEw/
# sKyD73DvWXD/Ny+zNCRTA5/zkKWFPmL98zxJU47dt4FRDu+ZJJHgGISAD2lpbjY8
# StKJRTi5lzr0F67L0C24cHxvXV9DhOJdQuA5m+hXnMvII9ZL7/NkWNxJmtCey63k
# +PxcV5w9vJb/UiSIeXHj9yVEgWXs1D6eLfFjLuoFV8jfkLub2chlWT/sAfCz/4e2
# BUGKT/OGCvFwwfo7hF/6DrsYfi1WNpj1LGxSxz8ymS1vxfMMuftbd24yD9t99IO1
# SF4YiFB19Mv2zYvORhUVFQmPu0Zx6GOpew11Tt9kUkdZfahuXugdGMK1x0U0B/Ag
# 0DBeq7s+RbgTWvhwDCDP07DH2iLH7zxaQS4Ley11AxET5yUsU0uD9Vs75Ep6pJax
# l1+WkfFLjKaf8pkLV2ehRAKOySFbmaPeiYHDCqtMchYc+MbUKM7tUsZAaFKqtGhT
# vjReOyvG3Zd1sKF5M4pXobLVmSNfBcvLVnWOGktlfllkI4EeLU7EStfmKpQRfHCX
# 54As+rno9m1soR7LuOHc3b4lg7/h6DD1LjWO1x5nQFfv0IFgPLgCA/D653x7dKwT
# MhEPHvBg/NeqFILF97+fLufM0SS2V2toG38QUWd4qt21cLl2+RiJSGJo
# SIG # End signature block
