$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#Load VMware View Snapin to powershell v2 - Starts

Set-Variable product_name "VMware View PowerCLI" -scope Private
Set-Variable view_snapin_name "VMware.View.Broker" -scope Private
$ViewSnapinLoaded = Get-PSSnapin | Where { $_.Name -eq $view_snapin_name }
if(!$ViewSnapinLoaded)
{
	# Install or Re-register View Cmdlets
	$installpath = (get-itemproperty "HKLM:\Software\VMware, Inc.\VMware VDM").ServerInstallPath
	$BuildVersion = (get-itemproperty "HKLM:\Software\VMware, Inc.\VMware VDM").BuildNumber
	$os=Get-WMIObject win32_operatingsystem | select OSArchitecture
	if ($os.OSArchitecture -like "64*")
	{
		$path="$env:windir\Microsoft.NET\Framework64\v2.0.50727\installUtil.exe"
        if(![System.IO.File]::Exists($path))
		{             
			$path="$env:windir\Microsoft.NET\Framework64\v4.0.30319\installUtil.exe"
			if(![System.IO.File]::Exists($path))
			{
     			Write-Host "Either .NET v2 or v4 frameworks are not installed"
				return
			}
		}
	}
	else
	{
		$path="$env:windir\Microsoft.NET\Framework\v2.0.50727\installUtil.exe"
		if(![System.IO.File]::Exists($path))
		{ 
			$path="$env:windir\Microsoft.NET\Framework\v4.0.30319\installUtil.exe"
			if(![System.IO.File]::Exists($path))
			{
				Write-Host "Either .NET v2 or v4 frameworks are not installed"
				return
			}
		}
	}
	set-alias installUtil $path
	$null = (installUtil ($installpath  + "\bin\PowershellServiceCmdlets.dll"))
}

Remove-Variable product_name -scope Private
Remove-Variable view_snapin_name -scope Private

#Load VMware View Snapin to powershell v2 - Ends


Add-pssnapin "VMware.View.Broker"
#$Global:ErrorActionPreference="SilentlyContinue"
$hostname = $env:computername
$hostname = "DomainMonitor." + $hostname
$LDAPPath = 'LDAP://localhost:389/OU=Servers,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry

$LDAPPath1 = 'LDAP://localhost:389/OU=Server Groups,DC=vdi,DC=vmware,DC=int'
$LDAPEntry1 = New-Object DirectoryServices.DirectoryEntry $LDAPPath1
$Selector1 = New-Object DirectoryServices.DirectorySearcher
$Selector1.SearchRoot = $LDAPEntry1

Write-Host "Connection Brokers"
Write-Host "-------------------"
$connBrokers = Get-ConnectionBroker  | select broker_id,activation,lastBackup,ldapBackupFrequency
if($connBrokers -ne $null)
{
	foreach($connBroker in $connBrokers)
	{
		Write-Host ($connBroker.broker_id,$connBroker.activation,
		$connBroker.lastBackup,$connBroker.ldapBackupFrequency ) -Separator "#"
	}
}
else
{
	Write-Host "- #"  -nonewline;
}

$VCs = @{}
$LDAPPath2 = 'LDAP://localhost:389/OU=VirtualCenter,OU=Properties,DC=vdi,DC=vmware,DC=int'
$LDAPEntry2 = New-Object DirectoryServices.DirectoryEntry $LDAPPath2
$Selector2 = New-Object DirectoryServices.DirectorySearcher
$Selector2.SearchRoot = $LDAPEntry2
$Selector2.Filter = "(objectClass=pae-VirtualCenter)"
$VCData = $Selector2.FindAll()
foreach($VC in $VCData)
{
    $attribute = $VC.Properties
	$dn = $attribute.'distinguishedname'
    $vcurl = $attribute.'pae-vcurl'
    $dnStr = [String]$dn
    $VCs.Add($dnStr.Trim(),$vcurl)    
}
$LDAPEntry2.Close()
$VCs.Keys

<##
logic for findig the current connection server is master or replica and ignore the session monitoring data
#$vdm = Get-ItemProperty "HKLM:\SOFTWARE\VMware, Inc.\VMware VDM" 
#$isStandardVDM = $vdm.ServerInstanceType
##>
$isStandardVDM = $False
$ldapaddr = 'LDAP://localhost:389/DC=vdi,DC=vmware,DC=int'
$ldapopen = [adsi]$ldapaddr
$objectCategoryarr = $ldapopen.'objectCategory' -split ','
#$objectCategoryarr.count
if($objectCategoryarr.count -eq 4)
{
    $schemaguid = $objectCategoryarr[3]
    $schemaConfigurationaddr= 'LDAP://localhost:389/CN=Schema,CN=Configuration,'+$schemaguid
    #$schemaConfigurationaddr
    $schemaConfigurationOpen = [adsi]$schemaConfigurationaddr
    #$schemaConfigurationOpen.fSMORoleOwner
    $fsmoRoleOwnerAddr = $schemaConfigurationOpen.fSMORoleOwner -split ","
    if($fsmoRoleOwnerAddr.count -gt 2)
    {
        $masterarr= $fsmoRoleOwnerAddr[1].split('`$')
        if($masterarr.count -eq 2)
        {
            $localhost = "CN=$env:computername"
            #$localhost
            #$masterarr[0]
            $isStandardVDM = $localhost -eq $masterarr[0]
        }
    }
}
$isStandardVDM

Write-Host "Pools"
Write-Host "--------"
if($isStandardVDM -eq $True)
{
	$PoolNames = @{}
	$LDAPPath2 = 'LDAP://localhost:389/OU=Applications,DC=vdi,DC=vmware,DC=int'
	$LDAPEntry2 = New-Object DirectoryServices.DirectoryEntry $LDAPPath2
	$Selector2 = New-Object DirectoryServices.DirectorySearcher
	$Selector2.SearchRoot = $LDAPEntry2
	$Selector2.Filter = "(objectClass=pae-DesktopApplication)"
	$poolsFromAdam = $Selector2.FindAll()
	foreach($p in $poolsFromAdam)
	{
		$attribute = $p.Properties
		$cn = $attribute.'cn'
	    $server = $attribute.'pae-servers'
	    $PoolNames.Add($cn,$server[0])
	}

	foreach($p in $PoolNames.Keys)
	{
		$headroomcount = -5
		$maximumcount = -5
		$minimumcount = -5
		try
		{
			$id = $p
			$ServerPool = $PoolNames.Item($p)
			$Selector1.Filter = "(distinguishedName="+$ServerPool+ ")"
			$poolsFromAdam = $Selector1.FindAll()
			$poolAdam = $poolsFromAdam[0]
			$attribute = $poolAdam.Properties
			$displayName = $attribute.'pae-displayname'
			$Hosts  = $attribute.'pae-memberdn'
			$disabled = $attribute.'pae-disabled'
			if($disabled[0] -eq 0) { $enabled = "true"} else {$enabled = "false"}
			$Type = $attribute.'pae-serverpooltype'
			$vcDN = $attribute.'pae-vcdn'
			if($vcDN -ne $null)
			{
				$vcDNStr = [String]$vcDN
				$vcServerName = $VCs.Item($vcDNStr.Trim())
			}
			else
			{
				$vcServerName = $null
			}
			if($Type -ne $null)
			{
				if($Type -eq 8)
				{
					$poolType = "TerminalService"
					$deliveryModel = "TerminalService"
					$desktopSource = "TerminalService"
				}
				elseif($Type -eq 5)
				{
					$poolType = "ManualVCPersistent"
					$deliveryModel = "Manual"
					$desktopSource = "VC"
				}
				elseif($Type -eq 4)
				{
					$poolType = "SviNonPersistent"
					$deliveryModel = "Provisioned"
					$desktopSource = "SVI"
				}
				elseif($Type -eq 18)
				{
					$poolType = "InstantClone"
					$deliveryModel = "Provisioned"
					$desktopSource = "SVI"
				} 
				elseif($Type -eq 12)
				{
					$poolType = "DedicatedVCPersistent"
					$deliveryModel = "Dedicated"
					$desktopSource = "VC"
				}
			}
		}
		catch
		{
			$deliveryModel = $null
			$desktopSource = $null
			$vcServerName = $null
			$poolType = $null   
		}
		$headroomcount = $attribute.'pae-vmheadroomcount'
		$maximumcount = $attribute.'pae-vmmaximumcount'
		$minimumcount = $attribute.'pae-vmminimumcount'

		if($headroomcount -eq $null)
		{
			$headroomcount = -5
		}
		if($maximumcount -eq $null)
		{
			$maximumcount = -5
		}
		if($minimumcount -eq $null)
		{
			$minimumcount = -5
		}
		if($displayName -eq $null -or $displayName.length -eq 0)
		{
			$displayName = "-"
		}
				
		if($enabled -eq $null -or $enabled.length -eq 0)
		{
			$enabled = "-"
		}
		if($deliveryModel -eq $null -or $deliveryModel.length -eq 0)
		{
			$deliveryModel = "-"
		}
		if($desktopSource -eq $null -or $desktopSource.length -eq 0)
		{
			$desktopSource = "-"
		}
		if($vcServerName -eq $null -or $vcServerName.length -eq 0)
		{
			$vcServerName = "-"
		}
		if($poolType -eq $null -or $poolType.length -eq 0)
		{
			$poolType = "-"
		}
		Write-Host ($id, $displayName,$enabled, $deliveryModel, $desktopSource,$vcServerName, $poolType, $headroomcount, $maximumcount, $minimumcount) -Separator "#"
		
		$poolentitlements = Get-PoolEntitlement -pool_id $id  | select displayName
		Write-Host "poolentitlement starts ^!^" -nonewline;
		if($poolentitlements -ne $null)
		{
			foreach($poolentitlement in $poolentitlements)
			{
				Write-Host ($poolentitlement.displayName) ("^!^")  -nonewline;
			}
		}
		else
		{
			Write-Host "- ^!^"  -nonewline;
		}
		Write-Host "poolentitlement stops"
		if($desktopSource -eq "VC" -or $desktopSource -eq "SVI")
		{
			$desktops = Get-DesktopVM -pool_id $id
			Write-Host "Desktops starts ^!^" -nonewline;
			if($desktops -ne $null)
			{
				foreach($desktop in $desktops)
				{
					$Name = $desktop.Name
					
					if($Name -eq $null -or $Name.length -eq 0)
					{
						$Name = "-"
					}
					$GuestFullName = $desktop.GuestFullName
					if($GuestFullName -eq $null -or $GuestFullName.length -eq 0)
					{
						$GuestFullName = "-"
					}
					$HostName = $desktop.HostName
					if($HostName -eq $null -or $HostName.length -eq 0)
					{
						$HostName = "-"
					}
					$IPAddress = $desktop.IPAddress
					if($IPAddress -eq $null -or $IPAddress.length -eq 0)
					{
						$IPAddress = "-"
					}
					$isInPool = $desktop.isInPool
					if($isInPool -eq $null -or $isInPool.length -eq 0)
					{
						$isInPool = "-"
					}
					$machine_id = $desktop.machine_id
					if($machine_id -eq $null -or $machine_id.length -eq 0)
					{
						$machine_id = "-"
					}
					if($machine_id -ne "-")
					{
						$Selector.Filter = "(&(objectClass=pae-VM)(cn="+$machine_id+ "))"
						$dk = $Selector.FindAll()
						$attribute = $dk[0].Properties
						$Path = $attribute.'pae-vmpath'
						$ServerGroup = $attribute.'pae-memberdnof'
						
					}
					else
					{
						$Path = "-"
						$ServerGroup = "-"
					}
					if($Path -eq $null -or $Path.length -eq 0)
					{
						$Path = "-"
					}
					Write-Host ($Name,$Path, $GuestFullName, $HostName, $IPAddress, $isInPool, $id, $machine_id,$ServerGroup, "^!^") -Separator "#" -nonewline;
				}
			}
			else
			{
				Write-Host "- ^!^" -nonewline;
			}
		}
		elseif($desktopSource -eq "TerminalService")
		{
			Write-Host "Desktops starts ^!^" -nonewline;
			$servers = $Hosts.Split(";")
			if($servers)
			{
				foreach($server in $servers)
				{
					$sid = $server.Split(",")[0]
					$sid = $sid.substring(3)
					$Selector.Filter = "(&(objectClass=pae-RDSHost)(cn=" + $sid + "))"
					$desktop = $Selector.FindAll()
					if($desktop -ne $null)
					{
						$attribute = $desktop[0].Properties
						$ServerGroup = $attribute.'pae-memberdnof'
						$Name = $attribute.'pae-displayname'
						$Enabled = $attribute.'pae-disabled'
						if($Enabled -eq $null -or $Enabled.length -eq 0)
						{
							$Enabled = 0	#0 means Enabled   1 means Disabled		
						}
						$MaxConns = $attribute.'pae-optmaximumsessions'
						if($MaxConns -eq $null -or $MaxConns.length -eq 0)
						{
							$MaxConns = 150
						}
						if($Name -eq $null -or $Name.length -eq 0)
						{
							$Name = "-"
						}
						$Path = "-"
						$GuestFullName = "-"
						$IPAddress = "-"
						$isInPool = "-"
						$machine_id = $sid
						$HostName = "-"
						Write-Host ($Name,$Path, $GuestFullName, $HostName, $IPAddress, $isInPool, $id, $machine_id,$ServerGroup,$Enabled,$Status,$MaxConns, "^!^") -Separator "#" -nonewline;
					}	
				}
			}
			else
			{
				Write-Host "- ^!^" -nonewline;
			}
		}
		
		Write-Host "Desktops stops"
		Write-Host "~#~"
	}

	Write-Host "PoolsUsage"
	Write-Host "----------"

	#$localSessions = Get-LocalSession  | select userName,pool_id,startTime,DNSName,duration,state,protocol,session_id
	write-Host "localsessions starts ^!^" -nonewline;
	<# if($localSessions -ne $null)
	{
		foreach($localSession in $localSessions)
		{
			$userName = $localSession.userName
			if($userName -eq $null -or $userName.length -eq 0)
			{
				$userName = "-"
			}
			$startTime = $localSession.startTime
			if($startTime -eq $null -or $startTime.length -eq 0)
			{
				$startTime = "-"
			}
			$DNSName = $localSession.DNSName
			if($DNSName -eq $null -or $DNSName.length -eq 0)
			{
				$DNSName = "-"
			}
			$duration = $localSession.duration
			if($duration -eq $null -or $duration.length -eq 0)
			{
				$duration = "-"
			}
			$state = $localSession.state
			if($state -eq $null -or $state.length -eq 0)
			{
				$state = "-"
			}

			$protocol = $localSession.protocol
			if($protocol -eq $null -or $protocol.length -eq 0)
			{
				$protocol = "-"
			}
			$session_id = $localSession.session_id
			if($session_id -eq $null -or $session_id.length -eq 0)
			{
				$session_id = "-"
			}
			$pool_id = $session_id
			Write-Host ($userName, $pool_id,$startTime,$DNSName, $duration,$state, $protocol,$session_id,"^!^") -Separator "#" -nonewline;
		}
	}
	else
	{
		Write-Host "- ^!^" -nonewline;
	} #>
	Write-Host "localsessions stops"

	$remoteSessions = Get-RemoteSession  | select userName,pool_id,startTime,DNSName,duration,state,protocol,session_id
	Write-Host "remotesessions starts ^!^" -nonewline;
	if($remoteSessions -ne $null)
	{
		foreach($remoteSession in $remoteSessions)
		{
			$userName = $remoteSession.userName
			if($userName -eq $null -or $userName.length -eq 0)
			{
				$userName = "-"
			}
			$DNSName = $remoteSession.DNSName
			if($DNSName -eq $null -or $DNSName.length -eq 0)
			{
				$DNSName = "-"
			}
			$startTime = $remoteSession.startTime
			if($startTime -eq $null -or $startTime.length -eq 0)
			{
				$startTime = "-"
			}
			$duration = $remoteSession.duration
			if($duration -eq $null -or $duration.length -eq 0)
			{
				$duration = "-"
			}
			$state = $remoteSession.state
			if($state -eq $null -or $state.length -eq 0)
			{
				$state = "-"
			}
			$protocol = $remoteSession.protocol
			if($protocol -eq $null -or $protocol.length -eq 0)
			{
				$protocol = "-"
			}
			$session_id = $remoteSession.session_id
			if($session_id -eq $null -or $session_id.length -eq 0)
			{
				$session_id = "-"
			}
			$pool_id = $session_id
			Write-Host ($userName,$pool_id,$startTime, $DNSName, $duration, $state, $protocol, $session_id,"^!^") -Separator "#" -nonewline;
		}
	}
	else
	{
		Write-Host "- ^!^" -nonewline;
	}
	write-Host "remotesesions stops"
	Write-Host 
}

Write-Host "Domain monitor"
Write-Host "---------------"
$domains = Get-Monitor -monitor DomainMonitor -monitor_id $env:computername
if($domains -ne $null)
{
	write-host($domains.domains)
}

Write-Host 

Write-Host "VC monitor"
Write-Host "-----------"
$vcs = Get-Monitor -monitor VCMonitor
if($vcs -ne $null)
{
	foreach($vc in $vcs)
	{
		Write-Host ($vc.URL,$vc.State) -Separator "^"
	}
}
Write-Host

Write-Host "DB monitor"
Write-Host "-------------"

$db = Get-monitor -monitor DBMonitor
Write-Host ($db.Server,$db.DBName,$db.State) -Separator "#"

Write-Host

Write-Host "License"
Write-Host "---------"

$license = Get-license
$license | fl

Write-Host

Write-Host "RDS Applications"
Write-Host "------------------"
if($isStandardVDM -eq $True)
{
	$LDAPPath1 = 'LDAP://localhost:389/OU=Applications,DC=vdi,DC=vmware,DC=int'
	$LDAPEntry1 = New-Object DirectoryServices.DirectoryEntry $LDAPPath1
	$Selector1 = New-Object DirectoryServices.DirectorySearcher
	$Selector1.SearchRoot = $LDAPEntry1
	$Selector1.Filter = "(objectClass=pae-RDSApplication)"
	$RDSApps = $Selector1.FindAll()
	if($RDSApps -ne $null)
	{
		foreach($RDSApp in $RDSApps)
		{
			$attribute = $RDSApp.Properties
			$RDSAppName = $attribute.'pae-displayname'
			$Pool = $attribute.'pae-servers'
			$Disabled = $attribute.'pae-disabled'
			Write-host($RDSAppName,$Pool,$Disabled) -Separator "#"
		}
	}
}

Write-Host

Write-Host "Farm"
Write-Host "--------"
if($isStandardVDM -eq $True)
{

	$LDAPPath1 = 'LDAP://localhost:389/OU=Server Groups,DC=vdi,DC=vmware,DC=int'
	$LDAPEntry1 = New-Object DirectoryServices.DirectoryEntry $LDAPPath1
	$Selector1 = New-Object DirectoryServices.DirectorySearcher
	$Selector1.SearchRoot = $LDAPEntry1
	$Selector1.Filter = "(objectClass=pae-ServerPool)"
	$Farms = $Selector1.FindAll()
	if($Farms -ne $null)
	{
		foreach($Farm in $Farms)
		{
			$attribute = $Farm.Properties
			$ServerType = $attribute.'pae-serverpooltype'
			if($ServerType -eq 8)
			{
				$FarmName = $attribute.'pae-displayname'
				$Status = $attribute.'pae-disabled'
				Write-host($FarmName,$Status) -Separator "#"
			}
		}
	}
}

Remove-Pssnapin "VMware.View.Broker"

# SIG # Begin signature block
# MIIbjAYJKoZIhvcNAQcCoIIbfTCCG3kCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUrYnx9AL7hQcwe+XD3i+dQ9lq
# L7KgghWiMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUx
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAw
# MDAwWhcNMjQwNTI5MjM1OTU5WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDf
# AZHYpsPdplqB5IT6QbS0qQSxDidrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+Y
# S+YrEJuIkVMKkqSZnixrkFl87uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V
# 4g1eGBDbFnpOMQr6luGqZVe+vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPO
# SFlJl90K0a0S8Tmkt6xdJZ+nNR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8
# n8o1gCRQIvbeueHfz+ZrG1K916KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAk
# ijRkSxTIMA2nskgiMx4/Ow4xjN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rk
# uy0ZBE1s42OmwIFMSBm7AR+R05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+
# jx4PzUTlUNCqYmIZYqr+z2OFuRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMG
# lp7fHai/li+NjxmjxEXS1e/JLSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUe
# YAfqTTIUeZZgKhQA1sEHRhH+Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uG
# Zeg8IFyjQQIDAQABo4IBxDCCAcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt
# 9mV1DlgwHQYDVR0OBBYEFPnIRJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQE
# AwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOg
# MYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5j
# cmwwSwYDVR0gBEQwQjA2BglghkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUH
# MAKGQmh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1
# cmVkSURDb2RlU2lnbmluZ0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEB
# CwUAA4IBAQCUCOdwU+8srLBP/gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/K
# nELeD4StX3JFXz5ddILA5oone/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5
# zmRFGm8WxDZdI20ztcvW0sObqn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53
# w7pWG170nktocFWTeUhkAy0foAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkox
# V9ldaXJ8Px1navd6PpDW4A781u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5
# SsCr29MlpK8UxK9y2Qmb+jEtRxR0QZLfMYIFVDCCBVACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFI/T8CX9HY9IbvqP
# J32v9ZwZ2XWqMA0GCSqGSIb3DQEBAQUABIICABM5HAxoTyctMRnl7jPVOdcmT8A5
# 4JqM7M0K2h+Yd/IQ6GmO1j2xzgfqA2584H+YHR5gBKIQvIXq+I/rgNWxQqPx3SKK
# rs2juDp0IjH6LSbCNXr/Bp3mEUOHvOqKq4usyheqMtfgll2ZHRCMea7IgO+oPSiW
# DuHJEhCPpraH1jJjtVSJSzkca+HyXhcn5RcPXKWhCbIQa5Qfxwo0shYc2vbqEQ1v
# wVOPBEy7cAATgkg9/wrUmlLvqi19m/IcL0vNkvJ4dOxqzluMsSx3LMTjtkVfeeI4
# 6tuRhDkR284KiyCwTSpFOKeLmf5nnVgWiA0hLg+oAhmx90q1AAsnPV+megYqPrEI
# Qa+wq0+WUokK/svdrrwBqPY0m9oxM5b0VesXPQzRTVL87OZTAvj5GurRinKAtHAN
# sUzRjdfp2/er3kWKO9PHxfw5SSTkMsdyZkeFg8gTupEapNllJO4ABEEqY149mjMA
# u+IbD84Wt/1J2PUV7GGesQ/+nbRVNZAMaSTHdYD49mocej9JnBNr6PUYEm+HzRG1
# L5nmoGWw6XWdcD2RnHe498XcAJhDkrnBhuKwQu1fXM97GjvpZR+i6u2X77l0K8TO
# 1LA4rbG5bVTJ6HEKjBGnkv2jhaDHrMhRAc9ffO+jE6icqt1VqZfA0f6W9fl2taFM
# j3oK975vCbHXc2PSoYICMDCCAiwGCSqGSIb3DQEJBjGCAh0wggIZAgEBMIGGMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBUaW1lc3RhbXBpbmcgQ0ECEA1CSuC+Ooj/YEAhzhQA8N0wDQYJYIZIAWUDBAIB
# BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0y
# MTA5MDExMjM3MDRaMC8GCSqGSIb3DQEJBDEiBCCWp9rpvaK9VXeL99LJB2m06LRz
# Vx/riib3mysao8j03TANBgkqhkiG9w0BAQEFAASCAQA6Rcd3gsYhcJ6iQ8hM5lMt
# AylAUV4iF2mf2ruT7AJBWaHcRBDAbUsDIda6AKIbAnHdp1iA4J5PaI4uRl6GSKvh
# BZfz34DpSBBsam+vQSYDq2Lm+5ShIX7Z5a38tZOyezd6dj1KE1LWf4eUF0/ouySA
# Uhv8dold/OA8yp+7oOkJiIUxj6qCgXy+x817bOkmXyN1ybSjLFfY2EaMLtaq7gtc
# 1EdjOoLn+lYkslHqXDWTfxUzTKp5TSpbyixbLrCVJsVc7AdzpjIJMxQN3FrTj6qV
# Xm1XMg79pApOuAUPksK9jYLJdRdYPisuCM62+KxmZBNvlaZr4SBOcpUe7OxorhLv
# SIG # End signature block
