$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.XenApp.Commands
$hostname = $env:COMPUTERNAME
$format = "#"
$result = $format + $hostname
Write-Host $result
$wgs = get-xaworkergroup -servername $hostname
if($wgs)
{
	foreach($wg in $wgs)
	{
		$apps = Get-XAApplication -workergroupname $wg.workergroupname
		if($apps)
		{
			foreach( $app in $apps)
			{
				$dname = $app.FolderPath +"\"+$app.BrowserName
				$wgname = $wg.FolderPath +"\"+$wg.workergroupname
				Write-Host( $dname, $wgname, $app.CommandLineExecutable)  -Separator "^^"
			}
		}
	}
}
$apps = Get-XAApplication -servername $hostname
if($apps)
{
	foreach( $app in $apps)
	{
		$dname = $app.FolderPath +"\"+$app.BrowserName
		Write-Host( $dname, $app.CommandLineExecutable)  -Separator "^^"
	}
}

Remove-PSSnapin Citrix.XenApp.Commands
